/* Change the number of balls in the Epic Pinball configuration file */

#include <stdio.h>

void main()
{
  int i, balls,
      total, eof = 0;
  unsigned char num[150], number;

  FILE *file;

  if ((file = fopen("config.pin","rb")) == NULL)
  {
    printf("\nYou must have the file config.pin in the current directory!\n");
    return;
  }

  eof = fscanf(file,"%c",&number);
  for (i = 0; eof != EOF; i++)
  {
    num[i] = number;
    eof = fscanf(file,"%c",&number);
  }

  fclose(file);

  printf("\nThis program allows you to change the number of balls\n");
  printf("for the shareware version of Epic's Pinball.\n\n");

  if (num[11] == 0)
    printf("The current configuration has \"unlimited balls\".\n\n");
  else
    printf("The current configuration has %d balls.\n\n",num[11]);
  printf("How many balls would you like (1-9, 0 for unlimited): ");

  scanf("%d",&balls);
  while (balls < 0 || balls > 9)
  {
    printf("\nSorry, but %d is invalid.  Please enter a number",balls);
    printf(" between 1 and 9.\n");
    printf("How many balls would you really like: ");
    scanf("%d",&balls);
  }

  printf("\nMaking backup:\ncopy config.pin config.bak\n");
  system("copy config.pin config.bak");

  file = fopen("config.pin","wb");

  total = i;  num[11] = balls;
  for (i = 0; i < total; i++)
		fprintf(file,"%c",num[i]);

	fclose(file);

  if (balls == 0)
    printf("Configuration changed to \"unlimited\" balls.\n\n");
  else
    printf("Configuration changed to %d balls.\n\n",balls);
}
