unit videoedit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, OleCtrls, VIDEOEDITLib_TLB, ExtCtrls;

type
  TForm1 = class(TForm)
    chkusevideocomp: TCheckBox;
    chkuseaudiocomp: TCheckBox;
    Label1: TLabel;
    cboVideoCompressor: TComboBox;
    Label2: TLabel;
    cboAudioCompressor: TComboBox;
    Label3: TLabel;
    txtFrameRate: TEdit;
    Button1: TButton;
    Label4: TLabel;
    cboWMV: TComboBox;
    Label5: TLabel;
    txtFileWidth: TEdit;
    Label6: TLabel;
    txtFileHeight: TEdit;
    RadioOutput: TRadioGroup;
    BtnStop: TButton;
    BtnStart: TButton;
    RadioMode: TRadioGroup;
    Label8: TLabel;
    Label9: TLabel;
    txtVideo1: TEdit;
    BtnSelVideo1: TButton;
    Label10: TLabel;
    txtVideoStart1: TEdit;
    Label11: TLabel;
    txtVideoStop1: TEdit;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    txtVideo2: TEdit;
    BtnSelVideo2: TButton;
    txtVideoStart2: TEdit;
    txtVideoStop2: TEdit;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    txtAudio1: TEdit;
    BtnSelAudio1: TButton;
    txtAudioStart1: TEdit;
    Label15: TLabel;
    Label16: TLabel;
    txtAudioStop1: TEdit;
    txtAudio2: TEdit;
    BtnSelAudio2: TButton;
    txtAudioStart2: TEdit;
    txtAudioStop2: TEdit;
    Label17: TLabel;
    Label18: TLabel;
    lblProgress: TLabel;
    cbotran: TComboBox;
    Label19: TLabel;
    Label20: TLabel;
    txtTranStart: TEdit;
    Label21: TLabel;
    txtTranStop: TEdit;
    chkTran: TCheckBox;
    Button2: TButton;
    EditExport1: TEdit;
    Button3: TButton;
    EditExport2: TEdit;
    Label22: TLabel;
    Button4: TButton;
    Button5: TButton;
    RadioFileType: TRadioGroup;
    Label23: TLabel;
    cboMpegType: TComboBox;
    Label24: TLabel;
    cboMpegFrameRate: TComboBox;
    Label25: TLabel;
    txtQuality: TEdit;
    Label26: TLabel;
    txtVideoBitRate: TEdit;
    Label27: TLabel;
    txtAudioBitRate: TEdit;
    Label7: TLabel;
    Label28: TLabel;
    chkvbrmode: TCheckBox;
    VideoEdit1: TVideoEdit;
    chkCustomProfile: TCheckBox;
    lblcustomprofile: TLabel;
    OpenDialog2: TOpenDialog;
    Label29: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure ShowEvent(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BtnSelVideo1Click(Sender: TObject);
    procedure BtnStartClick(Sender: TObject);
    procedure BtnStopClick(Sender: TObject);
    procedure Complete(Sender: TObject);
    procedure BtnSelVideo2Click(Sender: TObject);
    procedure BtnSelAudio1Click(Sender: TObject);
    procedure BtnSelAudio2Click(Sender: TObject);
    procedure Progress(ASender: TObject; iCurPos, iDuration: Double);
    procedure chkTranClick(Sender: TObject);
    procedure clickusevideocomp(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure OnMpegTypeChange(Sender: TObject);
    procedure RadioFileTypeClick(Sender: TObject);
    procedure UseAudioComp(Sender: TObject);
    procedure chkvbrmodeClick(Sender: TObject);
    procedure VideoEdit1Complete(Sender: TObject);
    procedure VideoEdit1Processing(ASender: TObject; iCurPos,
      iDuration: Double);
    procedure chkCustomProfileClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
var strVideoCompressor: string;
var VideoCompressorIndex: Integer;
var result : boolean;
begin



result := VideoEdit1.VideoCompressors.ShowPropertyPage(cboVideoCompressor.ItemIndex);

If result = False Then
    ShowMessage('No property page');



end;

procedure TForm1.ShowEvent(Sender: TObject);
var i:Integer;
begin
   For i:= 0 to VideoEdit1.VideoCompressors.Count-1 do
           cboVideoCompressor.Items.add(VideoEdit1.VideoCompressors.FindVideoCompressorName(i));
     cboVideoCompressor.ItemIndex :=0;

   For i:= 0 to VideoEdit1.AudioCompressors.Count-1 do
           cboAudioCompressor.Items.add(VideoEdit1.AudioCompressors.FindAudioCompressorName(i));
     cboAudioCompressor.ItemIndex :=0;

   For i:= 0 to VideoEdit1.WMVProfiles.Count-1 do
           cboWMV.Items.add(VideoEdit1.WMVProfiles.FindWMVProfileName(i));
     cboWMV.ItemIndex :=0;

   For i:= 0 to VideoEdit1.Transitions.Count-1 do
           cboTran.Items.add(VideoEdit1.Transitions.FindTransitionName(i));
     cboTran.ItemIndex :=0;

   cboMpegType.Items.add('VCD PAL');
   cboMpegType.Items.add('VCD NTSC');
   cboMpegType.Items.add('SVCD PAL');
   cboMpegType.Items.add('SVCD NTSC');
   cboMpegType.Items.add('DVD PAL');
   cboMpegType.Items.add('DVD NTSC');
   cboMpegType.Items.add('CUSTOM MPEG');
   cboMpegType.ItemIndex :=0;


   cboMpegFrameRate.Items.add('23.976');
   cboMpegFrameRate.Items.add('24');
   cboMpegFrameRate.Items.add('25');
   cboMpegFrameRate.Items.add('29.97');
   cboMpegFrameRate.Items.add('30');
   cboMpegFrameRate.Items.add('50');
   cboMpegFrameRate.Items.add('59.94');
   cboMpegFrameRate.ItemIndex :=0;


   chkvbrmode.Checked :=True;






end;

procedure TForm1.FormCreate(Sender: TObject);
begin
    RadioFileType.Items.Add('MPEG');
    RadioFileType.Items.Add('AVI');
    RadioFileType.Items.Add('WMV');
    RadioFileType.ItemIndex :=0;



    radiooutput.Items.Add('Preview');
    radiooutput.Items.Add('Save');
    radiooutput.ItemIndex :=0;

    Radiomode.Items.Add('Stretched to fit');
    Radiomode.Items.Add('No Resize');
    Radiomode.Items.Add('Resize preserving the aspect ratio');
    Radiomode.Items.Add('Resize crop');
    radiomode.ItemIndex :=0;




end;

procedure TForm1.BtnSelVideo1Click(Sender: TObject);
var idur:double;
begin
  OpenDialog1.Filter :=
  'All Files (*.*)|*.*|mpg (*.mpg)|*.mpg;*.mpeg|avi (*.avi)|*.avi|wmv (*.wmv)|*.wmv |JPEG (*.jpg)|*.jpg|Bitmap (*.bmp)|*.bmp|Gif (*.gif)|*.gif |TIF (*.tif)|*.tif|PNG (*.png)|*.png ';

   if opendialog1.Execute then
    begin
     txtVideo1.Text := opendialog1.FileName;
     txtVideoStart1.Text := '0';
     iDur := VideoEdit1.GetFileDuration(txtVideo1.Text);
       //if 0, this may image file, so set duration
        If iDur = 0 Then
            txtVideoStop1.Text := '1'
        Else
            txtVideoStop1.text := Format('%f', [iDur] );

    end

   else
       txtVIdeo1.Text :='';

end;

procedure TForm1.BtnStartClick(Sender: TObject);
var istretchmode : integer;
var result: boolean;
var strFilter : String;
begin

If chkvbrmode.Checked then
    VideoEdit1.MPEGVBRMode := True
Else
    VideoEdit1.MPEGVBRMode := False;

 VideoEdit1.MPEGVideoBitrate := strtoint(txtVideoBitRate.Text);
 VideoEdit1.MPEGAudioBitrate := strtoint(txtAudioBitRate.Text);


      istretchmode := RadioMode.ItemIndex;

      VideoEdit1.OutputFileHeight := strtoint(txtFileHeight.Text);
      VideoEdit1.OutputFileWidth := strtoint(txtFileWidth.Text);


     if RadioFileType.ItemIndex = 0 then //mpeg
        begin
             if cboMpegType.ItemIndex =0 then
              VideoEdit1.OutputType :=VCD_PAL;

             if cboMpegType.ItemIndex =1 then
              VideoEdit1.OutputType :=VCD_NTSC;

             if cboMpegType.ItemIndex =2 then
              VideoEdit1.OutputType :=SVCD_PAL;

             if cboMpegType.ItemIndex =3 then
              VideoEdit1.OutputType :=SVCD_NTSC;

             if cboMpegType.ItemIndex =4 then
              VideoEdit1.OutputType :=DVD_PAL;

             if cboMpegType.ItemIndex =5 then
              VideoEdit1.OutputType :=DVD_NTSC;

             if cboMpegType.ItemIndex =6 then
              begin
                  VideoEdit1.OutputType :=CUSTOM_MPEG;

                     case cboMpegFrameRate.ItemIndex of
                      0:  VideoEdit1.FrameRate :=23.976;
                      1:  VideoEdit1.FrameRate :=24;
                      2:  VideoEdit1.FrameRate :=25;
                      3:  VideoEdit1.FrameRate :=29.97;
                      4:  VideoEdit1.FrameRate :=30;
                      5:  VideoEdit1.FrameRate :=50;
                      6:  VideoEdit1.FrameRate :=59.94;
                     end;
              end;

            VideoEdit1.MPEGQuality :=strtoint(txtQuality.Text);
            strFilter := 'MPEG File (*.mpeg)|*.mpeg';
        end;

     if RadioFileType.ItemIndex = 1 then //avi
        begin
            strFilter := 'Avi File (*.avi)|*.avi';
            VideoEdit1.OutputType := AVI;
            VideoEdit1.VideoCompressor := CboVideoCompressor.ItemIndex;
            VideoEdit1.AudioCompressor := CboAudioCompressor.ItemIndex;
            VideoEdit1.FrameRate := strtoint(txtFrameRate.Text);
        end;

     if RadioFileType.ItemIndex = 2 then //wmv
        begin
            strFilter := 'wmv File (*.wmv)|*.wmv';
            VideoEdit1.OutputType := WMV;
             VideoEdit1.WMVProfile := cboWMV.ItemIndex;

        end;


      VideoEdit1.InitControl;

      if txtVideo1.Text <> '' then
        VideoEdit1.AddVideo(txtVideo1.Text,strTofloat(txtVideoStart1.Text),strTofloat(txtVideoStop1.Text),istretchmode);

      if txtVideo2.Text <> '' then
        VideoEdit1.AddVideo(txtVideo2.Text,strTofloat(txtVideoStart2.Text),strTofloat(txtVideoStop2.Text),istretchmode);

      if txtAudio1.Text <> '' then
        VideoEdit1.AddAudio(txtAudio1.Text,strTofloat(txtAudioStart1.Text),strTofloat(txtAudioStop1.Text));

      if txtAudio2.Text <> '' then
        VideoEdit1.AddAudio(txtAudio2.Text,strTofloat(txtAudioStart2.Text),strTofloat(txtAudioStop2.Text));

       if chkTran.Checked then
          VideoEdit1.AddTransition(cboTran.ItemIndex,strTofloat(txtTranStart.Text),strTofloat(txtTranStop.Text));

       If VideoEdit1.GetTotalDuration = 0 Then
          ShowMessage('Timeline empty,cannot process');

      If RadioOutput.ItemIndex = 1 then
        begin
        savedialog1.Filter :=strFilter;
             if savedialog1.Execute then
               begin
                result := VideoEdit1.Save(savedialog1.FileName);

                If result = False Then
                 ShowMessage('Fail to save file');
                end
               end

      else
        VideoEdit1.Preview;





end;

procedure TForm1.BtnStopClick(Sender: TObject);
begin

      VideoEdit1.Stop;
end;

procedure TForm1.Complete(Sender: TObject);
begin
    lblProgress.Caption :=''; 
         ShowMessage ('Save/Preview Completed');

end;

procedure TForm1.BtnSelVideo2Click(Sender: TObject);
var idur:double;
begin
  OpenDialog1.Filter :=
  'All Files (*.*)|*.*|mpg (*.mpg)|*.mpg;*.mpeg|avi (*.avi)|*.avi|wmv (*.wmv)|*.wmv |JPEG (*.jpg)|*.jpg|Bitmap (*.bmp)|*.bmp|Gif (*.gif)|*.gif |TIF (*.tif)|*.tif|PNG (*.png)|*.png ';

   if opendialog1.Execute then
    begin
     txtVideo2.Text := opendialog1.FileName;
     txtVideoStart2.Text := '0';
     iDur := VideoEdit1.GetFileDuration(txtVideo2.Text);
       //if 0, this may image file, so set duration
        If iDur = 0 Then
            txtVideoStop2.Text := '1'
        Else
            txtVideoStop2.text := Format('%f', [iDur] );

    end

   else
       txtVIdeo2.Text :='';

end;

procedure TForm1.BtnSelAudio1Click(Sender: TObject);
var idur:double;
begin
  OpenDialog1.Filter :=
  'All Files (*.*)|*.*|mpg (*.mpg)|*.mpg;*.mpeg|avi (*.avi)|*.avi|wmv (*.wmv)|*.wmv |JPEG (*.jpg)|*.jpg|Bitmap (*.bmp)|*.bmp|Gif (*.gif)|*.gif |TIF (*.tif)|*.tif|PNG (*.png)|*.png ';

   if opendialog1.Execute then
    begin
     txtAudio1.Text := opendialog1.FileName;
     txtAudioStart1.Text := '0';

     iDur := VideoEdit1.GetFileDuration(txtAudio1.Text);
       //if 0, this may image file, so set duration
        If iDur = 0 Then
            txtAudioStop1.Text := '1'
        Else
            txtAudioStop1.text := Format('%f', [iDur] );

    end

   else
       txtAudio1.Text :='';

end;

procedure TForm1.BtnSelAudio2Click(Sender: TObject);
var idur:double;
begin

  OpenDialog1.Filter :=
  'All Files (*.*)|*.*|mpg (*.mpg)|*.mpg;*.mpeg|avi (*.avi)|*.avi|wmv (*.wmv)|*.wmv |JPEG (*.jpg)|*.jpg|Bitmap (*.bmp)|*.bmp|Gif (*.gif)|*.gif |TIF (*.tif)|*.tif|PNG (*.png)|*.png ';

   if opendialog1.Execute then
    begin
     txtAudio2.Text := opendialog1.FileName;
     txtAudioStart2.Text := '0';

     iDur := VideoEdit1.GetFileDuration(txtAudio2.Text);
       //if 0, this may image file, so set duration
        If iDur = 0 Then
            txtAudioStop2.Text := '1'
        Else
            txtAudioStop2.text := Format('%f', [iDur] );

    end

   else
       txtAudio2.Text :='';

end;

procedure TForm1.Progress(ASender: TObject; iCurPos, iDuration: Double);
begin

    lblProgress.Caption :='Please wait ' + Format('%f', [iCurPos] )+ ' of ' + Format('%f', [iDuration] );

end;

procedure TForm1.chkTranClick(Sender: TObject);
begin

    if chkTran.Checked then
      begin
        cbotran.Enabled :=True;
        txtTranStart.Enabled :=True;
        txtTranStop.Enabled :=True;
      end;


end;

procedure TForm1.clickusevideocomp(Sender: TObject);
begin

      if chkusevideocomp.Checked then
          cboVideoCompressor.Enabled :=True
      else
          cboVideoCompressor.Enabled :=False;



end;

procedure TForm1.Button2Click(Sender: TObject);
var result:boolean;
begin

  result := VideoEdit1.GetFrame(txtVideo1.Text,strTofloat(EditExport1.Text),'c:\test1.bmp');

  if result = true then
    ShowMessage('save to c:\test1.bmp')
  else
    ShowMessage('fail to save');


end;

procedure TForm1.Button3Click(Sender: TObject);
var result:boolean;
begin
  result := VideoEdit1.GetFrame(txtVideo2.Text,strTofloat(EditExport2.Text),'c:\test2.bmp');

  if result = true then
    ShowMessage('save to c:\test2.bmp')
  else
    ShowMessage('fail to save');

end;

procedure TForm1.Button4Click(Sender: TObject);
var result : boolean;
begin
        VideoEdit1.InitControl;
        VideoEdit1.AddAudio(txtAudio1.Text,strTofloat(txtAudioStart1.Text),strTofloat(txtAudioStop1.Text));

       result :=VideoEdit1.Save2Wave('c:\wave1.wav',1,11025,1);

    if result = false then
      ShowMessage('fail save to c:\wave1.wav');

end;

procedure TForm1.Button5Click(Sender: TObject);
var result : boolean;
begin
        VideoEdit1.InitControl;
        VideoEdit1.AddAudio(txtAudio2.Text,strTofloat(txtAudioStart2.Text),strTofloat(txtAudioStop2.Text));

       result :=VideoEdit1.Save2Wave('c:\wave2.wav',1,11025,1);

    if result = false then
      ShowMessage('fail save to c:\wave2.wav')

end;

procedure TForm1.OnMpegTypeChange(Sender: TObject);
begin
    if cboMpegType.ItemIndex =6 then
      begin
        cboMpegFrameRate.Enabled :=True;
        txtFileWidth.Enabled :=True;
        txtFileHeight.Enabled :=True;
      end
     else
        begin
           cboMpegFrameRate.Enabled :=False;
           txtFileWidth.Enabled :=False;
           txtFileHeight.Enabled :=False;
        end;   


end;

procedure TForm1.RadioFileTypeClick(Sender: TObject);
begin

   if RadioFileType.ItemIndex = 0 then //mpeg
     begin
      cboMpegType.Enabled :=True;
      cboMpegFrameRate.Enabled :=False;
      chkusevideocomp.Enabled :=False;
      chkuseaudiocomp.Enabled :=False;
      cboVideoCompressor.Enabled :=False;
      cboAudioCompressor.Enabled :=False;
      txtFileWidth.Enabled :=False;
      txtFileHeight.Enabled :=False;
      cboWMV.Enabled :=False;
      txtFrameRate.Enabled :=False;

      chkvbrmode.Enabled :=True;
      txtQuality.Enabled :=True;

     end;

   if RadioFileType.ItemIndex = 1 then //avi
     begin
      cboMpegType.Enabled :=False;
      cboMpegFrameRate.Enabled :=False;
      chkusevideocomp.Enabled :=True;
      chkuseaudiocomp.Enabled :=True;
      cboVideoCompressor.Enabled :=False;
      cboAudioCompressor.Enabled :=False;
      txtFileWidth.Enabled :=True;
      txtFileHeight.Enabled :=True;
      cboWMV.Enabled :=False;
      txtFrameRate.Enabled :=True;
      chkvbrmode.Enabled :=False;
      txtQuality.Enabled :=False;

     end;

   if RadioFileType.ItemIndex = 2 then //wmv
     begin
      cboMpegType.Enabled :=False;
      cboMpegFrameRate.Enabled :=False;
      chkusevideocomp.Enabled :=False;
      chkuseaudiocomp.Enabled :=False;
      cboVideoCompressor.Enabled :=False;
      cboAudioCompressor.Enabled :=False;
      txtFileWidth.Enabled :=False;
      txtFileHeight.Enabled :=False;
      cboWMV.Enabled :=True;
      txtFrameRate.Enabled :=False;
      chkvbrmode.Enabled :=False;
      txtQuality.Enabled :=False;

     end;




      


end;

procedure TForm1.UseAudioComp(Sender: TObject);
begin
      if chkuseaudiocomp.Checked then
          cboAudioCompressor.Enabled :=True
      else
          cboAudioCompressor.Enabled :=False;

end;

procedure TForm1.chkvbrmodeClick(Sender: TObject);
begin

        if chkvbrmode.Checked then
          begin
            txtQuality.Enabled :=True;
            txtVideoBitRate.Enabled :=False;
            txtAudioBitRate.Enabled :=False;
          end
        else
          begin
            txtQuality.Enabled :=False;
            txtVideoBitRate.Enabled :=True;
            txtAudioBitRate.Enabled :=True;
          end;




end;

procedure TForm1.VideoEdit1Complete(Sender: TObject);
begin

         ShowMessage ('Save/Preview Completed');
      lblProgress.Caption :='';

end;

procedure TForm1.VideoEdit1Processing(ASender: TObject; iCurPos,
  iDuration: Double);
begin
      lblProgress.Caption :='Please wait ' + Format('%f', [iCurPos] )+ ' of ' + Format('%f', [iDuration] );
end;

procedure TForm1.chkCustomProfileClick(Sender: TObject);
begin
  if chkCustomProfile.Checked then
    begin
        opendialog2.Filter :='Window Media Encoder Profiles (*.prx)|*.prx||';
                       if opendialog2.Execute then
                          begin
                          VideoEdit1.WMVCustomFileName := opendialog2.FileName;
                               lblcustomprofile.Caption :=  opendialog2.FileName;
                          end;
                   cbowmv.Enabled :=False;       
     end
  else
      begin
          VideoEdit1.WMVCustomFileName :='';
          cbowmv.Enabled :=True;
      end;                              


end;

end.
