// UItoSDKDoc.h : interface of the CUItoSDKDoc class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_UITOSDKDOC_H__9DA6398A_2D4C_11D7_A628_0000E85B5CD9__INCLUDED_)
#define AFX_UITOSDKDOC_H__9DA6398A_2D4C_11D7_A628_0000E85B5CD9__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#define BUFFERLEN 1000

#include "../../../include/vec.h"

struct ThreadParams
{
	HBITMAP m_hBmp;
	int m_pixelPerMeter;
	char* m_settings;
	
};

 

class CUItoSDKDoc : public CDocument
{
protected: // create from serialization only
	CUItoSDKDoc();
	DECLARE_DYNCREATE(CUItoSDKDoc)

// Attributes
public:	

// Operations
public:
	void VectorizeInNewThread();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CUItoSDKDoc)
	public:
	//}}AFX_VIRTUAL

// Implementation
public:
	HBITMAP GetDIB();
	virtual ~CUItoSDKDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

private:
	HBITMAP m_hBmp;// DIB - device independent bitmap
	int m_pixelPerMeter;
	ThreadParams m_threadParams;
	char m_settings[BUFFERLEN];
	 

// Generated message map functions
protected:
	//{{AFX_MSG(CUItoSDKDoc)
	afx_msg void OnOpenRasterImage();
	afx_msg void OnSaveAsBmp();
	afx_msg void OnSaveAsTif();
	afx_msg void OnUpdateAsBmp(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSaveAsTif(CCmdUI* pCmdUI);
	afx_msg void OnMirrowVertically();
	afx_msg void OnUpdateMirrowVertically(CCmdUI* pCmdUI);
	afx_msg void OnRotateLeft();
	afx_msg void OnUpdateRotateLeft(CCmdUI* pCmdUI);
	afx_msg void OnRotateRight();
	afx_msg void OnUpdateRotateRight(CCmdUI* pCmdUI);
	afx_msg void OnNegate();
	afx_msg void OnUpdateNegate(CCmdUI* pCmdUI);
	afx_msg void OnFillSmallHoles();
	afx_msg void OnUpdateFillSmallHoles(CCmdUI* pCmdUI);
	afx_msg void OnFillHoles();
	afx_msg void OnUpdateFillHoles(CCmdUI* pCmdUI);
	afx_msg void OnConnect();
	afx_msg void OnUpdateConnect(CCmdUI* pCmdUI);
	afx_msg void OnClean();
	afx_msg void OnUpdateClean(CCmdUI* pCmdUI);
	afx_msg void OnThin();
	afx_msg void OnUpdateThin(CCmdUI* pCmdUI);
	afx_msg void OnThicken();
	afx_msg void OnUpdateThicken(CCmdUI* pCmdUI);
	afx_msg void OnVectorize();
	afx_msg void OnUpdateVectorize(CCmdUI* pCmdUI);
	afx_msg void OnUpdateVectorizeInNewThread(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	BOOL readSettings(char* buffer, int buffSize);
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_UITOSDKDOC_H__9DA6398A_2D4C_11D7_A628_0000E85B5CD9__INCLUDED_)
