<%
//	Created by:	Lineasoft Sagl
//	Web site:	www.lineasoft.ch
//	Version:	1.2  (01.10.2002)
//	File:		contentText.inc
//
//	Copyright  2002, Lineasoft Sagl (Switzerland)
%>	

<%
	////////////////////////////////////////////////////////////////////////////////////////////
	// Class ContentText
	////////////////////////////////////////////////////////////////////////////////////////////
	function ContentText( recordSet, from, to )
	{	
		// Properties 
		this.EOF				= true;
		this.BOF				= true;
		this.RecordCount		= 0;
		this.RecordPos			= -1;


		// Methods for navigation;
		this.MoveFirst			= MoveFirst000;
		this.MoveLast			= MoveLast000;
		this.Move				= Move000;
		this.MoveNext			= MoveNext000;
		this.MovePrev			= MovePrev000;		

		// Methods for values;
		this.GetValue			= Get000Value;

		this.GetId				= Get000Id;
		this.GetTitle			= Get000Title;
		this.GetSubTitle		= Get000SubTitle;
		this.GetPicture1		= Get000Picture1;
		this.GetPicture2		= Get000Picture2;
		this.GetLink			= Get000Link;
		this.GetLinkDescription	= Get000LinkDescription;
		this.GetBody			= Get000Body;		
		this.GetCreationDate	= Get000CreationDate;
		this.GetModificationDate	= Get000ModificationDate;	


		// Constructor
		this.rst = recordSet;
		
		if (from == null || from < 0)
			from = 0;
		
		if (from >= recordSet.RecordCount)
			from = recordSet.RecordCount-1;
		
		this.from = from;
		
		if (to == null || to == -1)
			this.to = recordSet.RecordCount-1;
		else
		{
			if (to < this.from)
				to = this.from;
			
			if (to >= recordSet.RecordCount)
				to = recordSet.RecordCount-1;
				
			this.to = to;
		}
		
		if (this.from == -1)
		{
			this.RecordCount = 0;
			this.BOF = true;
			this.EOF = true;
		}
		else	
		{
			this.RecordCount = this.to - this.from + 1;
			this.MoveFirst();
		}
	}
	

	function MoveFirst000()
	{
		if (this.RecordCount > 0)
		{
			this.rst.Move(this.from, adBookmarkFirst);
			this.RecordPos = 0;
			this.BOF = false;
			this.EOF = false;
		}
	}
	
	
	function MoveLast000()
	{
		if (this.RecordCount > 0)
		{
			this.rst.Move(this.to, adBookmarkFirst);
			this.RecordPos = this.RecordCount-1;
			this.BOF = false;
			this.EOF = false;
		}
	}

	function Move000(pos)
	{
		if (pos < 0)
			this.BOF = true;
		else if (pos >= this.RecordCount)
			this.EOF = true;
		else
		{
			this.rst.Move(this.from + pos, adBookmarkFirst);
			this.BOF = false;
			this.EOF = false;
		}
	}

	function MoveNext000()
	{
		if (this.RecordPos == this.RecordCount-1)
			this.EOF = true;
		else
		{
			this.RecordPos++;
			this.rst.Move(1, adBookmarkCurrent);
			this.BOF = false;
		}
	}
	
	function MovePrev000()
	{
		if (this.RecordCount == 0 || this.RecordPos == 0)
			this.BOF = true;
		else
		{
			this.RecordPos--;
			this.rst.Move(-1, adBookmarkCurrent);
			this.EOF = false;
		}
	}
	
	function Get000Value(fieldDb, defaultValue)
	{
		if (this.rst == null || this.EOF == true || this.BOF == true)	
			return defaultValue;		

		return this.rst(fieldDb).value != null ? this.rst(fieldDb).value : defaultValue;					
	}
	
	function Get000Id()					{ return this.GetValue("list_id", 1);}
	function Get000Title()				{ return this.GetValue("title", "");}
	function Get000SubTitle()			{ return this.GetValue("sub_title", "");}
	function Get000Picture1()			{ return this.GetValue("picture_file_name_1", "");}
	function Get000Picture2()			{ return this.GetValue("picture_file_name_2", "");}
	function Get000Link()				{ return this.GetValue("document_link", "");}
	function Get000LinkDescription()	{ return this.GetValue("document_link_description", "");}	
	function Get000Body()				{ return Parser(this.GetValue("body", ""));}
	function Get000CreationDate()		{ return GetFormattedDate(this.GetValue("creation_date", ""), false);}
	function Get000ModificationDate()	{ return GetFormattedDate(this.GetValue("modification_date", ""), false);}


%>