#!/usr/bin/perl

###############################################################################
#
# _HTML.pl - an include file for perl...
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/08/21 17:50:53 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: _HTML.pl,v 1.47.2.2 2001/08/21 17:50:53 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

#$CacheControl = 'max-age=30, must-revalidate';
$CacheControl = 'must-revalidate';

# Set up fonts - $font should not be used anywhere, but is left here in
# case I missed any. It has been separated into fonface and fontsize, to
# allow for user configurable font sizes. $FontBase is the default font size.
$FontFace = "<font face='geneva,helvetica,arial'>";
$FontBase = 1;

# Change fontface for windows
if ($ENV{"HTTP_USER_AGENT"} =~ /Win/) {
	$FontFace = "<font face='verdana,arial,helvetica'>";
}

# Set up font tags
# $CGIQuery->cookie accesses the cookies, the same way as $CGIQuery->param accesses the 
# submitted form data. Very neat and clean. The cookie is set by getsubjects.cgi
# This requires that _CGI.pl be included first

$fontinc = $CGIQuery->cookie('panForaFont');
if ($fontinc ne "") {
	$FontBase = $fontinc;
}

# Keep a separate font for the admin interface
#$admfontinc = $CGIQuery->cookie('AdminFont');
#if ($admfontinc ne "") {
#	$FontBase = $admfontinc;
#}

$FontSize = "<font size=$FontBase>";
$FontSize2 = "<font size=" . ($FontBase + 1) . ">";
$FontSize3 = "<font size=" . ($FontBase + 2) . ">";

$FontRed = "<font color=#e31616>";

# Below here are icon and image definitions. this makes it much easier
# to insert images.

# Standard indentation
$ImgIndent = "<img src=images/cleardot.gif width=5 height=5 border=0>";
$ImgIndentSmall = "<img src=images/cleardot.gif width=2 height=5 border=0>";

# Clear dots
$ImgClearDot = "<img src=images/cleardot.gif width=1 height=1 border=0>";
$ImgClear88 = "<img src=images/cleardot.gif width=8 height=8 border=0>";
$ImgClear1010 = "<img src=images/cleardot.gif width=10 height=10 border=0>";
$ImgClear1212 = "<img src=images/cleardot.gif width=12 height=12 border=0>";
$ImgSrcClearDot = "images/cleardot.gif";

# Red highlight Sources
$IcoSelSrc = "images/MBtnSelectedExpand.gif";
$IcoSelSrc2 = "images/MBtnSelectedExpand2.gif";
$IcoSelSrc3 = "images/MBtnSelectedExpand3.gif";

# Font dependent squares and Icons
$ImgClearSquare = $ImgClear88;
if ($FontBase > 1) {
	$ImgClearSquare = $ImgClear1010;
	$IcoSelSrc = $IcoSelSrc2;
}
if ($FontBase >= 4) {
	$ImgClearSquare = $ImgClear1212;
	$IcoSelSrc = $IcoSelSrc3;
}

# "Info" (Help) button
$BtnInfo = "<img src=images/InfoButton.gif width=12 height=12 border=0 align=absmiddle vspace=2 alt='Help'>";

# Threading Icons
$BtnExpanded = "<img src=images/gray_triang_down.gif width=8 height=8 border=0 alt='Collapse Thread'>";
$BtnCollapsed = "<img src=images/gray_triang.gif width=8 height=8 border=0 alt='Expand Thread'>";
$BtnSelected = "<img src=images/red_triang.gif width=8 height=8 border=0 alt='Expand Thread'>";
$BtnSelectedDn = "<img src=images/red_triang_down.gif width=8 height=8 border=0 alt='Collapse Thread'>";
$BtnSelectedMT = "<img src=images/red_triang_empty.gif width=8 height=8 border=0 alt='Collapse Thread'>";
$BtnSelectedLeft = "<img src=images/red_triang_selected.gif width=8 height=8 border=0>";

# Green Threading icons
$BtnLeadExpanded = "<img src=images/green_triang_down.gif width=8 height=8 border=0 alt='Collapse Thread'>";
$BtnLeadCollapsed = "<img src=images/green_triang.gif width=8 height=8 border=0 alt='Expand Thread'>";

# Empty threading icons
$IcoNoReplies = "<img src=images/gray_triang_empty.gif width=8 height=8>";
$IcoLeadNoReplies = "<img src=images/green_triang_empty.gif width=8 height=8>";

# Global Buttons
$BtnRefresh = "<img src=images/refreshButton.gif width=66 height=22 border=0 alt='Refresh all Views'>";
$BtnHelp = "<img src=images/help.gif border=0 width=47 height=22 alt='Help' align=absmiddle>";
$BtnLogout = "<img src=images/logout.gif border=0 width=39 height=17 alt='Logout'>";
$BtnRefreshThread = "<img src=images/refreshThread.gif width=23 height=15 border=0 alt='You Are Here' align=absmiddle>";

# Posting buttons
$BtnPost = "<img src=images/PostGraphicButton.gif width=50 height=16 border=0 alt='Post to Forum' align=absmiddle>";
$BtnReply = "<img src=images/replyButton.gif width=54 height=15 border=0 alt='Reply to Message' align=absmiddle>";

# Content Frame Buttons
$BtnProfile = "<img src=images/Profile.gif width=23 height=15 border=0 alt='User Profile' align=absmiddle>";
$BtnEdit = "<img src=images/EditMessageGraphicButton.gif width=23 height=15 border=0 alt='Edit Message' align=absmiddle>";
$BtnEmail = "<img src=images/EmailGraphicButton.gif width=23 height=15 border=0 alt='Email this Message' align=absmiddle>";

$BtnWordCount = "<img src=images/wordCount.gif border=0 width=83 height=26 alt='Word Count'>";

# font size icons
$BtnFontUp = "<img src=images/UpText.gif width=25 height=16 border=0 alt='Increase Font Size' align=absmiddle>";
$BtnFontUpDisabled = "<img src=images/UpTextDisabled.gif width=25 height=16 border=0 alt='Font Size at Maximum' align=absmiddle>";
$BtnFontDn = "<img src=images/DownText.gif width=25 height=16 border=0 alt='Decrease Font Size' align=absmiddle>";
$BtnFontDnDisabled = "<img src=images/DownTextDisabled.gif width=25 height=16 border=0 alt='Font Size at Minimum' align=absmiddle>";

$IcoNew = "<img src=images/new.gif width=9 height=9 align=middle alt='New'>";

# $ImgSrcTableBg = "images/thinyellow.gif";
$ImgSrcTableBg = "images/cleardot.gif";

# Submit Buttons
$BtnFormDel = "<input type=image src=images/DeleteButton.gif border=0 width=60 height=26 alt='Delete' name=delete align=absmiddle>";
$BtnFormDelDisabled = "<input type=image src=images/DeleteButton.gif border=0 width=60 height=26 alt='Delete (Disabled)' name=delete align=absmiddle>";
# $BtnFormDelDemo = "<a href=Demo.html><img src=images/DeleteButton.gif border=0 width=60 height=26 alt='Delete (Demo)' align=absmiddle></a>";
$BtnFormDelDemo = "<a href=Demo.html><img src=images/SubmitDeleteUserButtonDemo.gif border=0 width=60 height=26 alt='Delete (Demo)' align=absmiddle></a>";
$BtnFormEdit = "<input type=image src=images/SubmitEditButton.gif border=0 width=50 height=26 name=edit alt='Edit' align=absmiddle>";
$BtnFormSubmit = "<input type=image src=images/SubmitButton.gif border=0 width=60 height=26 alt='Submit Changes' name=submit align=absmiddle>";
$BtnFormSubmitDisabled = "<img src=images/SubmitButtonDisabled.gif border=0 width=60 height=26 alt='Submit Changes (Disabled)' align=absmiddle>";
# $BtnFormSubmitDemo = "<a href=Demo.html><img src=images/SubmitButton.gif border=0 width=60 height=26 alt='Submit (Demo)' align=absmiddle></a>";
$BtnFormSubmitDemo = "<a href=Demo.html><img src=images/SubmitButtonDemo.gif border=0 width=60 height=26 alt='Submit (Demo)' align=absmiddle></a>";
$BtnFormAdd = "<input type=image src=images/SubmitAddButton.gif border=0 width=50 height=26 alt='Add' name=submit align=absmiddle>";
$BtnFormClear = "<a href=javascript:resetforms()><img src=images/ClearButton.gif border=0 width=50 height=26 alt='Clear Form' align=absmiddle></a>";
$BtnFormSearch = "<input type=image src=images/SearchButton.gif border=0 width=60 height=26 alt='Search' name=Search align=absmiddle>";

# Submit Images
$BtnFormPreview = "<img src=images/PreviewButton.gif width=60 height=26 border=0 alt='Preview' align=absmiddle>";
$BtnFormSave = "<img src=images/Save.gif width=50 height=26 border=0 alt='Save' align=absmiddle>";
$BtnFormSaveDisabled = "<img src=images/SaveDisabled.gif width=50 height=26 border=0 alt='Save (Disabled)' align=absmiddle>";
# $BtnFormSaveDemo = "<a href=Demo.html><img src=images/Save.gif width=50 height=26 border=0 alt='Save (Demo)' align=absmiddle></a>";
$BtnFormSaveDemo = "<a href=Demo.html><img src=images/SaveDemo.gif width=50 height=26 border=0 alt='Save (Demo)' align=absmiddle></a>";
$BtnFormRevert = "<img src=images/Revert.gif width=60 height=26 border=0 alt='Revert to Previous' align=absmiddle>";
$BtnNextStep = "<img src=images/NextStepButton.gif width=75 height=26 border=0 alt='Continue to Next Step' align=absmiddle>";

$BtnCancel = "<img src=images/CancelButton.gif width=60 height=26 border=0 alt='Cancel' align=absmiddle>";
$BtnClose = "<img src=images/CloseWindowButton.gif width=97 height=26 border=0 alt='Close Window' align=absmiddle>";

# User editing buttons
$BtnFormUserCp = "<input type=image src=images/SubmitCopyUserButton.gif border=0 width=60 height=26 alt='Copy User' name=copyuser align=absmiddle>";
$BtnFormUserCpDisabled = "<img src=images/SubmitCopyUserButtonDisabled.gif border=0 width=60 height=26 alt='Copy User (Disabled)' align=absmiddle>";
# $BtnFormUserCpDemo = "<a href=Demo.html><img src=images/SubmitCopyUserButton.gif border=0 width=60 height=26 alt='Copy User (Demo)' align=absmiddle></a>";
$BtnFormUserCpDemo = "<a href=Demo.html><img src=images/SubmitCopyUserButtonDemo.gif border=0 width=60 height=26 alt='Copy User (Demo)' align=absmiddle></a>";
$BtnFormUserMv = "<input type=image src=images/SubmitMoveUserButton.gif border=0 width=60 height=26 alt='Move User' name=moveuser align=absmiddle>";
$BtnFormUserMvDisabled = "<img src=images/SubmitMoveUserButtonDisabled.gif border=0 width=60 height=26 alt='Move User' align=absmiddle>";
# $BtnFormUserMvDemo = "<a href=Demo.html><img src=images/SubmitMoveUserButton.gif border=0 width=60 height=26 alt='Move User (Demo)' align=absmiddle></a>";
$BtnFormUserMvDemo = "<a href=Demo.html><img src=images/SubmitMoveUserButtonDemo.gif border=0 width=60 height=26 alt='Move User (Demo)' align=absmiddle></a>";
$BtnFormUserDel = "<input type=image src=images/SubmitDeleteUserButton.gif border=0 width=60 height=26 alt='Delete User' name=deleteuser align=absmiddle>";
$BtnFormUserDelDisabled = "<img src=images/SubmitDeleteUserButtonDisabled.gif border=0 width=60 height=26 alt='Delete User (Disabled)' align=absmiddle>";
# $BtnFormUserDelDemo = "<a href=Demo.html><img src=images/SubmitDeleteUserButton.gif border=0 width=60 height=26 alt='Delete User (Demo)' align=absmiddle></a>";
$BtnFormUserDelDemo = "<a href=Demo.html><img src=images/SubmitDeleteUserButtonDemo.gif border=0 width=60 height=26 alt='Delete User (Demo)' align=absmiddle></a>";
$BtnFormAssign = "<input type=image src=images/SubmitAssignButton.gif border=0 width=60 height=26 alt='Assign' name=assign align=absmiddle>";
$BtnFormAssignDisabled = "<img src=images/SubmitAssignButtonDisabled.gif border=0 width=60 height=26 alt='Assign (Disabled)' align=absmiddle>";
# $BtnFormAssignDemo = "<a href=Demo.html><img src=images/SubmitAssignButton.gif border=0 width=60 height=26 alt='Assign (Demo)'align=absmiddle></a>";
$BtnFormAssignDemo = "<a href=Demo.html><img src=images/SubmitAssignButtonDemo.gif border=0 width=60 height=26 alt='Assign (Demo)'align=absmiddle></a>";

# Topics buttons
$BtnSubjRename = "<img src=images/ChangeGraphicButton.gif width=21 height=15 border=0 alt='Rename'>";
$BtnDel = "<img src=images/DeleteGraphicButton.gif width=22 height=15 border=0 alt='Delete'>";
$BtnSubjPost = "<img src=images/EditGraphicButton.gif width=22 height=15 border=0 alt='Edit Posting Permissions'>";
$BtnSubjAdd = "<img src=images/AddGraphicButton.gif width=22 height=15 border=0 alt='Add New Topics'>";
$BtnUserCp = "<img src=images/CopyUser.gif width=22 height=15 border=0 alt='Copy User'>";
$BtnUserMv = "<img src=images/MoveUser.gif width=22 height=15 border=0 alt='Move User'>";

$BtnFormRename = "<img src=images/RenameButton.gif width=60 height=26 border=0 alt=\"Rename\" align=absmiddle>";
$BtnFormRenameDisabled = "<img src=images/RenameButtonDisabled.gif width=60 height=26 border=0 alt=\"Rename (Disabled)\" align=absmiddle>";

# Color Picker
$BtnCopyPicker = "<img src=images/Copy2Picker.gif width=29 height=16 alt='Copy to Color Picker' align=absmiddle border=0>";
$BtnCopyPickerLarge = "<img src=images/Copy2Picker_L.gif width=50 height=17 alt='Copy to Color Picker' align=absmiddle border=0>";
$BtnHexRGB = "<img src=images/Hex2RGB.gif width=56 height=24 alt='RGB to Hex Converter' align=absmiddle border=0>";
$BtnConvertUp = "<img src=images/ConvertUp.gif width=24 height=16 alt='Convert' align=absmiddle border=0>";
$BtnConvertDn = "<img src=images/ConvertDn.gif width=24 height=16 alt='Convert' align=absmiddle border=0>";

# close Window
$BtnClose, "<img src=images/CloseWindowButton.gif width=97 height=26 border=0 alt='Close Window' align=absmiddle>";

# admin menu buttons
$BtnViewForum = "<img src=images/ViewForumButton.gif width=55 height=17 border=0 alt='View Forum' align=absmiddle>";
$BtnSULogin = "<img src=images/superloginButton.gif width=17 height=17 border=0 align=absmiddle vspace=1 alt='Log in as panFora System Administrator'>";
$BtnSULogout = "<img src=images/superlogoutButton.gif width=17 height=17 border=0 align=absmiddle vspace=1 alt='panFora System Administrator Logout'>";
$BtnHomePage = "<img src=images/HomeButton.gif border=0 width=55 height=17 align=absmiddle alt='Home Page'>";

# Admin Photo Browser Buttons
$BtnPhotoUp = "<img src=images/UploadPhotoButton.gif width=43 height=17 border=0 alt=\"Upload\">";
$BtnPhotoApply = "<img src=images/ApplyPhotoButton.gif width=60 height=26 border=0 alt=\"Apply\" align=absmiddle>";
$BtnPhotoApplyDisabled = "<img src=images/ApplyPhotoButtonDisabled.gif width=60 height=26 border=0 alt=\"Apply (Disabled)\" align=absmiddle>";

# Admin pointing arrows
$ImgAdminPointLeft = "<img src=images/pointerleft_Admin_anim.gif width=20 height=20 border=0 align=absmiddle>";
$ImgAdminPointUp = "<img src=images/pointerup_Admin_anim.gif width=20 height=20 border=0 align=absmiddle>";

1;

sub makeBodyTag {
	local($frame, $extras) = @_;
	local($bgcolor, $bgimage, $text, $link, $vlink, $tag);
	
	if ($frame eq "Topics") {
		$bgcolor = $FSbg;
		$bgimage = $FSbgimage;
		$text = $FStext;
		$link = $FSlink;
		$vlink = $FSvlink;
	} elsif ($frame eq "Threads") {
		$bgcolor = $FTbg;
		$bgimage = $FTbgimage;
		$text = $FTtext;
		$link = $FTlink;
		$vlink = $FTvlink;
	} else {
		$bgcolor = $FCbg;
		$bgimage = $FCbgimage;
		$text = $FCtext;
		$link = $FClink;
		$vlink = $FCvlink;
	}
	
	$tag = "<body";
	if ($bgcolor ne "") {
		$tag .= " bgcolor=\"" . $bgcolor . "\"";
	}
	if ($bgimage ne "") {
		$tag .= " background=\"" . $bgimage . "\"";
	}
	if ($text ne "") {
		$tag .= " text=\"" . $text . "\"";
	}
	if ($link ne "") {
		$tag .= " link=\"" . $link . "\"";
	}
	if ($vlink ne "") {
		$tag .= " vlink=\"" . $vlink . "\"";
	}
	$tag .= " marginwidth=0 marginheight=0 leftmargin=0 topmargin=0";
	if ($extras ne "") {
		$tag .= " " . $extras;
	}
	$tag .= ">";
	
	return($tag);
}

sub printCopyright {
	print "<!--  Copyright 1998-2000 wiTHinc Incorporated. ",
			"All Rights Reserved.   http://www.withinc.com -->\n\n";
}

sub showFileError {
	local($filename, $rw) = @_;
	local($action);
	if (-e "$DBFILE_COLORS") {
		$ColorQueryString = &lookupColors("1");
		&loadColors($ColorQueryString);
		&showFileErrorHTML($filename, $rw);
	} else {
		if ($rw eq "r") {
			$action = "read from";
		} else {
			$action = "write to";
		}
	
		print $CGIQuery->header(-expires=>'-1d', -cache-control=>$CacheControl);
		&printCopyright();
		print "<html>$BodyTag\n";
		print "<h2>Error:</h2><blockquote>\n";
		print "Unable to $action file: $filename. Check file permissions \n";
		print "and try again.\n";
		print "</blockquote>";
	}
}

sub showFileErrorHTML {
	local($filename, $rw) = @_;
	local($action);
	if ($rw eq "r") {
		$action = "read from";
	} else {
		$action = "write to";
	}
	
	print $CGIQuery->header;
	&printCopyright();
	print "<html><head><title>File Error</title></head>\n";
	print $BodyTag;
	print $FontFace, $FontSize;
	
	print "<table cellpadding=0 cellspacing=0 border=0 width=100%>\n";
	
	print "<tr><td valign=middle bgcolor=$FCheaderback>";
	print $FontFace, $FontSize3, "&nbsp;</font>";
	print $FontSize2, "<font color=$FCheadertext>";
	print "<b>File Error</b></font></td>\n";
	print "</tr>\n";
	print "<tr><td>$ImgClear88</td></tr>\n\n";
	print "</table>\n\n";
	
	print "Unable to $action file: $filename. Check file permissions \n";
	print "and try again.\n";
	
	print "<p>\n";

	print "<a href=javascript:history.back()>[Back]</a>";
}

sub showErrorHTML {
	# Simple way to present an htmlized error message to the user, if one
	# should pop up.

	local ($msg) = @_;
	
	if (-e "$DBFILE_COLORS") {
		$ColorQueryString = &lookupColors("1");
		&loadColors($ColorQueryString);
		&showErrorBackHTML($msg);
	} else {
		print $CGIQuery->header(-expires=>'-1d', -cache-control=>$CacheControl);
		&printCopyright();
		print "<html>$BodyTag\n";
		print "<h2>Error:</h2><blockquote>\n";
		print "$msg\n";
		print "</blockquote>";
	}
}

sub showErrorBackHTML {
	# Simple way to present an htmlized error message to the user, if one
	# should pop up.
	if (-e "$DBFILE_COLORS" && $Class eq "") {
		$ColorQueryString = &lookupColors("1");
		&loadColors($ColorQueryString);
		$BodyTag = &makeBodyTag("Content");
	}

	local ($msg, $backlink) = @_;
	# print $CGIQuery->header(-expires=>'-1d', -cache-control=>$CacheControl);
	print $CGIQuery->header;
	&printCopyright();
	print "<html><head><title>Error</title></head>\n";
	print $BodyTag;
	print $FontFace, $FontSize;
	
	print "<table cellpadding=0 cellspacing=0 border=0 width=100%>\n";
	
	print "<tr><td valign=middle bgcolor=$FCheaderback>";
	print $FontFace, $FontSize3, "&nbsp;</font>";
	print $FontSize2, "<font color=$FCheadertext>";
	print "<b>Error:</b></font></td>\n";
	print "</tr>\n";
	print "<tr><td>$ImgClear88</td></tr>\n\n";
	print "</table>\n\n";
	
	if ($msg ne "") {
		print "$msg<p>\n";
	}
	
	if ($backlink) {
		print "<a href='javascript:history.back()'>[Back]</a>";
	}
}

sub showHeaderBackHTML {
	# Simple way to present an htmlized message to the user
	# This is also used as the header for many pages
	
	local ($header, $msg, $backlink, $upper, $noCache, $helplink, $cookie) = @_;
	
	if ($noCache) {
		if ($cookie ne "") {
			print $CGIQuery->header(-expires=>'-1d', -cache-control=>$CacheControl, -cookie=>$cookie);
		} else {
			print $CGIQuery->header(-expires=>'-1d', -cache-control=>$CacheControl);
		}
	} else {
		if ($cookie ne "") {
			print $CGIQuery->header(-cookie=>$cookie);
		} else {
			print $CGIQuery->header;
		}
	}
	&printCopyright();
	print "<html><head><title>$header</title></head>\n";
	print $BodyTag, "\n";
	print $FontFace, $FontSize, "\n";
	
	if ($helplink ne "") {
		&printHelpJS($helplink);
	}
	
	print "<table cellpadding=0 cellspacing=0 border=0 width=100%>\n";
	
	print "<tr><td valign=middle bgcolor=";
	if ($upper == 1) {
		print $FTheaderback;
	} elsif ($upper == 2) {
		print $FSheaderback;
	} else {
		print $FCheaderback;
	}
	print " nowrap>";
	
	print "<img src=$ImgSrcClearDot width=3 height=14>";
	
	if ($helplink ne "") {
		&printHelpButton;
	}
	print "</td>\n";
	
	print "<td valign=middle bgcolor=";
	if ($upper == 1) {
		print $FTheaderback;
	} elsif ($upper == 2) {
		print $FSheaderback;
	} else {
		print $FCheaderback;
	}
	print " width=99%>";
	
	print $FontFace, $FontSize2, "<font color=";
	if ($upper == 1) {
		print $FTheadertext;
	} elsif ($upper == 2) {
		print $FSheadertext;
	} else {
		print $FCheadertext;
	}
	print ">";
	print "<b>$header</b></font></td>";
	print "</tr>\n";
	# print "<tr><td>$ImgIndentSmall</td></tr>\n";
	print "</table>\n\n";
	
	if ($msg ne "") {
		print "$msg\n";
	}
	
	if ($backlink > 0) {
		print "<p><a href=javascript:history.go(-$backlink)>[Back]</a>";
	}
}

sub printHelpJS {
	local($helplink) = @_;
	local($args);

	if ($Edu) {
		$helplink =~ s/CORP_Admin/EDU_Admin/g;
	}
	$args = "\'$CGI_AdminHelp?fid=$Class\&func=summary\&" . $helplink;
	$args .= "\',640,480,'AdminInfoWin'";
		
	print "<script language=javascript>\n<!--\n";
	print "function showHelp() {\n";
	print "	if (window.parent != null) {\n";
	print "		parent.openwin($args);\n";
	print "	} else {\n";
	print "		openwin($args);\n";
	print "	}\n";
	print "}\n";
	print "// -->\n</script>\n";
}

sub printHelpButton {
	print "<a href=\"#\" onClick=\"showHelp()\">";
	print $BtnInfo;
	print "</a>";
	print "<img src=$ImgSrcClearDot width=3 height=14>";
}

sub printEmptyTaskFrame {
	local($msg) = @_;
	&showHeaderBackHTML("Editing Frame", "<br>");
	print "<table border=0 cellpadding=2 cellspacing=0>\n";
	print "<tr><td valign=middle>";
	print $ImgAdminPointUp;
	print "</td>\n<td valign=middle>", $FontFace, $FontSize;
	if ($msg ne "") {
		print $msg;
	} else {
		print "Please make a selection in the Task Frame above.\n";
	}
	print "</td>\n</tr>\n</table>\n\n";
	print "</body></html>\n";
}

sub fileErr {
	local($f, $rw) = @_;
	
	&showHeaderBackHTML("File Error", "");
	
	if ($rw eq "r") {
		print "Unable to open file: $f for reading.\n";
	} else {
		print "Unable to write to file: $f .\n";
	}
	print "Check file permissions and try again.\n";
	
	print "<p><a href=javascript:history.go(-1)>[Back]</a>";
	
	print "</body></html>\n";
	exit();
}

sub printPretty {
	local($var) = @_;
	$var =~ s/_/ /g;
	$var =~ s/\// \/ /g;
	return($var);
}

sub printHdrTxtPretty {
	local($text) = @_;
	local($i, @s);

	$text =~ s/_/ /g;
	if ($text =~ /\//) {
		@s = split(/\//, $text);
		for ($i=0; $i < @s; $i++) {
			if ($i % 2) {
				print " $FontRed", @s[$i], "</font> ";
			} else {
				print "<i>", @s[$i], "</i>";
			}
		}
	} else {
		print "<i>", $text, "</i>";
	}
}

sub printSelOptions {
	local ($BtnSelectedopt, *opts) = @_;
	local ($p) = 0;
	
	for ($p=0; $p < @opts; $p++) {
		print "<option value=\"", @opts[$p], "\"";
		if ($BtnSelectedopt eq @opts[$p]) {
			print " selected";
		} 
		print "> ", @opts[$p], "\n";
	}
}

sub printJavascript {

	# This is the window opening javascript code. It is common to all of
	# the other scripts.

	print <<end_print;
	
<script language=javascript>
<!-- 
	// window.onerror=null;

	function donothing() {
	}

	function openwin(doc,w,h,wname) {
		var hei = 480;
		var wid = 540;
		var width = w;
		var height = h;
        
		// To make sure we get a new window, use the time as the window name
		var thedate = new Date();
		if ((wname) && wname != null) {
			var winname = wname;
		} else {
			var winname = thedate.getTime();
		}
		
		if ((width) && width != '' && width > 0 && (height) && height != '' && height > 0) {
			wid = width;
			hei = height;
		}

		options = "location=0,toolbar=0,menubar=0,resizable=1,scrollbars=1,width=" + wid + ",height=" + hei;
		if (winname == 'PreviewLayout' || winname == 'HelpWin') {
			if (screen.width > 1000) {
				wid = 800;
				hei = 600
			}
			if (winname == 'HelpWin') {
				options = "location=0,toolbar=1,menubar=0,resizable=1,scrollbars=1,width=" + wid + ",height=" + hei;
			} else {
				options = "location=0,toolbar=0,menubar=1,resizable=1,scrollbars=1,width=" + wid + ",height=" + hei;
			}
		}

		winname = window.open(doc, winname, options);
		winname.focus();
	}

// -->	
</script>
	
end_print

}

sub printResetJavascript {

	# Code to reset forms

	print <<end_print;
	
	<script language=javascript>

	<!-- 
	// For resetting forms
	function resetforms() {
		var numforms = document.forms.length;
		for(var i=0; i < numforms; i++) {
			document.forms[i].reset();
		}
	}
	
	// -->
	
	</script>
end_print

}

# Code for selecting multiple checkboxes.
sub printCheckSelJS {
	print <<end_print;
	
	<script language=javascript>
	function selectAll(whichOne) {
		for (var i=0; i < document.forms[0].elements.length; i++) {
			if (document.forms[0].elements[i].name == whichOne) {
				document.forms[0].elements[i].checked = true;
			}
		}
	}
	function deselectAll(whichOne) {
		for (var i=0; i < document.forms[0].elements.length; i++) {
			if (document.forms[0].elements[i].name == whichOne) {
				document.forms[0].elements[i].checked = false;
			}
		}
	}
	function selectInverse(whichOne) {
		for (var i=0; i < document.forms[0].elements.length; i++) {
			if (document.forms[0].elements[i].name == whichOne) {
				document.forms[0].elements[i].checked = !document.forms[0].elements[i].checked;
			}
		}
	}
	</script>
	
end_print
}
