// #########################################################
// === File #5 of 14 : user.h ==============================
// ------------------- C++ code : BEGIN --------------------

// ==============================================================
//
//  Copyright (c) 2002 by Alex Vinokur.  This work and all works
//  derived from it may be copied and modified without any
//  restrictions other than that a copy of this copyright notice
//  must be included in any copy of this work or any derived work.
//
// ==============================================================
// #########################################################
// ## mailto:alexvn@go.to, mailto:alexv@hitechclub.com
// ## http://up.to/alexv, http://go.to/alexv_math
// #########################################################
// ==============================================================


// ##############################################################
//
//  SOFTWARE : C/C++ Program Perfometer
//  FILE     : user.h
//
//  DESCRIPTION :
//         Declaration of performeter's functions implemented by user.
//         The functions have to be implemented
//	   in the following files 
//	   * adapt.c
//	   * user's source file(s); for instance, demo.c
//
// ##############################################################



////////////////
#ifndef _USER_H
#define _USER_H
////////////////

//==================
#include "common.h"


//#########################################
//#
//#  enum
//#
//#########################################
//=============================
enum ResourceType
{
  UNDEF_ResourceType,
  //-------------------------------------
  //--- According to struct rusage ------
  //-------------------------------------
  RESOURCE_user_time_used,
  RESOURCE_system_time_used,
  RESOURCE_max_resident_set_size,
  RESOURCE_integral_shared_text_memory_size,
  RESOURCE_integral_unshared_data_size,
  RESOURCE_integral_unshared_stack_size,
  RESOURCE_page_reclaims,
  RESOURCE_page_faults,
  RESOURCE_swaps,
  RESOURCE_block_input_operations,
  RESOURCE_block_output_operations,
  RESOURCE_messages_sent,
  RESOURCE_signals_received,
  RESOURCE_voluntary_context_switches,
  RESOURCE_involuntary_context_switches,
  //-------------------------------------
  //--- Another metrics -----------------
  //-------------------------------------
  RESOURCE_pseudo,
  LAST_ResourceType
};


//#########################################
//#
//#  typedefs
//#
//#########################################
//=============================
typedef void TypeMeasuredFunc (void);
//=============================



//#########################################
//#
//#  Global Template Functions 
//#  	DECLARATION
//#  --------------------------------------
//#  The functions below must be specializated
//#  in file adapt.c
//#  --------------------------------------
//#
//#########################################
//=============================
template <typename T1, typename T2, ResourceType T3>
string GetResourceStateUnitName ();

template <typename T1, typename T2, ResourceType T3>
string GetResourceCostUnitName ();

template <typename T1, typename T2, ResourceType T3>
string GetResourceName ();

template <typename T1, typename T2, ResourceType T3>
T1 GetCurrentResource();

template <typename T1, typename T2, ResourceType T3>
T2 GetDiffResourceValue(
	const T1&	start_resource_value_i, 
	const T1&	end_resource_value_i
	);

template <typename T1, typename T2, ResourceType T3>
bool ResourceValueIsSuspiciouslySmall (T2 value_i);

template <typename T1, typename T2, ResourceType T3>
bool ResourceValueIsSuspiciouslyBig (T2 value_i);



 //#########################################
//#
//#  Global Functions 
//#  	DECLARATION
//#  --------------------------------------
//#  The functions below must be implemented
//#  in file adapt.c
//#  --------------------------------------
//#
//#########################################

void SetEnvIt ();
void MeasureIt ();
void CompareIt ();


//###################
#endif	// _USER_H
//###################

//#######################################
//############# END OF FILE #############
//#######################################

// ------------------- C++ code : END ----------------------
// === File #5 of 14 : user.h ==============================
