// #########################################################
// === File #13 of 14 : demo2.cpp ==========================
// ------------------- C++ code : BEGIN --------------------

// ==============================================================
//
//  Copyright (c) 2002 by Alex Vinokur.  This work and all works
//  derived from it may be copied and modified without any
//  restrictions other than that a copy of this copyright notice
//  must be included in any copy of this work or any derived work.
//
// ==============================================================
// #########################################################
// ## mailto:alexvn@go.to, mailto:alexv@hitechclub.com
// ## http://up.to/alexv, http://go.to/alexv_math
// #########################################################
// ==============================================================


// ##############################################################
//
//  SOFTWARE : C/C++ Program Perfometer
//  FILE     : demo2.cpp
//
//  DESCRIPTION :
//         Implementation of measured/compared functions
//
// ##############################################################

//==============
#include "demo.h"
//==============

//#########################################
//#
//#  Functions To Be Measured (Compared)
//#  Prototypes are in file demo.h
//#
//#########################################

#define	STRING_SIZE_1	5
#define	STRING_SIZE_2	25
#define	STRING_SIZE_3	125

//----------------------------
void get_string_size (void)
{
string sstr1 (STRING_SIZE_1, 'a');
string sstr2 (STRING_SIZE_2, 'b');
string sstr3 (STRING_SIZE_3, 'c');

char cstr1 [STRING_SIZE_1 + 1];
char cstr2 [STRING_SIZE_2 + 1];
char cstr3 [STRING_SIZE_3 + 1];

  strcpy (cstr1, sstr1.c_str());
  strcpy (cstr2, sstr2.c_str());
  strcpy (cstr3, sstr3.c_str());

const string text_sstr1 = "string-size-" + to_string (STRING_SIZE_1);
const string text_sstr2 = "string-size-" + to_string (STRING_SIZE_2);
const string text_sstr3 = "string-size-" + to_string (STRING_SIZE_3);

const string text_cstr1 = "strlen-" + to_string (STRING_SIZE_1);
const string text_cstr2 = "strlen-" + to_string (STRING_SIZE_2);
const string text_cstr3 = "strlen-" + to_string (STRING_SIZE_3);


  //---------------------------------------------------------
  {
  TURN_ON (clock_t, clock_t, RESOURCE_user_time_used, text_sstr1) 
    {
      sstr1.size();
    }
  }


  //---------------------------------------------------------
  {
  TURN_ON (clock_t, clock_t, RESOURCE_user_time_used, text_sstr2) 
    {
      sstr2.size();
    }
  }


  //---------------------------------------------------------
  {
  TURN_ON (clock_t, clock_t, RESOURCE_user_time_used, text_sstr3) 
    {
      sstr3.size();
    }
  }

  //---------------------------------------------------------
  {
  TURN_ON (clock_t, clock_t, RESOURCE_user_time_used, text_cstr1) 
    {
      strlen (cstr1);
    }
  }

  //---------------------------------------------------------
  {
  TURN_ON (clock_t, clock_t, RESOURCE_user_time_used, text_cstr2) 
    {
      strlen (cstr2);
    }
  }


  //---------------------------------------------------------
  {
  TURN_ON (timeval, ulonglong, RESOURCE_user_time_used, text_cstr2) 
    {
      strlen (cstr2);
    }
  }

  //---------------------------------------------------------
  {
  TURN_ON (clock_t, clock_t, RESOURCE_user_time_used, text_cstr3) 
    {
      strlen (cstr3);
    }
  }


  //---------------------------------------------------------
  {
  TURN_ON (timeval, ulonglong, RESOURCE_user_time_used, text_cstr3) 
    {
      strlen (cstr3);
    }
  }


} // get_strlen



//----------------------------
void write_to_stream (void)
{
string sstr1 (STRING_SIZE_1, 'a');
string sstr2 (STRING_SIZE_2, 'b');

const string text_osstr1 = "to-ostringstream-" + to_string (STRING_SIZE_1);
const string text_osstr2 = "to-ostringstream-" + to_string (STRING_SIZE_2);

const string text_ostr1 = "to-ostrstream" + to_string (STRING_SIZE_1);
const string text_ostr2 = "to-ostrstream" + to_string (STRING_SIZE_2);


  //---------------------------------------------------------
  {
  TURN_ON (clock_t, clock_t, RESOURCE_user_time_used, text_osstr1) 
    {
      ostringstream osstr;
      osstr << sstr1;
    }
  }


  //---------------------------------------------------------
  {
  TURN_ON (clock_t, clock_t, RESOURCE_user_time_used, text_osstr2) 
    {
      ostringstream osstr;
      osstr << sstr2;
    }
  }


  //---------------------------------------------------------
  {
  TURN_ON (clock_t, clock_t, RESOURCE_user_time_used, text_ostr1) 
    {
      ostrstream ostr;
      ostr << sstr1;
      ostr.rdbuf()->freeze (0);
    }
  }

  //---------------------------------------------------------
  {
  TURN_ON (clock_t, clock_t, RESOURCE_user_time_used, text_ostr2) 
    {
      ostrstream ostr;
      ostr << sstr2;
      ostr.rdbuf()->freeze (0);
    }
  }

} // write_to_stream

// ------------------- C++ code : END ----------------------
// === File #13 of 14 : demo2.cpp ==========================
