/*
 * Created on Nov 7, 2003
 */
import java.awt.BorderLayout;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextPane;

/**
 * Displays general information about the Java Date Picker and the JVM.
 */
public class AboutDemo extends JPanel {
	private JTextPane message;

	public AboutDemo() {
		message = new JTextPane();
		message.setContentType("text/html");
		
		StringBuffer buffer = new StringBuffer();
		buffer.append("<html>");
		buffer.append("<h1>Java Date Picker</h1>");
		buffer.append("Version: 2.0.0<br>");
		buffer.append("(c) Copyright Standby Soft 2003. All rights reserved.<br>");
		buffer.append("Visit <a href='http://www.javadatepicker.com'>http://www.javadatepicker.com</a> for more information.<br>");
		buffer.append("<hr>");
		buffer.append("Java VM Version: " + System.getProperty("java.vm.version", "Unable to determine"));
		buffer.append("</html>");

		message.setText(buffer.toString());
		message.setEditable(false);

		setLayout(new BorderLayout());
		add(message, BorderLayout.CENTER);
	}

	private static void createAndShowGUI() {
		//Create and set up the window.
		JFrame frame = new JFrame("About");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		//Create and set up the content pane.
		AboutDemo newContentPane = new AboutDemo();
		newContentPane.setOpaque(true); //content panes must be opaque
		frame.setContentPane(newContentPane);

		//Display the window.
		frame.pack();
		frame.setVisible(true);
	}

	public static void main(String[] args) {
		//Schedule a job for the event-dispatching thread:
		//creating and showing this application's GUI.
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				createAndShowGUI();
			}
		});
	}
}
