/*
 * Decompiled with CFR 0.152.
 */
package javazoom.download;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javazoom.download.DownloadFolderSource;
import javazoom.download.DownloadListener;
import javazoom.download.DownloadSource;
import javazoom.download.DownloadZipSource;
import javazoom.download.util.Base64;
import javazoom.download.util.Config;
import javazoom.download.util.ConfigHandler;
import javazoom.download.util.DatabaseConfig;
import javazoom.download.util.Debug;
import javazoom.download.util.FileInfo;
import javazoom.download.util.FolderConfig;
import javazoom.download.util.MimeHandler;
import javazoom.download.util.ZipConfig;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DownloadImpl {
    public static String REALM = "Download4J Realm";
    public static String DEFAULTCONTENTTYPE = "application/unknown";
    public static String ZIPCONTENTTYPE = "application/zip";
    public static String DEFAULTCONTENTDISPOSITION = "";
    public static String LOGFILENAME = "download4j";
    public static String LOGFILEEXTENSION = ".log";
    public static String LOGFILEDATEFORMAT = "-yyyy-MM-dd_HH-mm";
    public static int UNKNOWN = -1;
    public static int FOLDER = 0;
    public static int ZIP = 1;
    public static int DATABASE = 2;
    private Config _$185 = null;
    private DownloadSource _$310 = null;
    private Properties _$312 = null;
    private DownloadListener _$313 = null;
    static /* synthetic */ Class class$javazoom$download$util$Config;

    public DownloadImpl(String string, String string2, DownloadListener downloadListener) throws SAXException, ParserConfigurationException, IOException {
        String string3;
        this._$313 = downloadListener;
        string2 = string2.replace('\\', '/').replace('/', File.separatorChar);
        string = string.replace('\\', '/').replace('/', File.separatorChar);
        String string4 = string + File.separatorChar + string2;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        ConfigHandler configHandler = new ConfigHandler(string);
        sAXParser.parse(new File(string4), (DefaultHandler)configHandler);
        Debug debug = Debug.getInstance();
        debug.setLogLevel(configHandler.getLogLevel());
        String string5 = configHandler.getLogFolder();
        if (string5 != null) {
            string5 = string5 + "/" + LOGFILENAME + new SimpleDateFormat(LOGFILEDATEFORMAT).format(new Date()) + LOGFILEEXTENSION;
            string5 = string5.replace('\\', '/').replace('/', File.separatorChar);
            debug.setFileWriter(string5);
        }
        this._$185 = configHandler.getConfig();
        if (this._$185 instanceof FolderConfig) {
            this._$310 = new DownloadFolderSource(this._$185);
        } else if (this._$185 instanceof ZipConfig) {
            this._$310 = new DownloadZipSource(this._$185);
        } else if (this._$185 instanceof DatabaseConfig) {
            try {
                string3 = ((DatabaseConfig)this._$185).getImplementation();
                this._$310 = this._$339(string3);
                this._$246(Debug.INFO, string3 + " loaded");
            }
            catch (Exception exception) {
                this._$246(0, exception.getMessage());
            }
        }
        string3 = this._$185.getProperties().getProperty("PATH") + File.separatorChar + this._$185.getProperties().getProperty("CONTENT-TYPE-FILE");
        string3 = string3.replace('\\', '/').replace('/', File.separatorChar);
        MimeHandler mimeHandler = new MimeHandler();
        sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(new File(string3), (DefaultHandler)mimeHandler);
        this._$312 = mimeHandler.getMimes();
        if (downloadListener != null) {
            downloadListener.update(this._$185.getFiles());
        }
        this._$246(Debug.DEBUG, "DownloadImpl initialized successfully");
    }

    public void process(String string, Properties properties, HttpServletResponse httpServletResponse) throws IOException {
        int n;
        String string2;
        String string3;
        int n2;
        String string4;
        String string5;
        Object object;
        String string6 = properties.getProperty("Authorization");
        String string7 = properties.getProperty("RemoteAddr");
        String string8 = properties.getProperty("customfield");
        Object object2 = null;
        Vector vector = this._$185.getFiles();
        int n3 = 0;
        while (n3 < vector.size()) {
            object = (FileInfo)vector.elementAt(n3);
            if (((FileInfo)object).getUrlMapping().equals(string)) {
                if (!string8.equals("")) {
                    if (((FileInfo)object).getCustomField().equals(string8)) {
                        object2 = object;
                        break;
                    }
                } else {
                    object2 = object;
                    break;
                }
            }
            ++n3;
        }
        if (object2 == null) {
            object = this._$185.getProperties();
            string5 = this._$312.getProperty(FileInfo.getExtension(string));
            if (string5 == null) {
                string5 = DEFAULTCONTENTTYPE;
            }
            if ((string4 = ((Properties)object).getProperty("CONTENT-DISPOSITION")) == null) {
                string4 = "";
            }
            n2 = 0;
            string3 = ((Properties)object).getProperty("ZIP");
            if (string3 != null && string3.equalsIgnoreCase("enabled")) {
                n2 = 1;
            }
            string2 = null;
            if (this._$185 instanceof FolderConfig) {
                string2 = ((FolderConfig)this._$185).getPath();
            } else if (this._$185 instanceof ZipConfig) {
                string2 = ((ZipConfig)this._$185).getPath();
            }
            object2 = new FileInfo(string2, string, string, string5, string4, n2 != 0, -1, ((Properties)object).getProperty("LOGIN"), ((Properties)object).getProperty("PASSWORD"), string8);
            vector.addElement(object2);
        }
        string = ((FileInfo)object2).getFilename();
        if (string6 != null && string6.toLowerCase().startsWith("basic")) {
            string6 = string6.substring(string6.lastIndexOf(" ") + 1, string6.length());
        }
        if ((n = this.checkAuth(string6, (FileInfo)object2)) != -1) {
            this._$246(Debug.INFO, "WWW-Authenticate for " + string + " [" + string7 + "," + string6 + "]");
            if (n == 1) {
                httpServletResponse.setHeader("WWW-Authenticate", "BASIC realm=\"" + REALM + "\"");
                httpServletResponse.sendError(401);
                return;
            }
        }
        if (((FileInfo)object2).getMaxDownload() > 0 && ((FileInfo)object2).getTotalDownload() >= ((FileInfo)object2).getMaxDownload()) {
            httpServletResponse.sendError(403, "Downloads limit reached");
            return;
        }
        string5 = ((FileInfo)object2).getContentType();
        if (string5 == null && (string5 = this._$312.getProperty(FileInfo.getExtension(string))) == null) {
            string5 = DEFAULTCONTENTTYPE;
        }
        if ((string4 = ((FileInfo)object2).getContentDisposition()) == null) {
            string4 = DEFAULTCONTENTDISPOSITION;
        }
        if (((FileInfo)object2).isZipEnabled()) {
            string5 = ZIPCONTENTTYPE;
        }
        if ((n2 = this.getDataLength((FileInfo)object2)) > 0) {
            try {
                string3 = "" + n2;
                httpServletResponse.setContentType(string5);
                if (string4 != null && !string4.equals("")) {
                    httpServletResponse.setHeader("Content-Disposition", string4 + ";filename=" + ((FileInfo)object2).getFilename());
                }
                if (!((FileInfo)object2).isZipEnabled()) {
                    httpServletResponse.setContentLength(n2);
                } else {
                    string3 = "- zipped on the fly - ???";
                }
                this._$246(Debug.INFO, "Start downloading : " + string + " " + string3 + " bytes (" + string5 + ") " + string4);
                string2 = httpServletResponse.getOutputStream();
                this.download((FileInfo)object2, (OutputStream)((Object)string2));
                this._$391((FileInfo)object2, true);
                this._$246(Debug.INFO, "Download successfull [" + ((FileInfo)object2).getTotalDownload() + "] : " + string);
            }
            catch (IOException iOException) {
                this._$246(Debug.INFO, "Download " + string + " cancelled : " + iOException.getMessage());
                this._$391((FileInfo)object2, false);
            }
        } else if (n2 == 0) {
            httpServletResponse.sendError(204);
        } else {
            this._$246(Debug.DEBUG, "Download " + string + " failed : Not exist or not readable");
            httpServletResponse.sendError(404);
        }
    }

    public int checkAuth(String string, FileInfo fileInfo) {
        String string2 = fileInfo.getLogin();
        String string3 = fileInfo.getPassword();
        return this.checkAuth(string, string2, string3);
    }

    public int checkAuth(String string, String string2, String string3) {
        if (string2 != null && !string2.equals("") && string3 != null && !string3.equals("")) {
            if (string != null && !string.equals("")) {
                String string4 = new String(Base64.decode(string));
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ":");
                String string5 = null;
                String string6 = null;
                if (stringTokenizer.hasMoreTokens()) {
                    string5 = stringTokenizer.nextToken();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string6 = stringTokenizer.nextToken();
                }
                if (string5 != null && string5.equals(string2) && string6 != null && string6.equals(string3)) {
                    return 0;
                }
                return 1;
            }
            return 1;
        }
        return -1;
    }

    public int getDataLength(FileInfo fileInfo) {
        if (this._$310 == null) {
            return -1;
        }
        return this._$310.getDataLength(fileInfo);
    }

    public void download(FileInfo fileInfo, OutputStream outputStream) throws IOException {
        if (this._$310 != null) {
            this._$310.download(fileInfo, outputStream);
        }
    }

    private void _$391(FileInfo fileInfo, boolean bl) {
        if (bl) {
            fileInfo.addDownload();
        } else {
            fileInfo.addIncompleteDownload();
        }
        if (this._$313 != null) {
            this._$313.updateFilename(fileInfo.getFilename());
        }
    }

    private DownloadSource _$339(String string) throws Exception {
        if (string != null) {
            Class<?> clazz = Class.forName(string);
            Class<?> clazz2 = clazz.getSuperclass();
            if (clazz2.getName().equals("javazoom.download.DownloadSource")) {
                Class[] classArray = new Class[]{class$javazoom$download$util$Config == null ? (class$javazoom$download$util$Config = DownloadImpl.class$("javazoom.download.util.Config")) : class$javazoom$download$util$Config};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{this._$185};
                DownloadSource downloadSource = (DownloadSource)constructor.newInstance(objectArray);
                return downloadSource;
            }
            throw new Exception("Wrong super class : " + string);
        }
        return null;
    }

    private void _$246(int n, String string) {
        Debug.getInstance().trace(n, this.getClass().getName() + ": " + string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

