{*******************************************************}
{                     PHP4Delphi                        }
{               PHP - Delphi interface                  }
{                       v.5.0                           }
{ Author:                                               }
{ Serhiy Perevoznyk                                     }
{ serge_perevoznyk@hotmail.com                          }
{ http://users.chello.be/ws36637                        }
{*******************************************************}
{$I PHP.INC}
unit DelphiFunctions;

interface
uses
  Windows, SysUtils, Classes, ZendAPI, PHPAPI, Dialogs, ShellAPI;

var
  DelphiTable : array [0..9] of zend_function_entry;

 author_functions : array[0..2] of zend_function_entry;
 author_class_entry : Tzend_class_entry;
 ce : pzend_class_entry;

procedure InitDelphiFunctions;
procedure RegisterAuthorClass(p : pointer);

implementation


procedure delphi_get_system_directory(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;

var
  Dir: array[0..MAX_PATH] of Char;
  p : pchar;
begin
  GetSystemDirectory(Dir, MAX_PATH);
  p := dir;
  ZVAL_STRING(return_value, p, true);
end;

procedure delphi_str_date(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;
begin
  ZVAL_STRING(return_value, PChar(DateToStr(Date)), true);
end;


procedure delphi_date(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;
begin
  ZVAL_DOUBLE(return_value, Date);
end;

procedure delphi_extract_file_dir(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;
var
  Param : array of Pzval;
  P : PChar;
begin
  if ( not (zend_get_parameters_ex(1, @Param) = SUCCESS )) then
  begin
    zend_wrong_param_count(TSRMLS_DC);
    Exit;
  end;
  convert_to_string(param[0]);
  p := PChar(ExtractFileDir(param[0].value.str.val));
  ZVAL_STRING(return_value, p, true);
end;


procedure delphi_extract_file_drive(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;
var
  Param : array of Pzval;
  P : PChar;
begin
  if ( not (zend_get_parameters_ex(1, @Param) = SUCCESS )) then
  begin
    zend_wrong_param_count(TSRMLS_DC);
    Exit;
  end;
  convert_to_string(param[0]);
  p := PChar(ExtractFileDrive(param[0].value.str.val));
  ZVAL_STRING(return_value, p, true);
end;


procedure delphi_extract_file_name(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;
var
  Param : array of Pzval;
  P : PChar;
begin
  if ( not (zend_get_parameters_ex(1, @Param) = SUCCESS )) then
  begin
    zend_wrong_param_count(TSRMLS_DC);
    Exit;
  end;
  convert_to_string(param[0]);
  p := PChar(ExtractFileName(param[0].value.str.val));
  ZVAL_STRING(return_value, p, true);
end;


procedure delphi_extract_file_ext(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;
var
  Param : array of Pzval;
  P : PChar;
begin
  if ( not (zend_get_parameters_ex(1, @Param) = SUCCESS )) then
  begin
    zend_wrong_param_count(TSRMLS_DC);
    Exit;
  end;
  convert_to_string(param[0]);
  p := PChar(ExtractFileExt(param[0].value.str.val));
  ZVAL_STRING(return_value, p, true);
end;


procedure delphi_show_message(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;
var
  Param : array of Pzval;
  P : PChar;
begin
  if ( not (zend_get_parameters_ex(1, @Param) = SUCCESS )) then
  begin
    zend_wrong_param_count(TSRMLS_DC);
    Exit;
  end;
  convert_to_string(param[0]);
  p := param[0].value.str.val;
  ShowMessage(P);
end;


procedure delphi_send_email(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;
begin
  ShellExecute(0, 'open', 'mailto:serge_perevoznyk@hotmail.com', nil, nil, SW_SHOWNORMAL);
end;


procedure delphi_visit_homepage(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;
begin
  ShowMessage('visit http://psvlib.sourceforge.net');
end;


procedure RegisterAuthorClass(p : pointer);
begin
  author_functions[0].fname := 'send_email';
  author_functions[0].handler := @delphi_send_email;
  author_functions[1].fname := 'visit_homepage';
  author_functions[1].handler := @delphi_visit_homepage;
  INIT_CLASS_ENTRY(author_class_entry, 'php4delphi_author', @author_functions);
  ce := zend_register_internal_class(@author_class_entry, p);
end;

procedure delphi_get_author(ht : integer; return_value : pzval; this_ptr : pzval;
      return_value_used : integer; TSRMLS_DC : pointer); cdecl;
var
 properties : array[0..3] of pchar;
begin
  properties[0] := 'name';
  properties[1] := 'last';
  properties[2] := 'height';
  properties[3] := 'email';
  _object_init_ex(return_value, ce, nil, 0, TSRMLS_DC );
  add_property_string_ex(return_value, properties[0], strlen(properties[0]) + 1, 'Serhiy', 1);
  add_property_string_ex(return_value, properties[1], strlen(properties[1]) + 1, 'Perevoznyk', 1);
  add_property_long_ex(return_value, properties[2], strlen(properties[2]) + 1, 185);
  add_property_string_ex(return_value, properties[3], strlen(properties[3]) + 1, 'serge_perevoznyk@hotmail.com', 1);
end;

procedure InitDelphiFunctions;
begin
  PHP_FUNCTION(DelphiTable[0], 'delphi_date', @delphi_date);
  PHP_FUNCTION(DelphiTable[1], 'delphi_extract_file_dir', @delphi_extract_file_dir);
  PHP_FUNCTION(DelphiTable[2], 'delphi_extract_file_drive', @delphi_extract_file_drive);
  PHP_FUNCTION(DelphiTable[3], 'delphi_extract_file_name', @delphi_extract_file_name);

  DelphiTable[4].fname := 'delphi_extract_file_ext';
  DelphiTable[4].handler := @delphi_extract_file_ext;
  DelphiTable[4].func_arg_types := nil;

  DelphiTable[5].fname := 'delphi_show_message';
  DelphiTable[5].handler := @delphi_show_message;
  DelphiTable[5].func_arg_types := nil;

  DelphiTable[6].fname := 'delphi_get_author';
  DelphiTable[6].handler := @delphi_get_author;
  DelphiTable[6].func_arg_types := nil;

  DelphiTable[7].fname := 'delphi_str_date';
  DelphiTable[7].handler := @delphi_str_date;
  DelphiTable[7].func_arg_types := nil;

  PHP_FUNCTION(DelphiTable[8], 'delphi_get_system_directory', @delphi_get_system_directory);
end;

end.