/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.identity.UniqueOrKey;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractIDConstraintTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.util.DOMUtil;
import org.w3c.dom.Element;

class XSDUniqueOrKeyTraverser
extends XSDAbstractIDConstraintTraverser {
    public XSDUniqueOrKeyTraverser(XSDHandler handler, XSAttributeChecker gAttrCheck) {
        super(handler, gAttrCheck);
    }

    void traverse(Element uElem, XSElementDecl element, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(uElem, false, schemaDoc);
        String uName = (String)attrValues[XSAttributeChecker.ATTIDX_NAME];
        if (uName == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{DOMUtil.getLocalName(uElem), SchemaSymbols.ATT_NAME});
            this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
            return;
        }
        UniqueOrKey uniqueOrKey = null;
        uniqueOrKey = DOMUtil.getLocalName(uElem).equals(SchemaSymbols.ELT_UNIQUE) ? new UniqueOrKey(uName, element.fName, 0) : new UniqueOrKey(uName, element.fName, 1);
        this.traverseIdentityConstraint(uniqueOrKey, uElem, schemaDoc, attrValues);
        grammar.addIDConstraintDecl(element, uniqueOrKey);
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
    }
}

