/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSGroupDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractParticleTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Element;

class XSDGroupTraverser
extends XSDAbstractParticleTraverser {
    XSDGroupTraverser(XSDHandler handler, XSAttributeChecker gAttrCheck) {
        super(handler, gAttrCheck);
    }

    XSParticleDecl traverseLocal(Element elmNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(elmNode, false, schemaDoc);
        QName refAttr = (QName)attrValues[XSAttributeChecker.ATTIDX_REF];
        XInt minAttr = (XInt)attrValues[XSAttributeChecker.ATTIDX_MINOCCURS];
        XInt maxAttr = (XInt)attrValues[XSAttributeChecker.ATTIDX_MAXOCCURS];
        XSGroupDecl group = null;
        if (refAttr == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{"group (local)", "ref"});
        } else {
            group = (XSGroupDecl)this.fSchemaHandler.getGlobalDecl(schemaDoc, 4, refAttr);
        }
        if (DOMUtil.getFirstChildElement(elmNode) != null) {
            this.reportSchemaError("s4s-elt-must-match", new Object[]{"group (local)", "(annotation?)"});
        }
        int minOccurs = minAttr.intValue();
        int maxOccurs = maxAttr.intValue();
        XSParticleDecl particle = null;
        if (group != null && (minOccurs != 0 || maxOccurs != 0)) {
            if (minOccurs == 1 && maxOccurs == 1) {
                particle = group.fParticle;
            } else if (minOccurs != 1 || maxOccurs != 1) {
                particle = new XSParticleDecl();
                particle.fType = group.fParticle.fType;
                particle.fValue = group.fParticle;
                particle.fMinOccurs = minOccurs;
                particle.fMaxOccurs = maxOccurs;
            }
        }
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return particle;
    }

    XSGroupDecl traverseGlobal(Element elmNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object redefinedGrp;
        Object[] attrValues = this.fAttrChecker.checkAttributes(elmNode, true, schemaDoc);
        String strNameAttr = (String)attrValues[XSAttributeChecker.ATTIDX_NAME];
        if (strNameAttr == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{"group (global)", "name"});
        }
        XSGroupDecl group = null;
        XSParticleDecl particle = null;
        Element l_elmChild = DOMUtil.getFirstChildElement(elmNode);
        if (l_elmChild == null) {
            this.reportSchemaError("s4s-elt-must-match", new Object[]{"group (global)", "(annotation?, (all | choice | sequence))"});
        } else {
            Object[] args;
            String childName = l_elmChild.getLocalName();
            if (childName.equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.traverseAnnotationDecl(l_elmChild, attrValues, true, schemaDoc);
                l_elmChild = DOMUtil.getNextSiblingElement(l_elmChild);
                if (l_elmChild != null) {
                    childName = l_elmChild.getLocalName();
                }
            }
            if (l_elmChild == null) {
                this.reportSchemaError("s4s-elt-must-match", new Object[]{"group (global)", "(annotation?, (all | choice | sequence))"});
            } else if (childName.equals(SchemaSymbols.ELT_ALL)) {
                particle = this.traverseAll(l_elmChild, schemaDoc, grammar, 4);
            } else if (childName.equals(SchemaSymbols.ELT_CHOICE)) {
                particle = this.traverseChoice(l_elmChild, schemaDoc, grammar, 4);
            } else if (childName.equals(SchemaSymbols.ELT_SEQUENCE)) {
                particle = this.traverseSequence(l_elmChild, schemaDoc, grammar, 4);
            } else {
                args = new Object[]{"group", childName};
                this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "GroupContentRestricted", args, (short)1);
            }
            if (l_elmChild != null && DOMUtil.getNextSiblingElement(l_elmChild) != null) {
                args = new Object[]{"group", childName};
                this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "GroupContentRestricted", args, (short)1);
            }
            if (particle != null && strNameAttr != null) {
                group = new XSGroupDecl();
                group.fName = strNameAttr;
                group.fTargetNamespace = schemaDoc.fTargetNamespace;
                group.fParticle = particle;
                grammar.addGlobalGroupDecl(group);
            }
        }
        if (group != null && (redefinedGrp = this.fSchemaHandler.getGrpOrAttrGrpRedefinedByRestriction(4, new QName(this.fSchemaHandler.EMPTY_STRING, strNameAttr, strNameAttr, schemaDoc.fTargetNamespace), schemaDoc)) != null) {
            grammar.addRedefinedGroupDecl(group, (XSGroupDecl)redefinedGrp);
        }
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return group;
    }
}

