/*
 * Decompiled with CFR 0.152.
 */
package com.synex.xml.sax;

import com.synex.xml.db.DBManager;
import com.synex.xml.db.DBManagerException;
import com.synex.xml.db.DBManagerImpl;
import com.synex.xml.ext.CustomAction;
import com.synex.xml.sax.XMLHandler;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLHandlerImpl
implements XMLHandler {
    public static final String ATTR_DRIVER = "driver";
    public static final String ATTR_URL = "url";
    public static final String ATTR_USER = "user";
    public static final String ATTR_PASSWORD = "password";
    public static final String ATTR_STATUS = "status";
    private Stack context = new Stack();
    private Properties props = new Properties();
    private Hashtable actionPool = new Hashtable();
    private String cdata;
    private DBManager db;
    private String status;

    public XMLHandlerImpl() {
        this(new DBManagerImpl());
    }

    public XMLHandlerImpl(DBManager dbManager) {
        this(dbManager, null);
    }

    public XMLHandlerImpl(DBManager dbManager, String sqlMapFile) {
        this.db = dbManager;
        this.setSQLMapFile(sqlMapFile);
    }

    public void setSQLMapFile(String sqlMapFile) {
        if (sqlMapFile != null && !sqlMapFile.equals("")) {
            try {
                this.props.load(new FileInputStream(sqlMapFile));
                System.out.println("SQL Map File: " + sqlMapFile + " was opened.");
            }
            catch (FileNotFoundException fne) {
                System.out.println("SQL Map Warning: " + fne.getMessage());
            }
            catch (IOException ioe) {
                System.out.println("SQL Map Warning: " + ioe.getMessage());
            }
        }
    }

    public void handleElement(String element, String data, Attributes meta) throws SAXException {
        this.cdata = data == null ? "" : new String(data);
    }

    public void handleElement(String element, Attributes meta) throws SAXException {
        this.handleElement(element, null, meta);
    }

    public void startElement(String element, Attributes meta) throws SAXException {
        AttributesImpl attrs = new AttributesImpl(meta);
        try {
            if (this.context.empty()) {
                this.db.open(attrs.getValue(ATTR_DRIVER), attrs.getValue(ATTR_URL), attrs.getValue(ATTR_USER), attrs.getValue(ATTR_PASSWORD));
                this.status = attrs.getValue(ATTR_STATUS).trim();
            } else {
                String key;
                Hashtable ids = new Hashtable();
                Hashtable<String, String> fields = new Hashtable<String, String>();
                int i = 0;
                while (i < attrs.getLength()) {
                    if ("ID".equals(attrs.getType(i))) {
                        ids.putAll(this.getSQLIds(this.getSQLName(attrs.getQName(i)), attrs.getValue(i)));
                    } else if ("IDREF".equals(attrs.getType(i))) {
                        fields.putAll(this.getSQLIds(this.getSQLName(attrs.getQName(i)), attrs.getValue(i)));
                    } else {
                        fields.put(this.getSQLName(attrs.getQName(i)), this.checkValue(attrs.getValue(i)));
                    }
                    ++i;
                }
                if (this.context.size() > 1) {
                    Object[] ctx = (Object[])this.context.peek();
                    Attributes parentAttrs = (Attributes)ctx[1];
                    int i2 = 0;
                    while (i2 < parentAttrs.getLength()) {
                        String fkName = this.getSQLName(parentAttrs.getQName(i2) + "_" + element, parentAttrs.getQName(i2));
                        if ("ID".equals(parentAttrs.getType(i2)) && !fields.containsKey(fkName)) {
                            fields.put(fkName, parentAttrs.getValue(i2));
                        }
                        ++i2;
                    }
                }
                if ("create".equals(this.status)) {
                    ids.putAll(this.db.addRow(this.getSQLName(element), ids, fields));
                } else if ("delete".equals(this.status) || "update".equals(this.status)) {
                    // empty if block
                }
                attrs.clear();
                Enumeration e = ids.keys();
                while (e.hasMoreElements()) {
                    key = (String)e.nextElement();
                    attrs.addAttribute(null, null, key, "ID", (String)ids.get(key));
                }
                Enumeration e2 = fields.keys();
                while (e2.hasMoreElements()) {
                    key = (String)e2.nextElement();
                    attrs.addAttribute(null, null, key, "CDATA", (String)fields.get(key));
                }
            }
        }
        catch (DBManagerException dbe) {
            try {
                this.db.close();
            }
            catch (DBManagerException dbex) {
                // empty catch block
            }
            throw new SAXException("DBManager error", dbe);
        }
        catch (Exception e) {
            try {
                this.db.close();
            }
            catch (DBManagerException dbex) {
                // empty catch block
            }
            throw new SAXException(e);
        }
        this.context.push(new Object[]{element, attrs});
    }

    public void endElement(String element) throws SAXException {
        try {
            if (!this.context.empty()) {
                Object[] ctx = (Object[])this.context.pop();
                if (this.context.empty()) {
                    this.db.close();
                    return;
                }
                Attributes meta = (Attributes)ctx[1];
                Hashtable<String, String> ids = new Hashtable<String, String>();
                Hashtable<String, String> fields = new Hashtable<String, String>();
                int i = 0;
                while (i < meta.getLength()) {
                    if ("ID".equals(meta.getType(i))) {
                        ids.put(meta.getQName(i), meta.getValue(i));
                    } else {
                        fields.put(meta.getQName(i), meta.getValue(i));
                    }
                    ++i;
                }
                if ("delete".equals(this.status)) {
                    this.db.deleteRow(this.getSQLName((String)ctx[0]), ids, fields);
                } else if ("update".equals(this.status)) {
                    this.db.updateRow(this.getSQLName((String)ctx[0]), ids, fields);
                }
                if (this.context.size() == 1) {
                    this.db.flush();
                }
            }
        }
        catch (DBManagerException dbe) {
            try {
                this.db.close();
            }
            catch (DBManagerException dbex) {
                // empty catch block
            }
            throw new SAXException("DBManager error", dbe);
        }
        catch (Exception e) {
            try {
                this.db.close();
            }
            catch (DBManagerException dbex) {
                // empty catch block
            }
            throw new SAXException(e);
        }
        this.cdata = null;
    }

    private String getSQLName(String name) {
        return this.getSQLName(name, name);
    }

    private String getSQLName(String name, String def) {
        if (name == null) {
            return def;
        }
        return this.props.getProperty(name, def);
    }

    private Map getSQLIds(String idNames, String idValues) {
        Hashtable<String, String> ids = new Hashtable<String, String>();
        StringTokenizer names = new StringTokenizer(idNames, ",");
        StringTokenizer values = new StringTokenizer(idValues, ":");
        String value = values.nextToken();
        while (names.hasMoreTokens()) {
            String name = names.nextToken();
            if (!values.hasMoreTokens() || "".equals(value = values.nextToken())) continue;
            ids.put(name, value);
        }
        return ids;
    }

    /*
     * WARNING - void declaration
     */
    private String checkValue(String value) throws SAXException {
        if (value != null) {
            int start;
            while ((start = value.indexOf("${")) > -1) {
                void var2_2;
                StringBuffer strBuff = new StringBuffer(value);
                int end = value.indexOf("}", (int)var2_2);
                if (end <= var2_2) continue;
                value = strBuff.replace((int)var2_2, 1 + end, this.getActionValue(strBuff.substring(2 + var2_2, end))).toString();
            }
        }
        return value;
    }

    private String getActionValue(String actionName) throws SAXException {
        String value;
        block8: {
            value = null;
            if (actionName == null || actionName.equals("")) {
                return null;
            }
            if (this.actionPool.containsKey(actionName)) {
                value = ((CustomAction)this.actionPool.get(actionName)).getValue();
            } else {
                try {
                    StringTokenizer st = new StringTokenizer(actionName, "$");
                    if (!st.hasMoreTokens()) break block8;
                    Object obj = Class.forName(st.nextToken()).newInstance();
                    if (obj instanceof CustomAction) {
                        value = ((CustomAction)obj).getValue();
                        this.actionPool.put(actionName, obj);
                        break block8;
                    }
                    throw new SAXException("class " + actionName + " should implement CustomAction");
                }
                catch (ClassNotFoundException cnfe) {
                    throw new SAXException("Class not found", cnfe);
                }
                catch (InstantiationException ie) {
                    throw new SAXException("Class object cannot be instantiated", ie);
                }
                catch (IllegalAccessException iae) {
                    throw new SAXException("Class or initializer is not accessible", iae);
                }
            }
        }
        return value;
    }
}

