#
# webcalng - a web based calendar program.
# Copyright 2003 - webcalng software solutions
#

#
# This file contains a subroutine used to setup the connection
# to the database when using a relational database with webcalng.
#

package webcalng_rdbms;
use DBI;
use strict;

#
# Just connect to the database.  We want to handle all errors on our own.
#
sub dbh_setup {
	my ($connection,$driver,$database);

	# Based on the DBD driver we are using, setup connection parameters.
	$driver   = $::webcalng_conf{'DBD'};

	if ($driver eq "mysql") {

		$connection = "DBI:mysql:database=$::webcalng_conf{'DB'};host=$::webcalng_conf{'DB_HOST'}";

	} elsif ($driver eq "Pg") {

		if ($::webcalng_conf{'DB_HOST'} eq "localhost") {
			# Handle connections to localhost a bit differently, as postgresql
			# needs to be started differently if the host is specified in the
			# connect string, and most people would not have done this.	
			$connection = "DBI:Pg:dbname=$::webcalng_conf{'DB'}";
		} else {
			$connection = "DBI:Pg:dbname=$::webcalng_conf{'DB'};host=$::webcalng_conf{'DB_HOST'}";
		}

	} elsif ($driver eq "Oracle") {

		$ENV{'ORACLE_HOME'} = $::webcalng_conf{'ORACLE_HOME'};
		$connection         = "DBI:Oracle:$::webcalng_conf{'TNSNAME'}";

	} elsif ($driver eq "ODBC") {

		$connection = "DBI:ODBC:$::webcalng_conf{'DSN'}";

	} else {

		webcalng_subs::hard_error("Invalid dbd: $driver");

	}

	# Connect to the database.  We want to manage the transactions and error handling oursevles.
	$::dbh = DBI->connect ($connection, $::webcalng_conf{'DB_USER'}, $::webcalng_conf{'DB_PASS'},
	                      {'RaiseError' => 0, AutoCommit => 0, PrintError => 0}
	                      ) or webcalng_subs::hard_error("$::DBI::err ($::DBI::errstr)");

	# These are only really needed for MS SQL Server, but they should not hurt for other databases.
	$::dbh->{LongReadLen} = 10240;
	$::dbh->{LongTruncOk} = 1;

	return 1;
}

1;
