using System;
using System.Collections;
using System.Data;
using System.Data.OleDb;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.IO;
using System.Xml;
using System.Text;
using System.Security;
using UOL.WebGrid;

namespace WebGrid
{
	/// <summary>
	/// Summary description for data.
	/// </summary>
	public class update : System.Web.UI.Page
	{
		UOL.WebGrid.WebGrid wg;
		OleDbConnection conn = null;
		string output = "";
		string [] tableColumns  = new string [] {"Address","City","Region","PostalCode","Country","Notes","US"};
		string table = "Em";
		string connectionString = @"Provider=Microsoft.Jet.OLEDB.4.0;Data Source=C:\Program Files\Microsoft Office\Office\Samples\northwind.mdb";
		private void Page_Load(object sender, System.EventArgs e)
		{
			try 
			{
				wg = new UOL.WebGrid.WebGrid(Session, Request);
				wg.OnQuery += new WebGridQueryEventHandler(this.OnQuery);
				wg.OnLoad += new WebGridQueryEventHandler(this.OnLoad);
				wg.OnUpdate += new WebGridUpdateEventHandler(this.OnUpdate);
				this.output = wg.Execute();

			}
			catch(Exception ex)
			{
				Console.WriteLine(ex.Message);
			}
		}
		public string Output
		{
			get { return this.output; }
		}
		private void OpenConnection()
		{
			try 
			{
				conn = new OleDbConnection(connectionString);
			}
			catch(Exception e)
			{
				throw new Exception(e.Message);
			}
		}
		private void CloseConnection()
		{
			if (conn != null) conn.Close();
		}
		private void OnQuery(object sender, WebGridQueryEventArgs args)
		{
			args.DataSource = GetData();
		}
		private void OnUpdate(object sender, WebGridUpdateEventArgs args)
		{
			try
			{
				OpenConnection();
				if (args.updateAllColumn != -1) UpdateAll(args.updateAllColumn,args.updateAllValue);
				if (args.Updates != null) Update(args.Updates);
				if (args.Deletes != null) Delete(args.Deletes);
				if (args.Inserts != null) Insert(args.Inserts);
				CloseConnection();
			}
			catch(Exception e)
			{
				Console.WriteLine(e.Message);
			}
		}
		private void OnLoad(object sender, WebGridQueryEventArgs args)
		{
			CloseConnection();
		}
		private object GetData()
		{
			object result = null;
			OleDbCommand command;
			try
			{
				OpenConnection();
				command = new OleDbCommand("select Address,City,Region,PostalCode,Country,Notes,US from Em",conn);
				command.CommandType=CommandType.Text;
				conn.Open();
				System.Data.OleDb.OleDbDataReader reader = command.ExecuteReader();
				result = reader;
			}
			catch(Exception e)
			{
				Console.WriteLine(e.Message);
			}
			return result;
		}
		private void UpdateAll(int column, string value)
		{
			conn = null;
			try
			{
				string columnName = this.tableColumns[column];
				string query = "UPDATE " + this.table + " SET " + columnName + "='" + value + "'";
				OleDbCommand command = new OleDbCommand(query,conn);
				command.ExecuteNonQuery();
			}
			catch(Exception e)
			{
				throw new Exception(e.Message);
			}
		}
		private void Update(Object [] rows)
		{
			conn = null;
			try
			{
				int whereColumn = 1;
				for(int j = 0; j < rows.Length; ++j)
				{
					string [] values = (string [])rows[j];
					StringBuilder query = new StringBuilder("UPDATE " + this.table + " SET ");
					for (int i = 0; i < this.tableColumns.Length - 1; ++i)
					{
						query.Append(this.tableColumns[i] + "='" + values[i] + "', ");
					}
					query.Append(this.tableColumns[this.tableColumns.Length - 1] + "='" + values[this.tableColumns.Length - 1] + " ");
					query.Append("WHERE " + this.tableColumns[whereColumn] + "='" + values[whereColumn] + "'");
					OleDbCommand command = new OleDbCommand(query.ToString(),conn);
					command.ExecuteNonQuery();
				}
			}
			catch(Exception e)
			{
				throw new Exception(e.Message);
			}
		}
		private void Delete(Object [] rows)
		{
			conn = null;
			try
			{
				int whereColumn = 1;
				for(int j = 0; j < rows.Length; ++j)
				{
					string [] values = (string [])rows[j];
					StringBuilder query = new StringBuilder("DELETE FROM " + this.table + " ");
					query.Append("WHERE " + this.tableColumns[whereColumn] + "='" + values[whereColumn] + "'");
					OleDbCommand command = new OleDbCommand(query.ToString(),conn);
					command.ExecuteNonQuery();
				}
			}
			catch(Exception e)
			{
				throw new Exception(e.Message);
			}
		}
		private void Insert(Object [] rows)
		{
			try
			{
				for(int j = 0; j < rows.Length; ++j)
				{
					string [] values = (string [])rows[j];
					StringBuilder query = new StringBuilder("INSERT INTO " + this.table + " (");
					for (int i = 0; i < this.tableColumns.Length - 1; ++i)
					{
						query.Append(this.tableColumns[i] + ", ");
					}
					query.Append(this.tableColumns[this.tableColumns.Length - 1] + ") VALUES (");
					for (int i = 0; i < this.tableColumns.Length - 1; ++i)
					{
						query.Append("'" + values[i] + "',");
					}
					query.Append("'" + values[this.tableColumns.Length - 1] + "')");
					OleDbCommand command = new OleDbCommand(query.ToString(),conn);
					command.ExecuteNonQuery();
				}
			}
			catch(Exception e)
			{
				throw new Exception(e.Message);
			}
		}
		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);
		}
		#endregion
	}
}
