/*
 * Decompiled with CFR 0.152.
 */
package com.ImajeJen;

import com.ImajeJen.ImajeJenUtil;
import com.ImajeJen.LayoutProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class WebSiteLayout
implements Cloneable {
    private File _$9546 = null;
    private Hashtable _$16691 = new Hashtable();
    public static final String GLOBAL = "<global>";
    public static final String COLUMNS = "<columns>";
    public static final String HEADINGS = "<headings>";
    public static final String FILE_FORMAT_VERSION = "1.0";
    public static final String DESCRIPTION = "Description";
    public static final String KEYWORDS = "Keywords";
    public static final String TRUE_VALUE = "True";
    public static final String FALSE_VALUE = "False";
    private static final String[] _$16944 = new String[]{"Image", "Name", "Type", "Dimensions", "Count", "Size", "Date", "Time", "Description"};

    public WebSiteLayout() {
        this._$9546 = null;
        this._$16666();
    }

    public WebSiteLayout(File initFileLayout) {
        this.setFile(initFileLayout);
        this._$16666();
        this.readFromFile();
    }

    private void _$16666() {
        LayoutProperties globalProps = new LayoutProperties(GLOBAL);
        ((Hashtable)globalProps).put("FullName", "Web Master");
        ((Hashtable)globalProps).put("EMail", "username@domain.com");
        ((Hashtable)globalProps).put("FolderIntro", "This is my collection of images.\nTo see the full sized version of an image\nclick on it's thumbnail.");
        ((Hashtable)globalProps).put("SourceFolder", "C:\\My Documents\\My Pictures");
        ((Hashtable)globalProps).put("DestFolder", "C:\\My Documents\\My Web Site\\ImajeJenGallery");
        globalProps.putIntValue("Quality", 75);
        globalProps.putIntValue("Scaling", 2);
        globalProps.putIntValue("RowSize", 1);
        globalProps.putIntValue("RowsPerPage", 0);
        globalProps.putIntValue("ImageSize", 70);
        ((Hashtable)globalProps).put("StartPageTitle", "My Image Gallery");
        globalProps.putIntValue("BackgroundColor", 0);
        ((Hashtable)globalProps).put("BackgroundImageFile", "");
        this._$16691.put(GLOBAL, globalProps);
        this._$16699();
    }

    private void _$16699() {
        LayoutProperties propsColumns = new LayoutProperties(COLUMNS);
        LayoutProperties propsHeadings = new LayoutProperties(HEADINGS);
        for (int i = 0; i < this.getMaxColumnHeadingCount(); ++i) {
            propsColumns.setFlag(this.getColumnKeyName(i), true);
            ((Hashtable)propsHeadings).put(this.getColumnKeyName(i), this.getColumnKeyName(i));
        }
        propsColumns.setFlag(DESCRIPTION, false);
        propsColumns.setFlag("Time", false);
        this._$16691.put(COLUMNS, propsColumns);
        this._$16691.put(HEADINGS, propsHeadings);
    }

    public void readFromFile() {
        try {
            if (this._$9546 != null && this._$9546.exists()) {
                LayoutProperties props = new LayoutProperties();
                BufferedReader brLayout = new BufferedReader(new FileReader(this._$9546));
                String szKey = null;
                String szLine = null;
                while (brLayout.ready()) {
                    szLine = brLayout.readLine();
                    if (szLine == null) continue;
                    int iLineLength = szLine.length();
                    if (szLine.equals(":")) {
                        szKey = props.getProperty("<Key>");
                        LayoutProperties propsOld = this.getItemProps(szKey);
                        if (propsOld != null) {
                            Enumeration enumOld = ((Hashtable)propsOld).keys();
                            while (enumOld.hasMoreElements()) {
                                String szEnumKey = (String)enumOld.nextElement();
                                String szNewValue = props.getStringValue(szEnumKey);
                                if (szNewValue != null && szNewValue.length() != 0) continue;
                                ((Hashtable)props).put(szEnumKey, propsOld.getStringValue(szEnumKey));
                            }
                        }
                        this.putItemProps(szKey, props);
                        props = new LayoutProperties();
                        continue;
                    }
                    String szVarName = "";
                    String szVarValue = "";
                    int i = 0;
                    while (szLine.charAt(i) != ':') {
                        szVarName = String.valueOf(szVarName).concat(String.valueOf(szLine.charAt(i)));
                        ++i;
                    }
                    ++i;
                    while (i < iLineLength) {
                        if (szLine.charAt(i) == '\\') {
                            switch (szLine.charAt(++i)) {
                                case '\\': {
                                    szVarValue = String.valueOf(szVarValue).concat(String.valueOf('\\'));
                                    break;
                                }
                                case 'n': {
                                    szVarValue = String.valueOf(szVarValue).concat(String.valueOf('\n'));
                                }
                            }
                        } else {
                            szVarValue = String.valueOf(szVarValue).concat(String.valueOf(szLine.charAt(i)));
                        }
                        ++i;
                    }
                    ((Hashtable)props).put(szVarName, szVarValue);
                }
                brLayout.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeToFile(File initFileLayout) {
        this.setFile(initFileLayout);
    }

    public void writeToFile() {
        try {
            if (this._$9546 != null) {
                int i;
                ((Hashtable)this.getGlobalProps()).put("FileFormatVersion", FILE_FORMAT_VERSION);
                String szItemKey = null;
                LayoutProperties props = null;
                String szVarName = null;
                String szVarValue = null;
                FileOutputStream fosLayout = new FileOutputStream(this._$9546);
                PrintWriter pwLayout = new PrintWriter(fosLayout, true);
                Enumeration enumItems = this._$16691.keys();
                int iKeyCount = this._$16691.size();
                String[] arrayKeys = new String[iKeyCount];
                for (i = 0; i < iKeyCount && enumItems.hasMoreElements(); ++i) {
                    arrayKeys[i] = (String)enumItems.nextElement();
                }
                ImajeJenUtil.sortStrings(arrayKeys);
                for (i = 0; i < iKeyCount; ++i) {
                    int k;
                    szItemKey = arrayKeys[i];
                    props = (LayoutProperties)this._$16691.get(szItemKey);
                    Enumeration enumVars = ((Hashtable)props).keys();
                    int iSubKeyCount = ((Hashtable)props).size();
                    if (iSubKeyCount <= 1) continue;
                    String[] arrayVarNames = new String[iSubKeyCount];
                    for (k = 0; k < iSubKeyCount && enumVars.hasMoreElements(); ++k) {
                        arrayVarNames[k] = (String)enumVars.nextElement();
                    }
                    ImajeJenUtil.sortStrings(arrayVarNames);
                    for (k = 0; k < iSubKeyCount; ++k) {
                        szVarName = arrayVarNames[k];
                        szVarValue = props.getProperty(szVarName);
                        pwLayout.print(String.valueOf(szVarName).concat(String.valueOf(":")));
                        int iLength = szVarValue.length();
                        block10: for (int j = 0; j < iLength; ++j) {
                            switch (szVarValue.charAt(j)) {
                                case '\\': {
                                    pwLayout.print("\\\\");
                                    continue block10;
                                }
                                case '\n': {
                                    pwLayout.print("\\n");
                                    continue block10;
                                }
                                default: {
                                    pwLayout.print(szVarValue.charAt(j));
                                }
                            }
                        }
                        pwLayout.println();
                    }
                    pwLayout.println(":");
                }
                pwLayout.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public LayoutProperties getItemProps(String szItemName) {
        return (LayoutProperties)this._$16691.get(szItemName);
    }

    public void putItemProps(String szItemKey, LayoutProperties props) {
        this._$16691.put(szItemKey, props);
    }

    public LayoutProperties getGlobalProps() {
        return this.getItemProps(GLOBAL);
    }

    public int getMaxColumnHeadingCount() {
        return _$16944.length;
    }

    public String getColumnKeyName(int i) {
        return _$16944[i];
    }

    public LayoutProperties getPropsColumnHeadings() {
        return (LayoutProperties)this._$16691.get(HEADINGS);
    }

    public LayoutProperties getPropsColumnSelected() {
        return (LayoutProperties)this._$16691.get(COLUMNS);
    }

    public void setFile(File initFile) {
        this._$9546 = initFile;
    }

    public File getFile() {
        return this._$9546;
    }
}

