#include "psock.hh"
#include <stdio.h>
#include <string.h>
#include "utils.hh"

const char *psock_static_error = 0;

const bool do_debug = true;

bool PSock::ws_e(bool isok, const char *e, const char *buf)
{
   if (isok)
     return true;
   if (do_debug && stage != stNoErr) {
      const char *st;
      switch (stage) {
       case stInit:
	 st = "Init";
	 break;
       case stReadHead:
	 st = "ReadHead";
	 break;
       case stSendHead:
	 st = "SendHead";
	 break;
       case stClient:
	 st = "Client";
	 break;
       case stServer:
	 st = "Server";
	 break;
       case stClose:
       default:
	 st = "Close";
	 break;
      }
      printf("%s: %s, %s, %i: %s: localhost:%i <-> %s:%i (%s)\n",
	     isok ? "status" : "error",
	     e, st, s,
	     winsock_geterror(s_WSAGetLastError()), port, host, fport, buf);
   }
   if (!isok) {
      no_error = false;
      psock_static_error = e;
   }
   return isok;
}

int winsock_initialized = 0;

bool winsock_init()
{
   if (++winsock_initialized == 1 && s_init())
     return false;
   return true;
}

PSock::PSock()
: no_error(true), host(0), port(0), fport(0), stage(stInit)
{
   if (!winsock_init())
     ws_e(false, "WinSock init", 0);
   s = s_socket();
}

PSock::PSock(shndl_t _s)
: no_error(true), host(0), port(0), fport(0), stage(stInit)
{
   if (!winsock_init())
     ws_e(false, "WinSock init", 0);   
   s = _s;
}

PSock::~PSock()
{
   if (s)
     Close();
   if (!--winsock_initialized)
     s_done();
}

bool PSock::Connect(const char *name, int port)
{
   host = mystrdup(name);
   fport = port;
   bool ret = !s_connect(s, name, port);
   return ws_e(ret, "Connect", 0);
}

const int MAX_BACKLOG = 100;

bool PSock::Listen(int _port)
{
   port = _port;
   if (s_bind(s, port) < 0)
     return ws_e(false, "Bind", 0);
   bool ret = s_listen(s, MAX_BACKLOG) != -1;
   return ws_e(ret, "Listen", 0);
}

PSock * PSock::Accept(bool AllowNonLocal)
{
   shndl_t s2;
   s2 = s_accept(s);
   if (!s2) {
      ws_e(false, "Accept", 0);
      return 0;
   }
   if (!AllowNonLocal && s_isnonlocal(s2)) {
      s_closesocket(s2);
      return 0;
   }
   PSock *p2 = new PSock(s2);
   ws_e(true, "Accept", 0);
   return p2;
}

void PSock::Close()
{
   s_closesocket(s);
   ws_e(true, "Close", 0);
   s = 0;
   no_error = true;
}

int PSock::Recv(void *buf, int size)
{
   ws_e(true, "Recv call", 0);
   int ret = s_recv(s, buf, size);
   if (ret < 0) {
      ws_e(false, "Receive", 0);
      return -1;
   }
   ws_e(true, "Receive", 0);
   // *(((char *) buf)+ret) = 0;
   // printf("r%i [%s]\n", s, (char *) buf);   
   return ret;
}

bool PSock::Send(const void *buf, int size)
{
   ws_e(true, "Send call", 0);   
//   printf("s%i [%s]\n", s, (char *) buf);
   int s2 = s_send(s, buf, size);
   bool ret = s2 == size;
   return ws_e(ret, "Send", (const char *) buf);
}

bool PSock::SendStr(const char *str)
{
   return Send(str, strlen(str));
}

PSock * PSock::Select(PSock *second)
{
//   printf("select call %i, %i\n", s, second->s);
   int r = s_select(s, second->s);
//   printf("select %i, %i, result %i\n", s, second->s, r);
   if (r == s)
     return this;
   else if (r == second->s)
     return second;
   ws_e(false, "Select", 0);
   return 0;
}

bool PSock::Alive()
{
   return s > 0 && no_error;
}

void PSock::SetStage(stages_t _stage)
{
   stage = _stage;
//  printf("%d\n", _stage);
}
