#include "conf.h"
#include "reg.h"
#include "h.h"
#include "win\rsc.h"
#include <stdlib.h>
#include <stdio.h>
#include "adb.h"
#include "win\h2.h"

BOOL CALLBACK ConfDlgProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM)
{
   if (uMsg == WM_COMMAND) {
      if (LOWORD(wParam) == IDCANCEL)
	;
      else if (LOWORD(wParam) == IDOK) {
	 use_proxy = SendMessage(GetDlgItem(hDlg, ID_CONF_PROXYUSE), BM_GETCHECK, 0, 0);
	 SendMessage(GetDlgItem(hDlg, ID_CONF_PROXYHOST), WM_GETTEXT, 255, (LPARAM) proxy_hostname);
	 char buf[256];
	 SendMessage(GetDlgItem(hDlg, ID_CONF_PROXYPORT), WM_GETTEXT, 10, (LPARAM) buf);
	 proxy_port = atoi(buf);
	 allow_nonlocal = SendMessage(GetDlgItem(hDlg, ID_CONF_NONLOCAL), BM_GETCHECK, 0, 0);
	 SendMessage(GetDlgItem(hDlg, ID_CONF_LISTPORT), WM_GETTEXT, 10, (LPARAM) buf);
	 int l2 = atoi(buf);
	 if (l2 && l2 != listen_port) {
	   listen_port = l2;
	   listen_port_changed = true;
	 }
	 if (SendMessage(GetDlgItem(hDlg, ID_CONF_AUTOUPDATEN), BM_GETCHECK, 0, 0))
 	   auto_update = 0;
	 else if (SendMessage(GetDlgItem(hDlg, ID_CONF_AUTOUPDATES), BM_GETCHECK, 0, 0))
	   auto_update = 1;
	 else
	   auto_update = 2;
	 stealth_mode = SendMessage(GetDlgItem(hDlg, ID_CONF_STEALTH), BM_GETCHECK, 0, 0);
	 SendMessage(GetDlgItem(hDlg, ID_CONF_MAXTRIES), WM_GETTEXT, 10, (LPARAM) buf);
	 max_connection_tries = atoi(buf);
	 SaveConf();
      } else
	return false;
      EnableWindow(hwnd, true);
      DestroyWindow(hDlg);
      hdlg = 0;
      return false;
   }
   return false;
}

void ShowConfDlg()
{
   hdlg = CreateDialog(hInstance, "confDLG", hwnd, (DLGPROC) ConfDlgProc);
   SendMessage(GetDlgItem(hdlg, ID_CONF_PROXYUSE), BM_SETCHECK, use_proxy, 0);
   SendMessage(GetDlgItem(hdlg, ID_CONF_PROXYHOST), WM_SETTEXT, 255, (LPARAM) proxy_hostname);
   char buf[256];
   sprintf(buf, "%d", proxy_port);
   SendMessage(GetDlgItem(hdlg, ID_CONF_PROXYPORT), WM_SETTEXT, 10, (LPARAM) buf);
   SendMessage(GetDlgItem(hdlg, ID_CONF_NONLOCAL), BM_SETCHECK, allow_nonlocal, 0);
   sprintf(buf, "%d", listen_port);
   SendMessage(GetDlgItem(hdlg, ID_CONF_LISTPORT), WM_SETTEXT, 10, (LPARAM) buf);
   SendMessage(GetDlgItem(hdlg, ID_CONF_AUTOUPDATEN), BM_SETCHECK, auto_update == 0, 0);
   SendMessage(GetDlgItem(hdlg, ID_CONF_AUTOUPDATES), BM_SETCHECK, auto_update == 1, 0);
   SendMessage(GetDlgItem(hdlg, ID_CONF_AUTOUPDATER), BM_SETCHECK, auto_update == 2, 0);
   SendMessage(GetDlgItem(hdlg, ID_CONF_STEALTH), BM_SETCHECK, stealth_mode, 0);  
   sprintf(buf, "%d", max_connection_tries);
   SendMessage(GetDlgItem(hdlg, ID_CONF_MAXTRIES), WM_SETTEXT, 10, (LPARAM) buf);
   ShowWindow(hdlg, SW_NORMAL);
   UpdateWindow(hdlg);
   EnableWindow(hwnd, false);
}
