'This script inserts line numbers into CodeModule member
'"Case",precompiler ("#") statement lines And handler lines ("'+++") are excluded
Sub NumsAdd(tarMem)
Dim n
   For n = tarMem.LineCount - 1 To 2 Step -1
      With tarMem.Line(n)
         .Number = 0 'reset line number
         If .Comment <> "'+++" Then
            If .Text <> "" And Left(.Text, 1) <> "#" And Left(.Text, 5) <> "Case " Then
               .Number = tarMem.CodeStart + n 'set line number
            End If
         End If
      End With
   Next
End Sub

'This script resets all line numbers in a VBMember object
Sub NumsClear(tarMem)
Dim n
For n = tarMem.LineCount To 1 Step -1
    With tarMem.Line(n)
        If .Number > 0 Then .Number = 0
    End With
Next
End Sub

'The script removes all lines commented with "'+++"
Sub HandClear(tarMem)
Dim n
    For n = tarMem.LineCount To 2 Step -1
        If tarMem.Line(n).Comment = "'+++" Then tarMem.DeleteLine n
    Next
End Sub

'This script inserts error handlers assuming that public function ToDoOnError()
'is defined in source code
Sub HandAdd(tarMem)
   HandClear (tarMem)
   NumsAdd (tarMem)
   If tarMem.LineCount > 3 Then
'exclude procedures by comment
      If UCase(tarMem.Line(1).Comment) = "'NO HANDLERS" Then Exit Sub
'insert On Error statement before second line (i.e. first procedure body line)
      tarMem.AddLine "On Error GoTo TrapSub   '+++", 2
'insert error trap lines before last body line
      tarMem.AddLine "Err.Clear   '+++", tarMem.LineCount
      tarMem.AddLine "TrapSub: If Err<>0 Then '+++", tarMem.LineCount
      tarMem.AddLine "   Select Case ToDoOnError(Err,""" & tarMem.Name & """, Erl ) '+++", tarMem.LineCount
      tarMem.AddLine "      Case vbRetry: Resume    '+++", tarMem.LineCount
      tarMem.AddLine "      Case vbIgnore: Resume Next '+++", tarMem.LineCount
      tarMem.AddLine "   End Select  '+++", tarMem.LineCount
      tarMem.AddLine "End If '+++", tarMem.LineCount
   End If
End Sub


'Set indentation using tokens
Sub Indents(tarMem)
Dim nl, ind, ind2, t, key, s
   ind = 0 'inital indent
   s = tarMem.CodeStart
   For nl = 2 To tarMem.LineCount - 1
   With tarMem.Line(nl)
      Set t = .GetTokens()
      If t.Count > 0 Then
         key = t(1).Token 'first token in the line
         If (key = "If" And t(t.Count).Token = "Then") Or _
            key = "Select" Or key = "For" Or key = "With" Or key = "Do" Or key = "While" Then
               ind2 = ind + 1 'more on next line
         ElseIf key = "End" Or key = "Next" Or key = "Loop" Or key = "Wend" Then
            If ind > 0 Then ind = ind - 1
            ind2 = ind 'less on next line too
         ElseIf key = "Else" Or key = "ElseIf" Then
            ind2 = ind 'previous on next line
            If ind > 0 Then ind = ind - 1 'less on this line
         End If
         .Indent = String(3 * ind, " ")
         If .Text <> "" And t(1) <> "Private" And t(1) <> "Public" And Left(t(1), 1) <> "#" And t(1) <> "Case" And .Comment <> "'+++" Then
            .Number = s + nl
         Else
            .Number = 0
         End If
         ind = ind2 'set for next line
      Else
         .Number = 0
      End If
   End With
   Next
End Sub

Sub Make()
   IDE.ActiveVBProject.MakeCompiledFile
End Sub
