//******************************************************
// SPRINT - Print & Preview engine for Delphi
// WWW.SMART.CO.YU
//******************************************************

unit report7;

interface

procedure Report_7(show:Boolean);

implementation

uses Main,Sprint,Graphics,SysUtils,Classes,DBTables,Dialogs,
     Printers,Chart,Series,Forms,Controls;

var Sp:TSprint;

procedure DefineHeading(title:string);
begin
   Sp.Style[tsDef1].Font.Name:='Arial';
   Sp.Style[tsDef1].Font.Size:=-32;
   Sp.Style[tsDef1].Font.Style:=[fsBold,fsItalic];
   Sp.Style[tsDef1].Font.Color:=clNavy;
   Sp.ClearFields;
   Sp.AddField(' ',' ',taCenter);
   Sp.AddField(' ',' ',taCenter);
   Sp.AddField(' ',' ',taCenter);
   Sp.Recalculate(-150); {15 mm from both paper edges}
   //Rectangled heading
   Sp.Canv.Brush.Color:=$00E0E0E0;
   Sp.Canv.Rectangle(
      Sp.Fields[1].AbsLeft,
      Sp.topm(150),
      Sp.Fields[3].AbsRight,
      Sp.topm(260));
   Sp.Canv.Brush.Color:=clWhite;      
   //Heading text
   Sp.SetStyle(tsDef1);
   Sp.PrintField(2,title);
   Sp.SetStyle(tsText);
   Sp.CurrY:=Sp.CurrY+200;
end;

procedure ShowDir(name:string;level:integer);
var
   spacer1,spacer2:string;
   iconpos:integer;
begin
   spacer1:=format('   %*.*s',[level*8,level*8,' ']);
   spacer2:=spacer1+'   ';
   iconpos:=Sp.Fields[1].AbsLeft+Sp.Canv.TextWidth(spacer1);
   Sp.Add([spacer2+name]);
   //icon
   Sp.Canv.Font.Name:='Wingdings';
   Sp.Canv.TextOut(iconpos,Sp.CurrY,'0');
   //
   Sp.SetStyle(tsText);
end;

procedure dir(path:string;level:integer);
var
   SearchRec: TSearchRec;
   curpath:string;
begin
   SetCurrentDir(path);
   curpath:=GetCurrentDir();
   if curpath[length(curpath)]<>'\' then curpath:=curpath+'\';
   if (FindFirst('*.*',faDirectory,SearchRec)=0) then begin
      if (SearchRec.Attr=faDirectory) and (SearchRec.Name[1]<>'.') then begin
         ShowDir(SearchRec.Name,level);
         dir(curpath+SearchRec.Name,level+1);
         chdir(curpath);
      end;
      while (FindNext(SearchRec)=0) do begin
         if (SearchRec.Attr=faDirectory) and (SearchRec.Name[1]<>'.') then begin
            ShowDir(SearchRec.Name,level);
            dir(curpath+SearchRec.Name,level+1);
            chdir(curpath);
         end;
      end;
      FindClose(SearchRec);
   end;
end;

procedure TChartDemo;
var
   tc:TChart;
   cs:TPieSeries;
   i:integer;
begin
      tc:=TChart.Create(nil);
      tc.AutoSize:=True;
      tc.Color:=clWhite;
      tc.BevelInner:=bvNone;
      tc.BevelOuter:=bvNone;
      tc.Frame.Visible:=False;
      tc.Chart3DPercent:=50;
      tc.Legend.Visible:=False;
      //Pie
      cs:=TPieSeries.Create(nil);
      cs.ParentChart:=tc;
      cs.Marks.Font.Size:=24;
      for i:=1 to 8 do begin
         cs.Add(
            random(150)+20,
            'Value '+inttostr(i),clScrollBar);
      end;
      Sp.CurrY:=Sp.CurrY+50;
      tc.DrawToMetaCanvas(
         Sp.canv,
         rect(Sp.leftm(350),
              Sp.CurrY,
              Sp.rightm(350),
              Sp.CurrY+((Sp.rightm(150)-Sp.leftm(150))div 5)*3));
      tc.FreeAllSeries;
      tc.Free;
end;

procedure Report_7(show:Boolean);
var curdir:string;
begin
   //1..initialize sprint
   Sp:=form1.SPrint1;
   Sp.BeginDoc;
   Sp.KEY:='When you purchase SPRINT you will insert received KEY here';
   //2..changing some default values (defaults: linespace=1.1)
   Sp.Style[tsHead].LineSpace:=1;
   Sp.Style[tsText].LineSpace:=1;
   Sp.Style[tsText].Font.Size:=10;
   Sp.Style[tsText].Font.Name:='Courier New';
   Sp.ShowHeader:=False;
   //3..Several demos in the row...
      //Print Directory Demo
      DefineHeading('Drive C:\');
      Sp.ClearFields;
      Sp.AddField('XXX','void',taLeftJustify);
      Sp.AddField('XXX','void',taLeftJustify);
      Sp.Recalculate(-150); {15 mm from both paper edges}
      Sp.Add(['c:\']);
      curdir:=GetCurrentDir;
      dir('c:\',0);
      SetCurrentDir(curdir);
      //TChart Print Demo
      Sp.PaperOrientation:=Landscape;
      Sp.NewPage;
      DefineHeading('TChart on SPRINT');
      TChartDemo();
      //Last word from SmART R&D
      Sp.NewPage;
      DefineHeading('SPRINT');
      Sp.ClearFields;
      Sp.AddField('XXX','void',taLeftJustify);
      Sp.AddField('XXX','void',taCenter);
      Sp.AddField('XXX','void',taLeftJustify);
      Sp.Style[tsDef1].Font.Size:=-22;
      Sp.Recalculate(-150); {15 mm from both paper edges}
      Sp.SetStyle(tsDef1);
      Sp.Add(['','* Create Reports and Documents with Ease! *']);
      Sp.Add(['','* Full canvas support! *']);
      Sp.Add(['','* Sophisticated high level functions! *']);
      Sp.Add(['','* Non-visual bugless report creating! *']);
      Sp.Add(['']);
      Sp.Add(['','www.smart.co.yu']);
      Sp.Add(['','SPRINT - PRINT & PREVIEW ENGINE']);
      Sp.Add(['']);
      Sp.Style[tsDef1].Font.Size:=48;
      Sp.Style[tsDef1].Font.Name:='Arial';
      Sp.Style[tsDef1].Font.Style:=[fsBold];
      Sp.Style[tsDef1].LineSpace:=0.8;
      Sp.Recalculate(-150); {15 mm from both paper edges}
      Sp.SetStyle(tsDef1);
      Sp.Add(['','NO']);
      Sp.Add(['','LIMITS']);
      Sp.Add(['','EXCEPT']);
      Sp.Add(['','YOUR']);
      Sp.Add(['','IMAGINATION']);

   //6..print or preview?
   if show then Sp.ShowPreview else Sp.PrintAll;
   Sp.EndDoc;
end;

end.
