// RoboHELP HTML Edition Dynamic HTML Effects Script
// Copyright  1998 Blue Sky Software Corporation.  All rights reserved.

// Version=1

// Warning:  Do not modify this file.  It is generated by RoboHELP HTML Edition and changes will be overwritten.

function animationContext(el, progressAnimation, finishAnimiation, animationDuration, animationPeriod)
{
	this.el = el;
	this.progressAnimation = progressAnimation;
	this.finishAnimiation = finishAnimiation;
	this.animationDuration = parseFloat(animationDuration);
	this.animationPeriod = animationPeriod;
	this.animationStartTime = (new Date()).getTime();
	this.continueAnimation = true;
}

function progressFade(ndx)
{
	percent = ((new Date()).getTime() - animationContexts[ndx].animationStartTime)/animationContexts[ndx].animationDuration;
	if (percent > 1.0)
	{
		percent = 1.0;
		animationContexts[ndx].continueAnimation = false;
	}
	animationContexts[ndx].el.filters.alpha.opacity = animationContexts[ndx].initialOpacity*(1.0-percent) +  animationContexts[ndx].finalOpacity*percent;
}

function finishFade(ndx)
{
	animationContexts[ndx].el.filters.alpha.opacity = parseInt(animationContexts[ndx].finalOpacity);
}

function progressTranslation(ndx)
{
	percent = ((new Date()).getTime() - animationContexts[ndx].animationStartTime)/animationContexts[ndx].animationDuration;
	if (percent > 1.0)
	{
		percent = 1.0;
		animationContexts[ndx].continueAnimation = false;
	}
	animationContexts[ndx].el.style.pixelLeft = animationContexts[ndx].startX*(1.0-percent) +  animationContexts[ndx].finalX*percent;
	animationContexts[ndx].el.style.pixelTop = animationContexts[ndx].startY*(1.0-percent) +  animationContexts[ndx].finalY*percent;
}

function finishTranslation(ndx)
{
	animationContexts[ndx].el.style.pixelLeft = parseInt(animationContexts[ndx].finalX);
	animationContexts[ndx].el.style.pixelTop = parseInt(animationContexts[ndx].finalY);
}

var animationContexts = new Array();
var BSSCSequenceIndex = 0;


function animationPump(ndx)
{
	animationContexts[ndx].progressAnimation(ndx);
	if (animationContexts[ndx].continueAnimation)
		animationContexts[ndx].tm = setTimeout("animationPump(" + ndx + ");", animationContexts[ndx].animationPeriod);
}

function clearAnimations()
{
	for (index=0; index<animationContexts.length; index++)
	{
		animationContexts[index].finishAnimiation(index);
		clearTimeout(animationContexts[index].tm);
	}
	animationContexts = new Array();
}

function startNextAnimationSet()
{
	clearAnimations();
	bStarted = false;
	bFound = false

	// Determine the next sequence number
	divElements = document.all.tags("DIV");
	for (index = 0; index < divElements.length; index++)
	{
		el = divElements[index];
		
		objectOrder = el.getAttribute("BSSCObjectOrder", false);
		if(null != objectOrder)
		{
			objectOrder = parseInt(objectOrder);
			if (objectOrder > BSSCSequenceIndex && (!bFound || objectOrder < minBSSCSequenceIndexFound))
			{
				minBSSCSequenceIndexFound = objectOrder;
				bFound = true;
			}
				
		}
	}

	if (bFound)
	{
		BSSCSequenceIndex = minBSSCSequenceIndexFound;
		bStarted = startAnimationSet(BSSCSequenceIndex);
	}
}

function getOffsetFromTopOfBrowser(el)
{
	if (null == el.offsetParent)
		return el.offsetTop;
	else
		return el.offsetTop + getOffsetFromTopOfBrowser(el.offsetParent);
}

function startAnimationSet(ndx)
{
	animationContextIndex = 0;
	bStarted = false;

	// Find document elements with "BSSCAnimationType" attribute
	divElements = document.all.tags("DIV");
	for (index = 0; index < divElements.length; index++)
	{
		el = divElements[index];
		
		animationType = el.getAttribute("BSSCAnimationType", false);
		if(null != animationType)
		{
			framePeriod = el.getAttribute("BSSCFramePeriod", false);
			frameCount = el.getAttribute("BSSCFrameCount", false);
			sequenceIndex = el.getAttribute("BSSCObjectOrder", false);

			// Stop any currently running RevealTrans filters
			if ("RevealTrans" == animationType && parseInt(sequenceIndex) == ndx-1)
				el.filters.RevealTrans.stop();  

			// Filter on ndx
			if (0 == ndx && null == sequenceIndex ||
				ndx == parseInt(sequenceIndex))
			{
				if ("FlyInFromRight" == animationType)
				{
					animationDuration = el.getAttribute("BSSCDuration", false);
					if (null == animationDuration)
						animationDuration = 1000; // default to 1s
					animationContexts[animationContextIndex] = new animationContext(el, progressTranslation, finishTranslation, animationDuration, 10);
					animationContexts[animationContextIndex].startX = document.body.clientWidth;
					animationContexts[animationContextIndex].startY = 0;
					animationContexts[animationContextIndex].finalX = 0;
					animationContexts[animationContextIndex].finalY = 0;
					animationPump(animationContextIndex++);
					bStarted = true;
				}

				if ("FlyInFromLeft" == animationType)
				{
					animationDuration = el.getAttribute("BSSCDuration", false);
					if (null == animationDuration)
						animationDuration = 1000; // default to 1s
					for (childIndex=0; childIndex<el.children.length; childIndex++)
					{
						if ("left" == el.children[childIndex].style.textAlign)
							el.children[childIndex].style.textAlign = "right";
					}
					pixelsToTranslate = document.body.clientWidth;
					animationContexts[animationContextIndex] = new animationContext(el, progressTranslation, finishTranslation, animationDuration, 10);
					animationContexts[animationContextIndex].startX = -document.body.clientWidth;
					animationContexts[animationContextIndex].startY = 0;
					animationContexts[animationContextIndex].finalX = 0;
					animationContexts[animationContextIndex].finalY = 0;
					animationPump(animationContextIndex++);
					bStarted = true;
				}
				
				if ("FlyInFromBottom" == animationType)
				{
					animationDuration = el.getAttribute("BSSCDuration", false);
					if (null == animationDuration)
						animationDuration = 1000; // default to 1s
					animationContexts[animationContextIndex] = new animationContext(el, progressTranslation, finishTranslation, animationDuration, 10);
					animationContexts[animationContextIndex].startX = 0;
					animationContexts[animationContextIndex].startY = document.body.clientHeight - el.offsetTop;
					animationContexts[animationContextIndex].finalX = 0;
					animationContexts[animationContextIndex].finalY = 0;
					animationPump(animationContextIndex++);
					bStarted = true;
				}

				if ("FlyInFromTop" == animationType)
				{
					animationDuration = el.getAttribute("BSSCDuration", false);
					if (null == animationDuration)
						animationDuration = 1000; // default to 1s
					animationContexts[animationContextIndex] = new animationContext(el, progressTranslation, finishTranslation, animationDuration, 10);
					animationContexts[animationContextIndex].startX = 0;
					animationContexts[animationContextIndex].startY = -getOffsetFromTopOfBrowser(el) - el.offsetHeight;
					animationContexts[animationContextIndex].finalX = 0;
					animationContexts[animationContextIndex].finalY = 0;
					animationPump(animationContextIndex++);
					bStarted = true;
				}


				if ("FlyInFromBottomRight" == animationType)
				{
					animationDuration = el.getAttribute("BSSCDuration", false);
					if (null == animationDuration)
						animationDuration = 1000; // default to 1s
					pixelsToTranslate = document.body.clientWidth;
					if (document.body.clientHeight - el.offsetTop < pixelsToTranslate)
						pixelsToTranslate = document.body.clientHeight - el.offsetTop;
					animationContexts[animationContextIndex] = new animationContext(el, progressTranslation, finishTranslation, animationDuration, 10);
					animationContexts[animationContextIndex].startX = pixelsToTranslate;
					animationContexts[animationContextIndex].startY = pixelsToTranslate;
					animationContexts[animationContextIndex].finalX = 0;
					animationContexts[animationContextIndex].finalY = 0;
					animationPump(animationContextIndex++);
					bStarted = true;
				}

				if ("FlyInFromTopRight" == animationType)
				{
					animationDuration = el.getAttribute("BSSCDuration", false);
					if (null == animationDuration)
						animationDuration = 1000; // default to 1s
					pixelsToTranslate = document.body.clientWidth;
					offsetFromTopOfBrowser = getOffsetFromTopOfBrowser(el);
					if (offsetFromTopOfBrowser + el.offsetHeight < pixelsToTranslate)
						pixelsToTranslate = offsetFromTopOfBrowser + el.offsetHeight;
					animationContexts[animationContextIndex] = new animationContext(el, progressTranslation, finishTranslation, animationDuration, 10);
					animationContexts[animationContextIndex].startX = pixelsToTranslate;
					animationContexts[animationContextIndex].startY = -pixelsToTranslate;
					animationContexts[animationContextIndex].finalX = 0;
					animationContexts[animationContextIndex].finalY = 0;
					animationPump(animationContextIndex++);
					bStarted = true;
				}

				if ("FlyInFromTopLeft" == animationType)
				{
					animationDuration = el.getAttribute("BSSCDuration", false);
					if (null == animationDuration)
						animationDuration = 1000; // default to 1s
					for (childIndex=0; childIndex<el.children.length; childIndex++)
					{
						if ("left" == el.children[childIndex].style.textAlign)
							el.children[childIndex].style.textAlign = "right";
					}
					pixelsToTranslate = document.body.clientWidth;
					offsetFromTopOfBrowser = getOffsetFromTopOfBrowser(el);
					if (offsetFromTopOfBrowser + el.offsetHeight < pixelsToTranslate)
						pixelsToTranslate = offsetFromTopOfBrowser + el.offsetHeight;
					animationContexts[animationContextIndex] = new animationContext(el, progressTranslation, finishTranslation, animationDuration, 10);
					animationContexts[animationContextIndex].startX = -pixelsToTranslate;
					animationContexts[animationContextIndex].startY = -pixelsToTranslate;
					animationContexts[animationContextIndex].finalX = 0;
					animationContexts[animationContextIndex].finalY = 0;
					animationPump(animationContextIndex++);
					bStarted = true;
				}

				if ("FlyInFromBottomLeft" == animationType)
				{
					animationDuration = el.getAttribute("BSSCDuration", false);
					if (null == animationDuration)
						animationDuration = 1000; // default to 1s
					for (childIndex=0; childIndex<el.children.length; childIndex++)
					{
						if ("left" == el.children[childIndex].style.textAlign)
							el.children[childIndex].style.textAlign = "right";
					}
					pixelsToTranslate = document.body.clientWidth;
					if (document.body.clientHeight - el.offsetTop < pixelsToTranslate)
						pixelsToTranslate = document.body.clientHeight - el.offsetTop;
					animationContexts[animationContextIndex] = new animationContext(el, progressTranslation, finishTranslation, animationDuration, 10);
					animationContexts[animationContextIndex].startX = -pixelsToTranslate;
					animationContexts[animationContextIndex].startY = pixelsToTranslate;
					animationContexts[animationContextIndex].finalX = 0;
					animationContexts[animationContextIndex].finalY = 0;
					animationPump(animationContextIndex++);
					bStarted = true;
				}
								
				if ("FadeIn" == animationType)
				{
					animationDuration = el.getAttribute("BSSCDuration", false);
					if (null == animationDuration)
						animationDuration = 1000; // default to 1s
					
					finalOpacity = el.getAttribute("BSSCFinalOpacity", false);
					if (null == finalOpacity)
						finalOpacity = 100;
					
					initialOpacity = el.getAttribute("BSSCInitialOpacity", false);
					if (null == initialOpacity)
						initialOpacity = 0;

					animationContexts[animationContextIndex] = new animationContext(el, progressFade, finishFade, animationDuration, 50);
					el.filters.opacity = initialOpacity;
					animationContexts[animationContextIndex].initialOpacity = initialOpacity;
					animationContexts[animationContextIndex].finalOpacity = finalOpacity;
					animationPump(animationContextIndex++);
					bStarted = true;
				}
				
				if ("RevealTrans" == animationType)
				{
					Duration = el.getAttribute("BSSCDuration", false);
					if (null == Duration)
						Duration = 1000; // default to 1s
					Transition = el.getAttribute("BSSCTransition", false);
					if (null == Transition)
						Transition = 0;
					el.style.filter = "RevealTrans();";
					el.filters.RevealTrans.Transition = Transition;
					el.filters.RevealTrans.apply();
					el.style.visibility = ""; 
					el.filters.RevealTrans.play(parseInt(Duration)/1000.0);  
					bStarted = true;
				}
			}
		}
	}
	return bStarted;
}

function ApplyTextFormatting(divEl, childEl)
{
	childEl.setAttribute("BSSCOriginalStyle", childEl.style);

	// Text Change
	hoverColor = divEl.getAttribute("BSSCHoverColor", false);
	if ("Default" != divEl.getAttribute("BSSCHoverColorName"))
	{
		childEl.setAttribute("BSSCOriginalColor", childEl.style.color);
		childEl.style.color = hoverColor;
	}

	hoverFontName = divEl.getAttribute("BSSCHoverFontName", false);
	if (null != hoverFontName && hoverFontName != "*Default*")
	{
		hoverFontFamily = divEl.getAttribute("BSSCHoverFontFamily", false);
		if (null != hoverFontFamily)
		{
			childEl.setAttribute("BSSCOriginalFontFamily", childEl.style.fontFamily);
			childEl.style.fontFamily = hoverFontFamily;
		}
	}

	hoverFontSize = divEl.getAttribute("BSSCHoverFontSize", false);
	{
		if (null != hoverFontSize && hoverFontSize != "*")
		{
			childEl.setAttribute("BSSCOriginalFontSize", childEl.style.fontSize);
			childEl.style.fontSize = hoverFontSize + "pt";
		}
	}

	hoverFontStyle = divEl.getAttribute("BSSCHoverFontStyle", false);
	if (null != hoverFontStyle && "Regular" != hoverFontStyle)
	{
		if ("Italic" == hoverFontStyle)
		{
			childEl.setAttribute("BSSCOriginalFontStyle", childEl.style.fontStyle);
			childEl.style.fontStyle = "italic";
		}
		else if ("Bold" == hoverFontStyle)
		{
			childEl.setAttribute("BSSCOriginalFontWeight", childEl.style.fontWeight);
			childEl.style.fontWeight = "bold";
		}
		else if ("Bold Italic" == hoverFontStyle)
		{
			childEl.setAttribute("BSSCOriginalFontStyle", childEl.style.fontStyle);
			childEl.style.fontStyle = "italic";
			childEl.setAttribute("BSSCOriginalFontWeight", childEl.style.fontWeight);
			childEl.style.fontWeight = "bold";
		}
	}

	hoverUnderline = divEl.getAttribute("BSSCHoverUnderLine", false);
	if (null != hoverUnderline && hoverUnderline == "TRUE")
	{
		childEl.setAttribute("BSSCOriginalTextDecoration", childEl.style.textDecoration);
		childEl.style.textDecoration = "underline";
	}
}

function RemoveTextFormatting(el)
{
	originalColor = el.getAttribute("BSSCOriginalColor", false);
	if (null != originalColor)
		el.style.color = originalColor;

	originalFontFamily = el.getAttribute("BSSCOriginalFontFamily", false);
	if (null != originalFontFamily)
		el.style.fontFamily = originalFontFamily;

	originalFontSize = el.getAttribute("BSSCOriginalFontSize", false);
	if (null != originalFontSize)
		el.style.fontSize = originalFontSize;

	originalFontStyle = el.getAttribute("BSSCOriginalFontStyle", false);
	if (null != originalFontStyle)
		el.style.fontStyle = originalFontStyle;

	originalFontWeight = el.getAttribute("BSSCOriginalFontWeight", false);
	if (null != originalFontWeight)
		el.style.fontWeight = originalFontWeight;

	originalTextDecoration = el.getAttribute("BSSCOriginalTextDecoration", false);
	if (null != originalTextDecoration)
		el.style.textDecoration = originalTextDecoration;
}

function BSSCOnMouseOver(el)
{
	// Text Formatting
	hoverColor = el.getAttribute("BSSCHoverColor", false);
	if (null != hoverColor)
		for (index=0; index<el.all.length; index++)
			ApplyTextFormatting(el, el.all[index]);

	// Glow
	glowColor = el.getAttribute("BSSCGlowColor", false);
	if (null != glowColor)
	{
		glowStrength = el.getAttribute("BSSCGlowStrength", false);
		if (null == glowStrength)
			glowStrength = "3";
		glowColorName = el.getAttribute("BSSCGlowColorName");
		if ("Default" == glowColorName)
			el.style.filter = "glow(Strength=" + glowStrength + ", enabled=1)";
		else
			el.style.filter = "glow(Color=#" + glowColor + ", Strength=" + glowStrength + ", enabled=1)";
	}
}

function BSSCOnMouseOut(el)
{
	// Text Formatting
	hoverColor = el.getAttribute("BSSCHoverColor", false);
	if (null != hoverColor)
		for (index=0; index<el.all.length; index++)
			RemoveTextFormatting(el.all[index]);

	// Glow
	glowColor = el.getAttribute("BSSCGlowColor", false);
	if (null != glowColor)
		el.style.filter="";

}

function IsIE4OrLater()
{
	if ("Microsoft Internet Explorer" != navigator.appName)
		return false;
	version = parseFloat(navigator.appVersion);
	if (version >= 4.0)
		return true;
	else
		return false;
}

function BSSCOnLoad()
{
	if (!IsIE4OrLater())
		return;
	doStaticEffects();
	startAnimationSet(0);
}

function BSSCOnClick()
{
	if (!IsIE4OrLater())
		return;
	startNextAnimationSet();
}

function doStaticEffects()
{
	divElements = document.all.tags("DIV");
	for (index = 0; index < divElements.length; index++)
	{
		el = divElements[index];
		
		dropShadowColor = el.getAttribute("BSSCDropShadowColor");
		if (null != dropShadowColor)
		{
			dropShadowXOffset = el.getAttribute("BSSCDropShadowXOffset");
			if (null == dropShadowXOffset)
				dropShadowXOffset = 0;
			dropShadowYOffset = el.getAttribute("BSSCDropShadowYOffset");
			if (null == dropShadowYOffset)
				dropShadowYOffset = 0;
			dropShadowColorName = el.getAttribute("BSSCDropShadowColorName");
			if ("Default" == dropShadowColorName)
				el.style.filter = "DropShadow(OffX=" + dropShadowXOffset + ", OffY=" + dropShadowYOffset + ")";
			else
				el.style.filter = "DropShadow(Color=" + dropShadowColor + ", OffX=" + dropShadowXOffset + ", OffY=" + dropShadowYOffset + ")";
		}
	}
}