Attribute VB_Name = "Constants"
'----------------------------------------------------------------------
' Constants.bas
'
' Author : Andrew Friedl @ Blackbox Software
' Created: 1999.12.08
' Purpose: an example of how to build a scanner using PatternPro RXT
' Related:
' Revised:
'
' Copyright 1999, BlackBox Software & Consulting
'----------------------------------------------------------------------
Option Explicit

'--------------------------------------------------------------------------------
' SINGLE CHARACTER TOKEN DEFINITIONS
'--------------------------------------------------------------------------------
Public Const TOK_NULL       As Integer = 0                  ' no more characters
Public Const TOK_TAB        As Integer = 9                  ' horizontal tab
Public Const TOK_CR         As Integer = 13                 ' carriage return
Public Const TOK_LF         As Integer = 10                 ' linefeed
Public Const TOK_SPACE      As Integer = 32                 ' a blank space
Public Const TOK_DQUOTE     As Integer = 34                 ' a double quote
Public Const TOK_SQUOTE     As Integer = 39                 ' a single quote
Public Const TOK_COMMA      As Integer = 44                 ' a comma
Public Const TOK_EQUAL      As Integer = 61                 ' equal sign "="
Public Const TOK_ESCAPE     As Integer = 92                 ' the '\' character
Public Const TOK_CBRACEL    As Integer = 123                ' the "{" character
Public Const TOK_CBRACER    As Integer = 125                ' the "}" character

'--------------------------------------------------------------------------------
' PATTERN TOKEN DEFINITIONS
'--------------------------------------------------------------------------------
Public Const TOK_MAX_CHAR   As Integer = 256

'--------------------------------------------------------------------------------
' PATTERN TOKEN DEFINITIONS
'--------------------------------------------------------------------------------
Public Const TOK_IGNORE     As Integer = TOK_MAX_CHAR + 1    ' stuff to ignore
Public Const TOK_NAME       As Integer = TOK_MAX_CHAR + 2    ' list element names
Public Const TOK_NUMBER     As Integer = TOK_MAX_CHAR + 3    ' all numeric values
Public Const TOK_STRING     As Integer = TOK_MAX_CHAR + 4    ' single and double quoted string
Public Const TOK_DATE       As Integer = TOK_MAX_CHAR + 5    ' "#date#"

'--------------------------------------------------------------------------------
' REGULAR EXPRESSION PATTERNS
'--------------------------------------------------------------------------------
Public Const PAT_NAME           As String = "[a-zA-Z](([a-zA-Z0-9_]/[a-zA-Z0-9])|[a-zA-Z0-9])*"
Public Const PAT_DQUOTED        As String = "\""([^\r\n""]|(\\\""))+\"""
Public Const PAT_SQUOTED        As String = "'([^\r\n']|(\\'))+'"
Public Const PAT_ESC_SEQ        As String = "\\[t""'rnl]"
Public Const PAT_NUMBER         As String = "[-+]?(([0-9]+)|([0-9]*\.[0-9]+)([eE][-+]?[0-9]+)?)"
Public Const PAT_DATE           As String = "#[^\r\n#]+#"
Public Const PAT_IGNORE         As String = "[\r\n\t\x20]+"

'--------------------------------------------------------------------------------
' SCANNER STATE DEFINITION
'--------------------------------------------------------------------------------
Public Const STATE_LIST     As Integer = 1
Public Const STATE_VALUE    As Integer = 2
