// CaptureFileDlg.cpp : implementation file
//

#include "stdafx.h"
#include "CaptureFile.h"
#include "CaptureFileDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCaptureFileDlg dialog

CCaptureFileDlg::CCaptureFileDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCaptureFileDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCaptureFileDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CCaptureFileDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCaptureFileDlg)
	DDX_Control(pDX, IDC_CHKMUTETV, m_ChkMuteTV);
	DDX_Control(pDX, IDC_CBOVIDEOINPUT, m_CboVideoInput);
	DDX_Control(pDX, IDC_CHKUSEVIDEOCOMP, m_ChkUseVideoCompressor);
	DDX_Control(pDX, IDC_CHKUSEAUDIOCOMP, m_ChkUseAudioCompressor);
	DDX_Control(pDX, IDC_CHKSHOWPREVIEW, m_ChkShowPreview);
	DDX_Control(pDX, IDC_CHKCAPVIDEO, m_ChkCaptureVideo);
	DDX_Control(pDX, IDC_CHKCAPAUDIO, m_ChkCaptureAudio);
	DDX_Control(pDX, IDC_CBOAUDIOCOMP, m_CboAudioComp);
	DDX_Control(pDX, IDC_CBOAUDIODEVICE, m_CboAudioDevice);
	DDX_Control(pDX, IDC_CBOVIDEOFORMAT, m_CboVideoFormat);
	DDX_Control(pDX, IDC_CBOVIDEOCOMP, m_CboVideoComp);
	DDX_Control(pDX, IDC_CBODEVICE, m_CboDevice);
	DDX_Control(pDX, IDC_VIDEOCAPCTRL1, m_VideoCap1);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCaptureFileDlg, CDialog)
	//{{AFX_MSG_MAP(CCaptureFileDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BTNPREVIEW, OnBtnpreview)
	ON_BN_CLICKED(IDC_BTNCAPTURE, OnBtncapture)
	ON_BN_CLICKED(IDC_BTNSTOP, OnBtnstop)
	ON_BN_CLICKED(IDC_CHKUSEAUDIOCOMP, OnChkuseaudiocomp)
	ON_BN_CLICKED(IDC_CHKUSEVIDEOCOMP, OnChkusevideocomp)
	ON_BN_CLICKED(IDC_CHKMUTETV, OnChkmutetv)
	ON_BN_CLICKED(IDC_BTNSETTING, OnBtnsetting)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCaptureFileDlg message handlers

BOOL CCaptureFileDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here


	int i;

	m_VideoCap1.SetTVMute(TRUE);

	int iDeviceCount= m_VideoCap1.GetDevices().GetCount();
	CString strDeviceName;

	for(i=0; i <iDeviceCount;i++)
	{

		strDeviceName=m_VideoCap1.GetDevices().FindDeviceName(i);
		m_CboDevice.AddString(strDeviceName);
	}

	if(m_CboDevice.GetCount()>0)
		m_CboDevice.SetCurSel(0);


	int iVideoInputCount= m_VideoCap1.GetVideoInputs().GetCount();
	CString strVideoInput;

	for(i=0; i <iVideoInputCount;i++)
	{

		strVideoInput=m_VideoCap1.GetVideoInputs().FindVideoInputName(i);
		m_CboVideoInput.AddString(strVideoInput);
	}

	if(m_CboVideoInput.GetCount()>0)
		m_CboVideoInput.SetCurSel(0);


	////////////////////video format

	int iVideoFormatCount= m_VideoCap1.GetVideoFormats().GetCount();

		
	CString strVideoFormat;

	for(i=0; i <iVideoFormatCount;i++)
	{

		strVideoFormat=m_VideoCap1.GetVideoFormats().FindVideoFormatName(i);
		m_CboVideoFormat.AddString(strVideoFormat);
		
	}

	if(m_CboVideoFormat.GetCount()>0)
		m_CboVideoFormat.SetCurSel(0);

	/////////////////// audio device

	int iAudioDeviceCount= m_VideoCap1.GetAudioDevices().GetCount();

	
	CString strAudioDeviceName;

	for(i=0; i <iAudioDeviceCount;i++)
	{

		strAudioDeviceName=m_VideoCap1.GetAudioDevices().FindDeviceName(i);
		m_CboAudioDevice.AddString(strAudioDeviceName);

	}

	if(m_CboAudioDevice.GetCount()>0)
		m_CboAudioDevice.SetCurSel(0);

	//////////////////audio compressor
	int iAudioCompCount= m_VideoCap1.GetAudioCompressors().GetCount();


	
	CString strAudioComp;

	for(i=0; i <iAudioCompCount;i++)
	{

		
		strAudioComp=m_VideoCap1.GetAudioCompressors().FindAudioCompressorName(i);
		m_CboAudioComp.AddString(strAudioComp);

	}

	if(m_CboAudioComp.GetCount()>0)
		m_CboAudioComp.SetCurSel(0);
		

	///////////////////////////////////video compressor

	int iVideoCompCount= m_VideoCap1.GetVideoCompressors().GetCount();

	
	
	CString strVideoComp;

	for(i=0; i <iVideoCompCount;i++)
	{

		
		strVideoComp=m_VideoCap1.GetVideoCompressors().FindVideoCompressorName(i);
		m_CboVideoComp.AddString(strVideoComp);

	}

	if(m_CboVideoComp.GetCount()>0)

		m_CboVideoComp.SetCurSel(0);



	m_ChkShowPreview.SetCheck(1);
	m_ChkCaptureAudio.SetCheck(1);
	m_ChkCaptureVideo.SetCheck(1);
	m_ChkMuteTV.SetCheck(1);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CCaptureFileDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CCaptureFileDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CCaptureFileDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CCaptureFileDlg::ControlCap()
{

	//////////////////device
	CString strDevice;
	m_CboDevice.GetLBText(m_CboDevice.GetCurSel(),strDevice);
	int iDeviceIndex =m_VideoCap1.GetDevices().FindDevice(strDevice);
	
	
	if(iDeviceIndex != -1)
		m_VideoCap1.SetDevice(iDeviceIndex);

	////////////// video input	
	CString strVideoInput;
	m_CboVideoInput.GetLBText(m_CboVideoInput.GetCurSel(),strVideoInput);
	int iVideoInputIndex =m_VideoCap1.GetVideoInputs().FindVideoInput(strVideoInput);
	
	
	if(iVideoInputIndex != -1)
		m_VideoCap1.SetVideoInput(iVideoInputIndex);	


	
	//////////////////Video Format
	CString strVideoFormat;
	m_CboVideoFormat.GetLBText(m_CboVideoFormat.GetCurSel(),strVideoFormat);
	
	
	
	int iVideoFormatIndex= m_VideoCap1.GetVideoFormats().FindVideoFormat(strVideoFormat);
	
	
	if(iVideoFormatIndex != -1)
		m_VideoCap1.SetVideoFormat(iVideoFormatIndex);
	
	
	
	//////////////////audio device
	CString strAudioDevice;
	m_CboAudioDevice.GetLBText(m_CboAudioDevice.GetCurSel(),strAudioDevice);
	int iAudioDeviceIndex =m_VideoCap1.GetAudioDevices().FindDevice(strAudioDevice);
	
	
	if(iAudioDeviceIndex != -1)
		m_VideoCap1.SetAudioDevice(iAudioDeviceIndex);
	
	
	/////////////////// audio compressor
	CString strAudioCompressor;
	
	m_CboAudioComp.GetLBText(m_CboAudioComp.GetCurSel(),strAudioCompressor);
	int iAudioCompIndex =m_VideoCap1.GetAudioCompressors().FindAudioCompressor(strAudioCompressor);
	
	
	if(iAudioCompIndex != -1)
		m_VideoCap1.SetAudioCompressor(iAudioCompIndex);
	
	
	//////////////////video compressor
	CString strVideoCompressor;
	
	m_CboVideoComp.GetLBText(m_CboVideoComp.GetCurSel(),strVideoCompressor);
	int iVideoCompIndex =m_VideoCap1.GetVideoCompressors().FindVideoCompressor(strVideoCompressor);
	
	
	if(iVideoCompIndex != -1)
		m_VideoCap1.SetVideoCompressor(iVideoCompIndex);

}

void CCaptureFileDlg::OnBtnpreview() 
{
	// TODO: Add your control notification handler code here
	ControlCap();
	m_VideoCap1.Start();	
	
}

void CCaptureFileDlg::OnBtncapture() 
{
	// TODO: Add your control notification handler code here

	ControlCap();
	
	char szFilter[]="avi file(*.avi)|*.avi|All Files(*.*)|*.*|| ";
	
	CFileDialog dlg(FALSE,"avi","*.avi",OFN_FILEMUSTEXIST,szFilter,this);
	
	if(dlg.DoModal()==IDOK)
	{


		
		m_VideoCap1.SetCaptureAudio(m_ChkCaptureAudio.GetCheck());

		m_VideoCap1.SetCaptureVideo(m_ChkCaptureVideo.GetCheck());
		m_VideoCap1.SetShowPreview(m_ChkShowPreview.GetCheck());

		
		m_VideoCap1.SetUseAudioCompressor(m_ChkUseAudioCompressor.GetCheck());

		m_VideoCap1.SetUseVideoCompressor(m_ChkUseVideoCompressor.GetCheck());
		m_VideoCap1.SetCaptureFileName(dlg.GetPathName());
		
		m_VideoCap1.SetCaptureMode(TRUE);
		
		
		
		int iResult=m_VideoCap1.Start();
		
		
		if(iResult== -1)
		{
			
			AfxMessageBox("Capture Failure, Video/Audio compressor not correct or capture file opening");
			return;
		}		
		

		GetDlgItem(IDC_BTNPREVIEW)->EnableWindow(FALSE);
		GetDlgItem(IDC_BTNSTOP)->EnableWindow(TRUE);
		GetDlgItem(IDC_BTNCAPTURE)->EnableWindow(FALSE);

		
	}
	
	
}

void CCaptureFileDlg::OnBtnstop() 
{
	// TODO: Add your control notification handler code here
	m_VideoCap1.SetShowPreview(TRUE);
	m_VideoCap1.SetCaptureMode(FALSE);
	m_VideoCap1.Stop();
	m_VideoCap1.Start();


	GetDlgItem(IDC_BTNSTOP)->EnableWindow(FALSE);
	GetDlgItem(IDC_BTNPREVIEW)->EnableWindow(TRUE);
	GetDlgItem(IDC_BTNCAPTURE)->EnableWindow(TRUE);
	
}

void CCaptureFileDlg::OnChkuseaudiocomp() 
{
	// TODO: Add your control notification handler code here

	if(m_ChkUseAudioCompressor.GetCheck()==BST_CHECKED)
		m_CboAudioComp.EnableWindow(TRUE);
	else
		m_CboAudioComp.EnableWindow(FALSE);



}

void CCaptureFileDlg::OnChkusevideocomp() 
{
	// TODO: Add your control notification handler code here
	if(m_ChkUseVideoCompressor.GetCheck()==BST_CHECKED)
		m_CboVideoComp.EnableWindow(TRUE);
	else
		m_CboVideoComp.EnableWindow(FALSE);

	
}

void CCaptureFileDlg::OnChkmutetv() 
{
	// TODO: Add your control notification handler code here
	if(m_ChkMuteTV.GetCheck()==BST_CHECKED)
		m_VideoCap1.SetTVMute(TRUE);
	else
		m_VideoCap1.SetTVMute(FALSE);
	
}

void CCaptureFileDlg::OnBtnsetting() 
{
	// TODO: Add your control notification handler code here
	CString strVideoCompressor;
	
	m_CboVideoComp.GetLBText(m_CboVideoComp.GetCurSel(),strVideoCompressor);
	int iVideoCompIndex =m_VideoCap1.GetVideoCompressors().FindVideoCompressor(strVideoCompressor);


	BOOL bResult=m_VideoCap1.GetVideoCompressors().ShowPropertyPage(iVideoCompIndex);

	if(bResult==FALSE)
		AfxMessageBox("No property page");


	//m_VideoCap1.
	
}
