// CamerControlDlg.cpp : implementation file
//

#include "stdafx.h"
#include "CamerControl.h"
#include "CamerControlDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCamerControlDlg dialog

CCamerControlDlg::CCamerControlDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCamerControlDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCamerControlDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CCamerControlDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCamerControlDlg)
	DDX_Control(pDX, IDC_CBOVIDEOINPUT, m_CboVideoInput);
	DDX_Control(pDX, IDC_SLIDERGAIN, m_SdGain);
	DDX_Control(pDX, IDC_SLIDERBACKLIGHT, m_SdBackLight);
	DDX_Control(pDX, IDC_SLIDERWHITEBALANCE, m_SdWhiteBalance);
	DDX_Control(pDX, IDC_SLIDERCOLORENABLE, m_SdColorEnable);
	DDX_Control(pDX, IDC_SLIDERGAMMA, m_SdGamma);
	DDX_Control(pDX, IDC_SLIDERSHARPNESS, m_SdSharpness);
	DDX_Control(pDX, IDC_SLIDERSATURATION, m_SdSaturation);
	DDX_Control(pDX, IDC_SLIDERHUE, m_SdHue);
	DDX_Control(pDX, IDC_SLIDERCONTRAST, m_SdContrast);
	DDX_Control(pDX, IDC_SLIDERBRIGHTNESS, m_SdBrightness);
	DDX_Control(pDX, IDC_VIDEOCAPCTRL1, m_VideoCap1);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCamerControlDlg, CDialog)
	//{{AFX_MSG_MAP(CCamerControlDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BTNPREVIEW, OnBtnpreview)
	ON_BN_CLICKED(IDC_BTNSHOWPROPERTY, OnBtnshowproperty)
	ON_WM_HSCROLL()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCamerControlDlg message handlers

BOOL CCamerControlDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	int iVideoInputCount= m_VideoCap1.GetVideoInputs().GetCount();
	CString strVideoInput;
	int i;

	for(i=0; i <iVideoInputCount;i++)
	{

		strVideoInput=m_VideoCap1.GetVideoInputs().FindVideoInputName(i);
		m_CboVideoInput.AddString(strVideoInput);
	}

	if(m_CboVideoInput.GetCount()>0)
		m_CboVideoInput.SetCurSel(0);


	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CCamerControlDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CCamerControlDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CCamerControlDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CCamerControlDlg::OnBtnpreview() 
{
	// TODO: Add your control notification handler code here

	CString strVideoInput;
	m_CboVideoInput.GetLBText(m_CboVideoInput.GetCurSel(),strVideoInput);
	int iVideoInputIndex =m_VideoCap1.GetVideoInputs().FindVideoInput(strVideoInput);
	
	
	if(iVideoInputIndex != -1)
		m_VideoCap1.SetVideoInput(iVideoInputIndex);


	m_VideoCap1.Start();


	if( m_VideoCap1.GetBrightness().GetAvailable()) 
	{
		m_SdBrightness.SetRangeMin(m_VideoCap1.GetBrightness().GetMin());
		m_SdBrightness.SetRangeMax(m_VideoCap1.GetBrightness().GetMax());
		m_SdBrightness.SetPos(m_VideoCap1.GetBrightness().GetValue());

	}
	else
		m_SdBrightness.EnableWindow(FALSE);



	if( m_VideoCap1.GetContrast().GetAvailable())
	{

		m_SdContrast.SetRangeMin(m_VideoCap1.GetContrast().GetMin());
		m_SdContrast.SetRangeMax(m_VideoCap1.GetContrast().GetMax());
		m_SdContrast.SetPos(m_VideoCap1.GetContrast().GetValue());


	}
	else
		m_SdContrast.EnableWindow(FALSE);



	if( m_VideoCap1.GetHue().GetAvailable())
	{

		m_SdHue.SetRangeMin(m_VideoCap1.GetHue().GetMin());
		m_SdHue.SetRangeMax(m_VideoCap1.GetHue().GetMax());
		m_SdHue.SetPos(m_VideoCap1.GetHue().GetValue());


	}
	else
		m_SdHue.EnableWindow(FALSE);


	if(m_VideoCap1.GetSaturation().GetAvailable())
	{

		m_SdSaturation.SetRangeMin(m_VideoCap1.GetSaturation().GetMin());
		m_SdSaturation.SetRangeMax(m_VideoCap1.GetSaturation().GetMax());
		m_SdSaturation.SetPos(m_VideoCap1.GetSaturation().GetValue());

	}
	else
		m_SdSaturation.EnableWindow(FALSE);

	if(m_VideoCap1.GetSharpness().GetAvailable())
	{

		m_SdSharpness.SetRangeMin(m_VideoCap1.GetSharpness().GetMin());
		m_SdSharpness.SetRangeMax(m_VideoCap1.GetSharpness().GetMax());
		m_SdSharpness.SetPos(m_VideoCap1.GetSharpness().GetValue());

	}
	else
		m_SdSharpness.EnableWindow(FALSE);


	if(m_VideoCap1.GetGamma().GetAvailable())
	{

		m_SdGamma.SetRangeMin(m_VideoCap1.GetGamma().GetMin());
		m_SdGamma.SetRangeMax(m_VideoCap1.GetGamma().GetMax());
		m_SdGamma.SetPos(m_VideoCap1.GetGamma().GetValue());

	}
	else
		m_SdGamma.EnableWindow(FALSE);
	

	if(m_VideoCap1.GetColorEnable().GetAvailable())
	{

		m_SdColorEnable.SetRangeMin(m_VideoCap1.GetColorEnable().GetMin());
		m_SdColorEnable.SetRangeMax(m_VideoCap1.GetColorEnable().GetMax());
		m_SdColorEnable.SetPos(m_VideoCap1.GetColorEnable().GetValue());

	}
	else
		m_SdColorEnable.EnableWindow(FALSE);
	
	if(m_VideoCap1.GetColorEnable().GetAvailable())
	{

		m_SdWhiteBalance.SetRangeMin(m_VideoCap1.GetWhiteBalance().GetMin());
		m_SdWhiteBalance.SetRangeMax(m_VideoCap1.GetWhiteBalance().GetMax());
		m_SdWhiteBalance.SetPos(m_VideoCap1.GetWhiteBalance().GetValue());

	}
	else
		m_SdWhiteBalance.EnableWindow(FALSE);

	if(m_VideoCap1.GetBacklightCompensation().GetAvailable())
	{

		m_SdBackLight.SetRangeMin(m_VideoCap1.GetBacklightCompensation().GetMin());
		m_SdBackLight.SetRangeMax(m_VideoCap1.GetBacklightCompensation().GetMax());
		m_SdBackLight.SetPos(m_VideoCap1.GetBacklightCompensation().GetValue());

	}
	else
		m_SdBackLight.EnableWindow(FALSE);

	if(m_VideoCap1.GetGain().GetAvailable())
	{

		m_SdGain.SetRangeMin(m_VideoCap1.GetGain().GetMin());
		m_SdGain.SetRangeMax(m_VideoCap1.GetGain().GetMax());
		m_SdGain.SetPos(m_VideoCap1.GetGain().GetValue());

	}
	else
		m_SdGain.EnableWindow(FALSE);



	
}

void CCamerControlDlg::OnBtnshowproperty() 
{
	// TODO: Add your control notification handler code here

	m_VideoCap1.ShowVideoCapturePropertyPage();



}

void CCamerControlDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	// TODO: Add your message handler code here and/or call default

	int iID = pScrollBar->GetDlgCtrlID();
	int iCurrent;

	if(iID==IDC_SLIDERBRIGHTNESS)
	{
		CSliderCtrl *pSlider = (CSliderCtrl *)pScrollBar;
		iCurrent = pSlider->GetPos();
		m_VideoCap1.GetBrightness().SetValue(iCurrent);

	}
	else if(iID==IDC_SLIDERCONTRAST)
	{
		CSliderCtrl *pSlider = (CSliderCtrl *)pScrollBar;
		iCurrent = pSlider->GetPos();
		m_VideoCap1.GetContrast().SetValue(iCurrent);

	}
	else if(iID==IDC_SLIDERHUE)
	{
		CSliderCtrl *pSlider = (CSliderCtrl *)pScrollBar;
		iCurrent = pSlider->GetPos();
		m_VideoCap1.GetHue().SetValue(iCurrent);

	}
	else if(iID==IDC_SLIDERSATURATION)
	{
		CSliderCtrl *pSlider = (CSliderCtrl *)pScrollBar;
		iCurrent = pSlider->GetPos();
		m_VideoCap1.GetSaturation().SetValue(iCurrent);

	}
	else if(iID==IDC_SLIDERSHARPNESS)
	{
		CSliderCtrl *pSlider = (CSliderCtrl *)pScrollBar;
		iCurrent = pSlider->GetPos();
		m_VideoCap1.GetSharpness().SetValue(iCurrent);

	}
	else if(iID==IDC_SLIDERGAMMA)
	{
		CSliderCtrl *pSlider = (CSliderCtrl *)pScrollBar;
		iCurrent = pSlider->GetPos();
		m_VideoCap1.GetGamma().SetValue(iCurrent);

	}
	else if(iID==IDC_SLIDERCOLORENABLE)
	{
		CSliderCtrl *pSlider = (CSliderCtrl *)pScrollBar;
		iCurrent = pSlider->GetPos();
		m_VideoCap1.GetColorEnable().SetValue(iCurrent);

	}
	else if(iID==IDC_SLIDERWHITEBALANCE)
	{
		CSliderCtrl *pSlider = (CSliderCtrl *)pScrollBar;
		iCurrent = pSlider->GetPos();
		m_VideoCap1.GetWhiteBalance().SetValue(iCurrent);

	}

	else if(iID==IDC_SLIDERBACKLIGHT)
	{
		CSliderCtrl *pSlider = (CSliderCtrl *)pScrollBar;
		iCurrent = pSlider->GetPos();
		m_VideoCap1.GetBacklightCompensation().SetValue(iCurrent);

	}
	else if(iID==IDC_SLIDERBACKLIGHT)
	{
		CSliderCtrl *pSlider = (CSliderCtrl *)pScrollBar;
		iCurrent = pSlider->GetPos();
		m_VideoCap1.GetBacklightCompensation().SetValue(iCurrent);

	}
	else if(iID==IDC_SLIDERGAIN)
	{
		CSliderCtrl *pSlider = (CSliderCtrl *)pScrollBar;
		iCurrent = pSlider->GetPos();
		m_VideoCap1.GetGain().SetValue(iCurrent);

	}



	
	


	
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}
