/*
** File:	scrnmode.c
** Version: 1.0		10/17/2000
** Author:  John Fitzgibbon (fitz@jfitz.com)
** License: This program is Open Source FREEWARE.
**
** Description:
** Quick and dirty command line program for changing screen mode, 
** (resolution, color depth, etc.).
**
** Useful for apps/games that will only run in specific screen modes.
** (e.g., my WinTV card will only display full screen at 640 x 480)
**
** Call with no parameters for a list of screen modes supported by your display.
** Call with a display mode number to change the display mode for this session.
** Call with "reset" as the 1st parameter to reset the display.
** Include optional command to invoke after changing mode as 2nd parameter.
** Include parameters for the optional command as the 3nd parameter.
** (Use quotes if the command takes multiple parameters.)
*/

#include <windows.h>
#include <stdio.h>

int main (int argc, char * argv[])
{
	DEVMODE dm;
	DWORD iModeNum;
	DWORD maxIModeNum;
	LONG changeStatus;

	if (argc <= 1)
	{
		printf(
			"\nSCRNMODE 1.0\t10/17/2000\tJohn Fitzgibbon\tfitz@jfitz.com\n\n"
			"Specify \"N\" or \"reset\" as a parameter to change or reset the screen mode.\n\"N\" should be one of the following:\n\n"
			"  N  Color Width Height Flags Freq\n"
			"---  ----- ----- ------ ----- ----\n");
	}
	for (maxIModeNum=0; EnumDisplaySettings(NULL,maxIModeNum,&dm); maxIModeNum++)
	{
		if (argc <= 1)
			printf("%3d %6d %5d %6d %5d %4d\n",maxIModeNum,
				dm.dmBitsPerPel,
				dm.dmPelsWidth,
				dm.dmPelsHeight,
				dm.dmDisplayFlags,
				dm.dmDisplayFrequency);
	}

	if (maxIModeNum)
		maxIModeNum--;

	if (argc > 1)
	{
		if (!strcmp(argv[1],"reset"))
			ChangeDisplaySettings(NULL,0);
		else
		{
			iModeNum = atoi(argv[1]);
			if (iModeNum > maxIModeNum)
				iModeNum = maxIModeNum;
			if (EnumDisplaySettings(NULL,iModeNum,&dm))
			{
#ifdef _DEBUG
				printf("Changing to Display# %d %6d %5d %6d %5d %4d\n",iModeNum,
					dm.dmBitsPerPel,
					dm.dmPelsWidth,
					dm.dmPelsHeight,
					dm.dmDisplayFlags,
					dm.dmDisplayFrequency);
#endif
				dm.dmSize = sizeof (DEVMODE);
				dm.dmFields = 
					DM_BITSPERPEL |
					DM_PELSWIDTH |
					DM_PELSHEIGHT |
					DM_DISPLAYFLAGS |
					DM_DISPLAYFREQUENCY;
				changeStatus = ChangeDisplaySettings(&dm,0);
#ifdef _DEBUG
				if (changeStatus == DISP_CHANGE_SUCCESSFUL)
					printf("SUCCESSFUL\n");
#endif
				if (changeStatus == DISP_CHANGE_RESTART)
					printf("RESTART\n");
				if (changeStatus == DISP_CHANGE_BADFLAGS)
					printf("BADFLAGS\n");
				if (changeStatus == DISP_CHANGE_FAILED)
					printf("FAILED\n");
				if (changeStatus == DISP_CHANGE_BADMODE)
					printf("BADMODE\n");
				if (changeStatus == DISP_CHANGE_NOTUPDATED)
					printf("NOTUPDATED\n");
			}
		}
		if (argc > 3)
			ShellExecute(NULL, NULL, argv[2], argv[3], ".", SW_SHOWNORMAL);
		else if (argc > 2)
			ShellExecute(NULL, NULL, argv[2], "", ".", SW_SHOWNORMAL);
	}
	else
	{
		printf(
			"\nYou may also specify a command to execute after changing the screen mode.\n"
			"\nPress ENTER to continue...");
		_fgetchar();
	}

	return 0;
}
