/*
 * Program: rdel V1.0
 * Author:  Rik Wade (olds@scs.leeds.ac.uk)
 * Date:    30/08/1995
 *
 * Comments: 'rdel' is a little hack for those who want files which
 *           are deleted at the command prompt to be placed in the
 *           'recycle' bin on that drive.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dir.h>

/* This is the directory where all recycled files go
 */
#define DELDIR "recycled"


void main(int argc, char* argv[])
{
    /* For the file copying
     */
	FILE *infile, *outfile;

	char *dname = DELDIR, *fname = "\0", *ptr;
    char buf[10];

	/* Make sure we get a single filename
	 */
    if (argc!=2) { printf("usage: rdel <filename>\n"); exit(1); }

    ptr = strrchr(argv[1],'\\');
    if (!ptr) { ptr = argv[1]; }

    strcat(fname,"\\");
    strcat(fname,dname);
    strcat(fname,"\\");
    strcat(fname,ptr);

	/* If the file opens then process it, otherwise nothing
	 */
    if ( (!(infile = fopen(argv[1], "rb"))) ||
	    (!(outfile = fopen(fname, "wb"))) ) {

       	perror("Unable to open file");
    }
	else
	{
        printf("Recycling: %s\n",argv[1]);

        /* Now read a byte, write a byte.
         */
    	while(!feof(infile)) {
	    	if(fread(buf,1,1,infile)) {
			    fwrite(buf,1,1,outfile);
            }
		}
		fclose(infile);
		fclose(outfile);

        /* Remove the original file
         */
        remove(argv[1]);
    }
}
