REM     The Standart Personal GNU Text BASIC Interpretter.
REM     Copyright (C) Sandul Yura Valentinovich.
REM     (R) Monday, 5 May 2003 year.
REM     This program is free software; you can redistribute it and/or modify
REM it under the terms of the GNU General Public License as published by the
REM Free Software Foundation; either version 2 of the License, or (at your
REM option) any later version.
REM     This program is distributed in the hope that it will be useful, but
REM WITHOUT ANY WARRANTY; without even the implied warranty of
REM MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
REM Public License for more details.
REM     You should have received a copy of the GNU General Public License
REM along with this program; if not, write to the Free Software Foundation,
REM Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
REM
REM $DYNAMIC
DECLARE SUB OutHelp ()
DECLARE SUB ScratchScreen ()
DECLARE SUB OutText ()
DECLARE SUB DeleteBackSymbol ()
DECLARE SUB EnterLine ()
DECLARE SUB OutBox (Title$, Message$)
DECLARE SUB ControlCoordinates ()
DECLARE SUB ClearAll ()
DECLARE SUB ClearANSI ()
DECLARE SUB RunLine (InLine$)
DECLARE SUB CursorRight ()
DECLARE SUB CursorUp ()
DECLARE SUB CursorDown ()
DECLARE SUB PageUp ()
DECLARE SUB PageDown ()
DECLARE SUB CursorHome ()
DECLARE SUB CursorEnd ()
DECLARE SUB CursorLeft ()
DECLARE SUB DeleteSymbol ()
DECLARE SUB ANSIOut (ANSISymbol$)
DECLARE SUB Hang ()
DECLARE SUB MakeBox (BoxColumn%, BoxRow%, BoxWidth%, BoxHeight%)
DECLARE SUB Restart ()
DECLARE SUB WriteLineOut (Line$)
DECLARE SUB SetVariable (VariableName$, VariableType%, VariableValue$)
DECLARE SUB SetTimerValue (NewValue&)
DECLARE SUB WriteLine (Line$)
DECLARE FUNCTION Calculate$ (InLine$)
DECLARE FUNCTION CalculateExpression$ (InLine$)
DECLARE FUNCTION CalendarBox% (Title$, Message$, DayValue%, MonthValue%, YearValue%)
DECLARE FUNCTION CurrentDateTime$ ()
DECLARE FUNCTION DayName$ (DayNumber%)
DECLARE FUNCTION DayOfWeek% (DayValue%, MonthValue%, YearValue%)
DECLARE FUNCTION DayOfWeekName$ (DayValue%, MonthValue%, YearValue%)
DECLARE FUNCTION DaysCount& (DayValue%, MonthValue%, YearValue%)
DECLARE FUNCTION FindLabel% (LabelName$)
DECLARE FUNCTION FindLine% (NumberOfLine%)
DECLARE FUNCTION GetTimerValue& ()
DECLARE FUNCTION InDefFn$ (DefFnName$, DefFnType%, InLine$)
DECLARE FUNCTION InMeaning$ (InLine$)
DECLARE FUNCTION InName$ (InLine$)
DECLARE FUNCTION InNumber# (InLine$)
DECLARE FUNCTION InputBox% (Title$, Message$, InputTextLine$)
DECLARE FUNCTION InVariable$ (VariableName$, VariableType%, InLine$)
DECLARE FUNCTION IsLeapYear% (YearValue%)
DECLARE FUNCTION MenuBox% (ItemsCount%)
DECLARE FUNCTION MessageBox% (Title$, Message$)
DECLARE FUNCTION MonthDays% (MonthValue%, YearValue%)
DECLARE FUNCTION MonthDaysCount% (MonthValue%, YearValue%)
DECLARE FUNCTION MonthName$ (MonthNumber%)
DECLARE FUNCTION ParseCalculate$ (InLine$)
DECLARE FUNCTION ParseInMeaning$ (InLine$)
DECLARE FUNCTION ParseInNumber$ (InLine$)
DECLARE FUNCTION ParseRunLine$ (InLine$)
DECLARE FUNCTION SquareRoot# (Meaning#)
DECLARE FUNCTION WeekNumber% (DayValue%, MonthValue%, YearValue%)
DECLARE FUNCTION InMeaningOfExpression$ (InLine$)
DECLARE FUNCTION ParseInMeaningOfExpression$ (InLine$)
DECLARE FUNCTION ParseCalculateExpression$ (InLine$)
OPTION BASE 1
CONST False% = 0
CONST True% = NOT False%
CONST TextLines% = 100
CONST DefFnSCountValue% = 4
CONST DefFnSArgumentsCountValue% = 4
CONST VariablesCountValue% = 8
CONST GoSubSCountValue% = 4
CONST FilesCountValue% = 4
CONST ANSIParametersCountValue% = 4
CONST WhilesCountValue% = 4
CONST FromsCountValue% = 4
CONST SubroutinesCountValue% = 4
CONST SubroutinesArgumentsCountValue% = 4
DIM SHARED MenuItems$(19)
DIM SHARED Text$(TextLines%)
DIM SHARED TextColumn%
DIM SHARED TextRow%
DIM SHARED TextPosition%
DIM SHARED LinePosition%
DIM SHARED TextName$
DIM SHARED StatusText$
DIM SHARED CursorRow%
DIM SHARED CursorColumn%
DIM SHARED CursorSaved%
DIM SHARED Parameters%(ANSIParametersCountValue%)
DIM SHARED ParametersCount%
DIM SHARED ANSIMode%
DIM SHARED NumberLine$
DIM SHARED DefFnS$(DefFnSCountValue%)
DIM SHARED DefFnSArgs$(DefFnSCountValue%, DefFnSArgumentsCountValue%)
DIM SHARED DefFnSArgsCount%(DefFnSCountValue%)
DIM SHARED Variables$(VariablesCountValue%)
DIM SHARED GoSubS%(GoSubSCountValue%)
DIM SHARED BASICFiles$(FilesCountValue%)
DIM SHARED Whiles$(WhilesCountValue%)
DIM SHARED Froms$(FromsCountValue%)
DIM SHARED Subroutines$(SubroutinesCountValue%)
DIM SHARED SubroutinesResults$(SubroutinesCountValue%)
DIM SHARED SubroutinesArguments$(SubroutinesCountValue%, SubroutinesArgumentsCountValue%)
DIM SHARED SubroutinesArgumentsCount%(SubroutinesCountValue%)
DIM SHARED SubroutineMode%
DIM SHARED CurrentSubroutine%
DIM SHARED DefFnSCount%
DIM SHARED VariablesCount%
DIM SHARED GoSubSCount%
DIM SHARED RunMode%
DIM SHARED TraceMode%
DIM SHARED CurrentLine%
DIM SHARED CurrentDefFn%
DIM SHARED DefFnMode%
DIM SHARED NumStr%
DIM Index%
DIM PrinterName$
DIM LinesPerPage%
DIM WorkIndex%
DIM WorkKey$
DIM OldSecond%
DIM WorkLine$
DIM Work$
DIM WorkYear%
DIM WorkMonth%
DIM WorkDay%
DIM OutIndex%
DIM Value%
DIM LineNumber%
DIM Days%(37)
DIM Errors$(95)
TextName$ = "Text.txt"
PrinterName$ = "Prn"
LinesPerPage% = 55
TextColumn% = 1
TextRow% = 1
TextPosition% = 1
LinePosition% = 1
OldSecond% = NOT VAL(MID$(TIME$, 7, 2))
StatusText$ = CurrentDateTime$
Errors$(1) = "NEXT without FOR"
Errors$(2) = "Syntax error"
Errors$(3) = "RETURN without GOSUB"
Errors$(4) = "Out of DATA"
Errors$(5) = "Illegal function call"
Errors$(6) = "Overflow"
Errors$(7) = "Out of memory"
Errors$(8) = "Label not defined"
Errors$(9) = "Subscript out of range"
Errors$(10) = "Duplicate definition"
Errors$(11) = "Division by zero"
Errors$(12) = "Illegal in direct mode"
Errors$(13) = "Type mismatch"
Errors$(14) = "Out of string space"
Errors$(15) = "Inavlid line number"
Errors$(16) = "String formula too complex"
Errors$(17) = "Cannot continue"
Errors$(18) = "Function not defined"
Errors$(19) = "No RESUME"
Errors$(20) = "RESUME without error"
Errors$(21) = "Too many program lines"
Errors$(22) = "Too many variables"
Errors$(23) = "User - defined functions are not declare"
Errors$(24) = "Device timeout"
Errors$(25) = "Device fault"
Errors$(26) = "FOR without NEXT"
Errors$(27) = "Out of paper"
Errors$(28) = "Inquired user - defined function is not declare"
Errors$(29) = "WHILE without WEND"
Errors$(30) = "WEND without WHILE"
Errors$(31) = "Too many calculating user - defined functions"
Errors$(32) = "Too many arguments for user - defined function"
Errors$(33) = "Duplicate label"
Errors$(34) = "Unknown statement"
Errors$(35) = "Subprogram not defined"
Errors$(36) = "File already closed"
Errors$(37) = "Argument - count mismatch"
Errors$(38) = "Array not defined"
Errors$(39) = "Too many user - defined functions"
Errors$(40) = "Variable required"
Errors$(41) = "Trace mode is already turned to On"
Errors$(42) = "Cannot run this statement without program is running mode"
Errors$(43) = "Line is not found"
Errors$(44) = "Too many GOSUB's"
Errors$(45) = "Program already running"
Errors$(46) = "Nothing to save"
Errors$(47) = "Trace mode is already turned to Off"
Errors$(48) = "Too many lines in file"
Errors$(49) = "Cannot turn on debug mode if program is running"
Errors$(50) = "FIELD overflow"
Errors$(51) = "Internal error"
Errors$(52) = "Bad file name or number"
Errors$(53) = "File not found"
Errors$(54) = "Bad file mode"
Errors$(55) = "File already open"
Errors$(56) = "FIELD statement active"
Errors$(57) = "Device I/O error"
Errors$(58) = "File already exists"
Errors$(59) = "Bad record length"
Errors$(60) = "Debug mode is already turned to On"
Errors$(61) = "Disk full"
Errors$(62) = "Input past end of file"
Errors$(63) = "Bad record number"
Errors$(64) = "Bad file name"
Errors$(65) = "Nothing to run"
Errors$(66) = "Nothing to debug"
Errors$(67) = "Too many files"
Errors$(68) = "Device unavailable"
Errors$(69) = "Communication-buffer overflow"
Errors$(70) = "Permission denied"
Errors$(71) = "Disk not ready"
Errors$(72) = "Disk - media error"
Errors$(73) = "Feature unavailable"
Errors$(74) = "Rename across disks"
Errors$(75) = "Path/File access error"
Errors$(76) = "Path not found"
Errors$(77) = "Cannot trace not turned to debug mode program"
Errors$(78) = "Debug mode is already turned to Off"
Errors$(79) = "Invalid line numbers range"
Errors$(80) = "Cannot end not runned program"
Errors$(81) = "Too many WHILE's"
Errors$(82) = "EXIT WHILE without WHILE"
Errors$(83) = "Too many FROM's"
Errors$(84) = "EXIT FROM without FROM"
Errors$(85) = "SUB without END SUB"
Errors$(86) = "IF without END IF"
Errors$(87) = "SELECT CASE without END SELECT"
Errors$(88) = "Too many SUB's"
Errors$(89) = "Too many arguments for subroutine"
Errors$(90) = "EXIT SUB without SUB"
Errors$(91) = "SUBRESULT without SUB"
Errors$(92) = "Year must be in range from 1980 up to 2099"
Errors$(93) = "Month must be in range from 1 up to 12"
Errors$(94) = "Day must be in range from 1 up to maximal count of days in given month and given year"
Errors$(95) = "Invalid line"
SCREEN 0, 1, 0, 0
CALL ScratchScreen
CALL OutText
DO
 WorkKey$ = ""
 WHILE WorkKey$ = ""
  IF OldSecond% <> VAL(MID$(TIME$, 7, 2)) THEN
   OldSecond% = VAL(MID$(TIME$, 7, 2))
   StatusText$ = CurrentDateTime$
   CALL OutText
  END IF
  WorkKey$ = INKEY$
 WEND
 SELECT CASE LEN(WorkKey$)
 CASE 1
   SELECT CASE WorkKey$
   CASE CHR$(8)
     CALL DeleteBackSymbol
   CASE CHR$(13)
     CALL EnterLine
   CASE CHR$(27)
     StatusText$ = "Main menu."
     CALL OutText
     MenuItems$(1) = "Save text."
     MenuItems$(2) = "Save text with other name."
     MenuItems$(3) = "Load text."
     MenuItems$(4) = "Merge in text."
     MenuItems$(5) = "Change printer name (" + PrinterName$ + ".)."
     MenuItems$(6) = "Change count of lines per page (" + LTRIM$(STR$(LinesPerPage%)) + ".)."
     MenuItems$(7) = "Print text."
     MenuItems$(8) = "Find line."
     MenuItems$(9) = "Replace line."
     MenuItems$(10) = "Replace all occurences."
     MenuItems$(11) = "Insert calendar."
     MenuItems$(12) = "Insert current date and time."
     MenuItems$(13) = "Parse program text."
     MenuItems$(14) = "Run program."
     MenuItems$(15) = "Run current line."
     MenuItems$(16) = "Calculate expression in current line."
     MenuItems$(17) = "New."
     MenuItems$(18) = "Out help."
     MenuItems$(19) = "Quit."
     SELECT CASE MenuBox%(19)
     CASE 1
       StatusText$ = "Save text."
       CALL ScratchScreen
       CALL OutText
       ON ERROR GOTO CannotOpenFileForSave
       OPEN TextName$ FOR OUTPUT AS #1
       ON ERROR GOTO 0
       FOR Index% = TextLines% TO 1 STEP -1
        IF Text$(Index%) <> "" THEN EXIT FOR
       NEXT Index%
       FOR Index% = 1 TO Index%
        ON ERROR GOTO CannotWriteToFileForSave
        PRINT #1, Text$(Index%)
        ON ERROR GOTO 0
       NEXT Index%
       CLOSE #1
     CASE 2
       StatusText$ = "Save text as other name."
       CALL ScratchScreen
       CALL OutText
       WorkLine$ = ""
       IF InputBox%("GNUTextBasic.", "Please enter new file name.", WorkLine$) THEN
        CALL ScratchScreen
        CALL OutText
        WorkLine$ = UCASE$(LEFT$(LTRIM$(RTRIM$(WorkLine$)), 1)) + LCASE$(MID$(LTRIM$(RTRIM$(WorkLine$)), 2))
        IF (WorkLine$ = "") OR (LEN(WorkLine$) > 12) OR (INSTR(WorkLine$, ":") > 0) OR (INSTR(WorkLine$, "/") > 0) OR (INSTR(WorkLine$, "\") > 0) OR (INSTR(WorkLine$, "?") > 0) OR (INSTR(WorkLine$, "*") > 0) THEN
         CALL OutBox("GNUTextBasic.", "You input the invalid file name.")
        ELSE
         ON ERROR GOTO CannotOpenFileForSaveAs
         OPEN WorkLine$ FOR OUTPUT AS #1
         ON ERROR GOTO 0
         FOR Index% = TextLines% TO 1 STEP -1
          IF Text$(Index%) <> "" THEN EXIT FOR
         NEXT Index%
         FOR Index% = 1 TO Index%
          ON ERROR GOTO CannotWriteToFileForSaveAs
          PRINT #1, Text$(Index%)
          ON ERROR GOTO 0
         NEXT Index%
         CLOSE #1
         TextName$ = WorkLine$
        END IF
       END IF
     CASE 3
       StatusText$ = "Load text."
       CALL ScratchScreen
       CALL OutText
       WorkLine$ = ""
       IF InputBox%("GNUTextBasic.", "Please enter text exist file name for load.", WorkLine$) THEN
        CALL ScratchScreen
        CALL OutText
        WorkLine$ = UCASE$(LEFT$(LTRIM$(RTRIM$(WorkLine$)), 1)) + LCASE$(MID$(LTRIM$(RTRIM$(WorkLine$)), 2))
        IF (WorkLine$ = "") OR (LEN(WorkLine$) > 12) OR (INSTR(WorkLine$, ":") > 0) OR (INSTR(WorkLine$, "/") > 0) OR (INSTR(WorkLine$, "\") > 0) OR (INSTR(WorkLine$, "?") > 0) OR (INSTR(WorkLine$, "*") > 0) THEN
         CALL OutBox("GNUTextBasic.", "You input the invalid file name.")
        ELSE
         IF MessageBox%("GNUTextBasic.", "Save current text before load new?") THEN
          StatusText$ = "Save text."
          CALL ScratchScreen
          CALL OutText
          ON ERROR GOTO CannotOpenFileForSave
          OPEN TextName$ FOR OUTPUT AS #1
          ON ERROR GOTO 0
          FOR Index% = TextLines% TO 1 STEP -1
           IF Text$(Index%) <> "" THEN EXIT FOR
          NEXT Index%
          FOR Index% = 1 TO Index%
           ON ERROR GOTO CannotWriteToFileForSave
           PRINT #1, Text$(Index%)
           ON ERROR GOTO 0
          NEXT Index%
          CLOSE #1
         END IF
         StatusText$ = "Load text."
         CALL ScratchScreen
         CALL OutText
         FOR Index% = 1 TO TextLines%
          Text$(Index%) = ""
         NEXT Index%
         TextColumn% = 1
         TextRow% = 1
         TextPosition% = 1
         LinePosition% = 1
         ON ERROR GOTO CannotOpenFileForLoad
         OPEN WorkLine$ FOR INPUT AS #1
         ON ERROR GOTO 0
         Index% = 1
         DO WHILE NOT EOF(1)
          ON ERROR GOTO CannotReadFromFileForLoad
          LINE INPUT #1, Work$
          ON ERROR GOTO 0
          Work$ = LEFT$(Work$, 256)
          FOR WorkIndex% = 0 TO 31
           WHILE INSTR(Work$, CHR$(WorkIndex%)) > 0
            Work$ = MID$(Work$, 1, INSTR(Work$, CHR$(WorkIndex%)) - 1) + SPACE$(1) + MID$(Work$, INSTR(Work$, CHR$(WorkIndex%)) + 1)
           WEND
          NEXT WorkIndex%
          Text$(Index%) = Work$
          Index% = Index% + 1
          IF Index% = TextLines% + 1 THEN
           CALL OutBox("GNUTextBasic.", "Input file is too lagre. Loaded first " + LTRIM$(STR$(TextLines%)) + " lines.")
           EXIT DO
          END IF
         LOOP
         CLOSE #1
         TextName$ = WorkLine$
        END IF
       END IF
     CASE 4
       StatusText$ = "Merge in text."
       CALL ScratchScreen
       CALL OutText
       IF (TextRow% + 1) > TextLines% - 1 THEN
        CALL OutBox("GNUTextBasic.", "Nothing room to merge in.")
       ELSE
        WorkLine$ = ""
        IF InputBox%("GNUTextBasic.", "Please enter text exist file name for merge in.", WorkLine$) THEN
         CALL ScratchScreen
         CALL OutText
         WorkLine$ = UCASE$(LEFT$(LTRIM$(RTRIM$(WorkLine$)), 1)) + LCASE$(MID$(LTRIM$(RTRIM$(WorkLine$)), 2))
         IF (WorkLine$ = "") OR (LEN(WorkLine$) > 12) OR (INSTR(WorkLine$, ":") > 0) OR (INSTR(WorkLine$, "/") > 0) OR (INSTR(WorkLine$, "\") > 0) OR (INSTR(WorkLine$, "?") > 0) OR (INSTR(WorkLine$, "*") > 0) THEN
          CALL OutBox("GNUTextBasic.", "You input the invalid file name.")
         ELSE
          IF MessageBox%("GNUTextBasic.", "Save current text before merging?") THEN
           StatusText$ = "Save text."
           CALL ScratchScreen
           CALL OutText
           ON ERROR GOTO CannotOpenFileForSave
           OPEN TextName$ FOR OUTPUT AS #1
           ON ERROR GOTO 0
           FOR Index% = TextLines% TO 1 STEP -1
            IF Text$(Index%) <> "" THEN EXIT FOR
           NEXT Index%
           FOR Index% = 1 TO Index%
            ON ERROR GOTO CannotWriteToFileForSave
            PRINT #1, Text$(Index%)
            ON ERROR GOTO 0
           NEXT Index%
           CLOSE #1
          END IF
          StatusText$ = "Merge in text."
          CALL ScratchScreen
          CALL OutText
          FOR Index% = TextRow% + 1 TO TextLines%
           Text$(Index%) = ""
          NEXT Index%
          ON ERROR GOTO CannotOpenFileForMerge
          OPEN WorkLine$ FOR INPUT AS #1
          ON ERROR GOTO 0
          Index% = TextRow% + 1
          DO WHILE NOT EOF(1)
           ON ERROR GOTO CannotReadFromFileForMerge
           LINE INPUT #1, Work$
           ON ERROR GOTO 0
           Work$ = LEFT$(Work$, 256)
           FOR WorkIndex% = 0 TO 31
            WHILE INSTR(Work$, CHR$(WorkIndex%)) > 0
             Work$ = MID$(Work$, 1, INSTR(Work$, CHR$(WorkIndex%)) - 1) + SPACE$(1) + MID$(Work$, INSTR(Work$, CHR$(WorkIndex%)) + 1)
            WEND
           NEXT WorkIndex%
           Text$(Index%) = Work$
           Index% = Index% + 1
           IF Index% = TextLines% + 1 THEN EXIT DO
          LOOP
          CLOSE #1
         END IF
        END IF
       END IF
     CASE 5
       StatusText$ = "Changing printer name."
       CALL ScratchScreen
       CALL OutText
       WorkLine$ = ""
       IF InputBox%("GNUTextBasic.", "Please enter new printer name.", WorkLine$) THEN
        CALL ScratchScreen
        CALL OutText
        WorkLine$ = UCASE$(LEFT$(LTRIM$(RTRIM$(WorkLine$)), 1)) + LCASE$(MID$(LTRIM$(RTRIM$(WorkLine$)), 2))
        IF (WorkLine$ = "") OR (LEN(WorkLine$) > 12) OR (INSTR(WorkLine$, ":") > 0) OR (INSTR(WorkLine$, "/") > 0) OR (INSTR(WorkLine$, "\") > 0) OR (INSTR(WorkLine$, "?") > 0) OR (INSTR(WorkLine$, "*") > 0) THEN
         CALL OutBox("GNUTextBasic.", "You input the invalid printer name.")
        ELSE
         PrinterName$ = WorkLine$
        END IF
       END IF
     CASE 6
       StatusText$ = "Changing count of lines per page."
       CALL ScratchScreen
       CALL OutText
       WorkLine$ = ""
       IF InputBox%("GNUTextBasic.", "Please enter new count of lines per page (from 1 to 256.).", WorkLine$) THEN
        CALL ScratchScreen
        CALL OutText
        WorkLine$ = LTRIM$(RTRIM$(WorkLine$))
        IF (VAL(WorkLine$) < 1) OR (VAL(WorkLine$) > 256) THEN
         CALL OutBox("GNUTextBasic.", "You input the invalid count of lines per page.")
        ELSE
         LinesPerPage% = VAL(WorkLine$)
        END IF
       END IF
     CASE 7
       StatusText$ = "Print text."
       CALL ScratchScreen
       CALL OutText
       ON ERROR GOTO CannotOpenPrinter
       OPEN PrinterName$ FOR OUTPUT AS #1
       ON ERROR GOTO 0
       FOR Index% = TextLines% TO 1 STEP -1
        IF Text$(Index%) <> "" THEN EXIT FOR
       NEXT Index%
       WorkIndex% = 0
       FOR Index% = 1 TO Index%
        ON ERROR GOTO CannotWriteToPrinter
        PRINT #1, Text$(Index%)
        ON ERROR GOTO 0
        WorkIndex% = WorkIndex% + 1
        IF WorkIndex% = LinesPerPage% THEN
         ON ERROR GOTO CannotWriteToPrinter
         PRINT #1, CHR$(12)
         ON ERROR GOTO 0
         CALL OutBox("GNUTextBasic.", "Please insert new paper on printer.")
         CALL ScratchScreen
         CALL OutText
         WorkIndex% = 0
        END IF
       NEXT Index%
       ON ERROR GOTO CannotWriteToPrinter
       PRINT #1, CHR$(26);
       ON ERROR GOTO 0
       CLOSE #1
     CASE 8
       StatusText$ = "Find text."
       CALL ScratchScreen
       CALL OutText
       WorkLine$ = ""
       IF InputBox%("GNUTextBasic.", "Please enter text to find.", WorkLine$) THEN
        CALL ScratchScreen
        CALL OutText
        FOR Index% = TextRow% TO TextLines% + 1
         IF Index% = TextLines% + 1 THEN
          CALL OutBox("GNUTextBasic.", "Text is not found.")
          EXIT FOR
         END IF
         IF INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$)) > 0 THEN EXIT FOR
        NEXT Index%
        IF Index% < TextLines% + 1 THEN
         TextRow% = Index%
         TextPosition% = TextRow%
         TextColumn% = INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$))
         LinePosition% = TextColumn%
         CALL ControlCoordinates
        END IF
       END IF
     CASE 9
       StatusText$ = "Replace text."
       CALL ScratchScreen
       CALL OutText
       WorkLine$ = ""
       IF InputBox%("GNUTextBasic.", "Please enter text to find.", WorkLine$) THEN
        CALL ScratchScreen
        CALL OutText
        Work$ = ""
        IF InputBox%("GNUTextBasic.", "Please enter text to replace it.", Work$) THEN
         CALL ScratchScreen
         CALL OutText
         FOR Index% = TextRow% TO TextLines% + 1
          IF Index% = TextLines% + 1 THEN
           CALL OutBox("GNUTextBasic.", "Replacing is end.")
           EXIT FOR
          END IF
          WorkIndex% = 1
          WHILE INSTR(UCASE$(MID$(Text$(Index%), WorkIndex%)), UCASE$(WorkLine$)) > 0
           TextRow% = Index%
           TextPosition% = TextRow%
           TextColumn% = INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$))
           LinePosition% = TextColumn%
           CALL ControlCoordinates
           WorkIndex% = TextColumn%
           IF MessageBox%("GNUTextBasic.", "Replace this occurence?") THEN
            Text$(Index%) = LEFT$(MID$(Text$(Index%), 1, INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$)) - 1) + Work$ + MID$(Text$(Index%), (INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$)) + LEN(WorkLine$))), 256)
           ELSE
            EXIT FOR
           END IF
           CALL ScratchScreen
           CALL OutText
          WEND
         NEXT Index%
        END IF
       END IF
     CASE 10
       StatusText$ = "Replace all occurences."
       CALL ScratchScreen
       CALL OutText
       WorkLine$ = ""
       IF InputBox%("GNUTextBasic.", "Please enter text to find.", WorkLine$) THEN
        CALL ScratchScreen
        CALL OutText
        Work$ = ""
        IF InputBox%("GNUTextBasic.", "Please enter text to replace it.", Work$) THEN
         CALL ScratchScreen
         CALL OutText
         FOR Index% = TextRow% TO TextLines% + 1
          IF Index% = TextLines% + 1 THEN
           CALL OutBox("GNUTextBasic.", "Replacing is end.")
           EXIT FOR
          END IF
          WHILE INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$)) > 0
           Text$(Index%) = LEFT$(MID$(Text$(Index%), 1, INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$)) - 1) + Work$ + MID$(Text$(Index%), (INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$)) + LEN(WorkLine$))), 256)
          WEND
         NEXT Index%
        END IF
       END IF
     CASE 11
       StatusText$ = "Insert calendar."
       CALL ScratchScreen
       CALL OutText
       IF TextRow% > TextLines% - 8 THEN
        CALL OutBox("GNUTextBasic.", "Current line number is too large for insert calendar. Before insert calendar, current row must be less than " + LTRIM$(STR$(TextLines% - 7)) + ".")
       ELSE
        WorkDay% = VAL(MID$(DATE$, 4, 2))
        WorkMonth% = VAL(MID$(DATE$, 1, 2))
        WorkYear% = VAL(MID$(DATE$, 7, 4))
        IF CalendarBox%("GNUTextBasic.", "Please select date for including calendar.", WorkDay%, WorkMonth%, WorkYear%) THEN
         Text$(TextRow%) = LEFT$(MID$(Text$(TextRow%), 1, TextColumn% - 1) + MonthName$(WorkMonth%) + ", " + LTRIM$(STR$(WorkYear%)) + " year." + SPACE$(21 - LEN(MonthName$(WorkMonth%) + ", " + LTRIM$(STR$(WorkYear%)) + " year.")) + MID$(Text$(TextRow%), TextColumn%), 256)
         Text$(TextRow% + 1) = LEFT$(MID$(Text$(TextRow% + 1), 1, TextColumn% - 1) + " Mo Tu We Th Fr Sa Su" + MID$(Text$(TextRow% + 1), TextColumn%), 256)
         FOR OutIndex% = 1 TO 37
          Days%(OutIndex%) = 0
         NEXT OutIndex%
         Value% = 1
         FOR OutIndex% = DayOfWeek%(1, WorkMonth%, WorkYear%) TO 37
          Days%(OutIndex%) = Value%
          Value% = Value% + 1
          IF Value% = MonthDays%(WorkMonth%, WorkYear%) + 1 THEN EXIT FOR
         NEXT OutIndex%
         WorkLine$ = ""
         WorkIndex% = 2
         FOR OutIndex% = 1 TO 37
          IF Days%(OutIndex%) > 0 THEN
           IF Days%(OutIndex%) = WorkDay% THEN
            WorkLine$ = WorkLine$ + "*" + SPACE$(2 - LEN(LTRIM$(STR$(Days%(OutIndex%))))) + LTRIM$(STR$(Days%(OutIndex%)))
           ELSE
            WorkLine$ = WorkLine$ + SPACE$(3 - LEN(LTRIM$(STR$(Days%(OutIndex%))))) + LTRIM$(STR$(Days%(OutIndex%)))
           END IF
          ELSE
           WorkLine$ = WorkLine$ + SPACE$(3)
          END IF
          IF LEN(WorkLine$) = 21 THEN
           IF LEN(Text$(TextRow% + WorkIndex%)) < TextColumn% - 1 THEN Text$(TextRow% + WorkIndex%) = SPACE$(TextColumn% - 1)
           Text$(TextRow% + WorkIndex%) = LEFT$(MID$(Text$(TextRow% + WorkIndex%), 1, TextColumn% - 1) + WorkLine$ + MID$(Text$(TextRow% + WorkIndex%), TextColumn%), 256)
           WorkLine$ = ""
           WorkIndex% = WorkIndex% + 1
          END IF
         NEXT OutIndex%
         IF WorkLine$ <> "" THEN
          IF LEN(Text$(TextRow% + WorkIndex%)) < TextColumn% - 1 THEN Text$(TextRow% + WorkIndex%) = SPACE$(TextColumn% - 1)
          Text$(TextRow% + WorkIndex%) = LEFT$(MID$(Text$(TextRow% + WorkIndex%), 1, TextColumn% - 1) + WorkLine$ + SPACE$(21 - LEN(WorkLine$)) + MID$(Text$(TextRow% + WorkIndex%), TextColumn%), 256)
          WorkLine$ = ""
         END IF
        END IF
       END IF
     CASE 12
       Text$(TextRow%) = LEFT$(MID$(Text$(TextRow%), 1, TextColumn% - 1) + CurrentDateTime$ + MID$(Text$(TextRow%), TextColumn%), 256)
     CASE 13
       StatusText$ = "Parsing program text..."
       CALL ScratchScreen
       CALL OutText
       ON ERROR GOTO CannotParseText
       FOR Index% = 1 TO TextLines%
        IF LTRIM$(RTRIM$(Text$(Index%))) <> "" THEN
         WorkLine$ = LTRIM$(RTRIM$(Text$(Index%)))
         SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
         CASE "0" TO "9"
           LineNumber% = INT(InNumber#(WorkLine$))
           IF (LineNumber% < 1) OR (LineNumber% > TextLines%) THEN ERROR 15
           WorkLine$ = LTRIM$(WorkLine$)
           SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
           CASE "A" TO "Z"
             Text$(Index%) = STRING$(LEN(LTRIM$(STR$(TextLines%))) - LEN(LTRIM$(STR$(LineNumber%))), "0") + LTRIM$(STR$(LineNumber%)) + SPACE$(1) + ParseRunLine$(WorkLine$)
           CASE ELSE
             ERROR 95
           END SELECT
         CASE "A" TO "Z"
           Text$(Index%) = ParseRunLine$(WorkLine$)
         CASE ELSE
           ERROR 95
         END SELECT
        END IF
       NEXT Index%
       ON ERROR GOTO 0
     CASE 14
       StatusText$ = "Running program..."
       COLOR 7, 0
       CLS
       LOCATE 1, 1, 1, 7, 8
       CALL ClearAll
       CALL ClearANSI
       RunMode% = True%
       CurrentLine% = 1
       ON ERROR GOTO CannotRunProgramText
       DO
        IF LTRIM$(RTRIM$(Text$(CurrentLine%))) <> "" THEN
         WorkLine$ = LTRIM$(RTRIM$(Text$(CurrentLine%)))
         SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
         CASE "0" TO "9"
           LineNumber% = INT(InNumber#(WorkLine$))
           IF (LineNumber% < 1) OR (LineNumber% > TextLines%) THEN ERROR 15
           WorkLine$ = LTRIM$(WorkLine$)
           SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
           CASE "A" TO "Z"
             IF TraceMode% THEN PRINT "[" + LTRIM$(STR$(LineNumber%)) + "]";
             WorkLine$ = ParseRunLine$(WorkLine$)
             CALL RunLine(WorkLine$)
           CASE ELSE
             ERROR 95
           END SELECT
         CASE "A" TO "Z"
           WorkLine$ = ParseRunLine$(WorkLine$)
           CALL RunLine(WorkLine$)
         CASE ELSE
           ERROR 95
         END SELECT
        END IF
        CurrentLine% = CurrentLine% + 1
       LOOP UNTIL (CurrentLine% > TextLines%) OR (NOT RunMode%)
       ON ERROR GOTO 0
       CALL ClearAll
       CALL ClearANSI
       WHILE INKEY$ <> CHR$(13)
       WEND
     CASE 15
       StatusText$ = "Running current line..."
       COLOR 7, 0
       CLS
       LOCATE 1, 1, 1, 7, 8
       CALL ClearAll
       CALL ClearANSI
       ON ERROR GOTO CannotRunProgramTextLine
       IF LTRIM$(RTRIM$(Text$(TextRow%))) <> "" THEN
        WorkLine$ = LTRIM$(RTRIM$(Text$(TextRow%)))
        SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
        CASE "0" TO "9"
          LineNumber% = INT(InNumber#(WorkLine$))
          IF (LineNumber% < 1) OR (LineNumber% > TextLines%) THEN ERROR 15
          WorkLine$ = LTRIM$(WorkLine$)
          SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
          CASE "A" TO "Z"
            WorkLine$ = ParseRunLine$(WorkLine$)
            CALL RunLine(WorkLine$)
          CASE ELSE
            ERROR 95
          END SELECT
        CASE "A" TO "Z"
          WorkLine$ = ParseRunLine$(WorkLine$)
          CALL RunLine(WorkLine$)
        CASE ELSE
          ERROR 95
        END SELECT
       END IF
       ON ERROR GOTO 0
       CALL ClearAll
       CALL ClearANSI
       WHILE INKEY$ <> CHR$(13)
       WEND
     CASE 16
       StatusText$ = "Calculating expression..."
       CALL ScratchScreen
       CALL OutText
       ON ERROR GOTO CannotCalculateExpression
       IF LTRIM$(RTRIM$(Text$(TextRow%))) <> "" THEN
        WorkLine$ = LTRIM$(RTRIM$(Text$(TextRow%)))
        WorkLine$ = ParseCalculateExpression$(WorkLine$)
        Work$ = WorkLine$
        Work$ = CalculateExpression$(Work$)
        Text$(TextRow%) = WorkLine$ + "=" + Work$
       END IF
       ON ERROR GOTO 0
     CASE 17
       StatusText$ = "New."
       CALL ScratchScreen
       CALL OutText
       IF MessageBox%("GNUTextBasic.", "Save text before clear text?") THEN
        StatusText$ = "Save text."
        CALL ScratchScreen
        CALL OutText
        ON ERROR GOTO CannotOpenFileForSave
        OPEN TextName$ FOR OUTPUT AS #1
        ON ERROR GOTO 0
        FOR Index% = TextLines% TO 1 STEP -1
         IF Text$(Index%) <> "" THEN EXIT FOR
        NEXT Index%
        FOR Index% = 1 TO Index%
         ON ERROR GOTO CannotWriteToFileForSave
         PRINT #1, Text$(Index%)
         ON ERROR GOTO 0
        NEXT Index%
        CLOSE #1
       END IF
       FOR Index% = 1 TO TextLines%
        Text$(Index%) = ""
       NEXT Index%
       TextColumn% = 1
       TextRow% = 1
       TextPosition% = 1
       LinePosition% = 1
     CASE 18
       StatusText$ = "Out help."
       CALL ScratchScreen
       CALL OutText
       CALL OutHelp
     CASE 19
       StatusText$ = "Quit."
       CALL ScratchScreen
       CALL OutText
       IF MessageBox%("GNUTextBasic.", "Save text before quit?") THEN
        StatusText$ = "Save text."
        CALL ScratchScreen
        CALL OutText
        ON ERROR GOTO CannotOpenFileForSave
        OPEN TextName$ FOR OUTPUT AS #1
        ON ERROR GOTO 0
        FOR Index% = TextLines% TO 1 STEP -1
         IF Text$(Index%) <> "" THEN EXIT FOR
        NEXT Index%
        FOR Index% = 1 TO Index%
         ON ERROR GOTO CannotWriteToFileForSave
         PRINT #1, Text$(Index%)
         ON ERROR GOTO 0
        NEXT Index%
        CLOSE #1
       END IF
       EXIT DO
     END SELECT
     StatusText$ = CurrentDateTime$
     CALL ScratchScreen
     CALL OutText
   CASE ELSE
     IF ASC(WorkKey$) > (ASC(SPACE$(1)) - 1) THEN
      IF TextColumn% = 257 THEN
       IF TextRow% < TextLines% THEN
        TextRow% = TextRow% + 1
        TextPosition% = TextPosition% + 1
        TextColumn% = 1
        LinePosition% = 1
        Text$(TextRow%) = MID$(Text$(TextRow%), 1, TextColumn% - 1) + WorkKey$ + MID$(Text$(TextRow%), TextColumn%)
        CALL OutText
       END IF
      ELSE
       Text$(TextRow%) = MID$(Text$(TextRow%), 1, TextColumn% - 1) + WorkKey$ + MID$(Text$(TextRow%), TextColumn%)
       CALL CursorRight
      END IF
     END IF
   END SELECT
 CASE 2
   WorkKey$ = MID$(WorkKey$, 2)
   SELECT CASE WorkKey$
   CASE CHR$(72)
     CALL CursorUp
   CASE CHR$(80)
     CALL CursorDown
   CASE CHR$(73)
     CALL PageUp
   CASE CHR$(81)
     CALL PageDown
   CASE CHR$(71)
     CALL CursorHome
   CASE CHR$(79)
     CALL CursorEnd
   CASE CHR$(75)
     CALL CursorLeft
   CASE CHR$(77)
     CALL CursorRight
   CASE CHR$(83)
     CALL DeleteSymbol
   END SELECT
 END SELECT
TextWork:
LOOP
COLOR 7, 0
CLS
LOCATE 1, 1, 1, 7, 8
END
CannotOpenFileForSave:
 IF MessageBox%("GNUTextBasic.", "Cannot open file for save. Retry opening?") THEN
  CALL ScratchScreen
  CALL OutText
  RESUME
 ELSE
  StatusText$ = CurrentDateTime$
  CALL ScratchScreen
  CALL OutText
  RESUME TextWork
 END IF
CannotWriteToFileForSave:
 IF MessageBox%("GNUTextBasic.", "Cannot write to file for save. Retry writing?") THEN
  CALL ScratchScreen
  CALL OutText
  RESUME
 ELSE
  CLOSE #1
  KILL TextName$
  StatusText$ = CurrentDateTime$
  CALL ScratchScreen
  CALL OutText
  RESUME TextWork
 END IF
CannotOpenFileForSaveAs:
 IF MessageBox%("GNUTextBasic.", "Cannot open file for save as other name. Retry opening?") THEN
  CALL ScratchScreen
  CALL OutText
  RESUME
 ELSE
  StatusText$ = CurrentDateTime$
  CALL ScratchScreen
  CALL OutText
  RESUME TextWork
 END IF
CannotWriteToFileForSaveAs:
 IF MessageBox%("GNUTextBasic.", "Cannot write to file for save as other name. Retry writing?") THEN
  CALL ScratchScreen
  CALL OutText
  RESUME
 ELSE
  CLOSE #1
  KILL WorkLine$
  StatusText$ = CurrentDateTime$
  CALL ScratchScreen
  CALL OutText
  RESUME TextWork
 END IF
CannotOpenFileForLoad:
 IF MessageBox%("GNUTextBasic.", "Cannot open file for load. Retry opening?") THEN
  CALL ScratchScreen
  CALL OutText
  RESUME
 ELSE
  StatusText$ = CurrentDateTime$
  CALL ScratchScreen
  CALL OutText
  RESUME TextWork
 END IF
CannotReadFromFileForLoad:
 IF MessageBox%("GNUTextBasic.", "Cannot read from file for load. Retry reading?") THEN
  CALL ScratchScreen
  CALL OutText
  RESUME
 ELSE
  CLOSE #1
  StatusText$ = CurrentDateTime$
  CALL ScratchScreen
  CALL OutText
  RESUME TextWork
 END IF
CannotOpenFileForMerge:
 IF MessageBox%("GNUTextBasic.", "Cannot open file for merge in text. Retry opening?") THEN
  CALL ScratchScreen
  CALL OutText
  RESUME
 ELSE
  StatusText$ = CurrentDateTime$
  CALL ScratchScreen
  CALL OutText
  RESUME TextWork
 END IF
CannotReadFromFileForMerge:
 IF MessageBox%("GNUTextBasic.", "Cannot read from file for merge in text. Retry reading?") THEN
  CALL ScratchScreen
  CALL OutText
  RESUME
 ELSE
  CLOSE #1
  StatusText$ = CurrentDateTime$
  CALL ScratchScreen
  CALL OutText
  RESUME TextWork
 END IF
CannotOpenPrinter:
 IF MessageBox%("GNUTextBasic.", "Cannot open printer. Retry opening?") THEN
  CALL ScratchScreen
  CALL OutText
  RESUME
 ELSE
  StatusText$ = CurrentDateTime$
  CALL ScratchScreen
  CALL OutText
  RESUME TextWork
 END IF
CannotWriteToPrinter:
 IF MessageBox%("GNUTextBasic.", "Cannot write to printer. Retry writing?") THEN
  CALL ScratchScreen
  CALL OutText
  RESUME
 ELSE
  CLOSE #1
  StatusText$ = CurrentDateTime$
  CALL ScratchScreen
  CALL OutText
  RESUME TextWork
 END IF
CannotParseText:
 CALL OutBox("GNUTextBasic.", "Error in parsing text: " + Errors$(ERR) + ".")
 CALL ClearAll
 TextColumn% = 1
 LinePosition% = 1
 TextRow% = Index%
 TextPosition% = Index%
 StatusText$ = CurrentDateTime$
 CALL ScratchScreen
 CALL OutText
 RESUME TextWork
CannotRunProgramText:
 CALL ScratchScreen
 CALL OutText
 CALL OutBox("GNUTextBasic.", "Error in running text: " + Errors$(ERR) + ".")
 TextColumn% = 1
 LinePosition% = 1
 TextRow% = CurrentLine%
 TextPosition% = CurrentLine%
 CALL ClearAll
 CALL ClearANSI
 StatusText$ = CurrentDateTime$
 CALL ScratchScreen
 CALL OutText
 RESUME TextWork
CannotRunProgramTextLine:
 CALL ScratchScreen
 CALL OutText
 CALL OutBox("GNUTextBasic.", "Error in running text line: " + Errors$(ERR) + ".")
 TextColumn% = 1
 LinePosition% = 1
 CALL ClearAll
 CALL ClearANSI
 StatusText$ = CurrentDateTime$
 CALL ScratchScreen
 CALL OutText
 RESUME TextWork
CannotCalculateExpression:
 CALL ScratchScreen
 CALL OutText
 CALL OutBox("GNUTextBasic.", "Error in calculate expression: " + Errors$(ERR) + ".")
 TextColumn% = 1
 LinePosition% = 1
 CALL ClearAll
 StatusText$ = CurrentDateTime$
 CALL ScratchScreen
 CALL OutText
 RESUME TextWork

SUB ANSIOut (ANSISymbol$)
 DIM CurrentRow%
 DIM CurrentColumn%
 DIM Index%
 SELECT CASE ANSIMode%
 CASE 0
   SELECT CASE ANSISymbol$
   CASE CHR$(10)
     PRINT
   CASE CHR$(27)
     ANSIMode% = 1
   CASE ELSE
     IF ANSISymbol$ <> "" THEN IF ASC(ANSISymbol$) > (ASC(SPACE$(1)) - 1) THEN PRINT ANSISymbol$;
   END SELECT
 CASE 1
   SELECT CASE ANSISymbol$
   CASE "["
     ANSIMode% = 2
   CASE ELSE
     CALL ClearANSI
     CALL ANSIOut(ANSISymbol$)
   END SELECT
 CASE 2
   SELECT CASE ANSISymbol$
   CASE "H"
     SELECT CASE ParametersCount%
     CASE 0
       LOCATE 1, 1, 1, 7, 8
     CASE 1
       IF Parameters%(1) < 1 THEN Parameters%(1) = 1
       IF Parameters%(1) > 25 THEN Parameters%(1) = 25
       LOCATE Parameters%(1), 1, 1, 7, 8
     CASE ELSE
       IF Parameters%(1) < 1 THEN Parameters%(1) = 1
       IF Parameters%(1) > 25 THEN Parameters%(1) = 25
       IF Parameters%(2) < 1 THEN Parameters%(2) = 1
       IF Parameters%(2) > 80 THEN Parameters%(2) = 80
       LOCATE Parameters%(1), Parameters%(2), 1, 7, 8
     END SELECT
     CALL ClearANSI
   CASE "f"
     SELECT CASE ParametersCount%
     CASE 0
       LOCATE 1, 1, 1, 7, 8
     CASE 1
       IF Parameters%(1) < 1 THEN Parameters%(1) = 1
       IF Parameters%(1) > 25 THEN Parameters%(1) = 25
       LOCATE Parameters%(1), 1, 1, 7, 8
     CASE ELSE
       IF Parameters%(1) < 1 THEN Parameters%(1) = 1
       IF Parameters%(1) > 25 THEN Parameters%(1) = 25
       IF Parameters%(2) < 1 THEN Parameters%(2) = 1
       IF Parameters%(2) > 80 THEN Parameters%(2) = 80
       LOCATE Parameters%(1), Parameters%(2), 1, 7, 8
     END SELECT
     CALL ClearANSI
   CASE "A"
     IF Parameters%(1) < 1 THEN Parameters%(1) = 1
     IF (CSRLIN - Parameters%(1)) > 0 THEN LOCATE CSRLIN - Parameters%(1), POS(0), 1, 7, 8
     CALL ClearANSI
   CASE "B"
     IF Parameters%(1) < 1 THEN Parameters%(1) = 1
     IF (CSRLIN + Parameters%(1)) < 26 THEN LOCATE CSRLIN + Parameters%(1), POS(0), 1, 7, 8
     CALL ClearANSI
   CASE "C"
     IF Parameters%(1) < 1 THEN Parameters%(1) = 1
     IF (POS(0) + Parameters%(1)) < 81 THEN LOCATE CSRLIN, POS(0) + Parameters%(1), 1, 7, 8
     CALL ClearANSI
   CASE "D"
     IF Parameters%(1) < 1 THEN Parameters%(1) = 1
     IF (POS(0) - Parameters%(1)) > 0 THEN LOCATE CSRLIN, POS(0) - Parameters%(1), 1, 7, 8
     CALL ClearANSI
   CASE "s"
     IF NOT CursorSaved% THEN
      CursorSaved% = True%
      CursorRow% = CSRLIN
      CursorColumn% = POS(0)
     END IF
     CALL ClearANSI
   CASE "u"
     IF CursorSaved% THEN
      LOCATE CursorRow%, CursorColumn%, 1, 7, 8
      CursorRow% = 0
      CursorColumn% = 0
      CursorSaved% = False%
     END IF
     CALL ClearANSI
   CASE "J"
     CLS
     CALL ClearANSI
     LOCATE 1, 1, 1, 7, 8
   CASE "K"
     CurrentRow% = CSRLIN
     CurrentColumn% = POS(0)
     PRINT SPACE$(80 - POS(0));
     LOCATE CurrentRow%, CurrentColumn%, 1, 7, 8
     CurrentRow% = 0
     CurrentColumn% = 0
     CALL ClearANSI
   CASE "m"
     IF ParametersCount% > 0 THEN
      FOR Index% = 1 TO ParametersCount%
       SELECT CASE Parameters%(Index%)
       CASE 0
         COLOR 7, 0
       CASE 1
         COLOR 15
       CASE 4
         COLOR 1
       CASE 5
         COLOR 7
       CASE 7
         COLOR 0, 7
       CASE 8
         COLOR 0, 0
       CASE 30
         COLOR 0
       CASE 31
         COLOR 4
       CASE 32
         COLOR 2
       CASE 33
         COLOR 6
       CASE 34
         COLOR 1
       CASE 35
         COLOR 5
       CASE 36
         COLOR 3
       CASE 37
         COLOR 15
       CASE 40
         COLOR , 0
       CASE 41
         COLOR , 4
       CASE 42
         COLOR , 2
       CASE 43
         COLOR , 6
       CASE 44
         COLOR , 1
       CASE 45
         COLOR , 5
       CASE 46
         COLOR , 3
       CASE 47
         COLOR , 7
       END SELECT
      NEXT Index%
     ELSE
      COLOR 7, 0
     END IF
     CALL ClearANSI
   CASE "0" TO "9"
     ANSIMode% = 3
     CALL ANSIOut(ANSISymbol$)
   CASE ";"
     ParametersCount% = 1
   CASE ELSE
     CALL ClearANSI
     CALL ANSIOut(ANSISymbol$)
   END SELECT
 CASE 3
   SELECT CASE ANSISymbol$
   CASE "0" TO "9"
     IF LEN(NumberLine$) < 2 THEN NumberLine$ = NumberLine$ + ANSISymbol$
   CASE ";"
     IF ParametersCount% < ANSIParametersCountValue% THEN
      ParametersCount% = ParametersCount% + 1
      Parameters%(ParametersCount%) = VAL(NumberLine$)
     END IF
     NumberLine$ = ""
   CASE ELSE
     IF ParametersCount% < ANSIParametersCountValue% THEN
      ParametersCount% = ParametersCount% + 1
      Parameters%(ParametersCount%) = VAL(NumberLine$)
     END IF
     ANSIMode% = 2
     CALL ANSIOut(ANSISymbol$)
   END SELECT
 END SELECT
END SUB

FUNCTION Calculate$ (InLine$)
 DIM Result$
 DIM Value$
 DIM WorkNumStr%
 DIM SavedLine$
 Result$ = InMeaning$(InLine$)
 InLine$ = LTRIM$(InLine$)
 DO WHILE InLine$ <> ""
  SELECT CASE LEFT$(UCASE$(InLine$), 1)
  CASE "+"
    InLine$ = MID$(InLine$, 2)
    WorkNumStr% = NumStr%
    Value$ = InMeaning$(InLine$)
    IF NumStr% <> WorkNumStr% THEN ERROR 13
    IF NumStr% THEN Result$ = Result$ + Value$ ELSE Result$ = LTRIM$(STR$(VAL(Result$) + VAL(Value$)))
  CASE "-"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = InMeaning$(InLine$)
    IF NumStr% THEN ERROR 13
    Result$ = LTRIM$(STR$(VAL(Result$) - VAL(Value$)))
  CASE "/"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = InMeaning$(InLine$)
    IF NumStr% THEN ERROR 13
    IF VAL(Value$) = 0# THEN ERROR 11
    Result$ = LTRIM$(STR$(VAL(Result$) / VAL(Value$)))
  CASE "\"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = InMeaning$(InLine$)
    IF NumStr% THEN ERROR 13
    IF VAL(Value$) = 0# THEN ERROR 11
    Result$ = LTRIM$(STR$(VAL(Result$) / VAL(Value$)))
  CASE "*"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = InMeaning$(InLine$)
    IF NumStr% THEN ERROR 13
    Result$ = LTRIM$(STR$(VAL(Result$) * VAL(Value$)))
  CASE "^"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = InMeaning$(InLine$)
    IF NumStr% THEN ERROR 13
    Result$ = LTRIM$(STR$(VAL(Result$) ^ VAL(Value$)))
  CASE "="
    InLine$ = LTRIM$(MID$(InLine$, 2))
    SELECT CASE LEFT$(InLine$, 1)
    CASE "<"
      InLine$ = MID$(InLine$, 2)
      WorkNumStr% = NumStr%
      Value$ = InMeaning$(InLine$)
      IF NumStr% <> WorkNumStr% THEN ERROR 13
      IF NumStr% THEN Result$ = LTRIM$(STR$(Result$ <= Value$)) ELSE Result$ = LTRIM$(STR$(VAL(Result$) <= VAL(Value$)))
    CASE ">"
      InLine$ = MID$(InLine$, 2)
      WorkNumStr% = NumStr%
      Value$ = InMeaning$(InLine$)
      IF NumStr% <> WorkNumStr% THEN ERROR 13
      IF NumStr% THEN Result$ = LTRIM$(STR$(Result$ >= Value$)) ELSE Result$ = LTRIM$(STR$(VAL(Result$) >= VAL(Value$)))
    CASE ELSE
      WorkNumStr% = NumStr%
      Value$ = InMeaning$(InLine$)
      IF NumStr% <> WorkNumStr% THEN ERROR 13
      IF NumStr% THEN Result$ = LTRIM$(STR$(Result$ = Value$)) ELSE Result$ = LTRIM$(STR$(VAL(Result$) = VAL(Value$)))
    END SELECT
    NumStr% = False%
  CASE "<"
    InLine$ = LTRIM$(MID$(InLine$, 2))
    SELECT CASE LEFT$(InLine$, 1)
    CASE ">"
      InLine$ = MID$(InLine$, 2)
      WorkNumStr% = NumStr%
      Value$ = InMeaning$(InLine$)
      IF NumStr% <> WorkNumStr% THEN ERROR 13
      IF NumStr% THEN Result$ = LTRIM$(STR$(Result$ <> Value$)) ELSE Result$ = LTRIM$(STR$(VAL(Result$) <> VAL(Value$)))
    CASE "="
      InLine$ = MID$(InLine$, 2)
      WorkNumStr% = NumStr%
      Value$ = InMeaning$(InLine$)
      IF NumStr% <> WorkNumStr% THEN ERROR 13
      IF NumStr% THEN Result$ = LTRIM$(STR$(Result$ <= Value$)) ELSE Result$ = LTRIM$(STR$(VAL(Result$) <= VAL(Value$)))
    CASE ELSE
      WorkNumStr% = NumStr%
      Value$ = InMeaning$(InLine$)
      IF NumStr% <> WorkNumStr% THEN ERROR 13
      IF NumStr% THEN Result$ = LTRIM$(STR$(Result$ < Value$)) ELSE Result$ = LTRIM$(STR$(VAL(Result$) < VAL(Value$)))
    END SELECT
    NumStr% = False%
  CASE ">"
    InLine$ = LTRIM$(MID$(InLine$, 2))
    SELECT CASE LEFT$(InLine$, 1)
    CASE "<"
      InLine$ = MID$(InLine$, 2)
      WorkNumStr% = NumStr%
      Value$ = InMeaning$(InLine$)
      IF NumStr% <> WorkNumStr% THEN ERROR 13
      IF NumStr% THEN Result$ = LTRIM$(STR$(Result$ <> Value$)) ELSE Result$ = LTRIM$(STR$(VAL(Result$) <> VAL(Value$)))
    CASE "="
      InLine$ = MID$(InLine$, 2)
      WorkNumStr% = NumStr%
      Value$ = InMeaning$(InLine$)
      IF NumStr% <> WorkNumStr% THEN ERROR 13
      IF NumStr% THEN Result$ = LTRIM$(STR$(Result$ >= Value$)) ELSE Result$ = LTRIM$(STR$(VAL(Result$) >= VAL(Value$)))
    CASE ELSE
      WorkNumStr% = NumStr%
      Value$ = InMeaning$(InLine$)
      IF NumStr% <> WorkNumStr% THEN ERROR 13
      IF NumStr% THEN Result$ = LTRIM$(STR$(Result$ > Value$)) ELSE Result$ = LTRIM$(STR$(VAL(Result$) > VAL(Value$)))
    END SELECT
    NumStr% = False%
  CASE "A" TO "Z"
    SavedLine$ = InLine$
    SELECT CASE InName$(InLine$)
    CASE "AND"
      IF NumStr% THEN ERROR 13
      Value$ = InMeaning$(InLine$)
      IF NumStr% THEN ERROR 13
      Result$ = LTRIM$(STR$(VAL(Result$) AND VAL(Value$)))
    CASE "OR"
      IF NumStr% THEN ERROR 13
      Value$ = InMeaning$(InLine$)
      IF NumStr% THEN ERROR 13
      Result$ = LTRIM$(STR$(VAL(Result$) OR VAL(Value$)))
    CASE "XOR"
      IF NumStr% THEN ERROR 13
      Value$ = InMeaning$(InLine$)
      IF NumStr% THEN ERROR 13
      Result$ = LTRIM$(STR$(VAL(Result$) XOR VAL(Value$)))
    CASE "MOD"
      IF NumStr% THEN ERROR 13
      Value$ = InMeaning$(InLine$)
      IF NumStr% THEN ERROR 13
      Result$ = LTRIM$(STR$(VAL(Result$) MOD VAL(Value$)))
    CASE ELSE
      InLine$ = SavedLine$
      EXIT DO
    END SELECT
  CASE ELSE
    EXIT DO
  END SELECT
  InLine$ = LTRIM$(InLine$)
 LOOP
 IF NOT NumStr% THEN IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
 Calculate$ = Result$
END FUNCTION

FUNCTION CalculateExpression$ (InLine$)
 DIM Result$
 DIM Value$
 DIM WorkNumStr%
 DIM SavedLine$
 Result$ = InMeaningOfExpression$(InLine$)
 InLine$ = LTRIM$(InLine$)
 DO WHILE InLine$ <> ""
  SELECT CASE LEFT$(UCASE$(InLine$), 1)
  CASE "+"
    InLine$ = MID$(InLine$, 2)
    WorkNumStr% = NumStr%
    Value$ = InMeaningOfExpression$(InLine$)
    IF NumStr% <> WorkNumStr% THEN ERROR 13
    IF NumStr% THEN Result$ = Result$ + Value$ ELSE Result$ = LTRIM$(STR$(VAL(Result$) + VAL(Value$)))
  CASE "-"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = InMeaningOfExpression$(InLine$)
    IF NumStr% THEN ERROR 13
    Result$ = LTRIM$(STR$(VAL(Result$) - VAL(Value$)))
  CASE "/"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = InMeaningOfExpression$(InLine$)
    IF NumStr% THEN ERROR 13
    IF VAL(Value$) = 0# THEN ERROR 11
    Result$ = LTRIM$(STR$(VAL(Result$) / VAL(Value$)))
  CASE "\"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = InMeaningOfExpression$(InLine$)
    IF NumStr% THEN ERROR 13
    IF VAL(Value$) = 0# THEN ERROR 11
    Result$ = LTRIM$(STR$(VAL(Result$) / VAL(Value$)))
  CASE "*"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = InMeaningOfExpression$(InLine$)
    IF NumStr% THEN ERROR 13
    Result$ = LTRIM$(STR$(VAL(Result$) * VAL(Value$)))
  CASE "^"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = InMeaningOfExpression$(InLine$)
    IF NumStr% THEN ERROR 13
    Result$ = LTRIM$(STR$(VAL(Result$) ^ VAL(Value$)))
  CASE "="
    InLine$ = LTRIM$(MID$(InLine$, 2))
    SELECT CASE LEFT$(InLine$, 1)
    CASE "<"
      InLine$ = MID$(InLine$, 2)
      WorkNumStr% = NumStr%
      Value$ = InMeaningOfExpression$(InLine$)
      IF NumStr% <> WorkNumStr% THEN ERROR 13
      IF NumStr% THEN Result$ = LTRIM$(STR$(Result$ <= Value$)) ELSE Result$ = LTRIM$(STR$(VAL(Result$) <= VAL(Value$)))
    CASE ">"
      InLine$ = MID$(InLine$, 2)
      WorkNumStr% = NumStr%
      Value$ = InMeaningOfExpression$(InLine$)
      IF NumStr% <> WorkNumStr% THEN ERROR 13
      IF NumStr% THEN Result$ = LTRIM$(STR$(Result$ >= Value$)) ELSE Result$ = LTRIM$(STR$(VAL(Result$) >= VAL(Value$)))
    CASE ELSE
      WorkNumStr% = NumStr%
      Value$ = InMeaningOfExpression$(InLine$)
      IF NumStr% <> WorkNumStr% THEN ERROR 13
      IF NumStr% THEN Result$ = LTRIM$(STR$(Result$ = Value$)) ELSE Result$ = LTRIM$(STR$(VAL(Result$) = VAL(Value$)))
    END SELECT
    NumStr% = False%
  CASE "<"
    InLine$ = LTRIM$(MID$(InLine$, 2))
    SELECT CASE LEFT$(InLine$, 1)
    CASE ">"
      InLine$ = MID$(InLine$, 2)
      WorkNumStr% = NumStr%
      Value$ = InMeaningOfExpression$(InLine$)
      IF NumStr% <> WorkNumStr% THEN ERROR 13
      IF NumStr% THEN Result$ = LTRIM$(STR$(Result$ <> Value$)) ELSE Result$ = LTRIM$(STR$(VAL(Result$) <> VAL(Value$)))
    CASE "="
      InLine$ = MID$(InLine$, 2)
      WorkNumStr% = NumStr%
      Value$ = InMeaningOfExpression$(InLine$)
      IF NumStr% <> WorkNumStr% THEN ERROR 13
      IF NumStr% THEN Result$ = LTRIM$(STR$(Result$ <= Value$)) ELSE Result$ = LTRIM$(STR$(VAL(Result$) <= VAL(Value$)))
    CASE ELSE
      WorkNumStr% = NumStr%
      Value$ = InMeaningOfExpression$(InLine$)
      IF NumStr% <> WorkNumStr% THEN ERROR 13
      IF NumStr% THEN Result$ = LTRIM$(STR$(Result$ < Value$)) ELSE Result$ = LTRIM$(STR$(VAL(Result$) < VAL(Value$)))
    END SELECT
    NumStr% = False%
  CASE ">"
    InLine$ = LTRIM$(MID$(InLine$, 2))
    SELECT CASE LEFT$(InLine$, 1)
    CASE "<"
      InLine$ = MID$(InLine$, 2)
      WorkNumStr% = NumStr%
      Value$ = InMeaningOfExpression$(InLine$)
      IF NumStr% <> WorkNumStr% THEN ERROR 13
      IF NumStr% THEN Result$ = LTRIM$(STR$(Result$ <> Value$)) ELSE Result$ = LTRIM$(STR$(VAL(Result$) <> VAL(Value$)))
    CASE "="
      InLine$ = MID$(InLine$, 2)
      WorkNumStr% = NumStr%
      Value$ = InMeaningOfExpression$(InLine$)
      IF NumStr% <> WorkNumStr% THEN ERROR 13
      IF NumStr% THEN Result$ = LTRIM$(STR$(Result$ >= Value$)) ELSE Result$ = LTRIM$(STR$(VAL(Result$) >= VAL(Value$)))
    CASE ELSE
      WorkNumStr% = NumStr%
      Value$ = InMeaningOfExpression$(InLine$)
      IF NumStr% <> WorkNumStr% THEN ERROR 13
      IF NumStr% THEN Result$ = LTRIM$(STR$(Result$ > Value$)) ELSE Result$ = LTRIM$(STR$(VAL(Result$) > VAL(Value$)))
    END SELECT
    NumStr% = False%
  CASE "A" TO "Z"
    SavedLine$ = InLine$
    SELECT CASE InName$(InLine$)
    CASE "AND"
      IF NumStr% THEN ERROR 13
      Value$ = InMeaningOfExpression$(InLine$)
      IF NumStr% THEN ERROR 13
      Result$ = LTRIM$(STR$(VAL(Result$) AND VAL(Value$)))
    CASE "OR"
      IF NumStr% THEN ERROR 13
      Value$ = InMeaningOfExpression$(InLine$)
      IF NumStr% THEN ERROR 13
      Result$ = LTRIM$(STR$(VAL(Result$) OR VAL(Value$)))
    CASE "XOR"
      IF NumStr% THEN ERROR 13
      Value$ = InMeaningOfExpression$(InLine$)
      IF NumStr% THEN ERROR 13
      Result$ = LTRIM$(STR$(VAL(Result$) XOR VAL(Value$)))
    CASE "MOD"
      IF NumStr% THEN ERROR 13
      Value$ = InMeaningOfExpression$(InLine$)
      IF NumStr% THEN ERROR 13
      Result$ = LTRIM$(STR$(VAL(Result$) MOD VAL(Value$)))
    CASE ELSE
      InLine$ = SavedLine$
      EXIT DO
    END SELECT
  CASE ELSE
    EXIT DO
  END SELECT
  InLine$ = LTRIM$(InLine$)
 LOOP
 IF NOT NumStr% THEN IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
 CalculateExpression$ = Result$
END FUNCTION

FUNCTION CalendarBox% (Title$, Message$, DayValue%, MonthValue%, YearValue%)
 DIM OutMessage$
 DIM OutIndex%
 DIM Value%
 DIM Days%(37)
 DIM CalendarLine$
 DIM WorkDay%
 DIM WorkMonth%
 DIM WorkYear%
 DIM WorkKey$
 IF LEN(Message$) < 256 THEN OutMessage$ = Message$ + SPACE$(256 - LEN(Message$)) ELSE OutMessage$ = LEFT$(Message$, 256)
 CALL MakeBox(7, 5, 64, 14)
 PRINT LEFT$(Title$, 64) + SPACE$(64 - LEN(LEFT$(Title$, 64)));
 COLOR 1, 7
 FOR OutIndex% = 1 TO 4
  LOCATE 6 + OutIndex%, 8, 0
  PRINT LEFT$(OutMessage$, 64);
  OutMessage$ = MID$(OutMessage$, 65)
 NEXT OutIndex%
 COLOR 14, 7
 LOCATE 19, 8, 0
 PRINT "Please press key is equalient to your answer: ENTER=Yes, ESC=No.";
 WorkDay% = DayValue%
 WorkMonth% = MonthValue%
 WorkYear% = YearValue%
 COLOR 15, 7
 LOCATE 11, 31, 0
 PRINT "Mo Tu We Th Fr Sa Su";
 GOSUB OutCalendar
 DO
  WorkKey$ = INKEY$
  SELECT CASE LEN(WorkKey$)
  CASE 1
    SELECT CASE WorkKey$
    CASE CHR$(13)
      DayValue% = WorkDay%
      MonthValue% = WorkMonth%
      YearValue% = WorkYear%
      EXIT DO
    CASE CHR$(27)
      EXIT DO
    END SELECT
  CASE 2
    WorkKey$ = MID$(WorkKey$, 2)
    SELECT CASE WorkKey$
    CASE CHR$(72)
      WorkDay% = WorkDay% - 1
      IF WorkDay% < 1 THEN
       WorkMonth% = WorkMonth% - 1
       IF WorkMonth% < 1 THEN
        IF WorkYear% = 1980 THEN
         WorkMonth% = 1
         WorkDay% = 1
        ELSE
         WorkYear% = WorkYear% - 1
         WorkMonth% = 12
         WorkDay% = 31
        END IF
       ELSE
        WorkDay% = MonthDays%(WorkMonth%, WorkYear%)
       END IF
      END IF
      GOSUB OutCalendar
    CASE CHR$(80)
      WorkDay% = WorkDay% + 1
      IF WorkDay% > MonthDays%(WorkMonth%, WorkYear%) THEN
       WorkMonth% = WorkMonth% + 1
       IF WorkMonth% > 12 THEN
        IF WorkYear% = 2010 THEN
         WorkMonth% = 12
         WorkDay% = 31
        ELSE
         WorkYear% = WorkYear% + 1
         WorkMonth% = 1
         WorkDay% = 1
        END IF
       ELSE
        WorkDay% = 1
       END IF
      END IF
      GOSUB OutCalendar
    CASE CHR$(75)
      WorkDay% = WorkDay% - 1
      IF WorkDay% < 1 THEN
       WorkMonth% = WorkMonth% - 1
       IF WorkMonth% < 1 THEN
        IF WorkYear% = 1980 THEN
         WorkMonth% = 1
         WorkDay% = 1
        ELSE
         WorkYear% = WorkYear% - 1
         WorkMonth% = 12
         WorkDay% = 31
        END IF
       ELSE
        WorkDay% = MonthDays%(WorkMonth%, WorkYear%)
       END IF
      END IF
      GOSUB OutCalendar
    CASE CHR$(77)
      WorkDay% = WorkDay% + 1
      IF WorkDay% > MonthDays%(WorkMonth%, WorkYear%) THEN
       WorkMonth% = WorkMonth% + 1
       IF WorkMonth% > 12 THEN
        IF WorkYear% = 2010 THEN
         WorkMonth% = 12
         WorkDay% = 31
        ELSE
         WorkYear% = WorkYear% + 1
         WorkMonth% = 1
         WorkDay% = 1
        END IF
       ELSE
        WorkDay% = 1
       END IF
      END IF
      GOSUB OutCalendar
    CASE CHR$(73)
      WorkMonth% = WorkMonth% - 1
      IF WorkMonth% < 1 THEN
       IF WorkYear% = 1980 THEN
        WorkMonth% = 1
       ELSE
        WorkYear% = WorkYear% - 1
        WorkMonth% = 12
       END IF
      END IF
      IF WorkDay% > MonthDays%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDays%(WorkMonth%, WorkYear%)
      GOSUB OutCalendar
    CASE CHR$(81)
      WorkMonth% = WorkMonth% + 1
      IF WorkMonth% > 12 THEN
       IF WorkYear% = 2010 THEN
        WorkMonth% = 12
       ELSE
        WorkYear% = WorkYear% + 1
        WorkMonth% = 1
       END IF
      END IF
      IF WorkDay% > MonthDays%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDays%(WorkMonth%, WorkYear%)
      GOSUB OutCalendar
    CASE CHR$(71)
      IF WorkYear% > 1980 THEN
       WorkYear% = WorkYear% - 1
       IF WorkDay% > MonthDays%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDays%(WorkMonth%, WorkYear%)
       GOSUB OutCalendar
      END IF
    CASE CHR$(79)
      IF WorkYear% < 2010 THEN
       WorkYear% = WorkYear% + 1
       IF WorkDay% > MonthDays%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDays%(WorkMonth%, WorkYear%)
       GOSUB OutCalendar
      END IF
    END SELECT
  END SELECT
 LOOP
 CalendarBox% = WorkKey$ = CHR$(13)
 EXIT FUNCTION
OutCalendar:
 COLOR 8, 7
 LOCATE 12, 31, 0
 PRINT MonthName$(WorkMonth%) + ", " + LTRIM$(STR$(WorkYear%)) + " year." + SPACE$(21 - LEN(MonthName$(WorkMonth%) + ", " + LTRIM$(STR$(WorkYear%)) + " year."));
 FOR OutIndex% = 1 TO 37
  Days%(OutIndex%) = 0
 NEXT OutIndex%
 Value% = 1
 FOR OutIndex% = DayOfWeek%(1, WorkMonth%, WorkYear%) TO 37
  Days%(OutIndex%) = Value%
  Value% = Value% + 1
  IF Value% = MonthDays%(WorkMonth%, WorkYear%) + 1 THEN EXIT FOR
 NEXT OutIndex%
 CalendarLine$ = ""
 Value% = 1
 FOR OutIndex% = 1 TO 37
  IF Days%(OutIndex%) > 0 THEN
   IF Days%(OutIndex%) = WorkDay% THEN
    CalendarLine$ = CalendarLine$ + "*" + SPACE$(2 - LEN(LTRIM$(STR$(Days%(OutIndex%))))) + LTRIM$(STR$(Days%(OutIndex%)))
   ELSE
    CalendarLine$ = CalendarLine$ + SPACE$(3 - LEN(LTRIM$(STR$(Days%(OutIndex%))))) + LTRIM$(STR$(Days%(OutIndex%)))
   END IF
  ELSE
   CalendarLine$ = CalendarLine$ + SPACE$(3)
  END IF
  IF LEN(CalendarLine$) = 21 THEN
   COLOR 6, 7
   LOCATE 12 + Value%, 30, 0
   WHILE CalendarLine$ <> ""
    SELECT CASE LEFT$(CalendarLine$, 1)
    CASE "*"
      COLOR 14, 6
      CalendarLine$ = MID$(CalendarLine$, 2)
      PRINT SPACE$(1) + LEFT$(CalendarLine$, 3);
      CalendarLine$ = MID$(CalendarLine$, 4)
      COLOR 6, 7
    CASE ELSE
      PRINT LEFT$(CalendarLine$, 1);
      CalendarLine$ = MID$(CalendarLine$, 2)
    END SELECT
   WEND
   Value% = Value% + 1
  END IF
 NEXT OutIndex%
 IF CalendarLine$ <> "" THEN
  COLOR 6, 7
  LOCATE 12 + Value%, 30, 0
  WHILE CalendarLine$ <> ""
   SELECT CASE LEFT$(CalendarLine$, 1)
   CASE "*"
     COLOR 14, 6
     CalendarLine$ = MID$(CalendarLine$, 2)
     PRINT SPACE$(1) + LEFT$(CalendarLine$, 3);
     CalendarLine$ = MID$(CalendarLine$, 4)
     COLOR 6, 7
   CASE ELSE
     PRINT LEFT$(CalendarLine$, 1);
     CalendarLine$ = MID$(CalendarLine$, 2)
   END SELECT
  WEND
 END IF
 RETURN
END FUNCTION

SUB ClearAll
 DIM Index%
 DIM SubIndex%
 FOR Index% = 1 TO DefFnSCountValue%
  DefFnS$(Index%) = ""
  DefFnSArgsCount%(Index%) = 0
  FOR SubIndex% = 1 TO DefFnSArgumentsCountValue%
   DefFnSArgs$(Index%, SubIndex%) = ""
  NEXT SubIndex%
 NEXT Index%
 FOR Index% = 1 TO VariablesCountValue%
  Variables$(Index%) = ""
 NEXT Index%
 FOR Index% = 1 TO GoSubSCountValue%
  GoSubS%(Index%) = 0
 NEXT Index%
 FOR Index% = 1 TO FilesCountValue%
  BASICFiles$(Index%) = ""
 NEXT Index%
 FOR Index% = 1 TO WhilesCountValue%
  Whiles$(Index%) = ""
 NEXT Index%
 FOR Index% = 1 TO FromsCountValue%
  Froms$(Index%) = ""
 NEXT Index%
 FOR Index% = 1 TO SubroutinesCountValue%
  Subroutines$(Index%) = ""
  SubroutinesResults$(Index%) = ""
  SubroutinesArgumentsCount%(Index%) = 0
  FOR SubIndex% = 1 TO SubroutinesArgumentsCountValue%
   SubroutinesArguments$(Index%, SubIndex%) = ""
  NEXT SubIndex%
 NEXT Index%
 FOR Index% = 1 TO ANSIParametersCountValue%
  Parameters%(Index%) = 0
 NEXT Index%
 CurrentSubroutine% = 0
 DefFnSCount% = 0
 VariablesCount% = 0
 GoSubSCount% = 0
 CurrentLine% = 0
 CurrentDefFn% = 0
 NumStr% = False%
 DefFnMode% = False%
 RunMode% = False%
 TraceMode% = False%
 SubroutineMode% = False%
 CursorRow% = 0
 CursorColumn% = 0
 CursorSaved% = False%
 ParametersCount% = 0
 ANSIMode% = 0
 NumberLine$ = ""
 CLOSE
END SUB

SUB ClearANSI
 DIM Index%
 FOR Index% = 1 TO ANSIParametersCountValue%
  Parameters%(Index%) = 0
 NEXT Index%
 ParametersCount% = 0
 ANSIMode% = 0
 NumberLine$ = ""
END SUB

SUB ControlCoordinates
 IF TextRow% < 1 THEN TextRow% = 1
 IF TextPosition% < 1 THEN TextPosition% = 1
 IF TextRow% > TextLines% THEN TextRow% = TextLines%
 IF TextPosition% > 20 THEN TextPosition% = 20
 IF TextColumn% < 1 THEN TextColumn% = 1
 IF LinePosition% < 1 THEN LinePosition% = 1
 IF TextColumn% > LEN(Text$(TextRow%)) + 1 THEN TextColumn% = LEN(Text$(TextRow%)) + 1
 IF LEN(Text$(TextRow%)) > 76 THEN IF LinePosition% > 77 THEN LinePosition% = 77
 IF LEN(Text$(TextRow%)) < 77 THEN IF LinePosition% > LEN(Text$(TextRow%)) + 1 THEN LinePosition% = LEN(Text$(TextRow%)) + 1
 CALL OutText
END SUB

FUNCTION CurrentDateTime$
 CurrentDateTime$ = "Date: " + DayOfWeekName$(VAL(MID$(DATE$, 4, 2)), VAL(MID$(DATE$, 1, 2)), VAL(MID$(DATE$, 7, 4))) + ", " + LTRIM$(STR$(VAL(MID$(DATE$, 4, 2)))) + " " + MonthName$(VAL(MID$(DATE$, 1, 2))) + " " + LTRIM$(STR$(VAL(MID$(DATE$, 7, 4)))) + " year. Time: " + TIME$ + "."
END FUNCTION

SUB CursorDown
 TextRow% = TextRow% + 1
 TextPosition% = TextPosition% + 1
 CALL ControlCoordinates
END SUB

SUB CursorEnd
 TextColumn% = LEN(Text$(TextRow%)) + 1
 LinePosition% = TextColumn%
 CALL ControlCoordinates
END SUB

SUB CursorHome
 TextColumn% = 1
 LinePosition% = 1
 CALL ControlCoordinates
END SUB

SUB CursorLeft
 IF TextColumn% = 1 THEN
  IF TextRow% > 1 THEN
   TextColumn% = LEN(Text$(TextRow% - 1)) + 1
   LinePosition% = TextColumn%
   CALL CursorUp
  END IF
 ELSE
  TextColumn% = TextColumn% - 1
  LinePosition% = LinePosition% - 1
  CALL ControlCoordinates
 END IF
END SUB

SUB CursorRight
 IF TextColumn% = LEN(Text$(TextRow%)) + 1 THEN
  IF TextRow% < TextLines% THEN
   TextColumn% = 1
   LinePosition% = 1
   CALL CursorDown
  END IF
 ELSE
  TextColumn% = TextColumn% + 1
  LinePosition% = LinePosition% + 1
  CALL ControlCoordinates
 END IF
END SUB

SUB CursorUp
 TextRow% = TextRow% - 1
 TextPosition% = TextPosition% - 1
 CALL ControlCoordinates
END SUB

FUNCTION DayName$ (DayNumber%)
 SELECT CASE DayNumber%
 CASE 1
   DayName$ = "Monday"
 CASE 2
   DayName$ = "Tuesday"
 CASE 3
   DayName$ = "Wednesday"
 CASE 4
   DayName$ = "Thursday"
 CASE 5
   DayName$ = "Friday"
 CASE 6
   DayName$ = "Saturday"
 CASE 7
   DayName$ = "Sunday"
 END SELECT
END FUNCTION

FUNCTION DayOfWeek% (DayValue%, MonthValue%, YearValue%)
 SELECT CASE DaysCount&(DayValue%, MonthValue%, YearValue%) - (INT(DaysCount&(DayValue%, MonthValue%, YearValue%) / 7) * 7)
 CASE 0
   DayOfWeek% = 6
 CASE 1
   DayOfWeek% = 7
 CASE 2
   DayOfWeek% = 1
 CASE 3
   DayOfWeek% = 2
 CASE 4
   DayOfWeek% = 3
 CASE 5
   DayOfWeek% = 4
 CASE 6
   DayOfWeek% = 5
 CASE 7
   DayOfWeek% = 6
 END SELECT
END FUNCTION

FUNCTION DayOfWeekName$ (DayValue%, MonthValue%, YearValue%)
 DayOfWeekName$ = DayName$(DayOfWeek%(DayValue%, MonthValue%, YearValue%))
END FUNCTION

FUNCTION DaysCount& (DayValue%, MonthValue%, YearValue%)
 DaysCount& = (YearValue% * 365#) + INT(YearValue% / 100) + INT(YearValue% / 4) + MonthDaysCount%(MonthValue%, YearValue%) + DayValue%
END FUNCTION

SUB DeleteBackSymbol
 DIM Index%
 DIM LineLength%
 IF TextColumn% = 1 THEN
  IF TextRow% > 1 THEN
   IF LEN(Text$(TextRow% - 1)) < 256 THEN
    LineLength% = LEN(Text$(TextRow% - 1))
    Text$(TextRow% - 1) = Text$(TextRow% - 1) + LEFT$(Text$(TextRow%), 256 - LineLength%)
    Text$(TextRow%) = MID$(Text$(TextRow%), (256 - LineLength%) + 1)
    IF Text$(TextRow%) = "" THEN
     FOR Index% = TextRow% TO TextLines% - 1
      Text$(Index%) = Text$(Index% + 1)
      Text$(Index% + 1) = ""
     NEXT Index%
    END IF
    TextColumn% = LineLength% + 1
    LinePosition% = TextColumn%
    CALL CursorUp
   END IF
  END IF
 ELSE
  Text$(TextRow%) = MID$(Text$(TextRow%), 1, TextColumn% - 2) + MID$(Text$(TextRow%), TextColumn%)
  CALL CursorLeft
 END IF
END SUB

SUB DeleteSymbol
 DIM Index%
 DIM LineLength%
 IF TextColumn% = LEN(Text$(TextRow%)) + 1 THEN
  IF (LEN(Text$(TextRow%)) < 256) AND (TextRow% < TextLines%) THEN
   LineLength% = LEN(Text$(TextRow%))
   Text$(TextRow%) = Text$(TextRow%) + LEFT$(Text$(TextRow% + 1), 256 - LineLength%)
   Text$(TextRow% + 1) = MID$(Text$(TextRow% + 1), (256 - LineLength%) + 1)
   IF Text$(TextRow% + 1) = "" THEN
    FOR Index% = TextRow% + 1 TO TextLines% - 1
     Text$(Index%) = Text$(Index% + 1)
     Text$(Index% + 1) = ""
    NEXT Index%
   END IF
  END IF
 ELSE
  Text$(TextRow%) = MID$(Text$(TextRow%), 1, TextColumn% - 1) + MID$(Text$(TextRow%), TextColumn% + 1)
 END IF
 CALL OutText
END SUB

SUB EnterLine
 DIM Index%
 IF (TextRow% > (TextLines% - 1)) OR (Text$(TextLines%) <> "") THEN EXIT SUB
 FOR Index% = TextLines% - 1 TO TextRow% + 1 STEP -1
  Text$(Index% + 1) = Text$(Index%)
  Text$(Index%) = ""
 NEXT Index%
 Text$(TextRow% + 1) = MID$(Text$(TextRow%), TextColumn%)
 Text$(TextRow%) = MID$(Text$(TextRow%), 1, TextColumn% - 1)
 TextColumn% = 1
 LinePosition% = 1
 CALL CursorDown
END SUB

FUNCTION FindLabel% (LabelName$)
 DIM Index%
 DIM WorkLine$
 DIM LineNumber%
 FOR Index% = 1 TO TextLines% + 1
  IF Index% = TextLines% + 1 THEN ERROR 8
  IF LTRIM$(RTRIM$(Text$(Index%))) <> "" THEN
   WorkLine$ = LTRIM$(RTRIM$(Text$(Index%)))
   SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
   CASE "0" TO "9"
     LineNumber% = INT(InNumber#(WorkLine$))
     IF (LineNumber% < 1) OR (LineNumber% > TextLines%) THEN ERROR 15
     WorkLine$ = LTRIM$(WorkLine$)
     SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
     CASE "A" TO "Z"
       WorkLine$ = ParseRunLine$(WorkLine$)
       IF InName$(WorkLine$) = "LABEL" THEN
        WorkLine$ = Calculate$(WorkLine$)
        IF NOT NumStr% THEN ERROR 13
        IF WorkLine$ = LabelName$ THEN EXIT FOR
       END IF
     CASE ELSE
       ERROR 95
     END SELECT
   CASE "A" TO "Z"
     WorkLine$ = ParseRunLine$(WorkLine$)
     IF InName$(WorkLine$) = "LABEL" THEN
      WorkLine$ = Calculate$(WorkLine$)
      IF NOT NumStr% THEN ERROR 13
      IF WorkLine$ = LabelName$ THEN EXIT FOR
     END IF
   CASE ELSE
     ERROR 95
   END SELECT
  END IF
 NEXT Index%
 FindLabel% = Index%
END FUNCTION

FUNCTION FindLine% (NumberOfLine%)
 DIM Index%
 DIM LineNumber%
 DIM WorkLine$
 FOR Index% = 1 TO TextLines% + 1
  IF Index% = TextLines% + 1 THEN ERROR 43
  IF LTRIM$(RTRIM$(Text$(Index%))) <> "" THEN
   WorkLine$ = LTRIM$(RTRIM$(Text$(Index%)))
   IF ((ASC(WorkLine$) > (ASC("0") - 1)) AND (ASC(WorkLine$) < (ASC("9") + 1))) THEN
    LineNumber% = INT(InNumber#(WorkLine$))
    IF (LineNumber% < 1) OR (LineNumber% > TextLines%) THEN ERROR 15
    IF LineNumber% = NumberOfLine% THEN EXIT FOR
   END IF
  END IF
 NEXT Index%
 FindLine% = Index%
END FUNCTION

FUNCTION GetTimerValue&
 DIM TimerMeaning&
 DIM Bytes%(4)
 DIM Index%
 DEF SEG = &H0
 FOR Index% = &H0 TO &H3
  Bytes%(Index% + 1) = PEEK(&H46C + Index%)
 NEXT Index%
 DEF SEG = VARSEG(TimerMeaning&)
 FOR Index% = &H0 TO &H3
  POKE VARPTR(TimerMeaning&) + Index%, Bytes%(Index% + 1)
 NEXT Index%
 DEF SEG
 GetTimerValue& = TimerMeaning&
END FUNCTION

SUB Hang
 DIM HangCode%(32)
 DIM Index%
 DIM HangCode$
 HangCode$ = "BA0000529DBF40008EC7BF000026C6050083C70181FF010475F3B80000509D"
 HangCode$ = HangCode$ + "BB0000B90000BA0000BD0000BC0000BE0000BF00008EDA8EC7"
 HangCode$ = HangCode$ + "8ED4F0F4CD20CB"
 Index% = 0
 DEF SEG = VARSEG(HangCode%(1))
 WHILE HangCode$ <> ""
  POKE VARPTR(HangCode%(1)) + Index%, VAL("&H" + LEFT$(HangCode$, 2))
  Index% = Index% + 1
  HangCode$ = MID$(HangCode$, 3)
 WEND
 CALL Absolute(VARPTR(HangCode%(1)))
END SUB

FUNCTION InDefFn$ (DefFnName$, DefFnType%, InLine$)
 DIM Result$
 DIM WorkDefFnName$
 DIM WorkDefFnType%
 DIM OldDefFnMode%
 DIM WorkLine$
 DIM Index%
 DIM ArgumentType%
 IF DefFnSCount% = 0 THEN ERROR 23
 FOR Index% = 1 TO DefFnSCount% + 1
  IF Index% = DefFnSCount% + 1 THEN ERROR 28
  WorkLine$ = DefFnS$(Index%)
  WorkDefFnName$ = InName$(WorkLine$)
  WorkLine$ = LTRIM$(WorkLine$)
  WorkDefFnType% = False%
  SELECT CASE LEFT$(WorkLine$, 1)
  CASE "$"
    WorkDefFnType% = True%
    WorkLine$ = MID$(WorkLine$, 2)
  CASE "!"
    WorkLine$ = MID$(WorkLine$, 2)
  CASE "@"
    WorkLine$ = MID$(WorkLine$, 2)
  CASE "#"
    WorkLine$ = MID$(WorkLine$, 2)
  CASE "%"
    WorkLine$ = MID$(WorkLine$, 2)
  CASE "&"
    WorkLine$ = MID$(WorkLine$, 2)
  END SELECT
  IF (WorkDefFnName$ = DefFnName$) AND (WorkDefFnType% = DefFnType%) THEN EXIT FOR
 NEXT Index%
 IF CurrentDefFn% = DefFnSCountValue% THEN ERROR 31
 CurrentDefFn% = CurrentDefFn% + 1
 DefFnSArgsCount%(CurrentDefFn%) = 0
 FOR Index% = 1 TO DefFnSArgumentsCountValue%
  DefFnSArgs$(CurrentDefFn%, Index%) = ""
 NEXT Index%
 WorkLine$ = LTRIM$(WorkLine$)
 IF LEFT$(WorkLine$, 1) = "(" THEN
  WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
  DefFnSArgsCount%(CurrentDefFn%) = 1
  DO WHILE WorkLine$ <> ""
   Result$ = InName$(WorkLine$)
   WorkLine$ = LTRIM$(WorkLine$)
   ArgumentType% = False%
   SELECT CASE LEFT$(WorkLine$, 1)
   CASE "$"
     ArgumentType% = True%
     WorkLine$ = MID$(WorkLine$, 2)
   CASE "!"
     WorkLine$ = MID$(WorkLine$, 2)
   CASE "@"
     WorkLine$ = MID$(WorkLine$, 2)
   CASE "#"
     WorkLine$ = MID$(WorkLine$, 2)
   CASE "%"
     WorkLine$ = MID$(WorkLine$, 2)
   CASE "&"
     WorkLine$ = MID$(WorkLine$, 2)
   END SELECT
   DefFnSArgs$(CurrentDefFn%, DefFnSArgsCount%(CurrentDefFn%)) = Result$ + "[" + LTRIM$(STR$(ABS(ArgumentType%))) + "]="
   WorkLine$ = LTRIM$(WorkLine$)
   SELECT CASE LEFT$(WorkLine$, 1)
   CASE ","
     IF DefFnSArgsCount%(CurrentDefFn%) = DefFnSArgumentsCountValue% THEN ERROR 32
     WorkLine$ = MID$(WorkLine$, 2)
     DefFnSArgsCount%(CurrentDefFn%) = DefFnSArgsCount%(CurrentDefFn%) + 1
   CASE ")"
     WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
     EXIT DO
   CASE ELSE
     ERROR 2
   END SELECT
  LOOP
  InLine$ = LTRIM$(InLine$)
  IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
  InLine$ = LTRIM$(MID$(InLine$, 2))
  IF InLine$ = "" THEN ERROR 5
  Index% = 1
  DO WHILE InLine$ <> ""
   Result$ = Calculate$(InLine$)
   IF ABS(NumStr%) <> VAL(MID$(DefFnSArgs$(CurrentDefFn%, Index%), INSTR(DefFnSArgs$(CurrentDefFn%, Index%), "[") + 1, 1)) THEN ERROR 13
   DefFnSArgs$(CurrentDefFn%, Index%) = DefFnSArgs$(CurrentDefFn%, Index%) + Result$
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE ","
     IF Index% = DefFnSArgsCount%(CurrentDefFn%) THEN ERROR 37
     InLine$ = MID$(InLine$, 2)
     Index% = Index% + 1
   CASE ")"
     IF Index% <> DefFnSArgsCount%(CurrentDefFn%) THEN ERROR 37
     InLine$ = LTRIM$(MID$(InLine$, 2))
     EXIT DO
   CASE ELSE
     ERROR 2
   END SELECT
  LOOP
 END IF
 IF LEFT$(WorkLine$, 1) <> "=" THEN ERROR 2
 WorkLine$ = MID$(WorkLine$, 2)
 OldDefFnMode% = DefFnMode%
 DefFnMode% = True%
 Result$ = Calculate$(WorkLine$)
 IF NumStr% <> DefFnType% THEN ERROR 13
 DefFnMode% = OldDefFnMode%
 DefFnSArgsCount%(CurrentDefFn%) = 0
 FOR Index% = 1 TO DefFnSArgumentsCountValue%
  DefFnSArgs$(CurrentDefFn%, Index%) = ""
 NEXT Index%
 CurrentDefFn% = CurrentDefFn% - 1
 InDefFn$ = Result$
END FUNCTION

FUNCTION InMeaning$ (InLine$)
 DIM Crc32Table&(256)
 DIM CrcIndex%
 DIM Crc&
 DIM Index%
 DIM WorkValue%
 DIM Result$
 DIM Value$
 DIM Meaning$
 DIM WorkName$
 InLine$ = LTRIM$(InLine$)
 SELECT CASE LEFT$(UCASE$(InLine$), 1)
 CASE "+"
   InLine$ = MID$(InLine$, 2)
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   Result$ = LTRIM$(STR$(0# + VAL(Result$)))
   IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
   InMeaning$ = Result$
 CASE "-"
   InLine$ = MID$(InLine$, 2)
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   Result$ = LTRIM$(STR$(0# - VAL(Result$)))
   IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
   InMeaning$ = Result$
 CASE "0" TO "9"
   NumStr% = False%
   Result$ = LTRIM$(STR$(InNumber#(InLine$)))
   IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
   InMeaning$ = Result$
 CASE "."
   NumStr% = False%
   Result$ = LTRIM$(STR$(InNumber#(InLine$)))
   IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
   InMeaning$ = Result$
 CASE "&"
   NumStr% = False%
   Result$ = LTRIM$(STR$(InNumber#(InLine$)))
   IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
   InMeaning$ = Result$
 CASE CHR$(34)
   InLine$ = MID$(InLine$, 2)
   IF INSTR(InLine$, CHR$(34)) = 0 THEN ERROR 2
   NumStr% = True%
   InMeaning$ = MID$(InLine$, 1, INSTR(InLine$, CHR$(34)) - 1)
   InLine$ = MID$(InLine$, INSTR(InLine$, CHR$(34)) + 1)
 CASE "("
   InLine$ = MID$(InLine$, 2)
   InMeaning$ = Calculate$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
 CASE "A" TO "Z"
   WorkName$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   NumStr% = False%
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     NumStr% = True%
     InLine$ = MID$(InLine$, 2)
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF WorkName$ = "NOT" THEN
    Result$ = Calculate$(InLine$)
    IF NumStr% THEN ERROR 13
    Result$ = LTRIM$(STR$(NOT VAL(Result$)))
    IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
    InMeaning$ = Result$
   ELSE
    IF NumStr% THEN
     SELECT CASE WorkName$
     CASE "DATE"
       InMeaning$ = DATE$
     CASE "TIME"
       InMeaning$ = TIME$
     CASE "INKEY"
       InMeaning$ = INKEY$
     CASE "INPUT"
       IF LEFT$(InLine$, 1) = "(" THEN
        InLine$ = LTRIM$(MID$(InLine$, 2))
        IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
        InLine$ = MID$(InLine$, 2)
        Result$ = Calculate$(InLine$)
        IF NumStr% THEN ERROR 13
        InLine$ = LTRIM$(InLine$)
        IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
        InLine$ = MID$(InLine$, 2)
        IF (VAL(Result$) < 1) OR (VAL(Result$) > FilesCountValue%) THEN ERROR 52
        IF LEFT$(BASICFiles$(VAL(Result$)), 3) <> "IN=" THEN ERROR 54
        LINE INPUT #VAL(Result$), Result$
        NumStr% = True%
       ELSE
        LINE INPUT Result$
       END IF
       InMeaning$ = Result$
     CASE "CHR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       InMeaning$ = CHR$(INT(VAL(Result$)))
     CASE "HEX"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       InMeaning$ = HEX$(VAL(Result$))
     CASE "OCT"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       InMeaning$ = OCT$(VAL(Result$))
     CASE "DAYNAME"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       IF (VAL(Result$) < 1) OR (VAL(Result$) > 7) THEN ERROR 5
       InMeaning$ = DayName$(VAL(Result$))
     CASE "MONTHNAME"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       IF (VAL(Result$) < 1) OR (VAL(Result$) > 12) THEN ERROR 93
       InMeaning$ = MonthName$(VAL(Result$))
     CASE "SPACE"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       InMeaning$ = SPACE$(VAL(Result$))
     CASE "STR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       Result$ = LTRIM$(STR$(VAL(Result$)))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE "LCASE"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LCASE$(Result$)
     CASE "UCASE"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = UCASE$(Result$)
     CASE "LTRIM"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(Result$)
     CASE "RTRIM"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = RTRIM$(Result$)
     CASE "TRIM"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(RTRIM$(Result$))
     CASE "LEFT"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       InMeaning$ = LEFT$(Result$, VAL(Value$))
     CASE "RIGHT"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       InMeaning$ = RIGHT$(Result$, VAL(Value$))
     CASE "STRING"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF NumStr% THEN InMeaning$ = STRING$(VAL(Result$), Value$) ELSE InMeaning$ = STRING$(VAL(Result$), VAL(Value$))
       NumStr% = True%
     CASE "MID"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Meaning$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       InMeaning$ = MID$(Result$, VAL(Value$), VAL(Meaning$))
     CASE "DAYOFWEEKNAME"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Meaning$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       IF (VAL(Meaning$) < 1980) OR (VAL(Meaning$) > 2099) THEN ERROR 92
       IF (VAL(Value$) < 1) OR (VAL(Value$) > 12) THEN ERROR 93
       IF (VAL(Result$) < 1) OR (VAL(Result$) > MonthDays%(VAL(Value$), VAL(Meaning$))) THEN ERROR 94
       InMeaning$ = DayOfWeekName$(VAL(Result$), VAL(Value$), VAL(Meaning$))
     CASE "ENVIRON"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF NumStr% THEN InMeaning$ = ENVIRON$(Result$) ELSE InMeaning$ = ENVIRON$(VAL(Result$))
       NumStr% = True%
     CASE "MIN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
        CASE ")"
          InLine$ = MID$(InLine$, 2)
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
        Value$ = Calculate$(InLine$)
        IF NOT NumStr% THEN ERROR 13
        InLine$ = LTRIM$(InLine$)
        IF Value$ < Result$ THEN Result$ = Value$
       LOOP
       InMeaning$ = Result$
     CASE "MAX"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
        CASE ")"
          InLine$ = MID$(InLine$, 2)
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
        Value$ = Calculate$(InLine$)
        IF NOT NumStr% THEN ERROR 13
        InLine$ = LTRIM$(InLine$)
        IF Value$ > Result$ THEN Result$ = Value$
       LOOP
       InMeaning$ = Result$
     CASE ELSE
       IF LEFT$(WorkName$, 2) = "FN" THEN InMeaning$ = InDefFn$(WorkName$, True%, InLine$) ELSE InMeaning$ = InVariable$(WorkName$, True%, InLine$)
       IF NOT NumStr% THEN ERROR 13
     END SELECT
    ELSE
     SELECT CASE WorkName$
     CASE "PI"
       InMeaning$ = "3.1415926535897932385"
     CASE "CSRLIN"
       InMeaning$ = LTRIM$(STR$(CSRLIN))
     CASE "RANDOM"
       Result$ = LTRIM$(STR$(RND))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE "TIMER"
       InMeaning$ = LTRIM$(STR$(TIMER))
     CASE "TIMERVALUE"
       InMeaning$ = LTRIM$(STR$(GetTimerValue&))
     CASE "BLACK"
       InMeaning$ = "0"
     CASE "BLUE"
       InMeaning$ = "1"
     CASE "GREEN"
       InMeaning$ = "2"
     CASE "CYAN"
       InMeaning$ = "3"
     CASE "RED"
       InMeaning$ = "4"
     CASE "MAGENTA"
       InMeaning$ = "5"
     CASE "BROWN"
       InMeaning$ = "6"
     CASE "WHITE"
       InMeaning$ = "7"
     CASE "GRAY"
       InMeaning$ = "8"
     CASE "LIGHTBLUE"
       InMeaning$ = "9"
     CASE "LIGHTGREEN"
       InMeaning$ = "10"
     CASE "LIGHTCYAN"
       InMeaning$ = "11"
     CASE "LIGHTRED"
       InMeaning$ = "12"
     CASE "LIGHTMAGENTA"
       InMeaning$ = "13"
     CASE "YELLOW"
       InMeaning$ = "14"
     CASE "BRIGHTWHITE"
       InMeaning$ = "15"
     CASE "TRUE"
       InMeaning$ = LTRIM$(STR$(True%))
     CASE "FALSE"
       InMeaning$ = LTRIM$(STR$(False%))
     CASE "POS"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = False%
       InMeaning$ = LTRIM$(STR$(POS(0)))
     CASE "SQR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = LTRIM$(STR$(SquareRoot#(VAL(Result$))))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE "ABS"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = LTRIM$(STR$(ABS(VAL(Result$))))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE "ATN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = LTRIM$(STR$(ATN(VAL(Result$))))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE "COS"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = LTRIM$(STR$(COS(VAL(Result$))))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE "EXP"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = LTRIM$(STR$(EXP(VAL(Result$))))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE "FIX"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(FIX(VAL(Result$))))
     CASE "INT"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(INT(VAL(Result$))))
     CASE "LOG"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = LTRIM$(STR$(LOG(VAL(Result$))))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE "SIN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = LTRIM$(STR$(SIN(VAL(Result$))))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE "TAN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = LTRIM$(STR$(TAN(VAL(Result$))))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE "SGN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(SGN(VAL(Result$))))
     CASE "EOF"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = LTRIM$(MID$(InLine$, 2))
       IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (VAL(Result$) < 1) OR (VAL(Result$) > FilesCountValue%) THEN ERROR 52
       IF LEFT$(BASICFiles$(VAL(Result$)), 3) <> "IN=" THEN ERROR 54
       InMeaning$ = LTRIM$(STR$(EOF(VAL(Result$))))
     CASE "LOF"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = LTRIM$(MID$(InLine$, 2))
       IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (VAL(Result$) < 1) OR (VAL(Result$) > FilesCountValue%) THEN ERROR 52
       InMeaning$ = LTRIM$(STR$(LOF(VAL(Result$))))
     CASE "ASC"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF Result$ = "" THEN ERROR 5
       NumStr% = False%
       InMeaning$ = LTRIM$(STR$(ASC(Result$)))
     CASE "LEN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = False%
       InMeaning$ = LTRIM$(STR$(LEN(Result$)))
     CASE "CRC"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = False%
       FOR Index% = 1 TO 256
        Crc& = Index% - 1
        FOR CrcIndex% = 1 TO 8
         IF ((INT(Crc& / 2) * 2) <> Crc&) THEN Crc& = INT(Crc& / 2) XOR &HEDB88320 ELSE Crc& = INT(Crc& / 2)
        NEXT CrcIndex%
        Crc32Table&(Index%) = Crc&
       NEXT Index%
       Crc& = &HFFFFFFFF
       WHILE Result$ <> ""
        WorkValue% = ABS((Crc& MOD &H100) XOR ASC(Result$))
        Result$ = MID$(Result$, 2)
        IF WorkValue% < 0 THEN WorkValue% = 0
        IF WorkValue% > 255 THEN WorkValue% = 255
        Crc& = Crc32Table&(WorkValue% + 1) XOR INT(Crc& / &H100)
       WEND
       InMeaning$ = LTRIM$(STR$(Crc&))
     CASE "VAL"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = False%
       Result$ = LTRIM$(STR$(VAL(Result$)))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE "INSTR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = False%
       InMeaning$ = LTRIM$(STR$(INSTR(Result$, Value$)))
     CASE "DAYOFWEEK"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Meaning$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (VAL(Meaning$) < 1980) OR (VAL(Meaning$) > 2099) THEN ERROR 92
       IF (VAL(Value$) < 1) OR (VAL(Value$) > 12) THEN ERROR 93
       IF (VAL(Result$) < 1) OR (VAL(Result$) > MonthDays%(VAL(Value$), VAL(Meaning$))) THEN ERROR 94
       InMeaning$ = LTRIM$(STR$(DayOfWeek%(VAL(Result$), VAL(Value$), VAL(Meaning$))))
     CASE "WEEKNUMBER"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Meaning$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (VAL(Meaning$) < 1980) OR (VAL(Meaning$) > 2099) THEN ERROR 92
       IF (VAL(Value$) < 1) OR (VAL(Value$) > 12) THEN ERROR 93
       IF (VAL(Result$) < 1) OR (VAL(Result$) > MonthDays%(VAL(Value$), VAL(Meaning$))) THEN ERROR 94
       InMeaning$ = LTRIM$(STR$(WeekNumber%(VAL(Result$), VAL(Value$), VAL(Meaning$))))
     CASE "ISLEAPYEAR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (VAL(Result$) < 1980) OR (VAL(Result$) > 2099) THEN ERROR 92
       InMeaning$ = LTRIM$(STR$((INT(INT(VAL(Result$)) / 4) * 4) = INT(VAL(Result$))))
     CASE "MIN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
        CASE ")"
          InLine$ = MID$(InLine$, 2)
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
        Value$ = Calculate$(InLine$)
        IF NumStr% THEN ERROR 13
        InLine$ = LTRIM$(InLine$)
        IF VAL(Value$) < VAL(Result$) THEN Result$ = LTRIM$(STR$(VAL(Value$)))
       LOOP
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE "MAX"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
        CASE ")"
          InLine$ = MID$(InLine$, 2)
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
        Value$ = Calculate$(InLine$)
        IF NumStr% THEN ERROR 13
        InLine$ = LTRIM$(InLine$)
        IF VAL(Value$) > VAL(Result$) THEN Result$ = LTRIM$(STR$(VAL(Value$)))
       LOOP
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE "AVG"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       Index% = 1
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
        CASE ")"
          InLine$ = MID$(InLine$, 2)
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
        Value$ = Calculate$(InLine$)
        IF NumStr% THEN ERROR 13
        InLine$ = LTRIM$(InLine$)
        Result$ = LTRIM$(STR$(VAL(Result$) + VAL(Value$)))
        Index% = Index% + 1
       LOOP
       Result$ = LTRIM$(STR$(VAL(Result$) / Index%))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE ELSE
       IF LEFT$(WorkName$, 2) = "FN" THEN Result$ = InDefFn$(WorkName$, False%, InLine$) ELSE Result$ = InVariable$(WorkName$, False%, InLine$)
       IF NumStr% THEN ERROR 13
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     END SELECT
    END IF
   END IF
 CASE ELSE
   ERROR 2
 END SELECT
END FUNCTION

FUNCTION InMeaningOfExpression$ (InLine$)
 DIM Crc32Table&(256)
 DIM CrcIndex%
 DIM Crc&
 DIM Index%
 DIM WorkValue%
 DIM Result$
 DIM Value$
 DIM Meaning$
 DIM WorkName$
 InLine$ = LTRIM$(InLine$)
 SELECT CASE LEFT$(UCASE$(InLine$), 1)
 CASE "+"
   InLine$ = MID$(InLine$, 2)
   Result$ = CalculateExpression$(InLine$)
   IF NumStr% THEN ERROR 13
   Result$ = LTRIM$(STR$(0# + VAL(Result$)))
   IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
   InMeaningOfExpression$ = Result$
 CASE "-"
   InLine$ = MID$(InLine$, 2)
   Result$ = CalculateExpression$(InLine$)
   IF NumStr% THEN ERROR 13
   Result$ = LTRIM$(STR$(0# - VAL(Result$)))
   IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
   InMeaningOfExpression$ = Result$
 CASE "0" TO "9"
   NumStr% = False%
   Result$ = LTRIM$(STR$(InNumber#(InLine$)))
   IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
   InMeaningOfExpression$ = Result$
 CASE "."
   NumStr% = False%
   Result$ = LTRIM$(STR$(InNumber#(InLine$)))
   IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
   InMeaningOfExpression$ = Result$
 CASE "&"
   NumStr% = False%
   Result$ = LTRIM$(STR$(InNumber#(InLine$)))
   IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
   InMeaningOfExpression$ = Result$
 CASE CHR$(34)
   InLine$ = MID$(InLine$, 2)
   IF INSTR(InLine$, CHR$(34)) = 0 THEN ERROR 2
   NumStr% = True%
   InMeaningOfExpression$ = MID$(InLine$, 1, INSTR(InLine$, CHR$(34)) - 1)
   InLine$ = MID$(InLine$, INSTR(InLine$, CHR$(34)) + 1)
 CASE "("
   InLine$ = MID$(InLine$, 2)
   InMeaningOfExpression$ = CalculateExpression$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
 CASE "A" TO "Z"
   WorkName$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   NumStr% = False%
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     NumStr% = True%
     InLine$ = MID$(InLine$, 2)
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF WorkName$ = "NOT" THEN
    Result$ = CalculateExpression$(InLine$)
    IF NumStr% THEN ERROR 13
    Result$ = LTRIM$(STR$(NOT VAL(Result$)))
    IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
    InMeaningOfExpression$ = Result$
   ELSE
    IF NumStr% THEN
     SELECT CASE WorkName$
     CASE "DATE"
       InMeaningOfExpression$ = DATE$
     CASE "TIME"
       InMeaningOfExpression$ = TIME$
     CASE "INKEY"
       InMeaningOfExpression$ = INKEY$
     CASE "INPUT"
       Result$ = ""
       IF InputBox%("GNUTextBasic.", "Please enter line.", Result$) THEN InMeaningOfExpression$ = Result$ ELSE InMeaningOfExpression$ = ""
       CALL ScratchScreen
       CALL OutText
     CASE "CHR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       InMeaningOfExpression$ = CHR$(INT(VAL(Result$)))
     CASE "HEX"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       InMeaningOfExpression$ = HEX$(VAL(Result$))
     CASE "OCT"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       InMeaningOfExpression$ = OCT$(VAL(Result$))
     CASE "DAYNAME"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       IF (VAL(Result$) < 1) OR (VAL(Result$) > 7) THEN ERROR 5
       InMeaningOfExpression$ = DayName$(VAL(Result$))
     CASE "MONTHNAME"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       IF (VAL(Result$) < 1) OR (VAL(Result$) > 12) THEN ERROR 93
       InMeaningOfExpression$ = MonthName$(VAL(Result$))
     CASE "SPACE"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       InMeaningOfExpression$ = SPACE$(VAL(Result$))
     CASE "STR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       Result$ = LTRIM$(STR$(VAL(Result$)))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaningOfExpression$ = Result$
     CASE "LCASE"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaningOfExpression$ = LCASE$(Result$)
     CASE "UCASE"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaningOfExpression$ = UCASE$(Result$)
     CASE "LTRIM"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaningOfExpression$ = LTRIM$(Result$)
     CASE "RTRIM"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaningOfExpression$ = RTRIM$(Result$)
     CASE "TRIM"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaningOfExpression$ = LTRIM$(RTRIM$(Result$))
     CASE "LEFT"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       InMeaningOfExpression$ = LEFT$(Result$, VAL(Value$))
     CASE "RIGHT"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       InMeaningOfExpression$ = RIGHT$(Result$, VAL(Value$))
     CASE "STRING"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = CalculateExpression$(InLine$)
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF NumStr% THEN InMeaningOfExpression$ = STRING$(VAL(Result$), Value$) ELSE InMeaningOfExpression$ = STRING$(VAL(Result$), VAL(Value$))
       NumStr% = True%
     CASE "MID"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Meaning$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       InMeaningOfExpression$ = MID$(Result$, VAL(Value$), VAL(Meaning$))
     CASE "DAYOFWEEKNAME"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Meaning$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       IF (VAL(Meaning$) < 1980) OR (VAL(Meaning$) > 2099) THEN ERROR 92
       IF (VAL(Value$) < 1) OR (VAL(Value$) > 12) THEN ERROR 93
       IF (VAL(Result$) < 1) OR (VAL(Result$) > MonthDays%(VAL(Value$), VAL(Meaning$))) THEN ERROR 94
       InMeaningOfExpression$ = DayOfWeekName$(VAL(Result$), VAL(Value$), VAL(Meaning$))
     CASE "ENVIRON"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF NumStr% THEN InMeaningOfExpression$ = ENVIRON$(Result$) ELSE InMeaningOfExpression$ = ENVIRON$(VAL(Result$))
       NumStr% = True%
     CASE "MIN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
        CASE ")"
          InLine$ = MID$(InLine$, 2)
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
        Value$ = CalculateExpression$(InLine$)
        IF NOT NumStr% THEN ERROR 13
        InLine$ = LTRIM$(InLine$)
        IF Value$ < Result$ THEN Result$ = Value$
       LOOP
       InMeaningOfExpression$ = Result$
     CASE "MAX"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
        CASE ")"
          InLine$ = MID$(InLine$, 2)
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
        Value$ = CalculateExpression$(InLine$)
        IF NOT NumStr% THEN ERROR 13
        InLine$ = LTRIM$(InLine$)
        IF Value$ > Result$ THEN Result$ = Value$
       LOOP
       InMeaningOfExpression$ = Result$
     CASE ELSE
       ERROR 18
     END SELECT
    ELSE
     SELECT CASE WorkName$
     CASE "PI"
       InMeaningOfExpression$ = "3.1415926535897932385"
     CASE "RANDOM"
       Result$ = LTRIM$(STR$(RND))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaningOfExpression$ = Result$
     CASE "TIMER"
       InMeaningOfExpression$ = LTRIM$(STR$(TIMER))
     CASE "TIMERVALUE"
       InMeaningOfExpression$ = LTRIM$(STR$(GetTimerValue&))
     CASE "BLACK"
       InMeaningOfExpression$ = "0"
     CASE "BLUE"
       InMeaningOfExpression$ = "1"
     CASE "GREEN"
       InMeaningOfExpression$ = "2"
     CASE "CYAN"
       InMeaningOfExpression$ = "3"
     CASE "RED"
       InMeaningOfExpression$ = "4"
     CASE "MAGENTA"
       InMeaningOfExpression$ = "5"
     CASE "BROWN"
       InMeaningOfExpression$ = "6"
     CASE "WHITE"
       InMeaningOfExpression$ = "7"
     CASE "GRAY"
       InMeaningOfExpression$ = "8"
     CASE "LIGHTBLUE"
       InMeaningOfExpression$ = "9"
     CASE "LIGHTGREEN"
       InMeaningOfExpression$ = "10"
     CASE "LIGHTCYAN"
       InMeaningOfExpression$ = "11"
     CASE "LIGHTRED"
       InMeaningOfExpression$ = "12"
     CASE "LIGHTMAGENTA"
       InMeaningOfExpression$ = "13"
     CASE "YELLOW"
       InMeaningOfExpression$ = "14"
     CASE "BRIGHTWHITE"
       InMeaningOfExpression$ = "15"
     CASE "TRUE"
       InMeaningOfExpression$ = LTRIM$(STR$(True%))
     CASE "FALSE"
       InMeaningOfExpression$ = LTRIM$(STR$(False%))
     CASE "SQR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = LTRIM$(STR$(SquareRoot#(VAL(Result$))))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaningOfExpression$ = Result$
     CASE "ABS"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = LTRIM$(STR$(ABS(VAL(Result$))))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaningOfExpression$ = Result$
     CASE "ATN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = LTRIM$(STR$(ATN(VAL(Result$))))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaningOfExpression$ = Result$
     CASE "COS"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = LTRIM$(STR$(COS(VAL(Result$))))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaningOfExpression$ = Result$
     CASE "EXP"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = LTRIM$(STR$(EXP(VAL(Result$))))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaningOfExpression$ = Result$
     CASE "FIX"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaningOfExpression$ = LTRIM$(STR$(FIX(VAL(Result$))))
     CASE "INT"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaningOfExpression$ = LTRIM$(STR$(INT(VAL(Result$))))
     CASE "LOG"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = LTRIM$(STR$(LOG(VAL(Result$))))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaningOfExpression$ = Result$
     CASE "SIN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = LTRIM$(STR$(SIN(VAL(Result$))))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaningOfExpression$ = Result$
     CASE "TAN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = LTRIM$(STR$(TAN(VAL(Result$))))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaningOfExpression$ = Result$
     CASE "SGN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaningOfExpression$ = LTRIM$(STR$(SGN(VAL(Result$))))
     CASE "ASC"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF Result$ = "" THEN ERROR 5
       NumStr% = False%
       InMeaningOfExpression$ = LTRIM$(STR$(ASC(Result$)))
     CASE "LEN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = False%
       InMeaningOfExpression$ = LTRIM$(STR$(LEN(Result$)))
     CASE "CRC"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = False%
       FOR Index% = 1 TO 256
        Crc& = Index% - 1
        FOR CrcIndex% = 1 TO 8
         IF ((INT(Crc& / 2) * 2) <> Crc&) THEN Crc& = INT(Crc& / 2) XOR &HEDB88320 ELSE Crc& = INT(Crc& / 2)
        NEXT CrcIndex%
        Crc32Table&(Index%) = Crc&
       NEXT Index%
       Crc& = &HFFFFFFFF
       WHILE Result$ <> ""
        WorkValue% = ABS((Crc& MOD &H100) XOR ASC(Result$))
        Result$ = MID$(Result$, 2)
        IF WorkValue% < 0 THEN WorkValue% = 0
        IF WorkValue% > 255 THEN WorkValue% = 255
        Crc& = Crc32Table&(WorkValue% + 1) XOR INT(Crc& / &H100)
       WEND
       InMeaningOfExpression$ = LTRIM$(STR$(Crc&))
     CASE "VAL"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = False%
       Result$ = LTRIM$(STR$(VAL(Result$)))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaningOfExpression$ = Result$
     CASE "INSTR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = CalculateExpression$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = False%
       InMeaningOfExpression$ = LTRIM$(STR$(INSTR(Result$, Value$)))
     CASE "DAYOFWEEK"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Meaning$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (VAL(Meaning$) < 1980) OR (VAL(Meaning$) > 2099) THEN ERROR 92
       IF (VAL(Value$) < 1) OR (VAL(Value$) > 12) THEN ERROR 93
       IF (VAL(Result$) < 1) OR (VAL(Result$) > MonthDays%(VAL(Value$), VAL(Meaning$))) THEN ERROR 94
       InMeaningOfExpression$ = LTRIM$(STR$(DayOfWeek%(VAL(Result$), VAL(Value$), VAL(Meaning$))))
     CASE "WEEKNUMBER"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Meaning$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (VAL(Meaning$) < 1980) OR (VAL(Meaning$) > 2099) THEN ERROR 92
       IF (VAL(Value$) < 1) OR (VAL(Value$) > 12) THEN ERROR 93
       IF (VAL(Result$) < 1) OR (VAL(Result$) > MonthDays%(VAL(Value$), VAL(Meaning$))) THEN ERROR 94
       InMeaningOfExpression$ = LTRIM$(STR$(WeekNumber%(VAL(Result$), VAL(Value$), VAL(Meaning$))))
     CASE "ISLEAPYEAR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (VAL(Result$) < 1980) OR (VAL(Result$) > 2099) THEN ERROR 92
       InMeaningOfExpression$ = LTRIM$(STR$((INT(INT(VAL(Result$)) / 4) * 4) = INT(VAL(Result$))))
     CASE "MIN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
        CASE ")"
          InLine$ = MID$(InLine$, 2)
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
        Value$ = CalculateExpression$(InLine$)
        IF NumStr% THEN ERROR 13
        InLine$ = LTRIM$(InLine$)
        IF VAL(Value$) < VAL(Result$) THEN Result$ = LTRIM$(STR$(VAL(Value$)))
       LOOP
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaningOfExpression$ = Result$
     CASE "MAX"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
        CASE ")"
          InLine$ = MID$(InLine$, 2)
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
        Value$ = CalculateExpression$(InLine$)
        IF NumStr% THEN ERROR 13
        InLine$ = LTRIM$(InLine$)
        IF VAL(Value$) > VAL(Result$) THEN Result$ = LTRIM$(STR$(VAL(Value$)))
       LOOP
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaningOfExpression$ = Result$
     CASE "AVG"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = CalculateExpression$(InLine$)
       Index% = 1
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
        CASE ")"
          InLine$ = MID$(InLine$, 2)
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
        Value$ = CalculateExpression$(InLine$)
        IF NumStr% THEN ERROR 13
        InLine$ = LTRIM$(InLine$)
        Result$ = LTRIM$(STR$(VAL(Result$) + VAL(Value$)))
        Index% = Index% + 1
       LOOP
       Result$ = LTRIM$(STR$(VAL(Result$) / Index%))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaningOfExpression$ = Result$
     CASE ELSE
       ERROR 18
     END SELECT
    END IF
   END IF
 CASE ELSE
   ERROR 2
 END SELECT
END FUNCTION

FUNCTION InName$ (InLine$)
 DIM OutName$
 InLine$ = LTRIM$(InLine$)
 OutName$ = ""
 DO WHILE InLine$ <> ""
  SELECT CASE LEFT$(UCASE$(InLine$), 1)
  CASE "A" TO "Z"
    OutName$ = OutName$ + LEFT$(UCASE$(InLine$), 1)
    InLine$ = MID$(InLine$, 2)
  CASE "0" TO "9"
    OutName$ = OutName$ + LEFT$(InLine$, 1)
    InLine$ = MID$(InLine$, 2)
  CASE "_"
    OutName$ = OutName$ + "_"
    InLine$ = MID$(InLine$, 2)
  CASE "."
    OutName$ = OutName$ + "."
    InLine$ = MID$(InLine$, 2)
  CASE ELSE
    EXIT DO
  END SELECT
 LOOP
 IF OutName$ = "" THEN ERROR 2
 InName$ = OutName$
END FUNCTION

FUNCTION InNumber# (InLine$)
 DIM OutNumber$
 DIM PointPresent%
 InLine$ = LTRIM$(InLine$)
 OutNumber$ = ""
 PointPresent% = False%
 SELECT CASE LEFT$(InLine$, 1)
 CASE "&"
   InLine$ = LTRIM$(MID$(InLine$, 2))
   SELECT CASE LEFT$(UCASE$(InLine$), 1)
   CASE "H"
     InLine$ = LTRIM$(MID$(InLine$, 2))
     DO WHILE InLine$ <> ""
      SELECT CASE LEFT$(UCASE$(InLine$), 1)
      CASE "0" TO "9"
        OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
        InLine$ = MID$(InLine$, 2)
      CASE "A" TO "F"
        OutNumber$ = OutNumber$ + LEFT$(UCASE$(InLine$), 1)
        InLine$ = MID$(InLine$, 2)
      CASE "G" TO "Z"
        ERROR 2
      CASE "."
        InLine$ = MID$(InLine$, 2)
        IF (OutNumber$ = "") OR ((NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("9") + 1)))) AND (NOT ((ASC(UCASE$(InLine$)) > (ASC("A") - 1)) AND (ASC(UCASE$(InLine$)) < (ASC("F") + 1))))) OR PointPresent% THEN ERROR 2
        PointPresent% = True%
        OutNumber$ = OutNumber$ + "."
      CASE ELSE
        EXIT DO
      END SELECT
     LOOP
     IF OutNumber$ = "" THEN ERROR 2
     InNumber# = VAL("&H" + OutNumber$)
   CASE "O"
     InLine$ = LTRIM$(MID$(InLine$, 2))
     DO WHILE InLine$ <> ""
      SELECT CASE LEFT$(UCASE$(InLine$), 1)
      CASE "0" TO "7"
        OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
        InLine$ = MID$(InLine$, 2)
      CASE "8" TO "9"
        ERROR 2
      CASE "."
        InLine$ = MID$(InLine$, 2)
        IF (OutNumber$ = "") OR (NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("7") + 1)))) OR PointPresent% THEN ERROR 2
        PointPresent% = True%
        OutNumber$ = OutNumber$ + "."
      CASE ELSE
        EXIT DO
      END SELECT
     LOOP
     IF OutNumber$ = "" THEN ERROR 2
     InNumber# = VAL("&O" + OutNumber$)
   CASE "0" TO "7"
     DO WHILE InLine$ <> ""
      SELECT CASE LEFT$(UCASE$(InLine$), 1)
      CASE "0" TO "7"
        OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
        InLine$ = MID$(InLine$, 2)
      CASE "8" TO "9"
        ERROR 2
      CASE "."
        InLine$ = MID$(InLine$, 2)
        IF (OutNumber$ = "") OR (NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("7") + 1)))) OR PointPresent% THEN ERROR 2
        PointPresent% = True%
        OutNumber$ = OutNumber$ + "."
      CASE ELSE
        EXIT DO
      END SELECT
     LOOP
     IF OutNumber$ = "" THEN ERROR 2
     InNumber# = VAL("&O" + OutNumber$)
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "0" TO "9"
   DO WHILE InLine$ <> ""
    SELECT CASE LEFT$(UCASE$(InLine$), 1)
    CASE "0" TO "9"
      OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
      InLine$ = MID$(InLine$, 2)
    CASE "."
      InLine$ = MID$(InLine$, 2)
      IF (OutNumber$ = "") OR (NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("9") + 1)))) OR PointPresent% THEN ERROR 2
      PointPresent% = True%
      OutNumber$ = OutNumber$ + "."
    CASE ELSE
      EXIT DO
    END SELECT
   LOOP
   IF OutNumber$ = "" THEN ERROR 2
   InNumber# = VAL(OutNumber$)
 CASE "."
   PointPresent% = True%
   InLine$ = LTRIM$(MID$(InLine$, 2))
   DO WHILE InLine$ <> ""
    SELECT CASE LEFT$(UCASE$(InLine$), 1)
    CASE "0" TO "9"
      OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
      InLine$ = MID$(InLine$, 2)
    CASE "."
      ERROR 2
    CASE ELSE
      EXIT DO
    END SELECT
   LOOP
   IF OutNumber$ = "" THEN ERROR 2
   InNumber# = VAL("0." + OutNumber$)
 CASE ELSE
   ERROR 2
 END SELECT
END FUNCTION

FUNCTION InputBox% (Title$, Message$, InputTextLine$)
 DIM OutMessage$
 DIM OutIndex%
 DIM WorkKey$
 DIM InputTextCursorColumn%
 DIM InputTextCursorPosition%
 DIM InputText$
 IF LEN(Message$) < 256 THEN OutMessage$ = Message$ + SPACE$(256 - LEN(Message$)) ELSE OutMessage$ = LEFT$(Message$, 256)
 CALL MakeBox(7, 8, 64, 7)
 PRINT LEFT$(Title$, 64) + SPACE$(64 - LEN(LEFT$(Title$, 64)));
 COLOR 1, 7
 FOR OutIndex% = 1 TO 4
  LOCATE 9 + OutIndex%, 8, 0
  PRINT LEFT$(OutMessage$, 64);
  OutMessage$ = MID$(OutMessage$, 65)
 NEXT OutIndex%
 COLOR 14, 7
 LOCATE 15, 8, 0
 PRINT "Please press key is equalient to your answer: ENTER=Yes, ESC=No.";
 InputTextCursorColumn% = 1
 InputTextCursorPosition% = 1
 InputText$ = InputTextLine$
 GOSUB OutInputLine
 DO
  WorkKey$ = INKEY$
  SELECT CASE LEN(WorkKey$)
  CASE 1
    SELECT CASE WorkKey$
    CASE CHR$(8)
      IF InputTextCursorColumn% > 1 THEN
       InputTextCursorColumn% = InputTextCursorColumn% - 1
       InputTextCursorPosition% = InputTextCursorPosition% - 1
       IF InputTextCursorColumn% < 1 THEN InputTextCursorColumn% = 1
       IF InputTextCursorPosition% < 1 THEN InputTextCursorPosition% = 1
       InputText$ = MID$(InputText$, 1, InputTextCursorColumn% - 1) + MID$(InputText$, InputTextCursorColumn% + 1)
       GOSUB OutInputLine
      END IF
    CASE CHR$(13)
      InputTextLine$ = InputText$
      EXIT DO
    CASE CHR$(27)
      EXIT DO
    CASE ELSE
      IF (LEN(InputText$) < 256) AND (ASC(WorkKey$) > (ASC(SPACE$(1)) - 1)) THEN
       InputText$ = MID$(InputText$, 1, InputTextCursorColumn% - 1) + WorkKey$ + MID$(InputText$, InputTextCursorColumn%)
       InputTextCursorColumn% = InputTextCursorColumn% + 1
       InputTextCursorPosition% = InputTextCursorPosition% + 1
       IF InputTextCursorColumn% > LEN(InputText$) + 1 THEN InputTextCursorColumn% = LEN(InputText$) + 1
       IF LEN(InputText$) > 63 THEN IF InputTextCursorPosition% > 64 THEN InputTextCursorPosition% = 64
       IF LEN(InputText$) < 65 THEN IF InputTextCursorPosition% > LEN(InputText$) + 1 THEN InputTextCursorPosition% = LEN(InputText$) + 1
       GOSUB OutInputLine
      END IF
    END SELECT
  CASE 2
    WorkKey$ = MID$(WorkKey$, 2)
    SELECT CASE WorkKey$
    CASE CHR$(75)
      IF InputTextCursorColumn% > 1 THEN
       InputTextCursorColumn% = InputTextCursorColumn% - 1
       InputTextCursorPosition% = InputTextCursorPosition% - 1
       IF InputTextCursorColumn% < 1 THEN InputTextCursorColumn% = 1
       IF InputTextCursorPosition% < 1 THEN InputTextCursorPosition% = 1
       GOSUB OutInputLine
      END IF
    CASE CHR$(77)
      IF InputTextCursorColumn% < LEN(InputText$) + 1 THEN
       InputTextCursorColumn% = InputTextCursorColumn% + 1
       InputTextCursorPosition% = InputTextCursorPosition% + 1
       IF InputTextCursorColumn% > LEN(InputText$) + 1 THEN InputTextCursorColumn% = LEN(InputText$) + 1
       IF LEN(InputText$) > 63 THEN IF InputTextCursorPosition% > 64 THEN InputTextCursorPosition% = 64
       IF LEN(InputText$) < 65 THEN IF InputTextCursorPosition% > LEN(InputText$) + 1 THEN InputTextCursorPosition% = LEN(InputText$) + 1
       GOSUB OutInputLine
      END IF
    CASE CHR$(71)
      IF InputTextCursorColumn% <> 1 THEN
       InputTextCursorColumn% = 1
       InputTextCursorPosition% = 1
       GOSUB OutInputLine
      END IF
    CASE CHR$(79)
      IF InputTextCursorColumn% <> LEN(InputText$) + 1 THEN
       InputTextCursorColumn% = LEN(InputText$) + 1
       InputTextCursorPosition% = LEN(InputText$) + 1
       IF LEN(InputText$) > 63 THEN IF InputTextCursorPosition% > 64 THEN InputTextCursorPosition% = 64
       IF LEN(InputText$) < 65 THEN IF InputTextCursorPosition% > LEN(InputText$) + 1 THEN InputTextCursorPosition% = LEN(InputText$) + 1
       GOSUB OutInputLine
      END IF
    CASE CHR$(83)
      IF InputText$ <> "" THEN
       InputText$ = MID$(InputText$, 1, InputTextCursorColumn% - 1) + MID$(InputText$, InputTextCursorColumn% + 1)
       GOSUB OutInputLine
      END IF
    END SELECT
  END SELECT
 LOOP
 LOCATE , , 0
 InputBox% = WorkKey$ = CHR$(13)
 EXIT FUNCTION
OutInputLine:
 COLOR 4, 7
 LOCATE 14, 8, 0
 PRINT MID$(InputText$, (InputTextCursorColumn% - InputTextCursorPosition%) + 1, 64) + SPACE$(64 - LEN(MID$(InputText$, (InputTextCursorColumn% - InputTextCursorPosition%) + 1, 64)));
 LOCATE 14, 7 + InputTextCursorPosition%, 1, 7, 8
 RETURN
END FUNCTION

FUNCTION InVariable$ (VariableName$, VariableType%, InLine$)
 DIM Index%
 DIM LineNumber%
 DIM NumberOfLine%
 DIM WorkLine$
 DIM WorkName$
 DIM Result$
 DIM SubType%
 DIM ArgType%
 DIM OldSubroutineMode%
 IF DefFnMode% THEN
  IF DefFnSArgsCount%(CurrentDefFn%) = 0 THEN
   DefFnMode% = False%
   InVariable$ = InVariable$(VariableName$, VariableType%, InLine$)
   DefFnMode% = True%
  ELSE
   FOR Index% = 1 TO DefFnSArgsCount%(CurrentDefFn%) + 1
    IF Index% = DefFnSArgsCount%(CurrentDefFn%) + 1 THEN
     DefFnMode% = False%
     InVariable$ = InVariable$(VariableName$, VariableType%, InLine$)
     DefFnMode% = True%
     EXIT FOR
    END IF
    IF (MID$(DefFnSArgs$(CurrentDefFn%, Index%), 1, INSTR(DefFnSArgs$(CurrentDefFn%, Index%), "[") - 1) = VariableName$) AND (VAL(MID$(DefFnSArgs$(CurrentDefFn%, Index%), INSTR(DefFnSArgs$(CurrentDefFn%, Index%), "[") + 1, 1)) = ABS(VariableType%)) THEN
     InVariable$ = MID$(DefFnSArgs$(CurrentDefFn%, Index%), INSTR(DefFnSArgs$(CurrentDefFn%, Index%), "=") + 1)
     EXIT FOR
    END IF
   NEXT Index%
  END IF
 ELSEIF SubroutineMode% THEN
  IF SubroutinesArgumentsCount%(CurrentSubroutine%) = 0 THEN
   SubroutineMode% = False%
   InVariable$ = InVariable$(VariableName$, VariableType%, InLine$)
   SubroutineMode% = True%
  ELSE
   FOR Index% = 1 TO SubroutinesArgumentsCount%(CurrentSubroutine%) + 1
    IF Index% = SubroutinesArgumentsCount%(CurrentSubroutine%) + 1 THEN
     SubroutineMode% = False%
     InVariable$ = InVariable$(VariableName$, VariableType%, InLine$)
     SubroutineMode% = True%
     EXIT FOR
    END IF
    IF (MID$(SubroutinesArguments$(CurrentSubroutine%, Index%), 1, INSTR(SubroutinesArguments$(CurrentSubroutine%, Index%), "[") - 1) = VariableName$) AND (VAL(MID$(SubroutinesArguments$(CurrentSubroutine%, Index%), INSTR(SubroutinesArguments$(CurrentSubroutine%, Index%), "[") + 1, 1)) = ABS(VariableType%)) THEN
     InVariable$ = MID$(SubroutinesArguments$(CurrentSubroutine%, Index%), INSTR(SubroutinesArguments$(CurrentSubroutine%, Index%), "=") + 1)
     EXIT FOR
    END IF
   NEXT Index%
  END IF
 ELSE
  IF RunMode% THEN
   FOR LineNumber% = 1 TO TextLines% + 1
    IF LineNumber% = TextLines% + 1 THEN
     IF VariablesCount% = 0 THEN
      IF VariableType% THEN
       CALL SetVariable(VariableName$, VariableType%, "")
       InVariable$ = ""
      ELSE
       CALL SetVariable(VariableName$, VariableType%, "0")
       InVariable$ = "0"
      END IF
     ELSE
      FOR Index% = 1 TO VariablesCount% + 1
       IF Index% = VariablesCount% + 1 THEN
        IF VariableType% THEN
         CALL SetVariable(VariableName$, VariableType%, "")
         InVariable$ = ""
        ELSE
         CALL SetVariable(VariableName$, VariableType%, "0")
         InVariable$ = "0"
        END IF
        EXIT FOR
       END IF
       IF (MID$(Variables$(Index%), 1, INSTR(Variables$(Index%), "[") - 1) = VariableName$) AND (VAL(MID$(Variables$(Index%), INSTR(Variables$(Index%), "[") + 1, 1)) = ABS(VariableType%)) THEN
        InVariable$ = MID$(Variables$(Index%), INSTR(Variables$(Index%), "=") + 1)
        EXIT FOR
       END IF
      NEXT Index%
     END IF
     EXIT FUNCTION
    END IF
    IF LTRIM$(RTRIM$(Text$(LineNumber%))) <> "" THEN
     WorkLine$ = LTRIM$(RTRIM$(Text$(LineNumber%)))
     SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
     CASE "0" TO "9"
       NumberOfLine% = INT(InNumber#(WorkLine$))
       IF (NumberOfLine% < 1) OR (NumberOfLine% > TextLines%) THEN ERROR 15
       WorkLine$ = LTRIM$(WorkLine$)
       SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
       CASE "A" TO "Z"
         WorkLine$ = ParseRunLine$(WorkLine$)
         IF InName$(WorkLine$) = "SUB" THEN
          Result$ = InName$(WorkLine$)
          WorkLine$ = LTRIM$(WorkLine$)
          SubType% = False%
          SELECT CASE LEFT$(WorkLine$, 1)
          CASE "$"
            SubType% = True%
            WorkLine$ = MID$(WorkLine$, 2)
          CASE "!"
            WorkLine$ = MID$(WorkLine$, 2)
          CASE "@"
            WorkLine$ = MID$(WorkLine$, 2)
           CASE "#"
            WorkLine$ = MID$(WorkLine$, 2)
          CASE "%"
            WorkLine$ = MID$(WorkLine$, 2)
          CASE "&"
            WorkLine$ = MID$(WorkLine$, 2)
          END SELECT
          IF (VariableName$ = Result$) AND (VariableType% = SubType%) THEN EXIT FOR
         END IF
       CASE ELSE
         ERROR 95
       END SELECT
     CASE "A" TO "Z"
       WorkLine$ = ParseRunLine$(WorkLine$)
       IF InName$(WorkLine$) = "SUB" THEN
        Result$ = InName$(WorkLine$)
        WorkLine$ = LTRIM$(WorkLine$)
        SubType% = False%
        SELECT CASE LEFT$(WorkLine$, 1)
        CASE "$"
          SubType% = True%
          WorkLine$ = MID$(WorkLine$, 2)
        CASE "!"
          WorkLine$ = MID$(WorkLine$, 2)
        CASE "@"
          WorkLine$ = MID$(WorkLine$, 2)
         CASE "#"
          WorkLine$ = MID$(WorkLine$, 2)
        CASE "%"
          WorkLine$ = MID$(WorkLine$, 2)
        CASE "&"
          WorkLine$ = MID$(WorkLine$, 2)
        END SELECT
        IF (VariableName$ = Result$) AND (VariableType% = SubType%) THEN EXIT FOR
       END IF
     CASE ELSE
       ERROR 95
     END SELECT
    END IF
   NEXT LineNumber%
   WorkLine$ = LTRIM$(WorkLine$)
   IF CurrentSubroutine% = SubroutinesCountValue% THEN ERROR 88
   CurrentSubroutine% = CurrentSubroutine% + 1
   FOR Index% = 1 TO SubroutinesArgumentsCountValue%
    SubroutinesArguments$(CurrentSubroutine%, Index%) = ""
   NEXT Index%
   SubroutinesArgumentsCount%(CurrentSubroutine%) = 0
   IF LEFT$(WorkLine$, 1) = "(" THEN
    SubroutinesArgumentsCount%(CurrentSubroutine%) = 1
    WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
    DO WHILE WorkLine$ <> ""
     WorkName$ = InName$(WorkLine$)
     WorkLine$ = LTRIM$(WorkLine$)
     ArgType% = False%
     SELECT CASE LEFT$(WorkLine$, 1)
     CASE "$"
       ArgType% = True%
       WorkLine$ = MID$(WorkLine$, 2)
     CASE "!"
       WorkLine$ = MID$(WorkLine$, 2)
     CASE "@"
       WorkLine$ = MID$(WorkLine$, 2)
     CASE "#"
       WorkLine$ = MID$(WorkLine$, 2)
     CASE "%"
       WorkLine$ = MID$(WorkLine$, 2)
     CASE "&"
       WorkLine$ = MID$(WorkLine$, 2)
     END SELECT
     SubroutinesArguments$(CurrentSubroutine%, SubroutinesArgumentsCount%(CurrentSubroutine%)) = WorkName$ + "[" + LTRIM$(STR$(ABS(ArgType%))) + "]="
     WorkLine$ = LTRIM$(WorkLine$)
     SELECT CASE LEFT$(WorkLine$, 1)
     CASE ","
       WorkLine$ = MID$(WorkLine$, 2)
       IF SubroutinesArgumentsCount%(CurrentSubroutine%) = SubroutinesArgumentsCountValue% THEN ERROR 89
       SubroutinesArgumentsCount%(CurrentSubroutine%) = SubroutinesArgumentsCount%(CurrentSubroutine%) + 1
     CASE ")"
       WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
       EXIT DO
     CASE ELSE
       ERROR 2
     END SELECT
    LOOP
    InLine$ = LTRIM$(InLine$)
    IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
    InLine$ = LTRIM$(MID$(InLine$, 2))
    Index% = 1
    DO WHILE InLine$ <> ""
     Result$ = Calculate$(InLine$)
     IF VAL(MID$(SubroutinesArguments$(CurrentSubroutine%, Index%), INSTR(SubroutinesArguments$(CurrentSubroutine%, Index%), "[") + 1, 1)) <> ABS(NumStr%) THEN ERROR 13
     SubroutinesArguments$(CurrentSubroutine%, Index%) = SubroutinesArguments$(CurrentSubroutine%, Index%) + Result$
     InLine$ = LTRIM$(InLine$)
     SELECT CASE LEFT$(InLine$, 1)
     CASE ","
       InLine$ = MID$(InLine$, 2)
       IF Index% = SubroutinesArgumentsCount%(CurrentSubroutine%) THEN ERROR 37
       Index% = Index% + 1
     CASE ")"
       IF Index% <> SubroutinesArgumentsCount%(CurrentSubroutine%) THEN ERROR 37
       InLine$ = LTRIM$(MID$(InLine$, 2))
       EXIT DO
     CASE ELSE
       ERROR 2
     END SELECT
    LOOP
   END IF
   Subroutines$(CurrentSubroutine%) = "Return line=(" + LTRIM$(STR$(CurrentLine%)) + "). Old subroutine mode=[" + LTRIM$(STR$(ABS(SubroutineMode%))) + "]. Subroutine type=[" + LTRIM$(STR$(ABS(VariableType%))) + "]."
   SubroutinesResults$(CurrentSubroutine%) = ""
   OldSubroutineMode% = SubroutineMode%
   SubroutineMode% = True%
   CurrentLine% = LineNumber% + 1
   DO
    IF LTRIM$(RTRIM$(Text$(CurrentLine%))) <> "" THEN
     WorkLine$ = LTRIM$(RTRIM$(Text$(CurrentLine%)))
     SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
     CASE "0" TO "9"
       LineNumber% = INT(InNumber#(WorkLine$))
       IF (LineNumber% < 1) OR (LineNumber% > TextLines%) THEN ERROR 15
       IF TraceMode% THEN PRINT "[" + LTRIM$(STR$(LineNumber%)) + "]";
       WorkLine$ = LTRIM$(WorkLine$)
       SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
       CASE "A" TO "Z"
         WorkLine$ = ParseRunLine$(WorkLine$)
         IF WorkLine$ = "End Sub" THEN EXIT DO
         CALL RunLine(WorkLine$)
       CASE ELSE
         ERROR 95
       END SELECT
     CASE "A" TO "Z"
       WorkLine$ = ParseRunLine$(WorkLine$)
       IF WorkLine$ = "End Sub" THEN EXIT DO
       CALL RunLine(WorkLine$)
     CASE ELSE
       ERROR 95
     END SELECT
    END IF
    CurrentLine% = CurrentLine% + 1
   LOOP UNTIL (CurrentLine% > TextLines%) OR (NOT RunMode%)
   InVariable$ = SubroutinesResults$(CurrentSubroutine%)
   WorkLine$ = MID$(Subroutines$(CurrentSubroutine%), INSTR(Subroutines$(CurrentSubroutine%), "(") + 1)
   CurrentLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
   WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "[") + 1)
   SubroutineMode% = ABS(VAL(MID$(WorkLine$, 1, 1))) = 1
   SubroutinesArgumentsCount%(CurrentSubroutine%) = 0
   SubroutinesResults$(CurrentSubroutine%) = ""
   FOR Index% = 1 TO SubroutinesArgumentsCountValue%
    SubroutinesArguments$(CurrentSubroutine%, Index%) = ""
   NEXT Index%
   Subroutines$(CurrentSubroutine%) = ""
   CurrentSubroutine% = CurrentSubroutine% - 1
   EXIT FUNCTION
  END IF
  IF VariablesCount% = 0 THEN
   IF VariableType% THEN
    CALL SetVariable(VariableName$, VariableType%, "")
    InVariable$ = ""
   ELSE
    CALL SetVariable(VariableName$, VariableType%, "0")
    InVariable$ = "0"
   END IF
  ELSE
   FOR Index% = 1 TO VariablesCount% + 1
    IF Index% = VariablesCount% + 1 THEN
     IF VariableType% THEN
      CALL SetVariable(VariableName$, VariableType%, "")
      InVariable$ = ""
     ELSE
      CALL SetVariable(VariableName$, VariableType%, "0")
      InVariable$ = "0"
     END IF
     EXIT FOR
    END IF
    IF (MID$(Variables$(Index%), 1, INSTR(Variables$(Index%), "[") - 1) = VariableName$) AND (VAL(MID$(Variables$(Index%), INSTR(Variables$(Index%), "[") + 1, 1)) = ABS(VariableType%)) THEN
     InVariable$ = MID$(Variables$(Index%), INSTR(Variables$(Index%), "=") + 1)
     EXIT FOR
    END IF
   NEXT Index%
  END IF
 END IF
END FUNCTION

FUNCTION IsLeapYear% (YearValue%)
 IsLeapYear% = ABS((INT(YearValue% / 4) * 4) = YearValue%)
END FUNCTION

SUB MakeBox (BoxColumn%, BoxRow%, BoxWidth%, BoxHeight%)
 DIM BoxWorkIndex%
 IF (BoxColumn% < 1) OR (BoxRow% < 1) OR (BoxWidth% < 1) OR (BoxHeight% < 1) OR (BoxWidth% > 77) OR (BoxHeight% > 22) OR (((BoxColumn% - 1) + BoxWidth%) > 77) OR (((BoxRow% - 1) + BoxHeight%) > 22) THEN EXIT SUB
 COLOR 0, 7
 LOCATE BoxRow%, BoxColumn%, 0
 PRINT CHR$(201) + STRING$(BoxWidth%, CHR$(205)) + CHR$(187);
 FOR BoxWorkIndex% = 1 TO BoxHeight% + 1
  LOCATE BoxRow% + BoxWorkIndex%, BoxColumn%, 0
  PRINT CHR$(186) + SPACE$(BoxWidth%) + CHR$(186);
  COLOR 0, 0
  PRINT SPACE$(1);
  COLOR 0, 7
 NEXT BoxWorkIndex%
 LOCATE BoxRow% + BoxHeight% + 1, BoxColumn%, 0
 PRINT CHR$(200) + STRING$(BoxWidth%, CHR$(205)) + CHR$(188);
 COLOR 0, 0
 LOCATE BoxRow% + BoxHeight% + 2, BoxColumn% + 1, 0
 PRINT SPACE$(BoxWidth% + 2);
 COLOR 15, 2
 LOCATE BoxRow% + 1, BoxColumn% + 1, 0
END SUB

FUNCTION MenuBox% (ItemsCount%)
 DIM MenuIndex%
 DIM MenuLineLength%
 DIM CurrentItem%
 DIM WorkKey$
 IF (ItemsCount% < 1) OR (ItemsCount% > UBOUND(MenuItems$)) OR (UBOUND(MenuItems$) > 20) THEN
  MenuBox% = 0
  EXIT FUNCTION
 END IF
 MenuLineLength% = 0
 FOR MenuIndex% = 1 TO ItemsCount%
  IF LEN(MenuItems$(MenuIndex%)) > MenuLineLength% THEN MenuLineLength% = LEN(MenuItems$(MenuIndex%))
 NEXT MenuIndex%
 IF MenuLineLength% < 56 THEN MenuLineLength% = 56
 IF MenuLineLength% > 75 THEN MenuLineLength% = 75
 CurrentItem% = 1
 GOSUB OutMenu
 DO
  WorkKey$ = UCASE$(INKEY$)
  SELECT CASE LEN(WorkKey$)
  CASE 1
    SELECT CASE WorkKey$
    CASE CHR$(13)
      MenuBox% = CurrentItem%
      EXIT DO
    CASE CHR$(27)
      MenuBox% = 0
      EXIT DO
    CASE ELSE
      IF (ASC(WorkKey$) > (ASC("A") - 1)) AND (ASC(WorkKey$) < (ASC("A") + ItemsCount%)) THEN
       CurrentItem% = (ASC(WorkKey$) - ASC("A")) + 1
       GOSUB OutMenu
      END IF
    END SELECT
  CASE 2
    WorkKey$ = MID$(WorkKey$, 2)
    SELECT CASE WorkKey$
    CASE CHR$(72)
      IF CurrentItem% > 1 THEN
       CurrentItem% = CurrentItem% - 1
       GOSUB OutMenu
      END IF
    CASE CHR$(80)
      IF CurrentItem% < ItemsCount% THEN
       CurrentItem% = CurrentItem% + 1
       GOSUB OutMenu
      END IF
    CASE CHR$(73)
      IF CurrentItem% <> 1 THEN
       CurrentItem% = 1
       GOSUB OutMenu
      END IF
    CASE CHR$(81)
      IF CurrentItem% <> ItemsCount% THEN
       CurrentItem% = ItemsCount%
       GOSUB OutMenu
      END IF
    CASE CHR$(71)
      IF CurrentItem% <> 1 THEN
       CurrentItem% = 1
       GOSUB OutMenu
      END IF
    CASE CHR$(79)
      IF CurrentItem% <> ItemsCount% THEN
       CurrentItem% = ItemsCount%
       GOSUB OutMenu
      END IF
    END SELECT
  END SELECT
 LOOP
 EXIT FUNCTION
OutMenu:
 CALL MakeBox(INT((80 - (MenuLineLength% + 5)) / 2) + 1, INT((25 - (ItemsCount% + 5)) / 2) + 1, MenuLineLength% + 2, ItemsCount% + 2)
 FOR MenuIndex% = 1 TO ItemsCount%
  COLOR 14, 7
  LOCATE INT((25 - (ItemsCount% + 5)) / 2) + (MenuIndex% + 1), INT((80 - (MenuLineLength% + 5)) / 2) + 2, 0
  PRINT CHR$(ASC("A") + (MenuIndex% - 1));
  COLOR 12, 7
  PRINT "=";
  IF MenuIndex% = CurrentItem% THEN COLOR 15, 6 ELSE COLOR 8, 7
  PRINT LEFT$(MenuItems$(MenuIndex%), MenuLineLength%) + SPACE$(MenuLineLength% - LEN(LEFT$(MenuItems$(MenuIndex%), MenuLineLength%)));
 NEXT MenuIndex%
 COLOR 0, 7
 LOCATE INT((25 - (ItemsCount% + 5)) / 2) + 2 + ItemsCount%, INT((80 - (MenuLineLength% + 5)) / 2) + 1, 0
 PRINT CHR$(204) + STRING$(MenuLineLength% + 2, CHR$(205)) + CHR$(185);
 COLOR 14, 7
 LOCATE INT((25 - (ItemsCount% + 5)) / 2) + 3 + ItemsCount%, INT((80 - (MenuLineLength% + 5)) / 2) + 2, 0
 PRINT SPACE$(INT((MenuLineLength% - 56) / 2) + 1) + "Please press ENTER to select menu item or ESC to cancel."
 RETURN
END FUNCTION

FUNCTION MessageBox% (Title$, Message$)
 DIM OutMessage$
 DIM OutIndex%
 DIM WorkKey$
 IF LEN(Message$) < 256 THEN OutMessage$ = Message$ + SPACE$(256 - LEN(Message$)) ELSE OutMessage$ = LEFT$(Message$, 256)
 CALL MakeBox(7, 9, 64, 6)
 PRINT LEFT$(Title$, 64) + SPACE$(64 - LEN(LEFT$(Title$, 64)));
 COLOR 1, 7
 FOR OutIndex% = 1 TO 4
  LOCATE 10 + OutIndex%, 8, 0
  PRINT LEFT$(OutMessage$, 64);
  OutMessage$ = MID$(OutMessage$, 65)
 NEXT OutIndex%
 COLOR 14, 7
 LOCATE 15, 8, 0
 PRINT "Please press key is equalient to your answer: ENTER=Yes, ESC=No.";
 WorkKey$ = ""
 WHILE (WorkKey$ <> CHR$(13)) AND (WorkKey$ <> CHR$(27))
  WorkKey$ = INKEY$
 WEND
 MessageBox% = WorkKey$ = CHR$(13)
END FUNCTION

FUNCTION MonthDays% (MonthValue%, YearValue%)
 SELECT CASE MonthValue%
 CASE 1
   MonthDays% = 31
 CASE 2
   MonthDays% = 28 + IsLeapYear%(YearValue%)
 CASE 3
   MonthDays% = 31
 CASE 4
   MonthDays% = 30
 CASE 5
   MonthDays% = 31
 CASE 6
   MonthDays% = 30
 CASE 7
   MonthDays% = 31
 CASE 8
   MonthDays% = 31
 CASE 9
   MonthDays% = 30
 CASE 10
   MonthDays% = 31
 CASE 11
   MonthDays% = 30
 CASE 12
   MonthDays% = 31
 END SELECT
END FUNCTION

FUNCTION MonthDaysCount% (MonthValue%, YearValue%)
 SELECT CASE MonthValue%
 CASE 1
   MonthDaysCount% = 0
 CASE 2
   MonthDaysCount% = 31
 CASE 3
   MonthDaysCount% = 59 + IsLeapYear%(YearValue%)
 CASE 4
   MonthDaysCount% = 90 + IsLeapYear%(YearValue%)
 CASE 5
   MonthDaysCount% = 120 + IsLeapYear%(YearValue%)
 CASE 6
   MonthDaysCount% = 151 + IsLeapYear%(YearValue%)
 CASE 7
   MonthDaysCount% = 181 + IsLeapYear%(YearValue%)
 CASE 8
   MonthDaysCount% = 212 + IsLeapYear%(YearValue%)
 CASE 9
   MonthDaysCount% = 243 + IsLeapYear%(YearValue%)
 CASE 10
   MonthDaysCount% = 273 + IsLeapYear%(YearValue%)
 CASE 11
   MonthDaysCount% = 304 + IsLeapYear%(YearValue%)
 CASE 12
   MonthDaysCount% = 334 + IsLeapYear%(YearValue%)
 END SELECT
END FUNCTION

FUNCTION MonthName$ (MonthNumber%)
 SELECT CASE MonthNumber%
 CASE 1
   MonthName$ = "January"
 CASE 2
   MonthName$ = "February"
 CASE 3
   MonthName$ = "March"
 CASE 4
   MonthName$ = "April"
 CASE 5
   MonthName$ = "May"
 CASE 6
   MonthName$ = "June"
 CASE 7
   MonthName$ = "July"
 CASE 8
   MonthName$ = "August"
 CASE 9
   MonthName$ = "September"
 CASE 10
   MonthName$ = "October"
 CASE 11
   MonthName$ = "November"
 CASE 12
   MonthName$ = "December"
 END SELECT
END FUNCTION

SUB OutBox (Title$, Message$)
 DIM OutMessage$
 DIM OutIndex%
 IF LEN(Message$) < 256 THEN OutMessage$ = Message$ + SPACE$(256 - LEN(Message$)) ELSE OutMessage$ = LEFT$(Message$, 256)
 CALL MakeBox(7, 9, 64, 6)
 PRINT LEFT$(Title$, 64) + SPACE$(64 - LEN(LEFT$(Title$, 64)));
 COLOR 1, 7
 FOR OutIndex% = 1 TO 4
  LOCATE 10 + OutIndex%, 8, 0
  PRINT LEFT$(OutMessage$, 64);
  OutMessage$ = MID$(OutMessage$, 65)
 NEXT OutIndex%
 COLOR 14, 7
 LOCATE 15, 8, 0
 PRINT "       Please press the ENTER key to quit from this box.";
 WHILE INKEY$ <> CHR$(13)
 WEND
END SUB

SUB OutHelp
 DIM WorkKey$
 CALL MakeBox(4, 4, 70, 16)
 COLOR 1, 7
 PRINT "System variables:"
 LOCATE 6, 5
 PRINT "        RANDOM"
 LOCATE 7, 5
 PRINT "        If get value, then return the random number. If set value,"
 LOCATE 8, 5
 PRINT "        then reinitializing the random number generator."
 LOCATE 9, 5
 PRINT "        TIMERVALUE"
 LOCATE 10, 5
 PRINT "        This variable location on address: 0000:046C. This variable"
 LOCATE 11, 5
 PRINT "        contain meaning of system timer."
 LOCATE 12, 5
 PRINT "        DATE$"
 LOCATE 13, 5
 PRINT "        This variable contain system date in the format: MM-DD-YYYY."
 LOCATE 14, 5
 PRINT "        TIME$"
 LOCATE 15, 5
 PRINT "        This variable contain system time in the format: HH:MM:SS."
 LOCATE 16, 5
 PRINT "Constans:"
 LOCATE 17, 5
 PRINT "        PI=3.1415926535897932385,BLACK=0,BLUE=1,GREEN=2,CYAN=3,RED=4,"
 LOCATE 18, 5
 PRINT "        MAGENTA=5,BROWN=6,WHITE=7,GRAY=8,LIGHTBLUE=9,LIGHTGREEN=10,"
 LOCATE 19, 5
 PRINT "        LIGHTCYAN=11,LIGHTRED=12,LIGHTMAGENTA=13,YELLOW=14,"
 LOCATE 20, 5
 COLOR 14, 7
 PRINT "Please press the ENTER key to continue or ESC key to cancel.";
 WorkKey$ = CHR$(0)
 WHILE (WorkKey$ <> CHR$(13)) AND (WorkKey$ <> CHR$(27))
 WorkKey$ = INKEY$
 WEND
 IF WorkKey$ = CHR$(27) THEN EXIT SUB
 CALL MakeBox(4, 4, 70, 16)
 COLOR 1, 7
 PRINT "        BRIGHTWHITE=15,TRUE=-1,FALSE=0"
 LOCATE 6, 5
 PRINT "String functions:"
 LOCATE 7, 5
 PRINT "        INKEY$"
 LOCATE 8, 5
 PRINT "        If any numeric or alphabetical key is pressed, the return the"
 LOCATE 9, 5
 PRINT "        one symbol, contain the input symbol. If not keys is pressed,"
 LOCATE 10, 5
 PRINT "        then return the empty string. If pressed the special keys"
 LOCATE 11, 5
 PRINT "        (like F1 - F10), then return two - symbols string: first"
 LOCATE 12, 5
 PRINT "        symbol contain CHR$(0), and next (two) symbol contain symbol"
 LOCATE 13, 5
 PRINT "        with code of pressed key."
 LOCATE 14, 5
 PRINT "        INPUT$[(#FileNumber%)]"
 LOCATE 15, 5
 PRINT "        Read line from file or keyboard. If parenthis and file number"
 LOCATE 16, 5
 PRINT "        is not pointed, then return line, readed from keyboard, else"
 LOCATE 17, 5
 PRINT "        is readed from the file."
 LOCATE 18, 5
 PRINT "        CHR$(Code%)"
 LOCATE 19, 5
 PRINT "        Symbol for code: Code%."
 LOCATE 20, 5
 COLOR 14, 7
 PRINT "Please press the ENTER key to continue or ESC key to cancel.";
 WorkKey$ = CHR$(0)
 WHILE (WorkKey$ <> CHR$(13)) AND (WorkKey$ <> CHR$(27))
 WorkKey$ = INKEY$
 WEND
 IF WorkKey$ = CHR$(27) THEN EXIT SUB
 CALL MakeBox(4, 4, 70, 16)
 COLOR 1, 7
 PRINT "        HEX$(Value&)"
 LOCATE 6, 5
 PRINT "        Hexadecimal string type of number."
 LOCATE 7, 5
 PRINT "        OCT$(Value&)"
 LOCATE 8, 5
 PRINT "        Octal string type of number."
 LOCATE 9, 5
 PRINT "        DAYNAME$(NumberOfDay%)"
 LOCATE 10, 5
 PRINT "        Return name of days (1 - Monday, ... 7 - Sunday)."
 LOCATE 11, 5
 PRINT "        MONTHNAME$(NumberOfMonth%)"
 LOCATE 12, 5
 PRINT "        Return name of month (1 - January, ... 12 - December)."
 LOCATE 13, 5
 PRINT "        SPACE$(Count%)"
 LOCATE 14, 5
 PRINT "        Return the line of spaces."
 LOCATE 15, 5
 PRINT "        STR$(Value#)"
 LOCATE 16, 5
 PRINT "        Convert number to string."
 LOCATE 17, 5
 PRINT "        LCASE$(Line$)"
 LOCATE 18, 5
 PRINT "        Return line, converted to lower case."
 LOCATE 19, 5
 PRINT "        UCASE$(Line$)"
 LOCATE 20, 5
 COLOR 14, 7
 PRINT "Please press the ENTER key to continue or ESC key to cancel.";
 WorkKey$ = CHR$(0)
 WHILE (WorkKey$ <> CHR$(13)) AND (WorkKey$ <> CHR$(27))
 WorkKey$ = INKEY$
 WEND
 IF WorkKey$ = CHR$(27) THEN EXIT SUB
 CALL MakeBox(4, 4, 70, 16)
 COLOR 1, 7
 PRINT "        Return line, converted to upper case."
 LOCATE 6, 5
 PRINT "        LTRIM$(Line$)"
 LOCATE 7, 5
 PRINT "        Return line without leading spaces."
 LOCATE 8, 5
 PRINT "        RTRIM$(Line$)"
 LOCATE 9, 5
 PRINT "        Return line without trailing spaces."
 LOCATE 10, 5
 PRINT "        TRIM$(Line$)"
 LOCATE 11, 5
 PRINT "        Return line without leading and trailing spaces."
 LOCATE 12, 5
 PRINT "        LEFT$(Line$,Count%)"
 LOCATE 13, 5
 PRINT "        Return Count% symbols from the start of line."
 LOCATE 14, 5
 PRINT "        RIGHT$(Line$,Count%)"
 LOCATE 15, 5
 PRINT "        Return Count% symbols from the end of string."
 LOCATE 16, 5
 PRINT "        STRING$(Count%,Line$|Code%)"
 LOCATE 17, 5
 PRINT "        Return Count% of Line$ or symbols for Code%."
 LOCATE 18, 5
 PRINT "        MID$(Line$,Start%,Count%)"
 LOCATE 19, 5
 PRINT "        Return line from Line$, started with Start% symbol, length"
 LOCATE 20, 5
 COLOR 14, 7
 PRINT "Please press the ENTER key to continue or ESC key to cancel.";
 WorkKey$ = CHR$(0)
 WHILE (WorkKey$ <> CHR$(13)) AND (WorkKey$ <> CHR$(27))
 WorkKey$ = INKEY$
 WEND
 IF WorkKey$ = CHR$(27) THEN EXIT SUB
 CALL MakeBox(4, 4, 70, 16)
 COLOR 1, 7
 PRINT "        of Count%."
 LOCATE 6, 5
 PRINT "        DAYOFWEEKNAME$(Day%,Month%,Year%)"
 LOCATE 7, 5
 PRINT "        Return day of week name."
 LOCATE 8, 5
 PRINT "        ENVIRON$(NumberOfVariable%|VariableName$)"
 LOCATE 9, 5
 PRINT "        Return value of environement variable."
 LOCATE 10, 5
 PRINT "        MIN$(Line$[,Line$...])"
 LOCATE 11, 5
 PRINT "        Return minimal string."
 LOCATE 12, 5
 PRINT "        MAX$(Line$[,Line$...])"
 LOCATE 13, 5
 PRINT "        Return maximal string."
 LOCATE 14, 5
 PRINT "Numeric functions:"
 LOCATE 15, 5
 PRINT "        CSRLIN"
 LOCATE 16, 5
 PRINT "        Return value of row of current screen cursor position."
 LOCATE 17, 5
 PRINT "        TIMER"
 LOCATE 18, 5
 PRINT "        Return value of seconds from the start of day."
 LOCATE 19, 5
 PRINT "        POS(AnyExpression)"
 LOCATE 20, 5
 COLOR 14, 7
 PRINT "Please press the ENTER key to continue or ESC key to cancel.";
 WorkKey$ = CHR$(0)
 WHILE (WorkKey$ <> CHR$(13)) AND (WorkKey$ <> CHR$(27))
 WorkKey$ = INKEY$
 WEND
 IF WorkKey$ = CHR$(27) THEN EXIT SUB
 CALL MakeBox(4, 4, 70, 16)
 COLOR 1, 7
 PRINT "        Return value of column of current screen cursor position."
 LOCATE 6, 5
 PRINT "        SQR(Value#)"
 LOCATE 7, 5
 PRINT "        Return square root of Value#."
 LOCATE 8, 5
 PRINT "        ABS(Value#)"
 LOCATE 9, 5
 PRINT "        Return absolute value of Value#."
 LOCATE 10, 5
 PRINT "        ATN(Value#)"
 LOCATE 11, 5
 PRINT "        Return arctangent of Value#."
 LOCATE 12, 5
 PRINT "        COS(Value#)"
 LOCATE 13, 5
 PRINT "        Return cosine of Value#."
 LOCATE 14, 5
 PRINT "        EXP(Value#)"
 LOCATE 15, 5
 PRINT "        Return exponent of Value#."
 LOCATE 16, 5
 PRINT "        FIX(Value#)"
 LOCATE 17, 5
 PRINT "        Returns a whole number, round before the nearest whole"
 LOCATE 18, 5
 PRINT "        number."
 LOCATE 19, 5
 PRINT "        INT(Value#)"
 LOCATE 20, 5
 COLOR 14, 7
 PRINT "Please press the ENTER key to continue or ESC key to cancel.";
 WorkKey$ = CHR$(0)
 WHILE (WorkKey$ <> CHR$(13)) AND (WorkKey$ <> CHR$(27))
 WorkKey$ = INKEY$
 WEND
 IF WorkKey$ = CHR$(27) THEN EXIT SUB
 CALL MakeBox(4, 4, 70, 16)
 COLOR 1, 7
 PRINT "        Return integer (whole) part of Value#."
 LOCATE 6, 5
 PRINT "        LOG(Value#)"
 LOCATE 7, 5
 PRINT "        Return logarifm of Value#."
 LOCATE 8, 5
 PRINT "        SIN(Value#)"
 LOCATE 9, 5
 PRINT "        Return sine of Value#."
 LOCATE 10, 5
 PRINT "        TAN(Value#)"
 LOCATE 11, 5
 PRINT "        Return tangent of Value#."
 LOCATE 12, 5
 PRINT "        SGN(Value#)"
 LOCATE 13, 5
 PRINT "        If whole part of value is 0, then return 0. If Value# is less"
 LOCATE 14, 5
 PRINT "        than 0, then return -1. If value is greater than 0, return 1."
 LOCATE 15, 5
 PRINT "        EOF(#FileNumber%)"
 LOCATE 16, 5
 PRINT "        If end of file marker is present, return the True (-1), else"
 LOCATE 17, 5
 PRINT "        return the False (0)."
 LOCATE 18, 5
 PRINT "        LOF(#FileNumber%)"
 LOCATE 19, 5
 PRINT "        Return length in bytes of file."
 LOCATE 20, 5
 COLOR 14, 7
 PRINT "Please press the ENTER key to continue or ESC key to cancel.";
 WorkKey$ = CHR$(0)
 WHILE (WorkKey$ <> CHR$(13)) AND (WorkKey$ <> CHR$(27))
 WorkKey$ = INKEY$
 WEND
 IF WorkKey$ = CHR$(27) THEN EXIT SUB
 CALL MakeBox(4, 4, 70, 16)
 COLOR 1, 7
 PRINT "        ASC(Line$)"
 LOCATE 6, 5
 PRINT "        Return code of first symbol of string."
 LOCATE 7, 5
 PRINT "        LEN(Line$)"
 LOCATE 8, 5
 PRINT "        Return length of line."
 LOCATE 9, 5
 PRINT "        CRC(Line$)"
 LOCATE 10, 5
 PRINT "        Return CRC-32 code of line."
 LOCATE 11, 5
 PRINT "        VAL(NumberLine$)"
 LOCATE 12, 5
 PRINT "        Return numeric string, convert it to number."
 LOCATE 13, 5
 PRINT "        INSTR(Line$,SubLine$)"
 LOCATE 14, 5
 PRINT "        Return first position of SubLine$ in the Line$."
 LOCATE 15, 5
 PRINT "        DAYOFWEEK(Day%,Month%,Year%)"
 LOCATE 16, 5
 PRINT "        Return the day of week number (1 - Monday, ... 7 - Sunday)."
 LOCATE 17, 5
 PRINT "        WEEKNUMBER(Day%,Month%,Year%)"
 LOCATE 18, 5
 PRINT "        Return week number of start of the given year."
 LOCATE 19, 5
 PRINT "        ISLEAPYEAR(Year%)"
 LOCATE 20, 5
 COLOR 14, 7
 PRINT "Please press the ENTER key to continue or ESC key to cancel.";
 WorkKey$ = CHR$(0)
 WHILE (WorkKey$ <> CHR$(13)) AND (WorkKey$ <> CHR$(27))
 WorkKey$ = INKEY$
 WEND
 IF WorkKey$ = CHR$(27) THEN EXIT SUB
 CALL MakeBox(4, 4, 70, 16)
 COLOR 1, 7
 PRINT "        If is leap year, then return True (-1), else return False"
 LOCATE 6, 5
 PRINT "        (0)."
 LOCATE 7, 5
 PRINT "        MIN(Value#[,Value#...])"
 LOCATE 8, 5
 PRINT "        Return minimal value."
 LOCATE 9, 5
 PRINT "        MAX(Value#[,Value#...])"
 LOCATE 10, 5
 PRINT "        Return maximal value."
 LOCATE 11, 5
 PRINT "        AVG(Value#[,Value#...])"
 LOCATE 12, 5
 PRINT "        Return average value."
 LOCATE 13, 5
 PRINT "Statements:"
 LOCATE 14, 5
 PRINT "        BEEP"
 LOCATE 15, 5
 PRINT "        Beeping the beep."
 LOCATE 16, 5
 PRINT "        REM [Comment.]"
 LOCATE 17, 5
 PRINT "        This statement can include your comment lines to program."
 LOCATE 18, 5
 PRINT "        SYSTEM"
 LOCATE 19, 5
 PRINT "        Quit from the interpretter."
 LOCATE 20, 5
 COLOR 14, 7
 PRINT "Please press the ENTER key to continue or ESC key to cancel.";
 WorkKey$ = CHR$(0)
 WHILE (WorkKey$ <> CHR$(13)) AND (WorkKey$ <> CHR$(27))
 WorkKey$ = INKEY$
 WEND
 IF WorkKey$ = CHR$(27) THEN EXIT SUB
 CALL MakeBox(4, 4, 70, 16)
 COLOR 1, 7
 PRINT "        CLS"
 LOCATE 6, 5
 PRINT "        Clear the screen."
 LOCATE 7, 5
 PRINT "        REBOOT"
 LOCATE 8, 5
 PRINT "        Reboot the computer."
 LOCATE 9, 5
 PRINT "        HANG"
 LOCATE 10, 5
 PRINT "        Hang the computer."
 LOCATE 11, 5
 PRINT "        OPEN FileName$ FOR INPUT|OUTPUT|APPEND AS #FileNumber%"
 LOCATE 12, 5
 PRINT "        Open file."
 LOCATE 13, 5
 PRINT "        CLOSE #FileNumber%"
 LOCATE 14, 5
 PRINT "        Close file."
 LOCATE 15, 5
 PRINT "        PRINT [#FileNumber%,]Expression"
 LOCATE 16, 5
 PRINT "        Out meaning to file of screen."
 LOCATE 17, 5
 PRINT "        LET VariableName=Expression"
 LOCATE 18, 5
 PRINT "        Set value for variable."
 LOCATE 19, 5
 PRINT "        DEF FNNAME[(Argument[,Argument...])]=Expression"
 LOCATE 20, 5
 COLOR 14, 7
 PRINT "Please press the ENTER key to continue or ESC key to cancel.";
 WorkKey$ = CHR$(0)
 WHILE (WorkKey$ <> CHR$(13)) AND (WorkKey$ <> CHR$(27))
 WorkKey$ = INKEY$
 WEND
 IF WorkKey$ = CHR$(27) THEN EXIT SUB
 CALL MakeBox(4, 4, 70, 16)
 COLOR 1, 7
 PRINT "        Declare the user - defined function."
 LOCATE 6, 5
 PRINT "        LOCATE Column%,Row%"
 LOCATE 7, 5
 PRINT "        Change location of display cursor."
 LOCATE 8, 5
 PRINT "        COLOR ForeGround% ON BackGround%"
 LOCATE 9, 5
 PRINT "        Change current color of the screen."
 LOCATE 10, 5
 PRINT "        SOUND Frequency&,Duration&"
 LOCATE 11, 5
 PRINT "        Play a sound."
 LOCATE 12, 5
 PRINT "        SLEEP Seconds#"
 LOCATE 13, 5
 PRINT "        Stop program execution to Seconds# second. This value can be"
 LOCATE 14, 5
 PRINT "        less than 1 (sample: 0.001 - the sleep to 1 milisecond)."
 LOCATE 15, 5
 PRINT "        MKDIR DirectoryName$"
 LOCATE 16, 5
 PRINT "        Create new directory."
 LOCATE 17, 5
 PRINT "        CHDIR DirectoryName$"
 LOCATE 18, 5
 PRINT "        Change current directory."
 LOCATE 19, 5
 PRINT "        RMDIR DirectoryName$"
 LOCATE 20, 5
 COLOR 14, 7
 PRINT "Please press the ENTER key to continue or ESC key to cancel.";
 WorkKey$ = CHR$(0)
 WHILE (WorkKey$ <> CHR$(13)) AND (WorkKey$ <> CHR$(27))
 WorkKey$ = INKEY$
 WEND
 IF WorkKey$ = CHR$(27) THEN EXIT SUB
 CALL MakeBox(4, 4, 70, 16)
 COLOR 1, 7
 PRINT "        Remove directory."
 LOCATE 6, 5
 PRINT "        KILL FileMask$"
 LOCATE 7, 5
 PRINT "        Delete files."
 LOCATE 8, 5
 PRINT "        FILES FileMask$"
 LOCATE 9, 5
 PRINT "        Out to screen list of files. File mask can contain the path"
 LOCATE 10, 5
 PRINT "        to files."
 LOCATE 11, 5
 PRINT "        SHELL Command$"
 LOCATE 12, 5
 PRINT "        Call command interpretter (Command.com) with command."
 LOCATE 13, 5
 PRINT "        NAME OldFileOrDirectoryName$ AS NewFileOrDirectoryName$"
 LOCATE 14, 5
 PRINT "        Rename file or directory."
 LOCATE 15, 5
 PRINT "        SWAP Variable,Variable"
 LOCATE 16, 5
 PRINT "        Swap values of variables."
 LOCATE 17, 5
 PRINT "        GO TO|SUB LineNumber%|LabelName$"
 LOCATE 18, 5
 PRINT "        Perform call GO TO or GO SUB statement."
 LOCATE 19, 5
 PRINT "        RETURN"
 LOCATE 20, 5
 COLOR 14, 7
 PRINT "Please press the ENTER key to continue or ESC key to cancel.";
 WorkKey$ = CHR$(0)
 WHILE (WorkKey$ <> CHR$(13)) AND (WorkKey$ <> CHR$(27))
 WorkKey$ = INKEY$
 WEND
 IF WorkKey$ = CHR$(27) THEN EXIT SUB
 CALL MakeBox(4, 4, 70, 16)
 COLOR 1, 7
 PRINT "        Return from the GO SUB linear subroutine."
 LOCATE 6, 5
 PRINT "        SCREEN FOURTY|EIGHTY|MONO|COLOR"
 LOCATE 7, 5
 PRINT "        Change current screen mode. FOURTY - color, 40x25 mode;"
 LOCATE 8, 5
 PRINT "        EIGHTY - color, 80x25 mode; MONO - monocrome, 80x25 mode;"
 LOCATE 9, 5
 PRINT "        COLOR - color, 80x25 mode."
 LOCATE 10, 5
 PRINT "        TRON"
 LOCATE 11, 5
 PRINT "        Turn trace mode to on."
 LOCATE 12, 5
 PRINT "        TROFF"
 LOCATE 13, 5
 PRINT "        Turn trace mode to off."
 LOCATE 14, 5
 PRINT "        END"
 LOCATE 15, 5
 PRINT "        End of current program execution."
 LOCATE 16, 5
 PRINT "        EXIT WHILE|FROM|SUB"
 LOCATE 17, 5
 PRINT "        Perform exit from current repeat WHILE or FROM."
 LOCATE 18, 5
 PRINT "        FROM Variable=StartValue TO EndValue [STEP=Value]"
 LOCATE 19, 5
 PRINT "        NEXT Variable"
 LOCATE 20, 5
 COLOR 14, 7
 PRINT "Please press the ENTER key to continue or ESC key to cancel.";
 WorkKey$ = CHR$(0)
 WHILE (WorkKey$ <> CHR$(13)) AND (WorkKey$ <> CHR$(27))
 WorkKey$ = INKEY$
 WEND
 IF WorkKey$ = CHR$(27) THEN EXIT SUB
 CALL MakeBox(4, 4, 70, 16)
 COLOR 1, 7
 PRINT "        FROM (like FOR in other programming languages) repeat."
 LOCATE 6, 5
 PRINT "        STEP value can be less than 0."
 LOCATE 7, 5
 PRINT "        WHILE Conditional"
 LOCATE 8, 5
 PRINT "        WEND"
 LOCATE 9, 5
 PRINT "        The WHILE repeat."
 LOCATE 10, 5
 PRINT "        LABEL LabelName$"
 LOCATE 11, 5
 PRINT "        Define label."
 LOCATE 12, 5
 PRINT "        IF Conditional THEN Statement [ELSE Statement]"
 LOCATE 13, 5
 PRINT "        ... or ..."
 LOCATE 14, 5
 PRINT "        IF Conditional THEN"
 LOCATE 15, 5
 PRINT "         Statement"
 LOCATE 16, 5
 PRINT "        [ELSE"
 LOCATE 17, 5
 PRINT "          Statement]"
 LOCATE 18, 5
 PRINT "        END IF"
 LOCATE 19, 5
 PRINT "        The standart IF conditional operator."
 LOCATE 20, 5
 COLOR 14, 7
 PRINT "Please press the ENTER key to continue or ESC key to cancel.";
 WorkKey$ = CHR$(0)
 WHILE (WorkKey$ <> CHR$(13)) AND (WorkKey$ <> CHR$(27))
 WorkKey$ = INKEY$
 WEND
 IF WorkKey$ = CHR$(27) THEN EXIT SUB
 CALL MakeBox(4, 4, 70, 16)
 COLOR 1, 7
 PRINT "        SUB SubroutineName[(Argument[,Argument...])]"
 LOCATE 6, 5
 PRINT "        [SUBRESULT=Expession]"
 LOCATE 7, 5
 PRINT "        END SUB"
 LOCATE 8, 5
 PRINT "        Declare subroutine. Subroutines can be called as functions."
 LOCATE 9, 5
 PRINT "        CALL SubroutineName[(Expression[,Expression...])]"
 LOCATE 10, 5
 PRINT "        Call subroutine."
 LOCATE 11, 5
 PRINT "        SELECT CASE Expression"
 LOCATE 12, 5
 PRINT "        [CASE Expression"
 LOCATE 13, 5
 PRINT "         Statement"
 LOCATE 14, 5
 PRINT "         ...]"
 LOCATE 15, 5
 PRINT "        [CASE ELSE"
 LOCATE 16, 5
 PRINT "         Statement"
 LOCATE 17, 5
 PRINT "         ...]"
 LOCATE 18, 5
 PRINT "        END SELECT"
 LOCATE 19, 5
 PRINT "        The SELECT CASE select statement."
 LOCATE 20, 5
 COLOR 14, 7
 PRINT "Please press the ENTER key to continue or ESC key to cancel.";
 WorkKey$ = CHR$(0)
 WHILE (WorkKey$ <> CHR$(13)) AND (WorkKey$ <> CHR$(27))
 WorkKey$ = INKEY$
 WEND
 IF WorkKey$ = CHR$(27) THEN EXIT SUB
 CALL MakeBox(4, 4, 70, 16)
 COLOR 1, 7
 PRINT "Operators:"
 LOCATE 6, 5
 PRINT "        Value[!|@|#|$|%|&]      +          Value[!|@|#|$|%|&]"
 LOCATE 7, 5
 PRINT "        Value[!|@|#|%|&]        -          Value[!|@|#|%|&]"
 LOCATE 8, 5
 PRINT "        Value[!|@|#|%|&]        \          Value[!|@|#|%|&]"
 LOCATE 9, 5
 PRINT "        Value[!|@|#|%|&]        /          Value[!|@|#|%|&]"
 LOCATE 10, 5
 PRINT "        Value[!|@|#|%|&]        *          Value[!|@|#|%|&]"
 LOCATE 11, 5
 PRINT "        Value[!|@|#|%|&]        ^          Value[!|@|#|%|&]"
 LOCATE 12, 5
 PRINT "        Value[!|@|#|$|%|&]      =          Value[!|@|#|$|%|&]"
 LOCATE 13, 5
 PRINT "        Value[!|@|#|$|%|&]      <          Value[!|@|#|$|%|&]"
 LOCATE 14, 5
 PRINT "        Value[!|@|#|$|%|&]      >          Value[!|@|#|$|%|&]"
 LOCATE 15, 5
 PRINT "        Value[!|@|#|$|%|&]      <=         Value[!|@|#|$|%|&]"
 LOCATE 16, 5
 PRINT "        Value[!|@|#|$|%|&]      =>         Value[!|@|#|$|%|&]"
 LOCATE 17, 5
 PRINT "        Value[!|@|#|$|%|&]      =<         Value[!|@|#|$|%|&]"
 LOCATE 18, 5
 PRINT "        Value[!|@|#|$|%|&]      >=         Value[!|@|#|$|%|&]"
 LOCATE 19, 5
 PRINT "        Value[!|@|#|$|%|&]      <>         Value[!|@|#|$|%|&]"
 LOCATE 20, 5
 COLOR 14, 7
 PRINT "Please press the ENTER key to continue or ESC key to cancel.";
 WorkKey$ = CHR$(0)
 WHILE (WorkKey$ <> CHR$(13)) AND (WorkKey$ <> CHR$(27))
 WorkKey$ = INKEY$
 WEND
 IF WorkKey$ = CHR$(27) THEN EXIT SUB
 CALL MakeBox(4, 4, 70, 16)
 COLOR 1, 7
 PRINT "        Value[!|@|#|$|%|&]      ><         Value[!|@|#|$|%|&]"
 LOCATE 6, 5
 PRINT "        Value[!|@|#|%|&]        AND        Value[!|@|#|%|&]"
 LOCATE 7, 5
 PRINT "        Value[!|@|#|%|&]        OR         Value[!|@|#|%|&]"
 LOCATE 8, 5
 PRINT "        Value[!|@|#|%|&]        XOR        Value[!|@|#|%|&]"
 LOCATE 9, 5
 PRINT "        Value[!|@|#|%|&]        MOD        Value[!|@|#|%|&]"
 LOCATE 10, 5
 PRINT "                                NOT        Value[!|@|#|%|&]"
 LOCATE 11, 5
 PRINT "Settings:"
 LOCATE 12, 5
 PRINT "        Size of BASIC text lines area - 100 lines."
 LOCATE 13, 5
 PRINT "        Maximal count of user - defined funtions - 4."
 LOCATE 14, 5
 PRINT "        Maximal count of arguments for user - defined functions - 4."
 LOCATE 15, 5
 PRINT "        Maximal count of variables - 8."
 LOCATE 16, 5
 PRINT "        Maximal count of GO SUB subroutines - 4."
 LOCATE 17, 5
 PRINT "        Maximal count of files - 4."
 LOCATE 18, 5
 PRINT "        Maximal count of parameters for ANSI escape sequences - 4."
 LOCATE 19, 5
 PRINT "        Maximal count of WHILE's - 4."
 LOCATE 20, 5
 COLOR 14, 7
 PRINT "Please press the ENTER key to continue or ESC key to cancel.";
 WorkKey$ = CHR$(0)
 WHILE (WorkKey$ <> CHR$(13)) AND (WorkKey$ <> CHR$(27))
 WorkKey$ = INKEY$
 WEND
 IF WorkKey$ = CHR$(27) THEN EXIT SUB
 CALL MakeBox(4, 4, 70, 16)
 COLOR 1, 7
 PRINT "        Maximal count of FROM's - 4."
 LOCATE 20, 5
 COLOR 14, 7
 PRINT "Please press the ENTER key to continue or ESC key to cancel.";
 WorkKey$ = CHR$(0)
 WHILE (WorkKey$ <> CHR$(13)) AND (WorkKey$ <> CHR$(27))
 WorkKey$ = INKEY$
 WEND
 IF WorkKey$ = CHR$(27) THEN EXIT SUB
END SUB

SUB OutText
 DIM Index%
 CALL MakeBox(1, 1, 77, 22)
 COLOR 1, 7
 FOR Index% = 1 TO 20
  LOCATE Index% + 1, 2, 0
  PRINT SPACE$(77);
  LOCATE Index% + 1, 2, 0
  PRINT MID$(Text$((TextRow% - TextPosition%) + Index%), (TextColumn% - LinePosition%) + 1, 77);
 NEXT Index%
 COLOR 2, 7
 LOCATE 22, 2, 0
 PRINT SPACE$(77);
 LOCATE 22, 2, 0
 PRINT "Column=" + LTRIM$(STR$(TextColumn%)) + ". Row=" + LTRIM$(STR$(TextRow%)) + ". File=" + TextName$ + ". ESC=Menu.";
 COLOR 4, 7
 LOCATE 23, 2, 0
 PRINT SPACE$(77);
 LOCATE 23, 2, 0
 PRINT StatusText$;
 COLOR 1, 7
 LOCATE TextPosition% + 1, LinePosition% + 1, 1, 7, 8
END SUB

SUB PageDown
 TextRow% = TextRow% + 20
 TextPosition% = TextPosition% + 20
 CALL ControlCoordinates
END SUB

SUB PageUp
 TextRow% = TextRow% - 20
 TextPosition% = TextPosition% - 20
 CALL ControlCoordinates
END SUB

FUNCTION ParseCalculate$ (InLine$)
 DIM Result$
 DIM Value$
 DIM SavedLine$
 Result$ = ParseInMeaning$(InLine$)
 InLine$ = LTRIM$(InLine$)
 DO WHILE InLine$ <> ""
  SELECT CASE LEFT$(UCASE$(InLine$), 1)
  CASE "+"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "+" + ParseInMeaning$(InLine$)
  CASE "-"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "-" + ParseInMeaning$(InLine$)
  CASE "/"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "/" + ParseInMeaning$(InLine$)
  CASE "\"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "/" + ParseInMeaning$(InLine$)
  CASE "*"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "*" + ParseInMeaning$(InLine$)
  CASE "^"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "^" + ParseInMeaning$(InLine$)
  CASE "="
    InLine$ = LTRIM$(MID$(InLine$, 2))
    SELECT CASE LEFT$(InLine$, 1)
    CASE "<"
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "<=" + ParseInMeaning$(InLine$)
    CASE ">"
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "=>" + ParseInMeaning$(InLine$)
    CASE ELSE
      Result$ = Result$ + "=" + ParseInMeaning$(InLine$)
    END SELECT
  CASE "<"
    InLine$ = LTRIM$(MID$(InLine$, 2))
    SELECT CASE LEFT$(InLine$, 1)
    CASE ">"
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "<>" + ParseInMeaning$(InLine$)
    CASE "="
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "<=" + ParseInMeaning$(InLine$)
    CASE ELSE
      Result$ = Result$ + "<" + ParseInMeaning$(InLine$)
    END SELECT
  CASE ">"
    InLine$ = LTRIM$(MID$(InLine$, 2))
    SELECT CASE LEFT$(InLine$, 1)
    CASE "<"
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "<>" + ParseInMeaning$(InLine$)
    CASE "="
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "=>" + ParseInMeaning$(InLine$)
    CASE ELSE
      Result$ = Result$ + ">" + ParseInMeaning$(InLine$)
    END SELECT
    NumStr% = False%
  CASE "A" TO "Z"
    SavedLine$ = InLine$
    SELECT CASE InName$(InLine$)
    CASE "AND"
      Result$ = Result$ + " And " + ParseInMeaning$(InLine$)
    CASE "OR"
      Result$ = Result$ + " Or " + ParseInMeaning$(InLine$)
    CASE "XOR"
      Result$ = Result$ + " XOr " + ParseInMeaning$(InLine$)
    CASE "MOD"
      Result$ = Result$ + " Mod " + ParseInMeaning$(InLine$)
    CASE ELSE
      InLine$ = SavedLine$
      EXIT DO
    END SELECT
  CASE ELSE
    EXIT DO
  END SELECT
  InLine$ = LTRIM$(InLine$)
 LOOP
 ParseCalculate$ = Result$
END FUNCTION

FUNCTION ParseCalculateExpression$ (InLine$)
 DIM Result$
 DIM Value$
 DIM SavedLine$
 Result$ = ParseInMeaningOfExpression$(InLine$)
 InLine$ = LTRIM$(InLine$)
 DO WHILE InLine$ <> ""
  SELECT CASE LEFT$(UCASE$(InLine$), 1)
  CASE "+"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "+" + ParseInMeaningOfExpression$(InLine$)
  CASE "-"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "-" + ParseInMeaningOfExpression$(InLine$)
  CASE "/"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "/" + ParseInMeaningOfExpression$(InLine$)
  CASE "\"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "/" + ParseInMeaningOfExpression$(InLine$)
  CASE "*"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "*" + ParseInMeaningOfExpression$(InLine$)
  CASE "^"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "^" + ParseInMeaningOfExpression$(InLine$)
  CASE "="
    InLine$ = LTRIM$(MID$(InLine$, 2))
    SELECT CASE LEFT$(InLine$, 1)
    CASE "<"
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "<=" + ParseInMeaningOfExpression$(InLine$)
    CASE ">"
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "=>" + ParseInMeaningOfExpression$(InLine$)
    CASE ELSE
      Result$ = Result$ + "=" + ParseInMeaningOfExpression$(InLine$)
    END SELECT
  CASE "<"
    InLine$ = LTRIM$(MID$(InLine$, 2))
    SELECT CASE LEFT$(InLine$, 1)
    CASE ">"
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "<>" + ParseInMeaningOfExpression$(InLine$)
    CASE "="
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "<=" + ParseInMeaningOfExpression$(InLine$)
    CASE ELSE
      Result$ = Result$ + "<" + ParseInMeaningOfExpression$(InLine$)
    END SELECT
  CASE ">"
    InLine$ = LTRIM$(MID$(InLine$, 2))
    SELECT CASE LEFT$(InLine$, 1)
    CASE "<"
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "<>" + ParseInMeaningOfExpression$(InLine$)
    CASE "="
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "=>" + ParseInMeaningOfExpression$(InLine$)
    CASE ELSE
      Result$ = Result$ + ">" + ParseInMeaningOfExpression$(InLine$)
    END SELECT
    NumStr% = False%
  CASE "A" TO "Z"
    SavedLine$ = InLine$
    SELECT CASE InName$(InLine$)
    CASE "AND"
      Result$ = Result$ + " And " + ParseInMeaningOfExpression$(InLine$)
    CASE "OR"
      Result$ = Result$ + " Or " + ParseInMeaningOfExpression$(InLine$)
    CASE "XOR"
      Result$ = Result$ + " XOr " + ParseInMeaningOfExpression$(InLine$)
    CASE "MOD"
      Result$ = Result$ + " Mod " + ParseInMeaningOfExpression$(InLine$)
    CASE ELSE
      InLine$ = SavedLine$
      EXIT DO
    END SELECT
  CASE ELSE
    EXIT DO
  END SELECT
  InLine$ = LTRIM$(InLine$)
 LOOP
 ParseCalculateExpression$ = Result$
END FUNCTION

FUNCTION ParseInMeaning$ (InLine$)
 DIM Result$
 DIM WorkName$
 InLine$ = LTRIM$(InLine$)
 SELECT CASE LEFT$(UCASE$(InLine$), 1)
 CASE "+"
   InLine$ = MID$(InLine$, 2)
   ParseInMeaning$ = ParseCalculate$(InLine$)
 CASE "-"
   InLine$ = MID$(InLine$, 2)
   ParseInMeaning$ = "-" + ParseCalculate$(InLine$)
 CASE "0" TO "9"
   ParseInMeaning$ = ParseInNumber$(InLine$)
 CASE "."
   ParseInMeaning$ = ParseInNumber$(InLine$)
 CASE "&"
   ParseInMeaning$ = ParseInNumber$(InLine$)
 CASE CHR$(34)
   InLine$ = MID$(InLine$, 2)
   IF INSTR(InLine$, CHR$(34)) = 0 THEN ERROR 2
   ParseInMeaning$ = CHR$(34) + MID$(InLine$, 1, INSTR(InLine$, CHR$(34)) - 1) + CHR$(34)
   InLine$ = MID$(InLine$, INSTR(InLine$, CHR$(34)) + 1)
 CASE "("
   InLine$ = MID$(InLine$, 2)
   ParseInMeaning$ = "(" + ParseCalculate$(InLine$) + ")"
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
 CASE "A" TO "Z"
   WorkName$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     Result$ = "$"
     InLine$ = MID$(InLine$, 2)
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF WorkName$ = "NOT" THEN
    ParseInMeaning$ = "Not " + ParseCalculate$(InLine$)
   ELSE
    Result$ = UCASE$(LEFT$(WorkName$, 1)) + LCASE$(MID$(WorkName$, 2)) + Result$
    IF LEFT$(InLine$, 1) = "(" THEN
     Result$ = Result$ + "("
     InLine$ = LTRIM$(MID$(InLine$, 2))
     IF LEFT$(InLine$, 1) = "#" THEN
      Result$ = Result$ + "#"
      InLine$ = LTRIM$(MID$(InLine$, 2))
     END IF
     DO WHILE InLine$ <> ""
      Result$ = Result$ + ParseCalculate$(InLine$)
      InLine$ = LTRIM$(InLine$)
      SELECT CASE LEFT$(InLine$, 1)
      CASE ","
        Result$ = Result$ + ","
        InLine$ = MID$(InLine$, 2)
      CASE ")"
        EXIT DO
      CASE ELSE
        ERROR 2
      END SELECT
     LOOP
     IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
     Result$ = Result$ + ")"
     InLine$ = MID$(InLine$, 2)
    END IF
    ParseInMeaning$ = Result$
   END IF
 CASE ELSE
   ERROR 2
 END SELECT
END FUNCTION

FUNCTION ParseInMeaningOfExpression$ (InLine$)
 DIM Result$
 DIM WorkName$
 InLine$ = LTRIM$(InLine$)
 SELECT CASE LEFT$(UCASE$(InLine$), 1)
 CASE "+"
   InLine$ = MID$(InLine$, 2)
   ParseInMeaningOfExpression$ = ParseCalculate$(InLine$)
 CASE "-"
   InLine$ = MID$(InLine$, 2)
   ParseInMeaningOfExpression$ = "-" + ParseCalculate$(InLine$)
 CASE "0" TO "9"
   ParseInMeaningOfExpression$ = ParseInNumber$(InLine$)
 CASE "."
   ParseInMeaningOfExpression$ = ParseInNumber$(InLine$)
 CASE "&"
   ParseInMeaningOfExpression$ = ParseInNumber$(InLine$)
 CASE CHR$(34)
   InLine$ = MID$(InLine$, 2)
   IF INSTR(InLine$, CHR$(34)) = 0 THEN ERROR 2
   ParseInMeaningOfExpression$ = CHR$(34) + MID$(InLine$, 1, INSTR(InLine$, CHR$(34)) - 1) + CHR$(34)
   InLine$ = MID$(InLine$, INSTR(InLine$, CHR$(34)) + 1)
 CASE "("
   InLine$ = MID$(InLine$, 2)
   ParseInMeaningOfExpression$ = "(" + ParseCalculate$(InLine$) + ")"
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
 CASE "A" TO "Z"
   WorkName$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     Result$ = "$"
     InLine$ = MID$(InLine$, 2)
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF WorkName$ = "NOT" THEN
    ParseInMeaningOfExpression$ = "Not " + ParseCalculate$(InLine$)
   ELSE
    Result$ = UCASE$(LEFT$(WorkName$, 1)) + LCASE$(MID$(WorkName$, 2)) + Result$
    IF LEFT$(InLine$, 1) = "(" THEN
     Result$ = Result$ + "("
     InLine$ = LTRIM$(MID$(InLine$, 2))
     DO WHILE InLine$ <> ""
      Result$ = Result$ + ParseCalculate$(InLine$)
      InLine$ = LTRIM$(InLine$)
      SELECT CASE LEFT$(InLine$, 1)
      CASE ","
        Result$ = Result$ + ","
        InLine$ = MID$(InLine$, 2)
      CASE ")"
        EXIT DO
      CASE ELSE
        ERROR 2
      END SELECT
     LOOP
     IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
     Result$ = Result$ + ")"
     InLine$ = MID$(InLine$, 2)
    END IF
    ParseInMeaningOfExpression$ = Result$
   END IF
 CASE ELSE
   ERROR 2
 END SELECT
END FUNCTION

FUNCTION ParseInNumber$ (InLine$)
 DIM OutNumber$
 DIM PointPresent%
 InLine$ = LTRIM$(InLine$)
 OutNumber$ = ""
 PointPresent% = False%
 SELECT CASE LEFT$(InLine$, 1)
 CASE "&"
   InLine$ = LTRIM$(MID$(InLine$, 2))
   SELECT CASE LEFT$(UCASE$(InLine$), 1)
   CASE "H"
     InLine$ = LTRIM$(MID$(InLine$, 2))
     DO WHILE InLine$ <> ""
      SELECT CASE LEFT$(UCASE$(InLine$), 1)
      CASE "0" TO "9"
        OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
        InLine$ = MID$(InLine$, 2)
      CASE "A" TO "F"
        OutNumber$ = OutNumber$ + LEFT$(UCASE$(InLine$), 1)
        InLine$ = MID$(InLine$, 2)
      CASE "G" TO "Z"
        ERROR 2
      CASE "."
        InLine$ = MID$(InLine$, 2)
        IF (OutNumber$ = "") OR ((NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("9") + 1)))) AND (NOT ((ASC(UCASE$(InLine$)) > (ASC("A") - 1)) AND (ASC(UCASE$(InLine$)) < (ASC("F") + 1))))) OR PointPresent% THEN ERROR 2
        PointPresent% = True%
        OutNumber$ = OutNumber$ + "."
      CASE ELSE
        EXIT DO
      END SELECT
     LOOP
     IF OutNumber$ = "" THEN ERROR 2
     ParseInNumber$ = "&H" + OutNumber$
   CASE "O"
     InLine$ = LTRIM$(MID$(InLine$, 2))
     DO WHILE InLine$ <> ""
      SELECT CASE LEFT$(UCASE$(InLine$), 1)
      CASE "0" TO "7"
        OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
        InLine$ = MID$(InLine$, 2)
      CASE "8" TO "9"
        ERROR 2
      CASE "."
        InLine$ = MID$(InLine$, 2)
        IF (OutNumber$ = "") OR (NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("7") + 1)))) OR PointPresent% THEN ERROR 2
        PointPresent% = True%
        OutNumber$ = OutNumber$ + "."
      CASE ELSE
        EXIT DO
      END SELECT
     LOOP
     IF OutNumber$ = "" THEN ERROR 2
     ParseInNumber$ = "&O" + OutNumber$
   CASE "0" TO "7"
     DO WHILE InLine$ <> ""
      SELECT CASE LEFT$(UCASE$(InLine$), 1)
      CASE "0" TO "7"
        OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
        InLine$ = MID$(InLine$, 2)
      CASE "8" TO "9"
        ERROR 2
      CASE "."
        InLine$ = MID$(InLine$, 2)
        IF (OutNumber$ = "") OR (NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("7") + 1)))) OR PointPresent% THEN ERROR 2
        PointPresent% = True%
        OutNumber$ = OutNumber$ + "."
      CASE ELSE
        EXIT DO
      END SELECT
     LOOP
     IF OutNumber$ = "" THEN ERROR 2
     ParseInNumber$ = "&O" + OutNumber$
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "0" TO "9"
   DO WHILE InLine$ <> ""
    SELECT CASE LEFT$(UCASE$(InLine$), 1)
    CASE "0" TO "9"
      OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
      InLine$ = MID$(InLine$, 2)
    CASE "."
      InLine$ = MID$(InLine$, 2)
      IF (OutNumber$ = "") OR (NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("9") + 1)))) OR PointPresent% THEN ERROR 2
      PointPresent% = True%
      OutNumber$ = OutNumber$ + "."
    CASE ELSE
      EXIT DO
    END SELECT
   LOOP
   IF OutNumber$ = "" THEN ERROR 2
   ParseInNumber$ = OutNumber$
 CASE "."
   PointPresent% = True%
   InLine$ = LTRIM$(MID$(InLine$, 2))
   DO WHILE InLine$ <> ""
    SELECT CASE LEFT$(UCASE$(InLine$), 1)
    CASE "0" TO "9"
      OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
      InLine$ = MID$(InLine$, 2)
    CASE "."
      ERROR 2
    CASE ELSE
      EXIT DO
    END SELECT
   LOOP
   IF OutNumber$ = "" THEN ERROR 2
   ParseInNumber$ = "0." + OutNumber$
 CASE ELSE
   ERROR 2
 END SELECT
END FUNCTION

FUNCTION ParseRunLine$ (InLine$)
 DIM WorkName$
 DIM WorkLine$
 DIM Result$
 DIM Value$
 DIM Meaning$
 DIM Value%
 DIM Number%
 DIM Index%
 DIM LineNumber%
 WorkName$ = InName$(InLine$)
 InLine$ = LTRIM$(InLine$)
 SELECT CASE WorkName$
 CASE "REBOOT"
   ParseRunLine$ = "Reboot"
 CASE "HANG"
   ParseRunLine$ = "Hang"
 CASE "BEEP"
   ParseRunLine$ = "Beep"
 CASE "REM"
   IF InLine$ <> "" THEN ParseRunLine$ = "Rem " + InLine$ ELSE ParseRunLine$ = "Rem"
 CASE "SYSTEM"
   ParseRunLine$ = "System"
 CASE "CLS"
   ParseRunLine$ = "Cls"
 CASE "BEEP"
   ParseRunLine$ = "Beep"
 CASE "LABEL"
   ParseRunLine$ = "Label " + ParseCalculate$(InLine$)
 CASE "OPEN"
   Result$ = ParseCalculate$(InLine$) + " For "
   IF InName$(InLine$) <> "FOR" THEN ERROR 2
   SELECT CASE InName$(InLine$)
   CASE "INPUT"
     Result$ = Result$ + "InPut"
   CASE "OUTPUT"
     Result$ = Result$ + "OutPut"
   CASE "APPEND"
     Result$ = Result$ + "Append"
   CASE ELSE
     ERROR 2
   END SELECT
   IF InName$(InLine$) <> "AS" THEN ERROR 2
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   ParseRunLine$ = "Open " + Result$ + " As #" + ParseCalculate$(InLine$)
 CASE "CLOSE"
   IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   ParseRunLine$ = "Close #" + ParseCalculate$(InLine$)
 CASE "PRINT"
   IF LEFT$(InLine$, 1) = "#" THEN
    InLine$ = MID$(InLine$, 2)
    Result$ = ParseCalculate$(InLine$)
    InLine$ = LTRIM$(InLine$)
    IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
    InLine$ = MID$(InLine$, 2)
    ParseRunLine$ = "Print #" + Result$ + "," + ParseCalculate$(InLine$)
   ELSE
    ParseRunLine$ = "Print " + ParseCalculate$(InLine$)
   END IF
 CASE "LET"
   Result$ = InName$(InLine$)
   Result$ = UCASE$(LEFT$(Result$, 1)) + LCASE$(MID$(Result$, 2))
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     Result$ = Result$ + "$"
     InLine$ = MID$(InLine$, 2)
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   ParseRunLine$ = "Let " + Result$ + "=" + ParseCalculate$(InLine$)
 CASE "DEF"
   Result$ = InName$(InLine$)
   IF LEFT$(Result$, 2) <> "FN" THEN ERROR 2
   Result$ = UCASE$(LEFT$(Result$, 3)) + LCASE$(MID$(Result$, 4))
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     Result$ = Result$ + "$"
     InLine$ = MID$(InLine$, 2)
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) = "(" THEN
    Result$ = Result$ + "("
    InLine$ = LTRIM$(MID$(InLine$, 2))
    DO WHILE InLine$ <> ""
     Value$ = InName$(InLine$)
     Value$ = UCASE$(LEFT$(Value$, 1)) + LCASE$(MID$(Value$, 2))
     Result$ = Result$ + Value$
     InLine$ = LTRIM$(InLine$)
     SELECT CASE LEFT$(InLine$, 1)
     CASE "$"
       Result$ = Result$ + "$"
       InLine$ = MID$(InLine$, 2)
     CASE "!"
       InLine$ = MID$(InLine$, 2)
     CASE "@"
       InLine$ = MID$(InLine$, 2)
     CASE "#"
       InLine$ = MID$(InLine$, 2)
     CASE "%"
       InLine$ = MID$(InLine$, 2)
     CASE "&"
       InLine$ = MID$(InLine$, 2)
     END SELECT
     InLine$ = LTRIM$(InLine$)
     SELECT CASE LEFT$(InLine$, 1)
     CASE ","
       Result$ = Result$ + ","
       InLine$ = MID$(InLine$, 2)
     CASE ")"
       Result$ = Result$ + ")"
       InLine$ = LTRIM$(MID$(InLine$, 2))
       EXIT DO
     CASE ELSE
       ERROR 2
     END SELECT
    LOOP
   END IF
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   ParseRunLine$ = "Def " + Result$ + "=" + ParseCalculate$(InLine$)
 CASE "LOCATE"
   Result$ = ParseCalculate$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   ParseRunLine$ = "Locate " + Result$ + "," + ParseCalculate$(InLine$)
 CASE "COLOR"
   Result$ = ParseCalculate$(InLine$)
   IF InName$(InLine$) <> "ON" THEN ERROR 2
   ParseRunLine$ = "Color " + Result$ + " On " + ParseCalculate$(InLine$)
 CASE "SOUND"
   Result$ = ParseCalculate$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   ParseRunLine$ = "Sound " + Result$ + "," + ParseCalculate$(InLine$)
 CASE "SLEEP"
   ParseRunLine$ = "Sleep " + ParseCalculate$(InLine$)
 CASE "MKDIR"
   ParseRunLine$ = "MkDir " + ParseCalculate$(InLine$)
 CASE "CHDIR"
   ParseRunLine$ = "ChDir " + ParseCalculate$(InLine$)
 CASE "RMDIR"
   ParseRunLine$ = "RmDir " + ParseCalculate$(InLine$)
 CASE "KILL"
   ParseRunLine$ = "Kill " + ParseCalculate$(InLine$)
 CASE "FILES"
   ParseRunLine$ = "Files " + ParseCalculate$(InLine$)
 CASE "SHELL"
   ParseRunLine$ = "Shell " + ParseCalculate$(InLine$)
 CASE "NAME"
   Result$ = ParseCalculate$(InLine$)
   IF InName$(InLine$) <> "AS" THEN ERROR 2
   ParseRunLine$ = "Name " + Result$ + " As " + ParseCalculate$(InLine$)
 CASE "SWAP"
   Result$ = InName$(InLine$)
   Result$ = UCASE$(LEFT$(Result$, 1)) + LCASE$(MID$(Result$, 2))
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     Result$ = Result$ + "$"
     InLine$ = MID$(InLine$, 2)
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Value$ = InName$(InLine$)
   Value$ = UCASE$(LEFT$(Value$, 1)) + LCASE$(MID$(Value$, 2))
   Result$ = Result$ + "," + Value$
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     Result$ = Result$ + "$"
     InLine$ = MID$(InLine$, 2)
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   ParseRunLine$ = "Swap " + Result$
 CASE "GO"
   SELECT CASE InName$(InLine$)
   CASE "TO"
     ParseRunLine$ = "Go To " + ParseCalculate$(InLine$)
   CASE "SUB"
     ParseRunLine$ = "Go Sub " + ParseCalculate$(InLine$)
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "RETURN"
   ParseRunLine$ = "Return"
 CASE "SCREEN"
   SELECT CASE InName$(InLine$)
   CASE "FOURTY"
     ParseRunLine$ = "Screen Fourty"
   CASE "EIGHTY"
     ParseRunLine$ = "Screen Eighty"
   CASE "MONO"
     ParseRunLine$ = "Screen Mono"
   CASE "COLOR"
     ParseRunLine$ = "Screen Color"
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "RUN"
   ParseRunLine$ = "Run"
 CASE "TRON"
   ParseRunLine$ = "TrOn"
 CASE "TROFF"
   ParseRunLine$ = "TrOff"
 CASE "CALL"
   Result$ = InName$(InLine$)
   Result$ = UCASE$(LEFT$(Result$, 1)) + LCASE$(MID$(Result$, 2))
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     Result$ = Result$ + "$"
     InLine$ = MID$(InLine$, 2)
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) = "(" THEN
    Result$ = Result$ + "("
    InLine$ = LTRIM$(MID$(InLine$, 2))
    DO WHILE InLine$ <> ""
     Result$ = Result$ + ParseCalculate$(InLine$)
     InLine$ = LTRIM$(InLine$)
     SELECT CASE LEFT$(InLine$, 1)
     CASE ","
       Result$ = Result$ + ","
       InLine$ = MID$(InLine$, 2)
     CASE ")"
       Result$ = Result$ + ")"
       InLine$ = LTRIM$(MID$(InLine$, 2))
       EXIT DO
     CASE ELSE
       ERROR 2
     END SELECT
    LOOP
   END IF
   ParseRunLine$ = "Call " + Result$
 CASE "END"
   IF InLine$ <> "" THEN
    SELECT CASE InName$(InLine$)
    CASE "SUB"
      ParseRunLine$ = "End Sub"
    CASE "IF"
      ParseRunLine$ = "End If"
    CASE "SELECT"
      ParseRunLine$ = "End Select"
    CASE ELSE
      ERROR 2
    END SELECT
   ELSE
    ParseRunLine$ = "End"
   END IF
 CASE "EXIT"
   SELECT CASE InName$(InLine$)
   CASE "SUB"
     ParseRunLine$ = "Exit Sub"
   CASE "FROM"
     ParseRunLine$ = "Exit From"
   CASE "WHILE"
     ParseRunLine$ = "Exit While"
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "FROM"
   Result$ = InName$(InLine$)
   Result$ = UCASE$(LEFT$(Result$, 1)) + LCASE$(MID$(Result$, 2))
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     ERROR 13
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Result$ = Result$ + "=" + ParseCalculate$(InLine$) + " To "
   IF InName$(InLine$) <> "TO" THEN ERROR 2
   Result$ = Result$ + ParseCalculate$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF InLine$ <> "" THEN
    IF InName$(InLine$) <> "STEP" THEN ERROR 2
    InLine$ = LTRIM$(InLine$)
    IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + " Step=" + ParseCalculate$(InLine$)
   END IF
   ParseRunLine$ = "From " + Result$
 CASE "NEXT"
   Result$ = InName$(InLine$)
   Result$ = UCASE$(LEFT$(Result$, 1)) + LCASE$(MID$(Result$, 2))
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     ERROR 13
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   ParseRunLine$ = "Next " + Result$
 CASE "WHILE"
   ParseRunLine$ = "While " + ParseCalculate$(InLine$)
 CASE "WEND"
   ParseRunLine$ = "WEnd"
 CASE "IF"
   Result$ = ParseCalculate$(InLine$)
   IF InName$(InLine$) <> "THEN" THEN ERROR 2
   InLine$ = LTRIM$(InLine$)
   IF InLine$ <> "" THEN
    Result$ = Result$ + " Then " + ParseRunLine$(InLine$)
    InLine$ = LTRIM$(InLine$)
    IF InLine$ <> "" THEN
     IF InName$(InLine$) <> "ELSE" THEN ERROR 2
     Result$ = Result$ + " Else " + ParseRunLine$(InLine$)
    END IF
    ParseRunLine$ = "If " + Result$
   ELSE
    ParseRunLine$ = "If " + Result$ + " Then"
   END IF
 CASE "ELSE"
   ParseRunLine$ = "Else"
 CASE "SUBRESULT"
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   ParseRunLine$ = "SubResult=" + ParseCalculate$(InLine$)
 CASE "SUB"
   Result$ = InName$(InLine$)
   Result$ = UCASE$(LEFT$(Result$, 1)) + LCASE$(MID$(Result$, 2))
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     Result$ = Result$ + "$"
     InLine$ = MID$(InLine$, 2)
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) = "(" THEN
    Result$ = Result$ + "("
    InLine$ = LTRIM$(MID$(InLine$, 2))
    DO WHILE InLine$ <> ""
     Value$ = InName$(InLine$)
     Value$ = UCASE$(LEFT$(Value$, 1)) + LCASE$(MID$(Value$, 2))
     Result$ = Result$ + Value$
     InLine$ = LTRIM$(InLine$)
     SELECT CASE LEFT$(InLine$, 1)
     CASE "$"
       Result$ = Result$ + "$"
       InLine$ = MID$(InLine$, 2)
     CASE "!"
       InLine$ = MID$(InLine$, 2)
     CASE "@"
       InLine$ = MID$(InLine$, 2)
     CASE "#"
       InLine$ = MID$(InLine$, 2)
     CASE "%"
       InLine$ = MID$(InLine$, 2)
     CASE "&"
       InLine$ = MID$(InLine$, 2)
     END SELECT
     InLine$ = LTRIM$(InLine$)
     SELECT CASE LEFT$(InLine$, 1)
     CASE ","
       Result$ = Result$ + ","
       InLine$ = MID$(InLine$, 2)
     CASE ")"
       Result$ = Result$ + ")"
       InLine$ = LTRIM$(MID$(InLine$, 2))
       EXIT DO
     CASE ELSE
       ERROR 2
     END SELECT
    LOOP
   END IF
   ParseRunLine$ = "Sub " + Result$
 CASE "CASE"
   SELECT CASE LEFT$(UCASE$(InLine$), 1)
   CASE "A" TO "Z"
     WorkLine$ = InLine$
     IF InName$(InLine$) = "ELSE" THEN
      ParseRunLine$ = "Case Else"
     ELSE
      ParseRunLine$ = "Case " + ParseCalculate$(WorkLine$)
     END IF
   CASE ELSE
     ParseRunLine$ = "Case " + ParseCalculate$(InLine$)
   END SELECT
 CASE "SELECT"
   IF InName$(InLine$) <> "CASE" THEN ERROR 2
   ParseRunLine$ = "Select Case " + ParseCalculate$(InLine$)
 CASE ELSE
   ERROR 34
 END SELECT
END FUNCTION

SUB Restart
 DEF SEG = &HF000
 CALL Absolute(&HFFF0)
END SUB

SUB RunLine (InLine$)
 DIM WorkName$
 DIM WorkLine$
 DIM Result$
 DIM Value$
 DIM Meaning$
 DIM Value%
 DIM Number%
 DIM Index%
 DIM LineNumber%
 DIM NumberOfLine%
 DIM SubIndex%
 DIM IfElse%
 DIM WhileCount%
 DIM FromCount%
 DIM StartLine%
 DIM EndLine%
 DIM Conditional$
 DIM FromVariableName$
 DIM StartValue#
 DIM EndValue#
 DIM FromStep#
 DIM OldSubroutineMode%
 DIM SubroutineType%
 WorkName$ = InName$(InLine$)
 InLine$ = LTRIM$(InLine$)
 SELECT CASE WorkName$
 CASE "BEEP"
   BEEP
 CASE "REM"
   EXIT SUB
 CASE "SYSTEM"
   SYSTEM
 CASE "CLS"
   CLS
 CASE "REBOOT"
   CALL Restart
 CASE "HANG"
   CALL Hang
 CASE "OPEN"
   WorkName$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   IF InName$(InLine$) <> "FOR" THEN ERROR 2
   SELECT CASE InName$(InLine$)
   CASE "INPUT"
     Result$ = "InPut"
   CASE "OUTPUT"
     Result$ = "OutPut"
   CASE "APPEND"
     Result$ = "Append"
   CASE ELSE
     ERROR 2
   END SELECT
   IF InName$(InLine$) <> "AS" THEN ERROR 2
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Value$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   IF (VAL(Value$) < 1) OR (VAL(Value$) > FilesCountValue%) THEN ERROR 52
   IF BASICFiles$(VAL(Value$)) <> "" THEN ERROR 55
   SELECT CASE Result$
   CASE "InPut"
     OPEN WorkName$ FOR INPUT AS #VAL(Value$)
     BASICFiles$(VAL(Value$)) = "IN=" + WorkName$
   CASE "OutPut"
     OPEN WorkName$ FOR OUTPUT AS #VAL(Value$)
     BASICFiles$(VAL(Value$)) = "OUT=" + WorkName$
   CASE "Append"
     OPEN WorkName$ FOR APPEND AS #VAL(Value$)
     BASICFiles$(VAL(Value$)) = "OUT=" + WorkName$
   END SELECT
 CASE "CLOSE"
   IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   IF (VAL(Result$) < 1) OR (VAL(Result$) > FilesCountValue%) THEN ERROR 52
   IF BASICFiles$(VAL(Result$)) = "" THEN ERROR 36
   BASICFiles$(VAL(Result$)) = ""
   CLOSE #VAL(Result$)
 CASE "PRINT"
   IF LEFT$(InLine$, 1) = "#" THEN
    InLine$ = MID$(InLine$, 2)
    Result$ = Calculate$(InLine$)
    IF NumStr% THEN ERROR 2
    InLine$ = LTRIM$(InLine$)
    IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
    InLine$ = MID$(InLine$, 2)
    IF (VAL(Result$) < 1) OR (VAL(Result$) > FilesCountValue%) THEN ERROR 52
    IF LEFT$(BASICFiles$(VAL(Result$)), 4) <> "OUT=" THEN ERROR 54
    PRINT #VAL(Result$), Calculate$(InLine$)
   ELSE
    CALL WriteLineOut(Calculate$(InLine$))
   END IF
 CASE "LET"
   WorkName$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   Value% = False%
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     Value% = True%
     InLine$ = MID$(InLine$, 2)
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Result$ = Calculate$(InLine$)
   IF NumStr% <> Value% THEN ERROR 13
   CALL SetVariable(WorkName$, Value%, Result$)
 CASE "DEF"
   IF DefFnSCount% = DefFnSCountValue% THEN ERROR 39
   DefFnSCount% = DefFnSCount% + 1
   Result$ = InName$(InLine$)
   IF LEFT$(Result$, 2) <> "FN" THEN ERROR 2
   Result$ = UCASE$(LEFT$(Result$, 3)) + LCASE$(MID$(Result$, 4))
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     Result$ = Result$ + "$"
     InLine$ = MID$(InLine$, 2)
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) = "(" THEN
    Result$ = Result$ + "("
    InLine$ = LTRIM$(MID$(InLine$, 2))
    DO WHILE InLine$ <> ""
     Value$ = InName$(InLine$)
     Value$ = UCASE$(LEFT$(Value$, 1)) + LCASE$(MID$(Value$, 2))
     Result$ = Result$ + Value$
     InLine$ = LTRIM$(InLine$)
     SELECT CASE LEFT$(InLine$, 1)
     CASE "$"
       Result$ = Result$ + "$"
       InLine$ = MID$(InLine$, 2)
     CASE "!"
       InLine$ = MID$(InLine$, 2)
     CASE "@"
       InLine$ = MID$(InLine$, 2)
     CASE "#"
       InLine$ = MID$(InLine$, 2)
     CASE "%"
       InLine$ = MID$(InLine$, 2)
     CASE "&"
       InLine$ = MID$(InLine$, 2)
     END SELECT
     InLine$ = LTRIM$(InLine$)
     SELECT CASE LEFT$(InLine$, 1)
     CASE ","
       Result$ = Result$ + ","
       InLine$ = MID$(InLine$, 2)
     CASE ")"
       Result$ = Result$ + ")"
       InLine$ = LTRIM$(MID$(InLine$, 2))
       EXIT DO
     CASE ELSE
       ERROR 2
     END SELECT
    LOOP
   END IF
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   DefFnS$(DefFnSCount%) = Result$ + "=" + ParseCalculate$(InLine$)
 CASE "LOCATE"
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Value$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   LOCATE VAL(Value$), VAL(Result$)
 CASE "COLOR"
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   IF InName$(InLine$) <> "ON" THEN ERROR 2
   Value$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   COLOR VAL(Result$), VAL(Value$)
 CASE "SOUND"
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Value$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   SOUND VAL(Result$), VAL(Value$)
 CASE "SLEEP"
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   SLEEP VAL(Result$)
 CASE "MKDIR"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   MKDIR Result$
 CASE "CHDIR"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   CHDIR Result$
 CASE "RMDIR"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   RMDIR Result$
 CASE "KILL"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   KILL Result$
 CASE "FILES"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   FILES Result$
 CASE "SHELL"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   SHELL Result$
 CASE "NAME"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   IF InName$(InLine$) <> "AS" THEN ERROR 2
   Value$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   NAME Result$ AS Value$
 CASE "SWAP"
   Result$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   Value% = False%
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     Value% = True%
     InLine$ = MID$(InLine$, 2)
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Value$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   Number% = False%
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     Number% = True%
     InLine$ = MID$(InLine$, 2)
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   IF Value% <> Number% THEN ERROR 13
   Meaning$ = InVariable$(Result$, Value%, InLine$)
   CALL SetVariable(Result$, Value%, InVariable$(Value$, Value%, InLine$))
   CALL SetVariable(Value$, Value%, Meaning$)
 CASE "GO"
   IF NOT RunMode% THEN ERROR 42
   SELECT CASE InName$(InLine$)
   CASE "TO"
     Result$ = Calculate$(InLine$)
     IF NumStr% THEN CurrentLine% = FindLabel%(Result$) - 1 ELSE CurrentLine% = FindLine%(VAL(Result$)) - 1
   CASE "SUB"
     Result$ = Calculate$(InLine$)
     IF NumStr% THEN
      IF GoSubSCount% = GoSubSCountValue% THEN ERROR 44
      GoSubSCount% = GoSubSCount% + 1
      GoSubS%(GoSubSCount%) = CurrentLine%
      CurrentLine% = FindLabel%(Result$) - 1
     ELSE
      IF GoSubSCount% = GoSubSCountValue% THEN ERROR 44
      GoSubSCount% = GoSubSCount% + 1
      GoSubS%(GoSubSCount%) = CurrentLine%
      CurrentLine% = FindLine%(VAL(Result$)) - 1
     END IF
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "RETURN"
   IF NOT RunMode% THEN ERROR 42
   IF GoSubSCount% = 0 THEN ERROR 3
   CurrentLine% = GoSubS%(GoSubSCount%) - 1
   GoSubS%(GoSubSCount%) = 0
   GoSubSCount% = GoSubSCount% - 1
 CASE "SCREEN"
   SELECT CASE InName$(InLine$)
   CASE "FOURTY"
     SCREEN 0, , 0, 0
     WIDTH 40
   CASE "EIGHTY"
     SCREEN 0, , 0, 0
     WIDTH 80
   CASE "MONO"
     SCREEN 0, 0, 0, 0
   CASE "COLOR"
     SCREEN 0, 1, 0, 0
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "TRON"
   IF TraceMode% THEN ERROR 41
   TraceMode% = True%
   PRINT "Trace mode is On."
 CASE "TROFF"
   IF NOT TraceMode% THEN ERROR 47
   TraceMode% = False%
   PRINT "Trace mode is Off."
 CASE "END"
   IF InLine$ = "" THEN
    IF NOT RunMode% THEN ERROR 80
    RunMode% = False%
    CurrentLine% = 0
   ELSE
    IF (InName$(InLine$) = "SUB") AND SubroutineMode% THEN
     IF NOT SubroutineMode% THEN ERROR 90
     IF CurrentLine% = TextLines% THEN ERROR 85
     FOR Index% = 1 TO TextLines% + 1
      IF Index% = TextLines% + 1 THEN ERROR 85
      IF LTRIM$(RTRIM$(Text$(Index%))) <> "" THEN
       WorkLine$ = LTRIM$(RTRIM$(Text$(Index%)))
       SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
       CASE "0" TO "9"
         LineNumber% = INT(InNumber#(WorkLine$))
         IF (LineNumber% < 1) OR (LineNumber% > TextLines%) THEN ERROR 15
         WorkLine$ = LTRIM$(WorkLine$)
         SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
         CASE "A" TO "Z"
           WorkLine$ = ParseRunLine$(WorkLine$)
           IF InName$(WorkLine$) = "END" THEN
            WorkLine$ = LTRIM$(WorkLine$)
            IF WorkLine$ <> "" THEN
             IF InName$(WorkLine$) = "SUB" THEN
              CurrentLine% = Index%
              EXIT FOR
             END IF
            END IF
           END IF
         CASE ELSE
           ERROR 95
         END SELECT
       CASE "A" TO "Z"
         WorkLine$ = ParseRunLine$(WorkLine$)
         IF InName$(WorkLine$) = "END" THEN
          WorkLine$ = LTRIM$(WorkLine$)
          IF WorkLine$ <> "" THEN
           IF InName$(WorkLine$) = "SUB" THEN
            CurrentLine% = Index%
            EXIT FOR
           END IF
          END IF
         END IF
       CASE ELSE
         ERROR 95
       END SELECT
      END IF
     NEXT Index%
     IF NOT SubroutineMode% THEN ERROR 90
     WorkLine$ = MID$(Subroutines$(CurrentSubroutine%), INSTR(Subroutines$(CurrentSubroutine%), "(") + 1)
     CurrentLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "[") + 1)
     SubroutineMode% = ABS(VAL(MID$(WorkLine$, 1, 1))) = 1
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "]") + 1)
     SubroutineType% = ABS(VAL(MID$(WorkLine$, 1, 1))) = 1
     SubroutinesArgumentsCount%(CurrentSubroutine%) = 0
     SubroutinesResults$(CurrentSubroutine%) = ""
     FOR Index% = 1 TO SubroutinesArgumentsCountValue%
      SubroutinesArguments$(CurrentSubroutine%, Index%) = ""
     NEXT Index%
     Subroutines$(CurrentSubroutine%) = ""
    END IF
   END IF
 CASE "EXIT"
   IF NOT RunMode% THEN ERROR 42
   SELECT CASE InName$(InLine$)
   CASE "WHILE"
     FOR Index% = 1 TO WhilesCountValue% + 1
      IF Index% = WhilesCountValue% + 1 THEN ERROR 82
      IF Whiles$(Index%) = "" THEN
       WorkLine$ = MID$(Whiles$(Index%), INSTR(Whiles$(Index%), "(") + 1)
       StartLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
       WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
       EndLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
       Conditional$ = MID$(WorkLine$, INSTR(WorkLine$, "=") + 1)
       IF EndLine% = CurrentLine% THEN EXIT FOR
      END IF
     NEXT Index%
     IF (CurrentLine% > (StartLine% - 1)) AND (CurrentLine% < (EndLine% + 1)) THEN
      Whiles$(Index%) = ""
      CurrentLine% = EndLine%
     END IF
   CASE "FROM"
     FOR Index% = 1 TO FromsCountValue% + 1
      IF Index% = FromsCountValue% + 1 THEN ERROR 84
      IF Froms$(Index%) <> "" THEN
       WorkLine$ = MID$(Whiles$(Index%), INSTR(Whiles$(Index%), "(") + 1)
       StartLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
       WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
       EndLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
       WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
       StartValue# = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
       WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
       EndValue# = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
       WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
       FromStep# = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
       WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
       FromVariableName$ = MID$(WorkLine$, INSTR(WorkLine$, "=") + 1)
       IF EndLine% = CurrentLine% THEN EXIT FOR
      END IF
     NEXT Index%
     IF (CurrentLine% > (StartLine% - 1)) AND (CurrentLine% < (EndLine% + 1)) THEN
      Froms$(Index%) = ""
      CurrentLine% = EndLine%
     END IF
   CASE "SUB"
     IF NOT SubroutineMode% THEN ERROR 90
     IF CurrentLine% = TextLines% THEN ERROR 85
     FOR Index% = 1 TO TextLines% + 1
      IF Index% = TextLines% + 1 THEN ERROR 85
      IF LTRIM$(RTRIM$(Text$(Index%))) <> "" THEN
       WorkLine$ = LTRIM$(RTRIM$(Text$(Index%)))
       SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
       CASE "0" TO "9"
         LineNumber% = INT(InNumber#(WorkLine$))
         IF (LineNumber% < 1) OR (LineNumber% > TextLines%) THEN ERROR 15
         WorkLine$ = LTRIM$(WorkLine$)
         SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
         CASE "A" TO "Z"
           WorkLine$ = ParseRunLine$(WorkLine$)
           IF InName$(WorkLine$) = "END" THEN
            WorkLine$ = LTRIM$(WorkLine$)
            IF WorkLine$ <> "" THEN
             IF InName$(WorkLine$) = "SUB" THEN
              CurrentLine% = Index%
              EXIT FOR
             END IF
            END IF
           END IF
         CASE ELSE
           ERROR 95
         END SELECT
       CASE "A" TO "Z"
         WorkLine$ = ParseRunLine$(WorkLine$)
         IF InName$(WorkLine$) = "END" THEN
          WorkLine$ = LTRIM$(WorkLine$)
          IF WorkLine$ <> "" THEN
           IF InName$(WorkLine$) = "SUB" THEN
            CurrentLine% = Index%
            EXIT FOR
           END IF
          END IF
         END IF
       CASE ELSE
         ERROR 95
       END SELECT
      END IF
     NEXT Index%
     IF NOT SubroutineMode% THEN ERROR 90
     WorkLine$ = MID$(Subroutines$(CurrentSubroutine%), INSTR(Subroutines$(CurrentSubroutine%), "(") + 1)
     CurrentLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "[") + 1)
     SubroutineMode% = ABS(VAL(MID$(WorkLine$, 1, 1))) = 1
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "]") + 1)
     SubroutineType% = ABS(VAL(MID$(WorkLine$, 1, 1))) = 1
     SubroutinesArgumentsCount%(CurrentSubroutine%) = 0
     SubroutinesResults$(CurrentSubroutine%) = ""
     FOR Index% = 1 TO SubroutinesArgumentsCountValue%
      SubroutinesArguments$(CurrentSubroutine%, Index%) = ""
     NEXT Index%
     Subroutines$(CurrentSubroutine%) = ""
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "SUBRESULT"
   IF NOT RunMode% THEN ERROR 42
   IF NOT SubroutineMode% THEN ERROR 91
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Result$ = Calculate$(InLine$)
   WorkLine$ = MID$(Subroutines$(CurrentSubroutine%), INSTR(Subroutines$(CurrentSubroutine%), "(") + 1)
   Value% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
   WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "[") + 1)
   Value% = ABS(VAL(MID$(WorkLine$, 1, 1))) = 1
   WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "[") + 1)
   SubroutineType% = ABS(VAL(MID$(WorkLine$, 1, 1))) = 1
   IF NumStr% <> SubroutineType% THEN ERROR 13
   SubroutinesResults$(CurrentSubroutine%) = Result$
 CASE "FROM"
   IF NOT RunMode% THEN ERROR 42
   FromVariableName$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     ERROR 13
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   StartValue# = VAL(Result$)
   IF InName$(InLine$) <> "TO" THEN ERROR 2
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   EndValue# = VAL(Result$)
   InLine$ = LTRIM$(InLine$)
   IF InLine$ <> "" THEN
    IF InName$(InLine$) <> "STEP" THEN ERROR 2
    InLine$ = LTRIM$(InLine$)
    IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
    InLine$ = MID$(InLine$, 2)
    Result$ = Calculate$(InLine$)
    IF NumStr% THEN ERROR 13
    FromStep# = VAL(Result$)
   ELSE
    FromStep# = 1#
   END IF
   FromCount% = 0
   IF CurrentLine% = TextLines% THEN ERROR 26
   FOR LineNumber% = CurrentLine% + 1 TO TextLines% + 1
    IF LineNumber% = TextLines% + 1 THEN ERROR 26
    IF LTRIM$(RTRIM$(Text$(LineNumber%))) <> "" THEN
     WorkLine$ = LTRIM$(RTRIM$(Text$(LineNumber%)))
     SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
     CASE "0" TO "9"
       NumberOfLine% = INT(InNumber#(WorkLine$))
       IF (NumberOfLine% < 1) OR (NumberOfLine% > TextLines%) THEN ERROR 15
       WorkLine$ = LTRIM$(WorkLine$)
       SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
       CASE "A" TO "Z"
         WorkLine$ = ParseRunLine$(WorkLine$)
         SELECT CASE InName$(WorkLine$)
         CASE "FROM"
           FromCount% = FromCount% + 1
         CASE "NEXT"
           IF FromCount% = 0 THEN IF InName$(WorkLine$) = FromVariableName$ THEN EXIT FOR
           FromCount% = FromCount% - 1
         END SELECT
       CASE ELSE
         ERROR 95
       END SELECT
     CASE "A" TO "Z"
       WorkLine$ = ParseRunLine$(WorkLine$)
       SELECT CASE InName$(WorkLine$)
       CASE "FROM"
         FromCount% = FromCount% + 1
       CASE "NEXT"
         IF FromCount% = 0 THEN IF InName$(WorkLine$) = FromVariableName$ THEN EXIT FOR
         FromCount% = FromCount% - 1
       END SELECT
     CASE ELSE
       ERROR 95
     END SELECT
    END IF
   NEXT LineNumber%
   FOR Index% = 1 TO FromsCountValue% + 1
    IF Index% = FromsCountValue% + 1 THEN ERROR 83
    IF Froms$(Index%) = "" THEN EXIT FOR
   NEXT Index%
   IF StartValue# > EndValue# THEN
    IF NOT (FromStep# < 0#) THEN
     CurrentLine% = LineNumber%
    ELSE
     Froms$(Index%) = "Start line=(" + LTRIM$(STR$(CurrentLine%)) + "). End line=(" + LTRIM$(STR$(LineNumber%)) + "). Start value=(" + LTRIM$(STR$(StartValue#)) + "). End value=(" + LTRIM$(STR$(EndValue#)) + "). Step=(" + LTRIM$(STR$(FromStep#)) + "). Variable name=" + FromVariableName$
     CALL SetVariable(FromVariableName$, False%, LTRIM$(STR$(StartValue#)))
    END IF
   ELSE
    IF NOT (FromStep# > 0) THEN
     CurrentLine% = LineNumber%
    ELSE
     Froms$(Index%) = "Start line=(" + LTRIM$(STR$(CurrentLine%)) + "). End line=(" + LTRIM$(STR$(LineNumber%)) + "). Start value=(" + LTRIM$(STR$(StartValue#)) + "). End value=(" + LTRIM$(STR$(EndValue#)) + "). Step=(" + LTRIM$(STR$(FromStep#)) + "). Variable name=" + FromVariableName$
     CALL SetVariable(FromVariableName$, False%, LTRIM$(STR$(StartValue#)))
    END IF
   END IF
 CASE "NEXT"
   IF NOT RunMode% THEN ERROR 42
   WorkName$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     ERROR 13
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   FOR Index% = 1 TO FromsCountValue% + 1
    IF Index% = FromsCountValue% + 1 THEN ERROR 1
    IF Froms$(Index%) <> "" THEN
     WorkLine$ = MID$(Froms$(Index%), INSTR(Froms$(Index%), "(") + 1)
     StartLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
     EndLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
     StartValue# = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
     EndValue# = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
     FromStep# = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
     FromVariableName$ = MID$(WorkLine$, INSTR(WorkLine$, "=") + 1)
     IF (EndLine% = CurrentLine%) AND (FromVariableName$ = WorkName$) THEN EXIT FOR
    END IF
   NEXT Index%
   IF FromStep# < 0 THEN
    Result$ = InVariable$(FromVariableName$, False%, InLine$)
    IF VAL(Result$) <= EndValue# THEN
     Froms$(Index%) = ""
    ELSE
     CALL SetVariable(FromVariableName$, False%, LTRIM$(STR$(VAL(Result$) + FromStep#)))
     CurrentLine% = StartLine%
    END IF
   ELSE
    Result$ = InVariable$(FromVariableName$, False%, InLine$)
    IF VAL(Result$) >= EndValue# THEN
     Froms$(Index%) = ""
    ELSE
     CALL SetVariable(FromVariableName$, False%, LTRIM$(STR$(VAL(Result$) + FromStep#)))
     CurrentLine% = StartLine%
    END IF
   END IF
 CASE "WHILE"
   IF NOT RunMode% THEN ERROR 42
   Conditional$ = InLine$
   Value$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   IF CurrentLine% = TextLines% THEN ERROR 29
   WhileCount% = 0
   FOR LineNumber% = CurrentLine% + 1 TO TextLines% + 1
    IF LineNumber% = TextLines% + 1 THEN ERROR 29
    IF LTRIM$(RTRIM$(Text$(LineNumber%))) <> "" THEN
     WorkLine$ = LTRIM$(RTRIM$(Text$(LineNumber%)))
     SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
     CASE "0" TO "9"
       NumberOfLine% = INT(InNumber#(WorkLine$))
       IF (NumberOfLine% < 1) OR (NumberOfLine% > TextLines%) THEN ERROR 15
       WorkLine$ = LTRIM$(WorkLine$)
       SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
       CASE "A" TO "Z"
         WorkLine$ = ParseRunLine$(WorkLine$)
         SELECT CASE InName$(WorkLine$)
         CASE "WHILE"
           WhileCount% = WhileCount% + 1
         CASE "WEND"
           IF WhileCount% = 0 THEN EXIT FOR
           WhileCount% = WhileCount% - 1
         END SELECT
       CASE ELSE
         ERROR 95
       END SELECT
     CASE "A" TO "Z"
       WorkLine$ = ParseRunLine$(WorkLine$)
       SELECT CASE InName$(WorkLine$)
       CASE "WHILE"
         WhileCount% = WhileCount% + 1
       CASE "WEND"
         IF WhileCount% = 0 THEN EXIT FOR
         WhileCount% = WhileCount% - 1
       END SELECT
     CASE ELSE
       ERROR 95
     END SELECT
    END IF
   NEXT LineNumber%
   FOR Index% = 1 TO WhilesCountValue% + 1
    IF Index% = WhilesCountValue% + 1 THEN ERROR 81
    IF Whiles$(Index%) = "" THEN EXIT FOR
   NEXT Index%
   IF VAL(Value$) THEN
    Whiles$(Index%) = "Start line=(" + LTRIM$(STR$(CurrentLine%)) + "). End line=(" + LTRIM$(STR$(LineNumber%)) + "). Conditional=" + Conditional$
   ELSE
    CurrentLine% = LineNumber%
   END IF
 CASE "WEND"
   IF NOT RunMode% THEN ERROR 42
   FOR Index% = 1 TO WhilesCountValue% + 1
    IF Index% = WhilesCountValue% + 1 THEN ERROR 30
    IF Whiles$(Index%) <> "" THEN
     WorkLine$ = MID$(Whiles$(Index%), INSTR(Whiles$(Index%), "(") + 1)
     StartLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
     EndLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     Conditional$ = MID$(WorkLine$, INSTR(WorkLine$, "=") + 1)
     IF EndLine% = CurrentLine% THEN EXIT FOR
    END IF
   NEXT Index%
   Result$ = Calculate$(Conditional$)
   IF NumStr% THEN ERROR 13
   IF VAL(Result$) THEN
    CurrentLine% = StartLine%
   ELSE
    Whiles$(Index%) = ""
   END IF
 CASE "IF"
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   IF InName$(InLine$) <> "THEN" THEN ERROR 2
   InLine$ = LTRIM$(InLine$)
   IF InLine$ <> "" THEN
    Value$ = ParseRunLine$(InLine$)
    IfElse% = False%
    InLine$ = LTRIM$(InLine$)
    IF InLine$ <> "" THEN
     IF InName$(InLine$) <> "ELSE" THEN ERROR 2
     IfElse% = True%
     Meaning$ = ParseRunLine$(InLine$)
    END IF
    IF VAL(Result$) THEN
     CALL RunLine(Value$)
    ELSE
     IF IfElse% THEN CALL RunLine(Meaning$)
    END IF
   ELSE
    IF NOT RunMode% THEN ERROR 42
    IF CurrentLine% = TextLines% THEN ERROR 86
    IF VAL(Result$) = 0# THEN
     FOR Index% = CurrentLine% + 1 TO TextLines% + 1
      IF Index% = TextLines% + 1 THEN ERROR 86
      IF LTRIM$(RTRIM$(Text$(Index%))) <> "" THEN
       WorkLine$ = LTRIM$(RTRIM$(Text$(Index%)))
       SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
       CASE "0" TO "9"
         LineNumber% = INT(InNumber#(WorkLine$))
         IF (LineNumber% < 1) OR (LineNumber% > TextLines%) THEN ERROR 15
         WorkLine$ = LTRIM$(WorkLine$)
         SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
         CASE "A" TO "Z"
           WorkLine$ = ParseRunLine$(WorkLine$)
           SELECT CASE InName$(WorkLine$)
           CASE "ELSE"
             CurrentLine% = Index%
             EXIT FOR
           CASE "END"
             WorkLine$ = LTRIM$(WorkLine$)
             IF WorkLine$ <> "" THEN
              IF InName$(WorkLine$) = "IF" THEN
               CurrentLine% = Index%
               EXIT FOR
              END IF
             END IF
           END SELECT
         CASE ELSE
           ERROR 95
         END SELECT
       CASE "A" TO "Z"
         WorkLine$ = ParseRunLine$(WorkLine$)
         SELECT CASE InName$(WorkLine$)
         CASE "ELSE"
           CurrentLine% = Index%
           EXIT FOR
         CASE "END"
           WorkLine$ = LTRIM$(WorkLine$)
           IF WorkLine$ <> "" THEN
            IF InName$(WorkLine$) = "IF" THEN
             CurrentLine% = Index%
             EXIT FOR
            END IF
           END IF
         END SELECT
       CASE ELSE
         ERROR 95
       END SELECT
      END IF
     NEXT Index%
    END IF
   END IF
 CASE "ELSE"
   IF NOT RunMode% THEN ERROR 42
   IF CurrentLine% = TextLines% THEN ERROR 86
   FOR Index% = CurrentLine% + 1 TO TextLines% + 1
    IF Index% = TextLines% + 1 THEN ERROR 86
    IF LTRIM$(RTRIM$(Text$(Index%))) <> "" THEN
     WorkLine$ = LTRIM$(RTRIM$(Text$(Index%)))
     SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
     CASE "0" TO "9"
       LineNumber% = INT(InNumber#(WorkLine$))
       IF (LineNumber% < 1) OR (LineNumber% > TextLines%) THEN ERROR 15
       WorkLine$ = LTRIM$(WorkLine$)
       SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
       CASE "A" TO "Z"
         WorkLine$ = ParseRunLine$(WorkLine$)
         IF InName$(WorkLine$) = "END" THEN
          WorkLine$ = LTRIM$(WorkLine$)
          IF WorkLine$ <> "" THEN
           IF InName$(WorkLine$) = "IF" THEN EXIT FOR
          END IF
         END IF
       CASE ELSE
         ERROR 95
       END SELECT
     CASE "A" TO "Z"
       WorkLine$ = ParseRunLine$(WorkLine$)
       IF InName$(WorkLine$) = "END" THEN
        WorkLine$ = LTRIM$(WorkLine$)
        IF WorkLine$ <> "" THEN
         IF InName$(WorkLine$) = "IF" THEN EXIT FOR
        END IF
       END IF
     CASE ELSE
       ERROR 95
     END SELECT
    END IF
   NEXT Index%
   CurrentLine% = Index%
 CASE "SUB"
   IF NOT RunMode% THEN ERROR 42
   IF CurrentLine% = TextLines% THEN ERROR 85
   FOR LineNumber% = CurrentLine% + 1 TO TextLines% + 1
    IF LineNumber% = TextLines% + 1 THEN ERROR 85
    IF LTRIM$(RTRIM$(Text$(LineNumber%))) <> "" THEN
     WorkLine$ = LTRIM$(RTRIM$(Text$(LineNumber%)))
     SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
     CASE "0" TO "9"
       NumberOfLine% = INT(InNumber#(WorkLine$))
       IF (NumberOfLine% < 1) OR (NumberOfLine% > TextLines%) THEN ERROR 15
       WorkLine$ = LTRIM$(WorkLine$)
       SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
       CASE "A" TO "Z"
         WorkLine$ = ParseRunLine$(WorkLine$)
         IF InName$(WorkLine$) = "END" THEN
          WorkLine$ = LTRIM$(WorkLine$)
          IF WorkLine$ <> "" THEN IF InName$(WorkLine$) = "SUB" THEN EXIT FOR
         END IF
       CASE ELSE
         ERROR 95
       END SELECT
     CASE "A" TO "Z"
       WorkLine$ = ParseRunLine$(WorkLine$)
       IF InName$(WorkLine$) = "END" THEN
        WorkLine$ = LTRIM$(WorkLine$)
        IF WorkLine$ <> "" THEN IF InName$(WorkLine$) = "SUB" THEN EXIT FOR
       END IF
     CASE ELSE
       ERROR 95
     END SELECT
    END IF
   NEXT LineNumber%
   CurrentLine% = LineNumber%
 CASE "LABEL"
   EXIT SUB
 CASE "SELECT"
   IF NOT RunMode% THEN ERROR 42
   IF InName$(InLine$) <> "CASE" THEN ERROR 2
   Result$ = Calculate$(InLine$)
   Value% = NumStr%
   IF CurrentLine% = TextLines% THEN ERROR 87
   FOR Index% = 1 TO TextLines% + 1
    IF Index% = TextLines% + 1 THEN ERROR 87
    IF LTRIM$(RTRIM$(Text$(Index%))) <> "" THEN
     WorkLine$ = LTRIM$(RTRIM$(Text$(Index%)))
     SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
     CASE "0" TO "9"
       LineNumber% = INT(InNumber#(WorkLine$))
       IF (LineNumber% < 1) OR (LineNumber% > TextLines%) THEN ERROR 15
       WorkLine$ = LTRIM$(WorkLine$)
       SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
       CASE "A" TO "Z"
         WorkLine$ = ParseRunLine$(WorkLine$)
         IF InName$(WorkLine$) = "CASE" THEN
          WorkLine$ = LTRIM$(WorkLine$)
          SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
          CASE "A" TO "Z"
            WorkLine$ = ParseRunLine$(WorkLine$)
            Meaning$ = WorkLine$
            IF InName$(WorkLine$) = "ELSE" THEN
             CurrentLine% = Index%
             EXIT FOR
            ELSE
             InLine$ = Meaning$
             Value$ = Calculate$(WorkLine$)
             IF NumStr% = Value% THEN
              IF NumStr% THEN
               IF Result$ = Value$ THEN
                CurrentLine% = Index%
                EXIT FOR
               END IF
              ELSE
               IF VAL(Result$) = VAL(Value$) THEN
                CurrentLine% = Index%
                EXIT FOR
               END IF
              END IF
             END IF
            END IF
          CASE ELSE
            Value$ = Calculate$(WorkLine$)
            IF NumStr% = Value% THEN
             IF NumStr% THEN
              IF Result$ = Value$ THEN
               CurrentLine% = Index%
               EXIT FOR
              END IF
             ELSE
              IF VAL(Result$) = VAL(Value$) THEN
               CurrentLine% = Index%
               EXIT FOR
              END IF
             END IF
            END IF
          END SELECT
         END IF
       CASE ELSE
         ERROR 95
       END SELECT
     CASE "A" TO "Z"
       WorkLine$ = ParseRunLine$(WorkLine$)
       IF InName$(WorkLine$) = "CASE" THEN
        WorkLine$ = LTRIM$(WorkLine$)
        SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
        CASE "A" TO "Z"
          Meaning$ = WorkLine$
          IF InName$(WorkLine$) = "ELSE" THEN
           CurrentLine% = Index%
           EXIT FOR
          ELSE
           InLine$ = Meaning$
           Value$ = Calculate$(WorkLine$)
           IF NumStr% = Value% THEN
            IF NumStr% THEN
             IF Result$ = Value$ THEN
              CurrentLine% = Index%
              EXIT FOR
             END IF
            ELSE
             IF VAL(Result$) = VAL(Value$) THEN
              CurrentLine% = Index%
              EXIT FOR
             END IF
            END IF
           END IF
          END IF
        CASE ELSE
          Value$ = Calculate$(WorkLine$)
          IF NumStr% = Value% THEN
           IF NumStr% THEN
            IF Result$ = Value$ THEN
             CurrentLine% = Index%
             EXIT FOR
            END IF
           ELSE
            IF VAL(Result$) = VAL(Value$) THEN
             CurrentLine% = Index%
             EXIT FOR
            END IF
           END IF
          END IF
        END SELECT
       END IF
     CASE ELSE
       ERROR 95
     END SELECT
    END IF
   NEXT Index%
 CASE "CASE"
   IF NOT RunMode% THEN ERROR 42
   IF CurrentLine% = TextLines% THEN ERROR 87
   FOR Index% = 1 TO TextLines% + 1
    IF Index% = TextLines% + 1 THEN ERROR 87
    IF LTRIM$(RTRIM$(Text$(Index%))) <> "" THEN
     WorkLine$ = LTRIM$(RTRIM$(Text$(Index%)))
     SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
     CASE "0" TO "9"
       LineNumber% = INT(InNumber#(WorkLine$))
       IF (LineNumber% < 1) OR (LineNumber% > TextLines%) THEN ERROR 15
       WorkLine$ = LTRIM$(WorkLine$)
       SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
       CASE "A" TO "Z"
         WorkLine$ = ParseRunLine$(WorkLine$)
         IF InName$(WorkLine$) = "END" THEN
          WorkLine$ = LTRIM$(WorkLine$)
          IF WorkLine$ <> "" THEN
           IF InName$(WorkLine$) = "SELECT" THEN
            CurrentLine% = Index%
            EXIT FOR
           END IF
          END IF
         END IF
       CASE ELSE
         ERROR 95
       END SELECT
     CASE "A" TO "Z"
       WorkLine$ = ParseRunLine$(WorkLine$)
       IF InName$(WorkLine$) = "END" THEN
        WorkLine$ = LTRIM$(WorkLine$)
        IF WorkLine$ <> "" THEN
         IF InName$(WorkLine$) = "SELECT" THEN
          CurrentLine% = Index%
          EXIT FOR
         END IF
        END IF
       END IF
     CASE ELSE
       ERROR 95
     END SELECT
    END IF
   NEXT Index%
 CASE "CALL"
   IF NOT RunMode% THEN ERROR 42
   WorkName$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   SubroutineType% = False%
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     SubroutineType% = True%
     InLine$ = MID$(InLine$, 2)
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   FOR LineNumber% = 1 TO TextLines% + 1
    IF LineNumber% = TextLines% + 1 THEN ERROR 35
    IF LTRIM$(RTRIM$(Text$(Index%))) <> "" THEN
     WorkLine$ = LTRIM$(RTRIM$(Text$(Index%)))
     SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
     CASE "0" TO "9"
       NumberOfLine% = INT(InNumber#(WorkLine$))
       IF (NumberOfLine% < 1) OR (NumberOfLine% > TextLines%) THEN ERROR 15
       WorkLine$ = LTRIM$(WorkLine$)
       SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
       CASE "A" TO "Z"
         WorkLine$ = ParseRunLine$(WorkLine$)
         IF InName$(WorkLine$) = "SUB" THEN
          Result$ = InName$(WorkLine$)
          WorkLine$ = LTRIM$(WorkLine$)
          Value% = False%
          SELECT CASE LEFT$(WorkLine$, 1)
          CASE "$"
            Value% = True%
            WorkLine$ = MID$(WorkLine$, 2)
          CASE "!"
            WorkLine$ = MID$(WorkLine$, 2)
          CASE "@"
            WorkLine$ = MID$(WorkLine$, 2)
          CASE "#"
            WorkLine$ = MID$(WorkLine$, 2)
          CASE "%"
            WorkLine$ = MID$(WorkLine$, 2)
          CASE "&"
            WorkLine$ = MID$(WorkLine$, 2)
          END SELECT
          IF (WorkName$ = Result$) AND (SubroutineType% = Value%) THEN EXIT FOR
         END IF
       CASE ELSE
         ERROR 95
       END SELECT
     CASE "A" TO "Z"
       WorkLine$ = ParseRunLine$(WorkLine$)
       IF InName$(WorkLine$) = "SUB" THEN
        Result$ = InName$(WorkLine$)
        WorkLine$ = LTRIM$(WorkLine$)
        Value% = False%
        SELECT CASE LEFT$(WorkLine$, 1)
        CASE "$"
          Value% = True%
          WorkLine$ = MID$(WorkLine$, 2)
        CASE "!"
          WorkLine$ = MID$(WorkLine$, 2)
        CASE "@"
          WorkLine$ = MID$(WorkLine$, 2)
        CASE "#"
          WorkLine$ = MID$(WorkLine$, 2)
        CASE "%"
          WorkLine$ = MID$(WorkLine$, 2)
        CASE "&"
          WorkLine$ = MID$(WorkLine$, 2)
        END SELECT
        IF (WorkName$ = Result$) AND (SubroutineType% = Value%) THEN EXIT FOR
       END IF
     CASE ELSE
       ERROR 95
     END SELECT
    END IF
   NEXT LineNumber%
   WorkLine$ = LTRIM$(WorkLine$)
   IF CurrentSubroutine% = SubroutinesCountValue% THEN ERROR 88
   CurrentSubroutine% = CurrentSubroutine% + 1
   FOR Index% = 1 TO SubroutinesArgumentsCountValue%
    SubroutinesArguments$(CurrentSubroutine%, Index%) = ""
   NEXT Index%
   SubroutinesArgumentsCount%(CurrentSubroutine%) = 0
   IF LEFT$(WorkLine$, 1) = "(" THEN
    SubroutinesArgumentsCount%(CurrentSubroutine%) = 1
    WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
    DO WHILE WorkLine$ <> ""
     WorkName$ = InName$(WorkLine$)
     WorkLine$ = LTRIM$(WorkLine$)
     Value% = False%
     SELECT CASE LEFT$(WorkLine$, 1)
     CASE "$"
       Value% = True%
       WorkLine$ = MID$(WorkLine$, 2)
     CASE "!"
       WorkLine$ = MID$(WorkLine$, 2)
     CASE "@"
       WorkLine$ = MID$(WorkLine$, 2)
     CASE "#"
       WorkLine$ = MID$(WorkLine$, 2)
     CASE "%"
       WorkLine$ = MID$(WorkLine$, 2)
     CASE "&"
       WorkLine$ = MID$(WorkLine$, 2)
     END SELECT
     SubroutinesArguments$(CurrentSubroutine%, SubroutinesArgumentsCount%(CurrentSubroutine%)) = WorkName$ + "[" + LTRIM$(STR$(ABS(Value%))) + "]="
     WorkLine$ = LTRIM$(WorkLine$)
     SELECT CASE LEFT$(WorkLine$, 1)
     CASE ","
       WorkLine$ = MID$(WorkLine$, 2)
       IF SubroutinesArgumentsCount%(CurrentSubroutine%) = SubroutinesArgumentsCountValue% THEN ERROR 89
       SubroutinesArgumentsCount%(CurrentSubroutine%) = SubroutinesArgumentsCount%(CurrentSubroutine%) + 1
     CASE ")"
       WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
       EXIT DO
     CASE ELSE
       ERROR 2
     END SELECT
    LOOP
    InLine$ = LTRIM$(InLine$)
    IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
    InLine$ = LTRIM$(MID$(InLine$, 2))
    Index% = 1
    DO WHILE InLine$ <> ""
     Result$ = Calculate$(InLine$)
     IF VAL(MID$(SubroutinesArguments$(CurrentSubroutine%, Index%), INSTR(SubroutinesArguments$(CurrentSubroutine%, Index%), "[") + 1, 1)) <> ABS(NumStr%) THEN ERROR 13
     SubroutinesArguments$(CurrentSubroutine%, Index%) = SubroutinesArguments$(CurrentSubroutine%, Index%) + Result$
     InLine$ = LTRIM$(InLine$)
     SELECT CASE LEFT$(InLine$, 1)
     CASE ","
       InLine$ = MID$(InLine$, 2)
       IF Index% = SubroutinesArgumentsCount%(CurrentSubroutine%) THEN ERROR 37
       Index% = Index% + 1
     CASE ")"
       IF Index% <> SubroutinesArgumentsCount%(CurrentSubroutine%) THEN ERROR 37
       InLine$ = LTRIM$(MID$(InLine$, 2))
       EXIT DO
     CASE ELSE
       ERROR 2
     END SELECT
    LOOP
   END IF
   Subroutines$(CurrentSubroutine%) = "Return line=(" + LTRIM$(STR$(CurrentLine%)) + "). Old subroutine mode=[" + LTRIM$(STR$(ABS(SubroutineMode%))) + "]. Subroutine type=[" + LTRIM$(STR$(ABS(SubroutineType%))) + "]."
   SubroutinesResults$(CurrentSubroutine%) = ""
   OldSubroutineMode% = SubroutineMode%
   SubroutineMode% = True%
   CurrentLine% = LineNumber%
 CASE ELSE
   ERROR 34
 END SELECT
END SUB

SUB ScratchScreen
 COLOR 0, 2
 CLS
 PRINT "********************************************************************************"
 PRINT "                      The Standart GNU Personal Text Editor."
 PRINT "                     Copyright (C) Sandul Yura Valentinovich."
 PRINT "                           (R) Monday, 5 May 2003 year."
 PRINT
 PRINT "    This program is free software; you can redistribute it and/or modify it"
 PRINT "under the terms of the GNU General Public License as published by the Free"
 PRINT "Software Foundation; either version 2 of the License, or (at your option) any"
 PRINT "later version."
 PRINT "    This program is distributed in the hope that it will be useful, but WITHOUT"
 PRINT "ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS"
 PRINT "FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details."
 PRINT "    You should have received a copy of the GNU General Public License along with"
 PRINT "this program; if not, write to the Free Software Foundation, Inc., 675 Mass Ave,"
 PRINT "Cambridge, MA 02139, USA."
END SUB

SUB SetTimerValue (NewValue&)
 DIM TimerMeaning&
 DIM Bytes%(4)
 DIM Index%
 TimerMeaning& = NewValue&
 DEF SEG = VARSEG(TimerMeaning&)
 FOR Index% = 0 TO 3
  Bytes%(Index% + 1) = PEEK(VARPTR(TimerMeaning&) + Index%)
 NEXT Index%
 DEF SEG = &H0
 FOR Index% = 0 TO 3
  POKE &H46C + Index%, Bytes%(Index% + 1)
 NEXT Index%
 DEF SEG
END SUB

SUB SetVariable (VariableName$, VariableType%, VariableValue$)
 DIM Index%
 IF (VariableName$ = "TIME") AND VariableType% THEN
  TIME$ = VariableValue$
 ELSEIF (VariableName$ = "DATE") AND VariableType% THEN
  DATE$ = VariableValue$
 ELSEIF (VariableName$ = "ENVIRON") AND VariableType% THEN
  ENVIRON VariableValue$
 ELSEIF (VariableName$ = "RANDOM") AND (NOT VariableType%) THEN
  RANDOMIZE VAL(VariableValue$)
 ELSEIF (VariableName$ = "TIMERVALUE") AND (NOT VariableType%) THEN
  CALL SetTimerValue(VAL(VariableValue$))
 ELSE
  IF VariablesCount% = 0 THEN
   VariablesCount% = VariablesCount% + 1
   Variables$(VariablesCount%) = VariableName$ + "[" + LTRIM$(STR$(ABS(VariableType%))) + "]=" + VariableValue$
  ELSE
   FOR Index% = 1 TO VariablesCount% + 1
    IF Index% = VariablesCount% + 1 THEN
     IF VariablesCount% = VariablesCountValue% THEN ERROR 22
     VariablesCount% = VariablesCount% + 1
     Variables$(VariablesCount%) = VariableName$ + "[" + LTRIM$(STR$(ABS(VariableType%))) + "]=" + VariableValue$
     EXIT FOR
    END IF
    IF (MID$(Variables$(Index%), 1, INSTR(Variables$(Index%), "[") - 1) = VariableName$) AND (VAL(MID$(Variables$(Index%), INSTR(Variables$(Index%), "[") + 1, 1)) = ABS(VariableType%)) THEN
     Variables$(Index%) = VariableName$ + "[" + LTRIM$(STR$(ABS(VariableType%))) + "]=" + VariableValue$
     EXIT FOR
    END IF
   NEXT Index%
  END IF
 END IF
END SUB

FUNCTION SquareRoot# (Meaning#)
 DIM Value#
 DIM ControlValue#
 Value# = 1
 ControlValue# = 0
 WHILE Value# <> ControlValue#
  ControlValue# = Value#
  Value# = ((Meaning# / Value#) + Value#) / 2
 WEND
 SquareRoot# = Value#
END FUNCTION

FUNCTION WeekNumber% (DayValue%, MonthValue%, YearValue%)
 WeekNumber% = INT((MonthDaysCount%(MonthValue%, YearValue%) + DayValue%) / 7) + 1
END FUNCTION

SUB WriteLine (Line$)
 DIM OutLine$
 OutLine$ = Line$
 WHILE OutLine$ <> ""
  CALL ANSIOut(LEFT$(OutLine$, 1))
  OutLine$ = MID$(OutLine$, 2)
 WEND
END SUB

SUB WriteLineOut (Line$)
 CALL WriteLine(Line$ + CHR$(13) + CHR$(10))
END SUB

