/*
 * Decompiled with CFR 0.152.
 */
package com.speech4j.sound;

import com.speech4j.sound.AudioBuffer;
import com.speech4j.sound.SoundException;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class Util {
    private static char[] hexSymbols = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static String validSymbols = "1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static String lastRandomString = "";

    private Util() {
    }

    public static String bytes2String(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            byte by = (byte)(byArray[n] >> 4 & 0xF);
            stringBuffer.append(hexSymbols[by]);
            by = (byte)(byArray[n] & 0xF);
            stringBuffer.append(hexSymbols[by]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static byte[] string2Bytes(String string) {
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        while (n < string.length()) {
            byArray[n / 2] = Byte.parseByte(string.substring(n, n + 1), 16);
            byArray[n / 2] = (byte)(byArray[n / 2] << 4);
            int n2 = n / 2;
            byArray[n2] = (byte)(byArray[n2] | Byte.parseByte(string.substring(n + 1, n + 2), 16));
            n += 2;
        }
        return byArray;
    }

    public static void mergeAudio(String string, AudioFormat audioFormat, String[] stringArray) throws IOException, UnsupportedAudioFileException, SoundException {
        if (string == null) {
            throw new SoundException("File name is null");
        }
        if (stringArray == null) {
            throw new SoundException("Source is null");
        }
        if (stringArray.length == 0) {
            return;
        }
        try {
            Util.simpleMerge(string, audioFormat, stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Util.merge(audioFormat, stringArray, string);
        }
    }

    private static void simpleMerge(String string, AudioFormat audioFormat, String[] stringArray) throws IOException, UnsupportedAudioFileException, SoundException {
        Closeable closeable;
        if (audioFormat == null) {
            audioFormat = AudioSystem.getAudioFileFormat(new File(stringArray[0])).getFormat();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while (n < stringArray.length) {
            closeable = AudioSystem.getAudioInputStream(audioFormat, AudioSystem.getAudioInputStream(new File(stringArray[n])));
            byte[] byArray = new byte[((AudioInputStream)closeable).available()];
            ((AudioInputStream)closeable).read(byArray);
            ((AudioInputStream)closeable).close();
            byteArrayOutputStream.write(byArray);
            ++n;
        }
        closeable = new DataOutputStream(new FileOutputStream(string));
        Util.createWavHeader((DataOutput)((Object)closeable), byteArrayOutputStream.size(), audioFormat);
        byteArrayOutputStream.writeTo((OutputStream)closeable);
        byteArrayOutputStream.close();
        ((FilterOutputStream)closeable).close();
    }

    public static String randomString() {
        String string;
        while (true) {
            long l = System.currentTimeMillis() - 978400000000L;
            string = "";
            while (l != 0L) {
                string = validSymbols.charAt((int)(l % (long)validSymbols.length())) + string;
                l /= (long)validSymbols.length();
            }
            if (!string.equals(lastRandomString)) break;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        lastRandomString = string;
        return string;
    }

    public static AudioBuffer silence(double d, AudioFormat audioFormat) {
        int n = (int)(d * (double)audioFormat.getSampleRate() * (double)audioFormat.getSampleSizeInBits() * (double)audioFormat.getChannels() / 8.0);
        AudioBuffer audioBuffer = new AudioBuffer();
        audioBuffer.setFormat(audioFormat);
        audioBuffer.setData(new byte[n]);
        return audioBuffer;
    }

    public static double fileLength(String string) throws IOException, UnsupportedAudioFileException {
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(new File(string));
        AudioFormat audioFormat = audioInputStream.getFormat();
        double d = (float)audioFormat.getChannels() * audioFormat.getSampleRate() * (float)audioFormat.getSampleSizeInBits() / 8.0f;
        double d2 = (double)audioInputStream.available() / d;
        audioInputStream.close();
        return d2;
    }

    public static double bytes2sec(AudioFormat audioFormat, long l) {
        double d = (float)audioFormat.getChannels() * audioFormat.getSampleRate() * (float)audioFormat.getSampleSizeInBits() / 8.0f;
        return (double)l / d;
    }

    public static AudioBuffer merge(AudioFormat audioFormat, AudioBuffer[] audioBufferArray) throws IOException, SoundException {
        float f = 0.0f;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = true;
        if (audioFormat != null) {
            f = audioFormat.getSampleRate();
            n = audioFormat.getSampleSizeInBits();
            n2 = audioFormat.getChannels();
            bl = audioFormat.isBigEndian();
        }
        int n3 = 0;
        while (n3 < audioBufferArray.length) {
            AudioFormat audioFormat2 = audioBufferArray[n3].getFormat();
            if (f < audioFormat2.getSampleRate()) {
                f = audioFormat2.getSampleRate();
            }
            if (n < audioFormat2.getSampleSizeInBits()) {
                n = audioFormat2.getSampleSizeInBits();
            }
            if (n2 < audioFormat2.getChannels()) {
                n2 = audioFormat2.getChannels();
            }
            ++n3;
        }
        audioFormat = new AudioFormat(f, n, n2, bl2, bl);
        int n4 = audioFormat.getChannels() * audioFormat.getSampleSizeInBits() / 8;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n5 = 0;
        while (n5 < audioBufferArray.length) {
            byteArrayOutputStream.write(Util.convertSound(audioBufferArray[n5], audioFormat));
            ++n5;
        }
        AudioBuffer audioBuffer = new AudioBuffer();
        audioBuffer.setFormat(audioFormat);
        audioBuffer.setData(byteArrayOutputStream.toByteArray());
        byteArrayOutputStream.close();
        return audioBuffer;
    }

    public static void merge(AudioFormat audioFormat, AudioBuffer[] audioBufferArray, String string) throws IOException, SoundException {
        float f = 0.0f;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = true;
        if (audioFormat != null) {
            f = audioFormat.getSampleRate();
            n = audioFormat.getSampleSizeInBits();
            n2 = audioFormat.getChannels();
            bl = audioFormat.isBigEndian();
        }
        int n3 = 0;
        while (n3 < audioBufferArray.length) {
            AudioFormat audioFormat2 = audioBufferArray[n3].getFormat();
            if (f < audioFormat2.getSampleRate()) {
                f = audioFormat2.getSampleRate();
            }
            if (n < audioFormat2.getSampleSizeInBits()) {
                n = audioFormat2.getSampleSizeInBits();
            }
            if (n2 < audioFormat2.getChannels()) {
                n2 = audioFormat2.getChannels();
            }
            ++n3;
        }
        audioFormat = new AudioFormat(f, n, n2, bl2, bl);
        int n4 = audioFormat.getChannels() * audioFormat.getSampleSizeInBits() / 8;
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
        randomAccessFile.write(new byte[44]);
        int n5 = 0;
        while (n5 < audioBufferArray.length) {
            randomAccessFile.write(Util.convertSound(audioBufferArray[n5], audioFormat));
            ++n5;
        }
        Util.createWavHeader(randomAccessFile, audioFormat);
        randomAccessFile.close();
    }

    public static void createWavHeader(RandomAccessFile randomAccessFile, AudioFormat audioFormat) throws IOException {
        int n = (int)(randomAccessFile.length() - 44L);
        randomAccessFile.seek(0L);
        Util.createWavHeader(randomAccessFile, n, audioFormat);
    }

    public static void createWavHeader(DataOutput dataOutput, int n, AudioFormat audioFormat) throws IOException {
        dataOutput.write("RIFF".getBytes());
        int n2 = n + 44 - 8;
        dataOutput.write(n2 & 0xFF);
        dataOutput.write(n2 >> 8 & 0xFF);
        dataOutput.write(n2 >> 16 & 0xFF);
        dataOutput.write(n2 >> 24 & 0xFF);
        dataOutput.write("WAVEfmt ".getBytes());
        dataOutput.write(16);
        dataOutput.write(0);
        dataOutput.write(0);
        dataOutput.write(0);
        dataOutput.write(1);
        dataOutput.write(0);
        dataOutput.write(audioFormat.getChannels());
        dataOutput.write(0);
        int n3 = (int)audioFormat.getSampleRate();
        dataOutput.write(n3 & 0xFF);
        dataOutput.write(n3 >> 8 & 0xFF);
        dataOutput.write(n3 >> 16 & 0xFF);
        dataOutput.write(n3 >> 24 & 0xFF);
        int n4 = n3 * audioFormat.getSampleSizeInBits() * audioFormat.getChannels() / 8;
        dataOutput.write(n4 & 0xFF);
        dataOutput.write(n4 >> 8 & 0xFF);
        dataOutput.write(n4 >> 16 & 0xFF);
        dataOutput.write(n4 >> 24 & 0xFF);
        int n5 = audioFormat.getSampleSizeInBits() * audioFormat.getChannels() / 8;
        dataOutput.write(n5 & 0xFF);
        dataOutput.write(n5 >> 8 & 0xFF);
        int n6 = audioFormat.getSampleSizeInBits();
        dataOutput.write(n6 & 0xFF);
        dataOutput.write(n6 >> 8 & 0xFF);
        dataOutput.write("data".getBytes());
        dataOutput.write(n & 0xFF);
        dataOutput.write(n >> 8 & 0xFF);
        dataOutput.write(n >> 16 & 0xFF);
        dataOutput.write(n >> 24 & 0xFF);
    }

    public static void merge(AudioFormat audioFormat, String[] stringArray, String string) throws IOException, SoundException, UnsupportedAudioFileException {
        float f = 0.0f;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = true;
        if (audioFormat != null) {
            f = audioFormat.getSampleRate();
            n = audioFormat.getSampleSizeInBits();
            n2 = audioFormat.getChannels();
            bl = audioFormat.isBigEndian();
        }
        int n3 = 0;
        while (n3 < stringArray.length) {
            AudioFormat audioFormat2 = AudioSystem.getAudioFileFormat(new File(stringArray[n3])).getFormat();
            f = Math.max(f, audioFormat2.getSampleRate());
            n = Math.max(n, audioFormat2.getSampleSizeInBits());
            n2 = Math.max(n2, audioFormat2.getChannels());
            ++n3;
        }
        audioFormat = new AudioFormat(f, n, n2, bl2, bl);
        int n4 = audioFormat.getChannels() * audioFormat.getSampleSizeInBits() / 8;
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
        randomAccessFile.write(new byte[44]);
        int n5 = 0;
        while (n5 < stringArray.length) {
            int n6;
            File file = new File(stringArray[n5]);
            if (!file.exists()) {
                throw new IOException("File " + file.getAbsolutePath() + " not found");
            }
            AudioFileFormat audioFileFormat = AudioSystem.getAudioFileFormat(file);
            AudioFormat audioFormat3 = audioFileFormat.getFormat();
            AudioInputStream audioInputStream = new AudioInputStream(new FileInputStream(file), audioFormat3, audioFileFormat.getFrameLength());
            int n7 = audioFormat3.getChannels() * audioFormat3.getSampleSizeInBits() / 8;
            byte[] byArray = new byte[n7 * 4096];
            while ((n6 = audioInputStream.read(byArray)) != -1) {
                randomAccessFile.write(Util.convertSound(byArray, 0, n6, audioFormat3, audioFormat));
            }
            audioInputStream.close();
            ++n5;
        }
        Util.createWavHeader(randomAccessFile, audioFormat);
        randomAccessFile.close();
    }

    public static byte[] convertSound(AudioBuffer audioBuffer, AudioFormat audioFormat) throws SoundException {
        return Util.convertSound(audioBuffer.getData(), audioBuffer.getFormat(), audioFormat);
    }

    public static byte[] convertSound(byte[] byArray, AudioFormat audioFormat, AudioFormat audioFormat2) throws SoundException {
        return Util.convertSound(byArray, 0, byArray.length, audioFormat, audioFormat2);
    }

    public static byte[] convertSound(byte[] byArray, int n, int n2, AudioFormat audioFormat, AudioFormat audioFormat2) throws SoundException {
        if (audioFormat.matches(audioFormat2)) {
            if (n == 0 && n2 == byArray.length) {
                return byArray;
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            return byArray2;
        }
        int n3 = audioFormat2.getChannels() * audioFormat2.getSampleSizeInBits() / 8;
        int n4 = audioFormat.getChannels() * audioFormat.getSampleSizeInBits() / 8;
        int n5 = n2 / n4;
        int n6 = (int)((float)n5 * audioFormat2.getSampleRate() / audioFormat.getSampleRate());
        byte[] byArray3 = new byte[n6 * n3];
        int n7 = 0;
        while (n7 < n5) {
            int n8 = 0;
            int n9 = 0;
            int n10 = audioFormat.getSampleSizeInBits() / 8;
            block0 : switch (audioFormat.getChannels()) {
                case 2: {
                    switch (audioFormat.getSampleSizeInBits()) {
                        case 16: {
                            n9 = (short)(byArray[n + n7 * n4 + 1 + n10] << 8 & 0xFF00);
                        }
                        case 8: {
                            n9 |= byArray[n + n7 * n4 + n10] & 0xFF;
                            break;
                        }
                        default: {
                            throw new SoundException("Unsupported sample size: " + audioFormat.getSampleSizeInBits());
                        }
                    }
                }
                case 1: {
                    switch (audioFormat.getSampleSizeInBits()) {
                        case 16: {
                            n8 = (short)(byArray[n + n7 * n4 + 1] << 8 & 0xFF00);
                        }
                        case 8: {
                            n8 |= byArray[n + n7 * n4] & 0xFF;
                            break block0;
                        }
                    }
                    throw new SoundException("Unsupported sample size: " + audioFormat.getSampleSizeInBits());
                }
                default: {
                    throw new SoundException("Unsupported number of channels: " + audioFormat.getChannels());
                }
            }
            if (audioFormat.getChannels() == 1 && audioFormat2.getChannels() == 2) {
                n9 = n8;
            }
            switch (audioFormat2.getSampleSizeInBits() - audioFormat.getSampleSizeInBits()) {
                case -8: {
                    n9 = n9 >> 8 & 0xFF;
                    n8 = n8 >> 8 & 0xFF;
                    break;
                }
                case 0: {
                    break;
                }
                case 8: {
                    n9 = n9 << 8 & 0xFF00;
                    n8 = n8 << 8 & 0xFF00;
                    break;
                }
                default: {
                    throw new SoundException("Unsupported sample size: " + audioFormat.getSampleSizeInBits());
                }
            }
            int n11 = (int)((float)n7 * audioFormat2.getSampleRate() / audioFormat.getSampleRate());
            int n12 = (int)((float)(n7 + 1) * audioFormat2.getSampleRate() / audioFormat.getSampleRate());
            int n13 = n11;
            while (n13 < n12) {
                int n14 = n13 * n3;
                block17 : switch (audioFormat2.getChannels()) {
                    case 2: {
                        switch (audioFormat2.getSampleSizeInBits()) {
                            case 16: {
                                if (audioFormat2.isBigEndian()) {
                                    byArray3[n14 + 2] = (byte)(n9 >> 8 & 0xFF);
                                    byArray3[n14 + 3] = (byte)(n9 & 0xFF);
                                    break;
                                }
                                byArray3[n14 + 2] = (byte)(n9 & 0xFF);
                                byArray3[n14 + 3] = (byte)(n9 >> 8 & 0xFF);
                                break;
                            }
                            case 8: {
                                byArray3[n14 + 1] = (byte)(n9 & 0xFF);
                                break;
                            }
                            default: {
                                throw new SoundException("Unsupported sample size: " + audioFormat2.getSampleSizeInBits());
                            }
                        }
                    }
                    case 1: {
                        switch (audioFormat2.getSampleSizeInBits()) {
                            case 16: {
                                if (audioFormat2.isBigEndian()) {
                                    byArray3[n14] = (byte)(n8 >> 8 & 0xFF);
                                    byArray3[n14 + 1] = (byte)(n8 & 0xFF);
                                    break block17;
                                }
                                byArray3[n14] = (byte)(n8 & 0xFF);
                                byArray3[n14 + 1] = (byte)(n8 >> 8 & 0xFF);
                                break block17;
                            }
                            case 8: {
                                byArray3[n14] = (byte)(n8 & 0xFF);
                                break block17;
                            }
                        }
                        throw new SoundException("Unsupported sample size: " + audioFormat2.getSampleSizeInBits());
                    }
                    default: {
                        throw new SoundException("Unsupported number of channels: " + audioFormat2.getChannels());
                    }
                }
                ++n13;
            }
            ++n7;
        }
        return byArray3;
    }
}

