{***************************************************************}
{ FIBPlus - component library for direct access to Firebird and }
{ Interbase databases                                           }
{                                                               }
{    FIBPlus is based in part on the product                    }
{    Free IB Components, written by Gregory H. Deatz for        }
{    Hoagland, Longo, Moran, Dunst & Doukas Company.            }
{    mailto:gdeatz@hlmdd.com                                    }
{                                                               }
{    Copyright (c) 1998-2001 Serge Buzadzhy                     }
{    Contact: buzz@devrace.com                                  }
{                                                               }
{ ------------------------------------------------------------- }
{    FIBPlus home page      : http://www.fibplus.net/           }
{    FIBPlus support e-mail : fibplus@devrace.com               }
{ ------------------------------------------------------------- }
{                                                               }
{  Please see the file License.txt for full license information }
{***************************************************************}
unit pFIBDataSetOptions;

interface

uses Classes, Controls, Forms, FIBDataSet, pFIBProps, StdCtrls, ComCtrls,
  Db, pFIBDataSet;

type

  TFPDataSetOptionsForm = class(TForm)
    pFIBDataSet1: TpFIBDataSet;
    Pages: TPageControl;
    OptionsPage: TTabSheet;
    PreparePage: TTabSheet;
    OkB: TButton;
    CancelB: TButton;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    CheckBox8: TCheckBox;
    CheckBox9: TCheckBox;
    CheckBox10: TCheckBox;
    CheckBox11: TCheckBox;
    CheckBox12: TCheckBox;
    CheckBox13: TCheckBox;
    CheckBox14: TCheckBox;
    CheckBox15: TCheckBox;
    CheckBox16: TCheckBox;
    CheckBox17: TCheckBox;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    FDataSet: TFIBDataSet;
  public
    { Public declarations }
    function GetOptionBox(aIndex: Integer): TCheckBox;
    function GetPrepareOptionBox(aIndex: Integer): TCheckBox;
  end;

function EditOptions(aDataSet: TFIBDataSet; aPageIndex: Integer): boolean;

implementation
uses FIBConsts, SysUtils;

{$R *.dfm}

function EditOptions(aDataSet: TFIBDataSet; aPageIndex: Integer): boolean;
var aForm: TFPDataSetOptionsForm;
    I: TpFIBDsOption;
    J: TpPrepareOption;
begin
  Result := False;
  if aDataSet = nil then exit;
  aForm := TFPDataSetOptionsForm.Create(Application);
  try
    with aForm do begin
      FDataSet := aDataSet;
      Caption := Format(Caption, [FDataSet.Name]);
      Pages.ActivePage := Pages.Pages[aPageIndex];
      for I := poTrimCharFields to poAllowChangeSqls do
        GetOptionBox(ord(I)).Checked := I in FDataSet.Options;
      for J := pfSetRequiredFields to psAskRecordCount do
        GetPrepareOptionBox(ord(J)).Checked := J in FDataSet.PrepareOptions;
      Result := ShowModal = mrOk;
      if Result then begin
        FDataSet.Options := [];
        for I := poTrimCharFields to poAllowChangeSqls do
          if GetOptionBox(ord(I)).Checked then FDataSet.Options := FDataSet.Options + [I];
        FDataSet.PrepareOptions := [];
        for J := pfSetRequiredFields to psAskRecordCount do
          if GetPrepareOptionBox(ord(J)).Checked then FDataSet.PrepareOptions := FDataSet.PrepareOptions + [J];
      end;
    end;
  finally
    aForm.Free;
  end;
end;

function TFPDataSetOptionsForm.GetOptionBox(aIndex: Integer): TCheckBox;
begin
  Result := TCheckBox(OptionsPage.Controls[aIndex]);
end;

function TFPDataSetOptionsForm.GetPrepareOptionBox(aIndex: Integer): TCheckBox;
begin
  Result := TCheckBox(PreparePage.Controls[aIndex]);
end;

procedure TFPDataSetOptionsForm.FormCreate(Sender: TObject);
begin
  //
  Caption := FPOptionsCaption;
  OptionsPage.Caption := FPOptionsPage;
  PreparePage.Caption := FPOptionsPreparePage;

  CheckBox1.Caption := FPOptionsTrimChars;
  CheckBox2.Caption := FPOptionsRefresh;
  CheckBox3.Caption := FPOptionsRefreshDelete;
  CheckBox4.Caption := FPOptionsAutoStart;
  CheckBox5.Caption := FPOptionsApplyFormats;
  CheckBox6.Caption := FPOptionsIdleUpdate;
  CheckBox7.Caption := FPOptionsKeepSort;
  CheckBox8.Caption := FPOptionsRestoreSort;
  CheckBox9.Caption := FPOptionsAllowChange;
  CheckBox10.Caption := FPOptionsSetRequired;
  CheckBox11.Caption := FPOptionsSetReadOnly;
  CheckBox12.Caption := FPOptionsSetDefault;
  CheckBox13.Caption := FPOptionsEmulateBoolean;
  CheckBox14.Caption := FPOptionsCreateBCD;
  CheckBox15.Caption := FPOptionsApplyRepository;
  CheckBox16.Caption := FPOptionsSortFields;
  CheckBox17.Caption := FPOptionsRecordCount;
end;

end.
