{***************************************************************}
{ FIBPlus - component library for direct access to Firebird and }
{ Interbase databases                                           }
{                                                               }
{    FIBPlus is based in part on the product                    }
{    Free IB Components, written by Gregory H. Deatz for        }
{    Hoagland, Longo, Moran, Dunst & Doukas Company.            }
{    mailto:gdeatz@hlmdd.com                                    }
{                                                               }
{    Copyright (c) 1998-2001 Serge Buzadzhy                     }
{    Contact: buzz@devrace.com                                  }
{                                                               }
{ ------------------------------------------------------------- }
{    FIBPlus home page      : http://www.fibplus.net/           }
{    FIBPlus support e-mail : fibplus@devrace.com               }
{ ------------------------------------------------------------- }
{                                                               }
{  Please see the file License.txt for full license information }
{***************************************************************}



unit RegFIBPlusEditors;

interface
{$I FIBPlus.inc}
uses
 {$IFDEF MSWINDOWS}
  Classes, Sysutils, DB, Dialogs, Controls,Forms,
  pFIBDataSet, pFIBDatabase, pFIBStoredProc,FIBSQLEd,
  pFIBQuery, DSContainer,  pFIBErrorHandler, pFIBStatistic,pFIBConditionsEdit,
 {$IFNDEF NO_MONITOR}
   FIBSQLMonitor,
 {$ENDIF}

  {$IFDEF D6+}
     DesignEditors,DesignIntf, Variants,
  {$else}
     DsgnIntf,
  {$endif}
  pFIBDBEdit,pFIBTrEdit
  {$IFDEF FOR_ALL},pFIBProps{$ELSE},sbFIBProps{$ENDIF}

  {$IFDEF CAN_DYN_ARRAY}
    {$IFDEF  INC_SERVICE_SUPPORT}
     , IB_Services
    {$ENDIF}
  {$ENDIF}
;
 {$ENDIF}
 {$IFDEF LINUX}
  Classes, SysUtils, DB, QDialogs, QControls,QForms,
  pFIBDataSet, pFIBDatabase, pFIBStoredProc,FIBSQLEd,
  pFIBQuery, DSContainer,pFIBErrorHandler,pFIBConditionsEdit,
  {$IFDEF D6+}
    
 DesignEditors,DesignIntf, Variants,
  {$else}
     DsgnIntf,
  {$endif}
  pFIBDBEdit,pFIBTrEdit
  {$IFDEF FOR_ALL},pFIBProps{$ELSE},sbFIBProps{$ENDIF}

  {$IFDEF CAN_DYN_ARRAY}
    {$IFDEF  INC_SERVICE_SUPPORT}
     , IB_Services
    {$ENDIF}
  {$ENDIF}
;
 {$ENDIF}


type
  TpFIBTransactionEditor = class(TComponentEditor)
    procedure ExecuteVerb(Index: Integer); override;
    function  GetVerb(Index: Integer): string; override;
    function  GetVerbCount: Integer; override;
  end;

  TpFIBStatisticEditor = class(TComponentEditor)
    procedure ExecuteVerb(Index: Integer); override;
    function  GetVerb(Index: Integer): string; override;
    function  GetVerbCount: Integer; override;
  end;


  TpFIBDatabaseEditor = class(TComponentEditor)
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

  TFIBSQLsProperties = class(TClassProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
    procedure Edit; override;
  end;

  TFIBSQLsProperty = class(TClassProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
    procedure Edit; override;
  end;

  TFIBConditionsEditor = class(TClassProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;


  TFIBGenSQlEd = class(TComponentEditor)
  {$IFDEF D6+}
    DefaultEditor: IComponentEditor;
  {$ELSE}
    DefaultEditor: TComponentEditor;
  {$ENDIF}
  public
{$IFDEF VER100}
    constructor Create(AComponent: TComponent; ADesigner: TFormDesigner); override;
{$ELSE}
  {$IFNDEF D6+}
    constructor Create(AComponent: TComponent; ADesigner: IFormDesigner); override;
  {$ELSE}
    constructor Create(AComponent: TComponent; ADesigner: IDesigner); override;
  {$ENDIF}
{$ENDIF}
    destructor Destroy; override;
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
    procedure SaveDataSetInfo;
  end;

  TpFIBAutoUpdateOptionsEditor = class(TClassProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

  TpFIBDataSetOptionsEditor = class(TSetProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

procedure Register;

implementation

uses
{$IFNDEF NO_REGISTRY} RegUtils, {$ENDIF}
FIBDataSet, FIBQuery, FIBDatabase, SqlTxtRtns, StrUtil,
     EdFieldInfo, pFIBDataInfo, EdDataSetInfo,FIBDBLoginDlg,FIBConsts,
     pFIBAutoUpdEditor, pFIBDataSetOptions;

const FIBPalette = 'FIBPlus';


type
 TFIBAliasEdit = class(TStringProperty)
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
 end;

function TFIBAliasEdit.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes;
  Result := Result + [paValueList]
end;

procedure TFIBAliasEdit.GetValues(Proc: TGetStrProc);
var i: integer;
  Keys: Variant;
begin
{$IFNDEF NO_REGISTRY}
  if PropCount > 1 then Exit;
  Keys := DefAllSubKey(['Software', RegFIBRoot, 'Aliases']);
  if VarType(Keys) = varBoolean then Exit;
  for i := VarArrayLowBound(Keys, 1) to VarArrayHighBound(Keys, 1) do Proc(Keys[i])
{$ENDIF}  
end;
//
type
 TFIBTrKindEdit = class(TStringProperty)
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
 end;

function TFIBTrKindEdit.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes;
  Result := Result + [paValueList]
end;

procedure TFIBTrKindEdit.GetValues(Proc: TGetStrProc);
var i: integer;
    Keys,v: Variant;
begin
{$IFNDEF NO_REGISTRY}
  if PropCount > 1 then Exit;
  Keys := DefAllSubKey(['Software', RegFIBRoot, RegFIBTrKinds]);
  Proc('NoUserKind');
  if VarType(Keys) = varBoolean then Exit;
  for i := VarArrayLowBound(Keys, 1) to VarArrayHighBound(Keys, 1) do begin
   v:=DefReadFromRegistry(['Software', RegFIBRoot, RegFIBTrKinds,
    Keys[i]
   ],['Name']);
   if VarType(v) <> varBoolean then
    Proc(v[0,0])
  end;
{$ENDIF}  
end;


type
  TDataSet_ID_Edit = class(TIntegerProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

function TDataSet_ID_Edit.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paDialog];
end;

procedure TDataSet_ID_Edit.Edit;
var OldID: integer;
begin
  OldID := TpFIBDataSet(GetComponent(0)).DataSet_ID;
  if not ExistDRepositaryTable(TpFibDataSet(GetComponent(0)).DataBase) then begin
    if
      MessageDlg(SCompEditInfoTableNotExist, mtConfirmation, [mbOK, mbCancel], 0
      ) <> mrOk
      then Exit;
    CreateDRepositaryTable(TpFibDataSet(GetComponent(0)).DataBase);
  end;

  ChooseDSInfo(TpFIBDataSet(GetComponent(0)));
  if OldID <> TpFIBDataSet(GetComponent(0)).DataSet_ID then
    Modified
end;
//
type TTableNameEdit = class(TStringProperty)
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

function TTableNameEdit.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes;
  Result := Result + [paValueList]
end;

procedure TTableNameEdit.GetValues(Proc: TGetStrProc);
var i: integer;
  Tables: TStrings;
begin
  if PropCount > 1 then Exit;
  if not (TAutoUpdateOptions(GetComponent(0)).Owner is TpFIBDataSet) then Exit;
  Tables := TStringList.Create;
  with TpFIBDataSet(TAutoUpdateOptions(GetComponent(0)).Owner) do try
    AllTables(SelectSQL.Text, Tables);
    for i := 0 to Pred(Tables.Count) do Proc(ExtractWord(1, Tables[i], [' ']));
  finally
    Tables.Free
  end
end;
//

type TKeyFieldNameEdit = class(TStringProperty)
    function  GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

function TKeyFieldNameEdit.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes;
  Result := Result + [paValueList]
end;

procedure TKeyFieldNameEdit.GetValues(Proc: TGetStrProc);
var i: integer;
  Tables: TStrings;
begin
  if PropCount > 1 then Exit;
  if not (TAutoUpdateOptions(GetComponent(0)).Owner is TpFIBDataSet) then Exit;
  Tables := TStringList.Create;
  with TpFIBDataSet(TAutoUpdateOptions(GetComponent(0)).Owner),
    TAutoUpdateOptions(GetComponent(0))
    do try
    if IsBlank(UpdateTableName) then
    begin
     ShowMessage('Error: UpdateTableName is empty');
     Exit;
    end;
    FieldDefs.Update;
    if FieldCount>0 then
      for i := 0 to Pred(FieldCount) do begin
        if (Fields[i] is TIntegerField)
         and     (UpperCase(GetRelationTableName(Fields[i])) = UpperCase(UpdateTableName))
        then
        begin
           Proc(Fields[i].FieldName);
        end;
      end
    else
      for i := 0 to Pred(FieldDefs.Count) do begin
        if (FieldDefs[i].DataType in [ftSmallint, ftInteger]) and          
        (UpperCase(GetRelationTableName(FieldDefs[i])) = UpperCase(UpdateTableName))
        then
        begin
           Proc(FieldDefs[i].Name);
        end;
      end

  finally
    Tables.Free
  end
end;


function TpFIBTransactionEditor.GetVerbCount: Integer;
begin
  Result := 1;
end;

function TpFIBTransactionEditor.GetVerb(Index: Integer): string;
begin
  case Index of
    0: Result := SCompEditEditTransaction;
  end;
end;

procedure TpFIBTransactionEditor.ExecuteVerb(Index: Integer);
begin
 case Index of
  0:  if EditFIBTrParams(TpFIBTransaction(Component)) then
       Designer.Modified
 end;
end;


//===========
procedure TpFIBDatabaseEditor.ExecuteVerb(Index: Integer);
var Tr:TFIBTransaction;
begin
  case Index of
    0: begin
        if not
         pFIBDataInfo.ExistFRepositaryTable(TFIBDataBase(Component)) then begin
          if MessageDlg(SCompEditInfoFieldsNotExist, mtConfirmation, [mbOK, mbCancel], 0) <> mrOk
            then Exit;
          CreateFRepositaryTable(TFIBDataBase(Component));
        end
        else
        begin
         Tr:=TFIBTransaction.Create(nil);
         try
          Tr.DefaultDatabase:=TFIBDataBase(Component);
          Update1RepositaryTable(Tr);
         finally
          Tr.Free;
         end
        end;

        ShowFieldInfo(TFIBDataBase(Component))
      end;
    1 :if EditFIBDatabase(TFIBDataBase(Component)) then
        Designer.Modified;
  end;
end;

function TpFIBDatabaseEditor.GetVerb(Index: Integer): string;
begin
  case Index of
    0: Result := SCompEditEditFieldInfo;
    1: Result := SCompEditDBEditor;
  end;
end;

function TpFIBDatabaseEditor.GetVerbCount: Integer;
begin
    Result := 2
end;


type TGeneratorNameEdit = class(TStringProperty)
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

function TGeneratorNameEdit.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes;
  Result := Result + [paValueList]
end;

procedure TGeneratorNameEdit.GetValues(Proc: TGetStrProc);
var
  Qry: TpFIBQuery;
  Trans: TpFIBTransaction;
  Dset: TpFIBDataset;
  lSQLDA: TFIBXSQLDA;

begin
  if PropCount > 1 then Exit;
  if not (TAutoUpdateOptions(GetComponent(0)).Owner is TpFIBDataSet) then
Exit;
  Dset:= (TAutoUpdateOptions(GetComponent(0)).Owner as TpFIBDataSet);
  Qry := nil; Trans := nil;
  try
  Trans := TpFIBTransaction.Create(nil);
  Qry := TpFIBQuery.Create(nil);
  Qry.ParamCheck:=false;
  Qry.Database := Dset.Database;
  Trans.DefaultDatabase := Dset.Database;
  Qry.Transaction := Trans;
  Qry.SQL.Text := 'select RDB$GENERATOR_NAME '+
                  'from RDB$GENERATORS '+
  'where (RDB$SYSTEM_FLAG is NULL) or (RDB$SYSTEM_FLAG = 0)'+
                  'order by RDB$GENERATOR_NAME';
  try
   Trans.StartTransaction;
   Qry.ExecQuery;
   lSQLDA := Qry.Current;
     while not Qry.Eof do
     begin
       Proc(Trim(lSQLDA.ByName['RDB$GENERATOR_NAME'].AsString));
       lSQLDA := Qry.Next;
     end;
   Qry.Close;
  finally
   Trans.Commit;
  end;

  finally
    Qry.Free;
    Trans.Free;
  end
end;

// DataSet component editors

type
  PClass = ^TClass;

{$IFDEF VER100}

constructor TFIBGenSQlEd.Create(AComponent: TComponent; ADesigner: TFormDesigner);
{$ELSE}

{$IFNDEF D6+}
constructor TFIBGenSQlEd.Create(AComponent: TComponent; ADesigner: IFormDesigner);
{$ELSE}
 constructor TFIBGenSQlEd.Create(AComponent: TComponent; ADesigner: IDesigner);
{$ENDIF}
{$ENDIF}
var CompClass: TClass;
begin
  inherited Create(AComponent, ADesigner);
  CompClass := PClass(Acomponent)^;
  try
    PClass(AComponent)^ := TDataSet;
    DefaultEditor := GetComponentEditor(AComponent, ADesigner);
  finally
    PClass(AComponent)^ := CompClass;
  end;
end;

destructor TFIBGenSQlEd.Destroy;
begin
{$IFDEF D6+}
//  DefaultEditor._Release;
// DefaultEditor.;
{$ELSE}
  DefaultEditor.Free;
{$ENDIF}
  inherited Destroy
end;


function TFIBGenSQlEd.GetVerbCount: Integer;
begin
  if (Component is TpFIBDataSet) then
    Result := DefaultEditor.GetVerbCount + 2
  else
    Result := DefaultEditor.GetVerbCount + 1;
end;

function TFIBGenSQlEd.GetVerb(Index: Integer): string;
begin
  if Index < DefaultEditor.GetVerbCount then
    Result := DefaultEditor.GetVerb(Index)
  else
    case Index - DefaultEditor.GetVerbCount of
      0: Result := SCompEditSQLGenerator;
      1: Result := SCompEditDataSetInfo;
    end;
end;

procedure TFIBGenSQlEd.ExecuteVerb(Index: Integer);
var SText:string;
    k:integer;
    Reopen:boolean;
begin
  if Index < DefaultEditor.GetVerbCount then
  with TFIBDataSet(Component) do
  begin
    Reopen:=Active;
    Close;
    QSelect.FreeHandle;
    Prepare;
    if Reopen then Open;      
    DefaultEditor.ExecuteVerb(Index);
  end
  else
  begin
   SText:=TFIBDataSet(Component).SelectSQL.Text;
   case Index - DefaultEditor.GetVerbCount of
      0: begin
          if IsBlank(TFIBDataSet(Component).SelectSQL.Text) then
           k:=1
          else
           k:=0;
          if ShowEdSQL(TFIBDataSet(Component),k) then Designer.Modified;
         end;
      1: SaveDataSetInfo
   end;
   if SText<>TFIBDataSet(Component).SelectSQL.Text then
    Designer.Modified;
  end;
end;

procedure TFIBGenSQlEd.SaveDataSetInfo;
begin
  with Component as TpFibDataSet do
    if DataSet_ID = 0 then ShowMessage(Name + SCompEditDataSet_ID)
    else
      if DataBase = nil then ShowMessage(SDataBaseNotAssigned)
      else begin
        if not ExistDRepositaryTable(TFIBDataset(Component).DataBase) then begin
          if
            MessageDlg(SCompEditInfoTableNotExist, mtConfirmation, [mbOK, mbCancel], 0
            ) <> mrOk
            then Exit;
          CreateDRepositaryTable(TFibDataSet(Component).DataBase);
        end;
        SaveFIBDataSetInfo(TpFibDataSet(Component));
      end;
end;

{  TFIBSQLsProperties }

function TFIBSQLsProperties.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paDialog,paSubProperties];
end;

function TFIBSQLsProperties.GetValue: string;
begin
 Result := '(SQLs)'
end;

procedure TFIBSQLsProperties.Edit;
begin
 if ShowEdSQL(TFIBDataSet(GetComponent(0)),1) then
    Designer.Modified
end;

{ TFIBSQLsProperty }

procedure TFIBSQLsProperty.Edit;
var  pName:string;
     KindSQL:integer;
begin
   pName:=GetPropInfo^.Name;
   if pName='SelectSQL' then
     KindSQL:=1
   else
   if pName='UpdateSQL' then
     KindSQL:=2
   else
   if pName='InsertSQL' then
     KindSQL:=3
   else
   if pName='DeleteSQL' then
     KindSQL:=4
   else
   if pName='RefreshSQL' then
     KindSQL:=5
   else
     KindSQL:=0;
   if ShowEdSQL(TFIBDataSet(TSQLs(GetComponent(0)).Owner),KindSQL) then
    Designer.Modified
end;


function TFIBSQLsProperty.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paDialog] - [paSubProperties];
end;

function TFIBSQLsProperty.GetValue: string;
begin
  Result := SCompEditSQLText;
end;


type

TpFIBStoredProcProperty = class(TStringProperty)
public
  function GetAttributes: TPropertyAttributes; override;
  procedure GetValues(Proc: TGetStrProc); override;
end;

function TpFIBStoredProcProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paSortList];
end;

procedure TpFIBStoredProcProperty.GetValues(Proc: TGetStrProc);
var
  StoredProc: TpFIBStoredProc;
  Qry: TpFIBQuery;
  Trans: TpFIBTransaction;
  lSQLDA: TFIBXSQLDA;
begin
  StoredProc := GetComponent(0) as TpFIBStoredProc;
  Qry := nil; Trans := nil;
  try
    Qry := TpFIBQuery.Create(nil);
    Qry.ParamCheck:=false;
    Qry.Database := StoredProc.Database;
    Trans := TpFIBTransaction.Create(nil);
    Trans.DefaultDatabase := StoredProc.Database;
    Qry.Transaction := Trans;
    Qry.SQL.Text := 'SELECT RDB$PROCEDURE_NAME FROM RDB$PROCEDURES';
    Trans.StartTransaction;
    try
    Qry.ExecQuery;
      lSQLDA := Qry.Current;
      while not Qry.Eof do
      begin
        Proc(Trim(lSQLDA.ByName['RDB$PROCEDURE_NAME'].AsString));
        lSQLDA := Qry.Next;
      end;
      Qry.Close;
    finally
      Trans.Commit;
    end;
  finally
    Qry.Free;
    Trans.Free;
  end;
end;

{ TpFIBStatisticEditor }

procedure TpFIBStatisticEditor.ExecuteVerb(Index: Integer);
begin
{$IFNDEF LINUX}
 with TpFIBStatistic(Component) do
  if ExistStatTable then
   ShowMessage(Database.DBName + ': ' + SCompEditStatTableExist)
  else
  begin
   CreateStatTable;
   ShowMessage(Database.DBName + ': ' + SCompEditStatTableCreated)
  end;
{$ENDIF}
end;

function TpFIBStatisticEditor.GetVerb(Index: Integer): string;
begin
 Result := SCompEditCreateStatTable;
end;

function TpFIBStatisticEditor.GetVerbCount: Integer;
begin
 Result:=1;
end;


{ TFIBConditionsEditor }

procedure TFIBConditionsEditor.Edit;
begin
 if GetComponent(0) is TFIBQuery then
  if EditCheckStrings(TFIBQuery(GetComponent(0)).Conditions) then
    Designer.Modified
  else
 else
  if GetComponent(0) is TpFIBDataSet then
  if EditCheckStrings(TpFIBDataSet(GetComponent(0)).Conditions) then
    Designer.Modified
 
end;

function TFIBConditionsEditor.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paDialog] - [paSubProperties];
end;

procedure Register;
begin
  RegisterPropertyEditor(TypeInfo(string), TpFIBDatabase, 'AliasName', TFIBAliasEdit);


  RegisterPropertyEditor(TypeInfo(string),TpFIBTransaction,
   'UserKindTransaction',   TFIBTrKindEdit
  );

  RegisterPropertyEditor(TypeInfo(TStrings),TSQLs,'',TFIBSQLsProperty);

  RegisterPropertyEditor(TypeInfo(TSQLs),TFIBDataSet,'',TFIBSQLsProperties);

  RegisterPropertyEditor(TypeInfo(TConditions),nil,'',TFIBConditionsEditor);

  RegisterPropertyEditor(TypeInfo(string), TAutoUpdateOptions,
    'UpdateTableName', TTableNameEdit
    );
  RegisterPropertyEditor(TypeInfo(string), TAutoUpdateOptions,
    'KeyFields', TKeyFieldNameEdit
    );
  RegisterPropertyEditor(TypeInfo(integer), TpFIBDataSet,
    'DataSet_ID', TDataSet_ID_Edit
    );
  RegisterPropertyEditor(TypeInfo(string), TpFIBStoredProc, 'StoredProcName',
   TpFIBStoredProcProperty
  );
  RegisterPropertyEditor(TypeInfo(boolean),TFIBDataSet,'WaitEndMasterScroll',nil);


  RegisterPropertyEditor(TypeInfo(TStrings),TFIBDataSet,'SelectSQL',nil);
  RegisterPropertyEditor(TypeInfo(TStrings),TFIBDataSet,'InsertSQL',nil);
  RegisterPropertyEditor(TypeInfo(TStrings),TFIBDataSet,'UpdateSQL',nil);
  RegisterPropertyEditor(TypeInfo(TStrings),TFIBDataSet,'DeleteSQL',nil);
  RegisterPropertyEditor(TypeInfo(TStrings),TFIBDataSet,'RefreshSQL',nil);

  {$IFNDEF LINUX}
  RegisterComponentEditor(TpFIBStatistic, TpFIBStatisticEditor);
  {$ENDIF}
  RegisterComponentEditor(TpFIBTransaction, TpFIBTransactionEditor);
  RegisterComponentEditor(TpFIBDatabase, TpFIBDatabaseEditor);
  RegisterComponentEditor(TFIBDataSet, TFIBGenSQlEd);
  RegisterPropertyEditor(TypeInfo(string), TAutoUpdateOptions,
    'GeneratorName', TGeneratorNameEdit
    );

  RegisterPropertyEditor(TypeInfo(TAutoUpdateOptions), TpFIBDataSet, 'AutoUpdateOptions', TpFIBAutoUpdateOptionsEditor);
  RegisterPropertyEditor(TypeInfo(TpPrepareOptions), nil, 'Options', TpFIBDataSetOptionsEditor);
  RegisterPropertyEditor(TypeInfo(TpFIBDsOptions), nil, 'PrepareOptions', TpFIBDataSetOptionsEditor);

  {$IFDEF D5+}
    RegisterFields([TFIBStringField,TFIBIntegerField,TFIBSmallIntField,
     TFIBFloatField,TFIBBCDField,TFIBBooleanField]
    );
   {$IFDEF FIB_FIELDS_VER2}
    RegisterFields([TFIBDateField,TFIBTimeField,TFIBDateTimeField]);
   {$ENDIF}
  {$ENDIF}
end;

function TpFIBAutoUpdateOptionsEditor.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paDialog, paSubProperties];
end;

procedure TpFIBAutoUpdateOptionsEditor.Edit;
begin
  EditAutoUpdateOptions(GetComponent(0) as TpFIBDataSet,
    (GetComponent(0) as TpFIBDataSet).AutoUpdateOptions);
end;

function TpFIBDataSetOptionsEditor.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paDialog];
end;

procedure TpFIBDataSetOptionsEditor.Edit;
var pName: string;
begin
  pName := GetPropInfo^.Name;
  if pName = 'Options' then EditOptions(GetComponent(0) as TpFIBDataSet, 0)
  else EditOptions(GetComponent(0) as TpFIBDataSet, 1);
end;

initialization
 AppHandleException :=Application.HandleException;
finalization
 AppHandleException :=nil;
end.


