{***************************************************************}
{ FIBPlus - component library for direct access to Firebird and }
{ Interbase databases                                           }
{                                                               }
{    FIBPlus is based in part on the product                    }
{    Free IB Components, written by Gregory H. Deatz for        }
{    Hoagland, Longo, Moran, Dunst & Doukas Company.            }
{    mailto:gdeatz@hlmdd.com                                    }
{                                                               }
{    Copyright (c) 1998-2001 Serge Buzadzhy                     }
{    Contact: buzz@devrace.com                                  }
{                                                               }
{ ------------------------------------------------------------- }
{    FIBPlus home page      : http://www.fibplus.net/           }
{    FIBPlus support e-mail : fibplus@devrace.com               }
{ ------------------------------------------------------------- }
{                                                               }
{  Please see the file License.txt for full license information }
{***************************************************************}

unit FIBSQLEd;

interface
{$I FIBPlus.inc}
{$I pFIBPropEd.inc}
uses
 {$IFDEF MSWINDOWS}
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DB,FIBDataSet, StdCtrls, ExtCtrls, FIBQuery,
  {$IFNDEF NO_MONITOR}
   FIBSQLMonitor,
  {$ENDIF}
  Buttons, ComCtrls, Menus, pFIBQuery, pFIBDataSet, Grids, DBGrids,pFIBProps
  {$IFDEF D6+}    ,Variants  {$ENDIF}
  {$IFDEF USE_SYN_EDIT}
   ,SynEditHighlighter, SynHighlighterSQL, SynEdit, SynMemo 
  {$ENDIF} ;
 {$ENDIF}
 {$IFDEF LINUX}
  Types, SysUtils, Classes, QGraphics,
  QControls, QForms, QDialogs,  DB, FIBDataSet,  QStdCtrls, QExtCtrls,
  FIBQuery,QTypes,Qt,
  QButtons, QComCtrls, QMenus, pFIBQuery, pFIBDataSet,
  QGrids, QDBGrids,
  pFIBProps   ,Variants;
 {$ENDIF}
type
  TfrmGenSQL = class(TForm)
    qryTabFields: TpFIBDataSet;
    Panel4: TPanel;
    Button1: TButton;
    Button2: TButton;
    qryCheck: TpFIBQuery;
    FindDialog1: TFindDialog;
    qryPrimaryFields: TpFIBQuery;
    qryAllTables: TpFIBDataSet;
    PopupMenu1: TPopupMenu;
    miTables: TMenuItem;
    miSP: TMenuItem;
    qrySPs: TpFIBDataSet;
    qrySPparams: TpFIBDataSet;
    DataSource1: TDataSource;
    dsShablon: TpFIBDataSet;
    btnRWillCards: TButton;
    btnPrepareSQL: TButton;
    btnSave1SQL: TButton;
    Panel1: TPanel;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Panel2: TPanel;
    cmbTables: TComboBox;
    btnGetFields: TButton;
    btnGenSql: TButton;
    btnClearSQLs: TButton;
    GroupBox1: TGroupBox;
    chCheck: TCheckBox;
    chFieldOrigin: TCheckBox;
    GroupBox2: TGroupBox;
    chByPrimary: TCheckBox;
    chNonUpdPrKey: TCheckBox;
    chParamDefSymb: TCheckBox;
    btnCheckSQls: TButton;
    Panel3: TPanel;
    Label1: TLabel;
    LstKeyFields: TListBox;
    Panel5: TPanel;
    Label2: TLabel;
    LstUpdFields: TListBox;
    TabSheet2: TTabSheet;
    Splitter2: TSplitter;
    grSQLKind: TRadioGroup;
    Panel6: TPanel;
    Panel7: TPanel;
    Label4: TLabel;
    LbTableSyn: TLabel;
    Edit1: TEdit;
    EdTabSyn: TEdit;
    chReplaceSQL: TCheckBox;
    DBGrid1: TDBGrid;
    Panel8: TPanel;
    cmbTabsNameViews: TComboBox;
    Label3: TLabel;
    Splitter1: TSplitter;
    Panel9: TPanel;
    Panel10: TPanel;
    SpeedButton1: TSpeedButton;
    FontDialog1: TFontDialog;
    SpeedButton2: TSpeedButton;
    procedure btnGetFieldsClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure grSQLKindClick(Sender: TObject);
    procedure btnGenSqlClick(Sender: TObject);
    procedure btnClearSQLsClick(Sender: TObject);
    procedure btnPrepareSQLClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
    procedure btnPrepareSQLMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure btnPrepareSQLKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure viewSQLKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure viewSQLKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);      
    procedure FindDialog1Find(Sender: TObject);
    procedure cmbTablesChange(Sender: TObject);
    procedure viewSQLChange(Sender: TObject);
    procedure btnSave1SQLClick(Sender: TObject);
    procedure btnCheckSQlsClick(Sender: TObject);
    procedure miTablesClick(Sender: TObject);
    procedure lstAllTables1DblClick(Sender: TObject);
    procedure lstAllTables1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure lstAllTables1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure DBGrid1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Panel7Resize(Sender: TObject);
    procedure qryAllTablesFilterRecord(DataSet: TDataSet;
      var Accept: Boolean);
    procedure Edit1Change(Sender: TObject);
    procedure chParamDefSymbClick(Sender: TObject);
    procedure cmbTabsNameViewsChange(Sender: TObject);
    procedure btnRWillCardsClick(Sender: TObject);
    procedure Panel4Resize(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnConnectClick(Sender: TObject);
    procedure DBGrid1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Panel6Resize(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
  private
    FFIBDataSet:TFIBDataSet;
    FTables    :TStringList;
    FAllFields :Tstrings;
    FPrimKeyFields:Tstrings;
    FUpdTableSynonym:string;
    fOldText: string;
    {$IFNDEF LINUX}
    procedure WMGetMinMaxInfo(var M: TWMGetMinMaxInfo); message WM_GetMinMaxInfo;
    {$ENDIF}
    function FindInTabFields(const vFieldName:string):boolean;
    procedure FillTableList;
    procedure FillPrimKeyFields;
    procedure FillAllFields;
    function  GetFieldOrigin(const tfdName:string):string;
    function  ShortRealName(const FieldName:string):string;
    procedure ShowSQL;
    procedure CheckSQL(SQL:Tstrings; const ErrMessage:string);
    procedure SaveFieldsOrigin;
    procedure EditorDragOver(Sender, Source: TObject; X, Y: Integer;
     State: TDragState; var Accept: Boolean);
    procedure EditorDragDrop(Sender, Source: TObject; X, Y: Integer);
  private
    FSelectSQL:Tstrings;
    FInsertSQL:Tstrings;
    FUpdateSQL:Tstrings;
    FDeleteSQL:Tstrings;
    FRefreshSQL:Tstrings;
    InMenuCall :boolean;
    function GetSelectSQL:Tstrings;
    procedure SetSelectSQL(Value:TStrings);
    function WhereClause(withSyn:boolean):string;
    procedure GenerateInsertSQL;
    procedure GenerateUpdateSQL;
    procedure GenerateDeleteSQL;
    procedure GenerateRefreshSQL;
    procedure CheckDataSet_ID;
    property SelectSQL:Tstrings read GetSelectSQL write  SetSelectSQL ;
  private
    vIsTempStartTransaction:boolean;
    vParamSymb :Char;
    function  GetDialect: integer;
    procedure CalcOptionsPage;
    procedure GenerateSQLs;
    function  GetOutPutText:TStrings;
    procedure GenTemplate(isSP:boolean);
    procedure ReadOptions;
    procedure SaveOptions;
    property  Dialect:integer read GetDialect;
  public
  end;

function  ShowGenSQL(aDataSet:TFIBDataSet):boolean;
function  ShowEdSQL(aDataSet:TFIBDataSet;KindSQL:integer):boolean;


implementation

{$R *.dfm}
uses
{$IFNDEF NO_REGISTRY} RegUtils, {$ENDIF}
StrUtil,SqlTxtRtns,pFIBDataInfo, FIBConsts;

const
   RegFIBSQLEdOptions='SQLEditor';

var
 {$IFDEF USE_SYN_EDIT}
  viewSQL: TSynMemo;
//  ViewBufText: TSynMemo;
  SynSQLSyn1: TSynSQLSyn;
 {$ELSE}
  viewSQL: TMemo;
//  ViewBufText: TMemo;
 {$ENDIF}

var
   LastTop, LastLeft,   LastWidth,LastHeight:integer;

procedure ChangeEnabled(Ctrls:array of TControl; Value:boolean);
var i:integer;
begin
 for  i:= Low(Ctrls) to High(Ctrls) do   Ctrls[i].Enabled:=Value
end;

function  ShowGenSQL(aDataSet:TFIBDataSet):boolean;
begin
 Result:=ShowEdSQL(aDataSet,0)
end;

function  ShowEdSQL(aDataSet:TFIBDataSet;KindSQL:integer):boolean;
var frmGenSQL:TfrmGenSQL;
    OpenDB :boolean;
begin
  Result:=false;
  if aDataSet=nil then Exit;
  OpenDB :=(aDataSet.DataBase<>nil) and (aDataSet.Transaction<>nil);
//  if (aDataSet.DataBase=nil) or (aDataSet.Transaction=nil) then
//   raise Exception.Create('Database(or Transaction) not assigned');

  Application.CreateForm(TfrmGenSQL,frmGenSQL);

  with frmGenSQL,aDataSet do begin
   {$IFDEF USE_SYN_EDIT}
    viewSQL    :=TSynMemo.Create(frmGenSQL);
    SynSQLSyn1 :=TSynSQLSyn.Create(frmGenSQL);
    with SynSQLSyn1 do begin
      DefaultFilter:= 'SQL files (*.sql)|*.sql';
      CommentAttri.Foreground := clBlue;
      NumberAttri.Foreground  := clRed ;
      StringAttri.Background  := clInactiveBorder;
      SQLDialect              := sqlInterbase6;
    end;
    viewSQL.    Highlighter:=SynSQLSyn1;

   {$ELSE}
    viewSQL:=TMemo.Create(frmGenSQL);
    viewSQL    .ScrollBars:=ssBoth;
   {$ENDIF}

   with viewSQL do
   begin
     Font.Name:='Courier New';
     Font.Size:=10;
     Parent:=Panel9;
     Align:=alClient;
     SendToBack;
     OnChange:=viewSQLChange;
     OnKeyDown:=viewSQLKeyDown;
     OnKeyUp:=viewSQLKeyUp;
     OnDragOver:=EditorDragOver;
     OnDragDrop:=EditorDragDrop;
   end;
   
   ReadOptions;
{   vIsTempStartTransaction:=OpenDB and not aDataSet.Transaction.Active;
   if vIsTempStartTransaction then
    aDataSet.Transaction.StartTransaction;}
   if LastTop<>0 then  Top:=LastTop;
   if LastLeft<>0 then Left:=LastLeft;
   if LastWidth<>0 then Width:=LastWidth;
   if LastHeight<>0 then Height:=LastHeight;
   FTables:=TStringList.Create;
   FAllFields    :=TStringList.Create;
   FPrimKeyFields:=TStringList.Create;
   FInsertSQL    :=TStringList.Create;FUpdateSQL:=TStringList.Create;
   FDeleteSQL    :=TStringList.Create;FRefreshSQL:=TStringList.Create;
   FSelectSQL    :=TStringList.Create;
   FUpdTableSynonym:='';
   FFIBDataSet:=aDataSet;
   cmbTabsNameViews.ItemIndex:=0;
    with aDataSet do begin
     qryTabFields.DataBase         :=DataBase;
     qryTabFields.Transaction      :=Transaction;
     qryCheck    .DataBase         :=DataBase;
     qryCheck    .Transaction      :=Transaction;
     if poNoForceIsNull in Options then
      qryCheck   .Options:=qryCheck.Options+[qoNoForceIsNull];
       
     qryAllTables.DataBase         :=DataBase;
     qryAllTables.Transaction      :=Transaction;
     qryPrimaryFields.DataBase     :=DataBase;
     qryPrimaryFields.Transaction  :=Transaction;
     qrySPs          .DataBase     :=DataBase;
     qrySPs          .Transaction  :=Transaction;
     qrySPparams     .DataBase     :=DataBase;
     qrySPparams     .Transaction  :=Transaction;
     dsShablon       .DataBase     :=DataBase;
     dsShablon       .Transaction  :=Transaction;
    end;
    FSelectSQL.Assign(SelectSQL);
    FInsertSQL.Assign(InsertSQL);
    FUpdateSQL.Assign(UpdateSQL);
    FDeleteSQL.Assign(DeleteSQL);
    FRefreshSQL.Assign(RefreshSQL);
    ChangeEnabled([btnCheckSQls, btnGenSql, btnGetFields,
                   btnRWillCards, btnPrepareSQL,
                   cmbTabsNameViews,Edit1
     ],
     OpenDB
    );

    {$IFDEF D5+}
     DBGrid1.OnMouseMove:=DBGrid1MouseMove;
    {$ENDIF} 
    CalcOptionsPage;
    if KindSQL>0 then begin
      PageControl1.ActivePage:=TabSheet2;
      if grSQLKind.ItemIndex<>KindSQL-1 then
       grSQLKind.ItemIndex:=KindSQL-1
      else
       PageControl1Change(PageControl1);
      ActiveControl:=viewSQL;
    end
    else
      PageControl1.ActivePage:=TabSheet1;

    PageControl1.OnChange :=PageControl1Change;
    PageControl1Change(PageControl1);
    Result:=ShowModal=mrOk;
    LastTop:=Top;
    LastLeft   :=Left;
    LastWidth  :=Width;
    LastHeight :=Height;

     FAllFields.Free;  FTables.Free;
     FPrimKeyFields.Free;
     FInsertSQL.Free;  FUpdateSQL.Free;
     FDeleteSQL.Free;  FRefreshSQL.Free; FSelectSQL.Free;
    if vIsTempStartTransaction then
     aDataSet.Transaction.Commit;
    SaveOptions;
    frmGenSQL.Free;
  end;
end;

{$IFNDEF LINUX}
procedure TfrmGenSQL.WMGetMinMaxInfo(var M: TWMGetMinMaxInfo);
begin
    inherited;
    with M.MinMaxInfo^ do begin
     ptMinTrackSize.X:=466;
     ptMinTrackSize.Y:=360;
    end;
end;
{$ENDIF}

function  TfrmGenSQL.GetDialect: integer;
begin
 if Assigned(qryTabFields.DataBase) then
  Result:=qryTabFields.DataBase.SQLDialect
 else
  Result:=1;
end;

function TfrmGenSQL.GetSelectSQL:Tstrings;
begin
 Result:=FFIBDataSet.SelectSQL
end;

procedure TfrmGenSQL.SetSelectSQL(Value:Tstrings);
begin
 with FFIBDataSet do begin
  if Active then Close;
  SelectSQL:=Value
 end;
end;

procedure TfrmGenSQL.FillPrimKeyFields;
begin
 FPrimKeyFields.Clear;
 if cmbTables.Text='' then Exit;
 with qryPrimaryFields do begin
   Params[0].AsString := cmbTables.Text;
   Close;
   ExecQuery;
   while not eof do begin
    FPrimKeyFields.Add(Trim(Fields[0].asString));
    Next
   end;
  end;
end;

procedure TfrmGenSQL.FillTableList;
begin
 AllTables(SelectSQL.Text,FTables);
end;

procedure TfrmGenSQL.CalcOptionsPage;
var i:integer;
begin
 with cmbTables do begin
  FillTableList;
  Items:=FTables;
  for i:=0 to Pred(Items.Count) do begin
   if Pos('"',Items[i])>0 then begin
    Items[i]:=Copy(Items[i],2,MaxInt);
    Items[i]:=Copy(Items[i],1,Pos('"',Items[i])-1);
   end
   else
   Items[i]:=UpperCase(ExtractWord(1, Items[i],[' ']));
  end;

  if Items.Count>0 then  begin
   ItemIndex:=0;
   cmbTablesChange(cmbTables)
  end;
  LstKeyFields.Clear;  LstUpdFields.Clear;
 end;
end;

function TfrmGenSQL.GetFieldOrigin(const tfdName:string):string;
var fPos:integer;
    curName:string;
begin
  Result:='';
  fPos:=0;
with FFIBDataSet do begin
  if not Prepared then Prepare;
  with QSelect do
   while fPos<Current.Count do
   with Current[fPos].Data^ do
   begin
    SetString(curName, aliasname, aliasname_length);
    if tfdName=curName then Break;
    Inc(fPos)
   end;
  if fPos=QSelect.Current.Count then Exit;
  with QSelect.Current[fPos].Data^ do begin
    SetString(curName, relname, relname_length);
    SetString(Result, sqlname, sqlname_length);
    Result:=curName+'.'+Result;
  end
end;

end;



function  TfrmGenSQL.ShortRealName(const FieldName:string):string;
begin
 Result:=ExtractWord(2,GetFieldOrigin(FieldName),['.'])
end;

procedure TfrmGenSQL.SaveFieldsOrigin;
var i:integer;
begin
 with FFIBDataSet do begin
   if DefaultFields or (not Active and (FieldCount=0)) then Exit;
   for i:=0 to Pred(FieldCount) do
     Fields[i].Origin:=Self.GetFieldOrigin(Fields[i].FieldName);
 end;
end;

function TfrmGenSQL.FindInTabFields(const vFieldName:string):boolean;
begin
 Result:=false;
 with qryTabFields do begin
  First;
  while not eof do begin
   Result:=Trim(Fields[0].asString)=vFieldName;
   if Result then Exit;
   Next
  end;
 end;
end;

procedure TfrmGenSQL.FillAllFields;
var j:integer;
    tfd:TFieldDef;
    rfn:string;
    NeedField:boolean;
begin
 btnConnectClick(nil);
 if cmbTables.Text='' then exit;
 with FFIBDataSet,FFIBDataSet.FieldDefs do begin
  if not QSelect.Prepared then Prepare;
  try
   Update;
  except
    btnCheckSQlsClick(nil)
  end;
  FAllFields.Clear;
  with qryTabFields do begin
   Params[0].Asstring := cmbTables.Text;
   Close;Open;
  end;
  for  j:=0   to Count-1 do  begin
    tfd:=FieldDefs[j];
    NeedField:=(FieldCount=0);
    if not NeedField then  NeedField:=FindField(tfd.Name)<>nil;
    if not NeedField then Continue;
    rfn:=Self.GetFieldOrigin(tfd.Name);
    NeedField:=(cmbTables.Text=ExtractWord(1,rfn,['.']));
    rfn:=ExtractWord(2,rfn,['.']);
    if NeedField then NeedField:=FindInTabFields(rfn);
    if NeedField then begin
     FAllFields.AddObject(tfd.Name,tfd);
    end;
  end;
 end;
end;

procedure TfrmGenSQL.ShowSQL;
begin
 case grSQLKind.ItemIndex of
  0:viewSQL.Lines.Text:=FSelectSQL.Text;
  1:viewSQL.Lines.Text:=FUpdateSQL.Text;
  2:viewSQL.Lines.Text:=FInsertSQL.Text;
  3:viewSQL.Lines.Text:=FDeleteSQL.Text;
  4:viewSQL.Lines.Text:=FRefreshSQL.Text;
 end;
// btnRWillCards.Visible:=grSQLKind.ItemIndex=0;
end;

procedure TfrmGenSQL.GenerateDeleteSQL;
begin
 with  FDeleteSQL,LstKeyFields do begin
  FDeleteSQL.Clear;
  Add('DELETE FROM '+  FormatIdentifier(Dialect,cmbTables.Text));
  Add('WHERE '+WhereClause(false));
 end;
end;


procedure TfrmGenSQL.GenerateInsertSQL;
var j:integer;
    pn,rfn,tmpStr,tmpStr1:string;
    vpFIBTableInfo:TpFIBTableInfo;
    vFi:TpFIBFieldInfo;
begin
 with  FInsertSQL,LstUpdFields do begin
  FInsertSQL.Clear;
  tmpStr:='';tmpStr1:='';
  ListTableInfo.Clear;
  vpFIBTableInfo:=ListTableInfo.
                   GetTableInfo(qryTabFields.Database,
                      cmbTables.Text
                   );

  for j:=0 to Pred(Items.Count) do begin
   rfn:=ShortRealName(Items[j]);

   vFi:=vpFIBTableInfo.FieldInfo(rfn);
   if (vFi=nil) or  vFi.IsComputed or vFi.IsTriggered then
    Continue;
   rfn:=FormatIdentifier(Dialect,rfn);
   pn :=FormatIdentifier(Dialect,Items[j]);
   if Selected[j]  then  begin
     tmpStr :=tmpStr+ForceNewStr+rfn+',';
     tmpStr1:=tmpStr1+ForceNewStr+vParamSymb+pn+',';
   end;
  end;
  if tmpStr<>'' then
   if tmpStr[Length(tmpStr)]=','   then tmpStr :=Copy(tmpStr,1,Length(tmpStr)-1);
  if tmpStr1<>'' then
   if tmpStr1[Length(tmpStr1)]=',' then tmpStr1:=Copy(tmpStr1,1,Length(tmpStr1)-1);
  Add('INSERT INTO '+FormatIdentifier(Dialect,cmbTables.Text)+'('+tmpStr); Add(')');
  Add('VALUES('+tmpStr1); Add(')');
 end;
end;

procedure TfrmGenSQL.GenerateUpdateSQL;
var j:integer;
    pn,rfn,tmpStr:string;
    vpFIBTableInfo:TpFIBTableInfo;
    vFi:TpFIBFieldInfo;

begin
 with  FUpdateSQL,LstUpdFields do begin
  FUpdateSQL.Clear;
  tmpStr:='';
  ListTableInfo.Clear;
  vpFIBTableInfo:=ListTableInfo.
                   GetTableInfo(qryTabFields.Database,
                      cmbTables.Text
                   );

  for j:=0 to Pred(Items.Count) do begin
   rfn:=ShortRealName(Items[j]);
   vFi:=vpFIBTableInfo.FieldInfo(rfn);
   if (vFi=nil) or  vFi.IsComputed or vFi.IsTriggered then
    Continue;
   rfn:=FormatIdentifier(Dialect,rfn);
   if (Pos('NEW_',Items[j])=1) or (Pos('OLD_',Items[j])=1)
   then
    pn :=FormatIdentifier(Dialect,'NEW_'+Items[j])
   else
    pn :=FormatIdentifier(Dialect,Items[j]);
   if Selected[j] then  begin
     if not chNonUpdPrKey.Checked or
        (FPrimKeyFields.IndexOf(rfn)=-1)
     then
      tmpStr :=tmpStr+ForceNewStr+rfn+' = '+vParamSymb+pn+',';
   end;
  end;
  if tmpStr<>'' then
   if tmpStr[Length(tmpStr)]=','   then tmpStr :=Copy(tmpStr,1,Length(tmpStr)-1);
  Add('UPDATE '+FormatIdentifier(Dialect,cmbTables.Text)+' SET '+tmpStr);
  Add(' WHERE '+WhereClause(false))
 end;
end;



procedure TfrmGenSQL.GenerateRefreshSQL;
var p:integer;
    s:string;
begin
  s:=SelectSQL.Text;
  p:=PosCI('GROUP BY',s);
  if p>0 then s:=Copy(s,1,p-1);
  p:=PosCI('ORDER BY',s);
  if p>0 then s:=Copy(s,1,p-1);
  FRefreshSQL.Text:=AddToWhereClause(s,'('+WhereClause(true)+')',True)
end;

function TfrmGenSQL.WhereClause(withSyn:boolean):string;
var i,j:integer;
    pn,rfn:string;
begin
 with  LstKeyFields do begin
  i:=0;Result:=ForceNewStr+space+space;
  for j:=0 to Pred(Items.Count) do begin
   if Selected[j] then  begin
    Inc(i);
    if (Items.Objects[j]<>nil) and
       (TFieldDef(Items.Objects[j]).DataType=ftBlob) or
       (TFieldDef(Items.Objects[j]).DataType=ftMemo) or
       (TFieldDef(Items.Objects[j]).DataType=ftBytes)
    then
     Continue;

    rfn:=ShortRealName(Items[j]);
    rfn:=FormatIdentifier(Dialect,rfn);
    pn :=FormatIdentifier(Dialect,'OLD_'+Items[j]);
    if withSyn and (FUpdTableSynonym<>'.') then
     Result:=Result+FUpdTableSynonym+rfn+' = '+vParamSymb+pn+ForceNewStr
    else
     Result:=Result+rfn+' = '+vParamSymb+pn+ForceNewStr;

    if i<SelCount then Result:=Result+' and '
   end;
  end;
 end;
 Result:=space+Result
end;

procedure TfrmGenSQL.GenerateSQLs;
begin
 GenerateInsertSQL;
 GenerateUpdateSQL;
 GenerateDeleteSQL;
 GenerateRefreshSQL;
end;

//
procedure TfrmGenSQL.btnGetFieldsClick(Sender: TObject);
var i:integer;
    rfn:string;
begin
 FillAllFields;
 LstKeyFields.Items:=FAllFields;
 LstUpdFields.Items:=FAllFields;
 if chByPrimary.Checked or chNonUpdPrKey.Checked then FillPrimKeyFields;
 try
    LstKeyFields.Items.BeginUpdate;
    LstUpdFields.Items.BeginUpdate;
    with LstKeyFields,LstKeyFields.Items do
    begin
     i:=0;
     while i<Count do
     begin
      if (Objects[i]<>nil) and
        (TFieldDef(Objects[i]).DataType=ftBlob) or
        (TFieldDef(Objects[i]).DataType=ftMemo) or
        (TFieldDef(Objects[i]).DataType=ftBytes)
      then
      begin
       Delete(i);
       Continue;
      end;

      rfn:=ShortRealName(Items[i]);
      Selected[i]:=not chByPrimary.Checked or (FPrimKeyFields.IndexOf(rfn)>-1);
      Inc(i)
     end;
    end;
    for i:=0 to Pred(LstUpdFields.Items.Count) do  LstUpdFields.Selected[i]:=true;
 finally
    LstKeyFields.Items.EndUpdate;
    LstUpdFields.Items.EndUpdate;
 end
end;

procedure TfrmGenSQL.Button1Click(Sender: TObject);
var NeedReOpen:boolean;
begin
 if chCheck.Checked then btnCheckSQlsClick(btnCheckSQls);
 with FFIBDataSet do begin
  if chFieldOrigin.Checked then  SaveFieldsOrigin;
  NeedReOpen:=Active;
  if NeedReOpen then Close;
  SelectSQL.Text :=FSelectSQL.Text;
  InsertSQL.Text :=FInsertSQL.Text;
  UpdateSQL.Text :=FUpdateSQL.Text;
  DeleteSQL.Text :=FDeleteSQL.Text;
  RefreshSQL.Text:=FRefreshSQL.Text;
  CheckDataSet_ID;
  if NeedReOpen then Open;
 end;
 ModalResult:=mrOk
end;

procedure TfrmGenSQL.Button2Click(Sender: TObject);
begin
 Close
end;

procedure TfrmGenSQL.grSQLKindClick(Sender: TObject);
begin
 PageControl1Change(PageControl1)
end;

procedure TfrmGenSQL.btnGenSqlClick(Sender: TObject);
begin
  btnConnectClick(nil);
  btnClearSQLsClick(btnClearSQLs);
  GenerateSQLs;
  PageControl1.ActivePage:=TabSheet2;
  PageControl1Change(PageControl1);
  viewSQLChange(nil);
end;

procedure TfrmGenSQL.btnClearSQLsClick(Sender: TObject);
var NeedReopen:boolean;
begin
 with FFIBDataSet do
 begin
  NeedReopen:=Active;
  if NeedReopen then Close;
  FInsertSQL.Clear;  FUpdateSQL.Clear;
  FDeleteSQL.Clear;  FRefreshSQL.Clear;
  if NeedReopen then
  begin
   Open; FillAllFields
  end;
 end;
end;

procedure TfrmGenSQL.btnCheckSQlsClick(Sender: TObject);
begin
  btnConnectClick(nil);
  CheckSQL(FSelectSQL, Format(SGenSQLErrorPreffix, ['SelectSQL']));
  CheckSQL(FUpdateSQL, Format(SGenSQLErrorPreffix, ['UpdateSQL']));
  CheckSQL(FInsertSQL, Format(SGenSQLErrorPreffix, ['InsertSQL']));
  CheckSQL(FDeleteSQL, Format(SGenSQLErrorPreffix, ['DeleteSQL']));
  CheckSQL(FRefreshSQL,Format(SGenSQLErrorPreffix, ['RefreshSQL']));
end;

procedure TfrmGenSQL.CheckSQL(SQL:Tstrings; const ErrMessage:string);
var LineErr,LineErrPos:integer;
    ErrCol,NumLineErr:string;
    i,l:integer;
    errType:byte;
begin
  if (qryCheck.Database=nil) or (qryCheck.Transaction=nil) then
   Exit;
  if EmptyStrings(SQL) then exit;
  qryCheck.Params.Count:=0;
  qryCheck.SQL.Text:=SQL.Text;
  try
   qryCheck.Prepare
  except
  ON E:Exception do
   if ErrMessage='' then begin
    //   viewSQL.Lines
    //      
    //   :)
    LineErrPos:=Pos('line',E.Message);
    if LineErrPos>0 then begin
         NumLineErr:=Copy(E.Message,LineErrPos+5,255);
         NumLineErr:=ExtractWord(1, NumLineErr,[' ',',']);
         LineErr:= StrToIntDef(NumLineErr, -1);
         if LineErr>-1 then begin
          l:=0;
          for i:=0 to LineErr-2 do L:=L+2+Length(SQL[i]);
          viewSQL.SelStart :=L;
          {$IFDEF USE_SYN_EDIT}
           viewSQL.SelEnd   :=Length(SQL[LineErr-1])
          {$ELSE}
           viewSQL.SelLength:=Length(SQL[LineErr-1])
          {$ENDIF}
        end;
    end
    else    begin
     LineErrPos:=Pos('Column unknown',E.Message);
     if LineErrPos>0 then begin
      errType:=1;
      ErrCol    :=Copy(E.Message,LineErrPos+17,255)
     end
     else begin
      LineErrPos:=Pos('Table unknown',E.Message);
      ErrCol    :=Copy(E.Message,LineErrPos+16,255);
      errType:=2;
     end;
     if LineErrPos=0 then raise;
     ErrCol    :=Copy(ErrCol,1,Length(ErrCol)-3);
     l:=0;
     for i:=0 to Pred(SQL.Count) do begin
      if (errType=2) and (PosCI('FROM',SQL[i])<>0) then errType:=1;
      if errType=1 then begin
       LineErrPos:=PosCI(ErrCol,SQL[i]);
       if LineErrPos<>0 then Break;
      end;
      L:=L+2+Length(SQL[i]);
     end;
     if LineErrPos<>0 then begin
          viewSQL.SelStart :=L+LineErrPos-1;
         {$IFDEF USE_SYN_EDIT}
          viewSQL.SelEnd   :=Length(ErrCol)
         {$ELSE}
          viewSQL.SelLength:=Length(ErrCol)
         {$ENDIF}
     end;
    end;
    raise
   end
    else raise Exception.Create(ErrMessage);
  end
end;

procedure TfrmGenSQL.btnPrepareSQLClick(Sender: TObject);
begin
  btnConnectClick(nil);
  if Trim(viewSQL.Lines.Text)='' then
    raise Exception.Create(SGenSQLEmpty);
  CheckSQL(viewSQL.Lines,'');
  ShowMessage(SGenSQLCorrectSQL);
end;

procedure TfrmGenSQL.FormResize(Sender: TObject);
begin
{ btnPrepareSQL.Top :=Height-154;
 btnRWillCards.Top :=btnPrepareSQL.Top-30;
 btnSave1SQL.Top   :=btnPrepareSQL.Top+29;
 btnSave1SQL.Left  :=Width-137;
 btnPrepareSQL.Left:=btnSave1SQL.Left;
 btnRWillCards.Left:=btnSave1SQL.Left;}
 Panel3.Width:=Trunc((Width-174)/2);
end;

procedure TfrmGenSQL.PageControl1Change(Sender: TObject);
begin
 ShowSQL;
 btnSave1SQL  .Visible:=PageControl1.ActivePage=TabSheet2;
 btnPrepareSQL.Visible:=PageControl1.ActivePage=TabSheet2;
 btnRWillCards.Visible:=(PageControl1.ActivePage=TabSheet2) and
   (grSQLKind.ItemIndex=0);

 Panel6.Visible:=grSQLKind.ItemIndex=0;
 Splitter2.Visible:=grSQLKind.ItemIndex=0;

end;

type
  THackRadioGroup = class(TCustomGroupBox)
  private
    FButtons: TList;
  end;

procedure TfrmGenSQL.viewSQLChange(Sender: TObject);
var CanHack:boolean;
begin
// if viewSQL.Focused then
  case grSQLKind.ItemIndex of
   0:FSelectSQL.Assign(viewSQL.Lines);
   1:FUpdateSQL.Assign(viewSQL.Lines);
   2:FInsertSQL.Assign(viewSQL.Lines);
   3:FDeleteSQL.Assign(viewSQL.Lines);
   4:FRefreshSQL.Assign(viewSQL.Lines);
  end;

{$IFDEF VER100}                {Borland Delphi 3.0 }
 CanHack:=true;
{$ELSE}
 {$IFDEF VER120}               {Borland Delphi 4.0 }
   CanHack:=true;
 {$ELSE}
 {$IFDEF VER130}               {Borland Delphi 5.0 }
   CanHack:=true;
 {$ELSE}
  {$IFDEF VER140}
   CanHack:=true;  
  {$ELSE}
    CanHack:=false;
  {$ENDIF}
 {$ENDIF}
 {$ENDIF}
{$ENDIF}


if CanHack then
 with THackRadioGroup(grSQLKind),FFIBDataSet do begin
    if FSelectSQL.Text<>SelectSQL.Text then begin
       TRadioButton(FButtons[0]).Font.Color:=clRed;
    end
    else
       TRadioButton(FButtons[0]).Font.Color:=clBlack;

    if FUpdateSQL.Text<>UpdateSQL.Text then
       TRadioButton(FButtons[1]).Font.Color:=clRed
    else
       TRadioButton(FButtons[1]).Font.Color:=clBlack;

    if (FInsertSQL.Text<>InsertSQL.Text) then
       TRadioButton(FButtons[2]).Font.Color:=clRed
    else
       TRadioButton(FButtons[2]).Font.Color:=clBlack;

    if FDeleteSQL.Text<>DeleteSQL.Text then
       TRadioButton(FButtons[3]).Font.Color:=clRed
    else
       TRadioButton(FButtons[3]).Font.Color:=clBlack;

    if FRefreshSQL.Text<>RefreshSQL.Text then
       TRadioButton(FButtons[4]).Font.Color:=clRed
    else
       TRadioButton(FButtons[4]).Font.Color:=clBlack;
end;

end;

procedure TfrmGenSQL.CheckDataSet_ID;
begin
  if (FFIBDataSet is TpFIBDataSet) then
  begin
     if TpFibDataSet(FFIBDataSet).DataSet_Id>0 then
      if ExistDRepositaryTable(FFIBDataSet.Database) and
       not SaveFIBDataSetInfo(TpFibDataSet(FFIBDataSet)) then
        TpFibDataSet(FFIBDataSet).DataSet_Id:=0
  end;
end;

procedure TfrmGenSQL.btnSave1SQLClick(Sender: TObject);
var DestStrs:Tstrings;
    NeedReOpen:boolean;
begin
 with FFIBDataSet do    begin
   case grSQLKind.ItemIndex of
    0:DestStrs:=SelectSQL;
    1:DestStrs:=UpdateSQL;
    2:DestStrs:=InsertSQL;
    3:DestStrs:=DeleteSQL;
   else
    DestStrs:=RefreshSQL;
   end;
   CheckSQL(viewSQL.Lines,'');
   NeedReOpen:=Active;
   if NeedReOpen then Close;
   CheckDataSet_ID;
   DestStrs.Text:=viewSQL.Lines.Text;
   if NeedReopen then begin
    Open; FillAllFields
   end;
   if   grSQLKind.ItemIndex=0   then CalcOptionsPage;
 end;
 viewSQLChange(viewSQL);
end;

procedure TfrmGenSQL.cmbTablesChange(Sender: TObject);
begin
 with cmbTables do
  if ItemIndex>-1 then begin
   FUpdTableSynonym:=ExtractLastWord(FTables[ItemIndex],[' ']) +'.';
   if FUpdTableSynonym[1]='@' then FUpdTableSynonym:='';     
  end
  else
   FUpdTableSynonym:='';
end;

procedure TfrmGenSQL.btnPrepareSQLMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
 viewSQL.SetFocus;
end;

procedure TfrmGenSQL.btnPrepareSQLKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 {$IFDEF MSWINDOWS}
  if Key=VK_RETURN then
 {$ENDIF}
 {$IFDEF LINUX}
   if Key=Key_RETURN then
 {$ENDIF}
 viewSQL.SetFocus;
end;

procedure TfrmGenSQL.viewSQLKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
begin
  if viewSQL.Text<>fOldText then viewSQLChange(Self);
end;

procedure TfrmGenSQL.viewSQLKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 fOldText:=viewSQL.Text;
 if ssCtrl in Shift then
  case Chr(Key) of
  'F','f','','':FindDialog1.Execute;
  end;

 {$IFDEF MSWINDOWS}
  if Key=VK_F3 then
 {$ELSE}
   if Key=Key_F3 then
 {$ENDIF}
  FindDialog1Find(FindDialog1)
 else
 {$IFDEF MSWINDOWS}
  if Key=VK_ESCAPE then
 {$ELSE}
   if Key=Key_ESCAPE then
 {$ENDIF}
  Close
end;

procedure TfrmGenSQL.FindDialog1Find(Sender: TObject);
var L,p,j:integer;
    curL:integer;
    lv:string;
  {$IFDEF USE_SYN_EDIT}
    CurMemo:TSynMemo;
  {$ELSE}
    CurMemo:TMemo;
  {$ENDIF}
begin
  //  .
  L:=0;
  CurMemo:=viewSQL;
  with CurMemo do
  for j:=0 to Pred(Lines.Count) do begin
    curL:=Length(Lines[j]);
    if (L+curL)<SelStart then L:=L+curL+2
    else begin
       if (L-1)< SelStart then begin
     {$IFDEF USE_SYN_EDIT}
        lv:=Copy(Lines[j],SelStart+SelEnd   -L,MaxInt);
     {$ELSE}
        lv:=Copy(Lines[j],SelStart+SelLength-L,MaxInt);
     {$ENDIF}
        p:=PosCI(FindDialog1.FindText,lv);
     {$IFDEF USE_SYN_EDIT}
        if p>0 then p:=p+SelStart+SelEnd-L-1;
     {$ELSE}
        if p>0 then p:=p+SelStart+SelLength-L-1;
     {$ENDIF}
       end
       else begin
        lv:=Lines[j];
        p:=PosCI(FindDialog1.FindText,lv);
       end;
       if (p=0)  then L:=L+curL+2
       else begin
         if L=0 then SelStart :=p else SelStart :=L+p-1;
     {$IFDEF USE_SYN_EDIT}
         SelEnd   :=Length(FindDialog1.FindText);
     {$ELSE}
         SelLength:=Length(FindDialog1.FindText);
     {$ENDIF}
         SetFocus;
      {$IFNDEF LINUX}
         FindDialog1.CloseDialog;
      {$ENDIF}
         Exit;
       end;
    end;
  end;
 {$IFNDEF LINUX}
  FindDialog1.CloseDialog;
 {$ENDIF}
end;

procedure TfrmGenSQL.miTablesClick(Sender: TObject);
var DS:TFIBDataSet;
begin
 InMenuCall:=true;
 try
   miTables.Checked:=Sender=miTables;
   miSP    .Checked:=Sender=miSP;
   if miTables.Checked then
   begin
    DS:=qryAllTables;
    cmbTabsNameViews.ItemIndex:=1;
   end
   else
   if miSP.Checked then
   begin
    DS:=qrySPs;
    cmbTabsNameViews.ItemIndex:=2;
   end
   else Exit;
   DataSource1.DataSet :=DS;
   with DS do begin
{    with Transaction do if not Active then begin
     if MessageDlg('Transaction is not Active. Activate?', mtWarning, [mbYes, mbNo], 0) = mrYes then
      Active := True
     else
      Abort;
    end;}
    if not Active then Open;
   end;
 finally
  InMenuCall:=false;
 end;
end;

function  TfrmGenSQL.GetOutPutText:TStrings;
begin
 Result:=FSelectSQL;
end;

function GetLinePosition(SQL:TStrings;Position:integer):integer;
var L:integer;
begin
 Result:=0; L:=0;
 while (L<Position) and (Result<SQL.Count) do begin
   L:=L+Length(SQL[Result])+2;
   Inc(Result);
 end;
end;

procedure TfrmGenSQL.GenTemplate(isSP:boolean);
var DefSyn:string;
    Dest:TStrings;
    DFrom:TPoint;
    SysTab:TFIBDataSet;
    LineFrom:integer;
    fn,pars:string;
    IsExecSP:boolean;
    CurMetaObj:string;
begin
 LineFrom:=0;
 if DBGrid1.DataSource.DataSet.FieldCount=0 then Exit;
 CurMetaObj:=DBGrid1.DataSource.DataSet.Fields[0].asString;
 if EdTabSyn.Text='' then DefSyn:=Copy(CurMetaObj,1,3)
 else DefSyn:=EdTabSyn.Text;
 Dest:=GetOutPutText;
 if chReplaceSQL.Checked then Dest.Clear;
 if isSP then SysTab:=qrySPparams else SysTab:=qryTabFields;
 with SysTab,Dest do begin
//   SysTab.Prepare;
   Params[0].AsString :=CurMetaObj;
   Close;Open;
   if RecordCount=0 then Exit;
//   if cmbOutPut.ItemIndex=1 then Dest.Clear;
   IsExecSP:=IsSP and (Fields[2].asInteger=0) ;
   if IsExecSP then begin
     Add('EXECUTE PROCEDURE ');DefSyn:=' ';
   end;
   if chReplaceSQL.Checked then begin
    if not IsExecSP then  Add('SELECT')
   end
   else begin
    DFrom:=DispositionFrom(Dest.Text);
    if DFrom.X=0 then raise Exception.Create('Clause "FROM" not found')
    else  begin
     Dest.Text:=Copy(Dest.Text,1,DFrom.X-1)+#13#10+
                Copy(Dest.Text,DFrom.X,DFrom.Y-DFrom.X)+ForceNewStr+
                Copy(Dest.Text,DFrom.Y+1,MaxInt)
                ;
     LineFrom:=GetLinePosition(Dest,DFrom.X+2)-1;
    end;
   end;
   while not eof and (not IsSP or (Fields[2].asInteger<>0)) do begin
    fn:=FormatIdentifier(Dialect,Fields[0].asString);
    if chReplaceSQL.Checked then
     Add(Space+DefSyn+'.'+fn+',')
    else begin
     Dest[LineFrom-1]:=Dest[LineFrom-1]+',';
     Insert(LineFrom,Space+DefSyn+'.'+fn);
     Inc(LineFrom)
    end;
    Next
   end;

   pars:='';
   if IsSP then   begin
     //Input SP params
       while not eof  do begin
        pars:=pars+ForceNewStr+vParamSymb+Trim(Fields[0].asString)+',';
        Next
       end;
       if pars<>'' then
        pars:=ForceNewStr+'('+Copy(pars,1,Length(pars)-1)+ForceNewStr+')';
   end;

   if chReplaceSQL.Checked then begin
    Strings[Pred(Count)]:=Copy(Strings[Pred(Count)],1,Length(Strings[Pred(Count)])-1);
    Add('FROM');
    Add(Space+ FormatIdentifier(Dialect,CurMetaObj)+pars+' '+DefSyn)
   end
   else begin
    DFrom:=DispositionFrom(Dest.Text);
    LineFrom :=GetLinePosition(Dest,DFrom.Y);
    Insert(LineFrom,Space+ 'JOIN '+
      Trim(CurMetaObj)+pars+' '+DefSyn+ ' ON ( )')
   end;
  end;
  DeleteEmptyStr(Dest);
  ShowSQL;
end;


procedure TfrmGenSQL.lstAllTables1DblClick(Sender: TObject);
begin
 GenTemplate(miSP.Checked)
end;

procedure TfrmGenSQL.lstAllTables1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 {$IFDEF MSWINDOWS}
  if Key=VK_RETURN then
 {$ENDIF}
 {$IFDEF LINUX}
   if Key=Key_Return then
 {$ENDIF}
 lstAllTables1DblClick(Sender)
end;

procedure TfrmGenSQL.lstAllTables1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var p:TPoint;
begin
 if not(miTables.Checked or miSP.Checked )then begin
  p.X:=X; p.Y:=Y;
  p:=DBGrid1.ClientToScreen(p);
  with p do  PopupMenu1.Popup(X,Y);
 end;
end;


procedure TfrmGenSQL.DBGrid1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  {$IFDEF MSWINDOWS}
  if Key=VK_RETURN then
 {$ENDIF}
 {$IFDEF LINUX}
   if Key=Key_Return then
 {$ENDIF}

 lstAllTables1DblClick(Sender)
end;

procedure TfrmGenSQL.Panel7Resize(Sender: TObject);
begin
 DBGrid1.Columns[0].Width:=Panel7.Width-24;
 Edit1.Width:=Panel7.Width-73;
 EdTabSyn.Width:=Panel7.Width-73;
 cmbTabsNameViews.Width:=Panel7.Width-6;
 chReplaceSQL.Width:=Panel7.Width-16;
end;

procedure TfrmGenSQL.qryAllTablesFilterRecord(DataSet: TDataSet;
  var Accept: Boolean);
begin
 Accept :=true;
 with DataSet do
  if Trim(Edit1.Text)<>'' then
   Accept :=PosCI(Trim(Edit1.Text),Fields[0].AsString)<>0;

end;

procedure TfrmGenSQL.Edit1Change(Sender: TObject);
begin
 btnConnectClick(nil);
 qrySPs.Filtered:=true;
 qryAllTables.Filtered:=true;
 qrySPs.RefreshFilters;
 qryAllTables.RefreshFilters;
end;

procedure TfrmGenSQL.chParamDefSymbClick(Sender: TObject);
begin
    if chParamDefSymb.Checked then
     vParamSymb:='?'
    else
     vParamSymb:=':';
end;

procedure TfrmGenSQL.cmbTabsNameViewsChange(Sender: TObject);
begin
 btnConnectClick(nil);
 if not InMenuCall then
  case cmbTabsNameViews.ItemIndex of
   0: DataSource1.DataSet.Close;
   1: miTablesClick(miTables);
   2: miTablesClick(miSP);
  end
end;

procedure TfrmGenSQL.btnRWillCardsClick(Sender: TObject);
var i,j,p:integer;
    s,s1:string;
    Alias,RelTable:string;
begin
 btnConnectClick(nil);
 s1:=viewSQL.Text;s:='';
 p:=Pos('*',s1);
 if p=0 then Exit;
 while p<>0 do
 begin
  j:=p-1;
  while (j>0) and (s1[j] in [' ',#9,#13,#10]) do Dec(j);
  RelTable:='';Alias:='';
  if (j>0) and (s1[j]='.') then
  begin
   while (j>0) and (s1[j] in [' ',#9,#13,#10,'.']) do
    Dec(j);
   while (j>0) and not (s1[j] in [' ',#9,#13,#10,'.']) do
   begin
    Alias:=s1[j]+Alias;
    Dec(j);
   end;
   RelTable:=TableByAlias(viewSQL.Text,Alias);
  end;
  s:=s+Copy(s1,1,j);
  if LastChar(s)<>#10 then s:=s+#13#10#9;
  with  dsShablon do
  begin
   Close; SelectSQL.Text:=viewSQL.Text;
   Open;
   for i :=0  to Pred(FieldCount) do
   begin
     if (RelTable='') or
      (GetRelationTableName(Fields[i])=UpperCase(RelTable))
     then
     begin
      if Alias<>'' then
       s:=s+Alias+'.'+GetRelationFieldName(Fields[i])
      else
       s:=s+GetFieldOrigin(Fields[i]);
      if i<FieldCount-1 then s:=s+','+#13#10#9;
     end;
   end;
  end;
  s1:=Copy(s1,p+1,100000);
  p:=Pos('*',s1);
 end;
 j:=1; p:=Length(s1);
 while (j<=p) and  (s1[j]in [' ',#13,#9,#10]) do Inc(j);
 s1:=Copy(s1,j,100000);
 if (LastChar(s)<>#10) then s:=s+#13#10;
 s:=s+s1;
 viewSQL.Text:=s;
 FSelectSQL.Assign(viewSQL.Lines)
end;

procedure TfrmGenSQL.Panel4Resize(Sender: TObject);
begin
 Button2.Left := PageControl1.Left + PageControl1.Width - Button2.Width;
 Button1.Left := Button2.Left - Button1.Width -5;
end;


function StrToFontStyle(const Str:String):TFontStyles;
begin
  Result:=[];
  if Pos('fsBold',Str)>0 then Include( Result, fsBold  );
  if Pos('fsItalic',Str)>0 then Include( Result, fsItalic  );
  if Pos('fsUnderline',Str)>0 then Include( Result, fsUnderline  );
  if Pos('fsStrikeOut',Str)>0 then Include( Result, fsStrikeOut  );
end;

procedure TfrmGenSQL.ReadOptions;
{$IFNDEF NO_REGISTRY}
var v:Variant;
    i:integer;
{$ENDIF}
begin
{$IFNDEF NO_REGISTRY}
 v:=
  DefReadFromRegistry(['Software',RegFIBRoot,RegFIBSQLEdOptions],
   ['WhereByPK',
    'NotUpdatePK',
    'Use?',
    'CheckSQL',
    'Origins',
    'Height',
    'Width',
    'GridWidth',
    'FontName',
    'FontSize',
    'FontColor',
    'FontStyle',
    'FontCharSet'
   ]
 );
 if (VarType(v)<>varBoolean) then
  for i:=0 to  12 do
   if V[1,i] then
   case i of
    0: chByPrimary.Checked   :=V[0,i];
    1: chNonUpdPrKey.Checked :=V[0,i];
    2: chParamDefSymb.Checked:=V[0,i];
    3: chCheck.Checked       :=V[0,i];
    4: chFieldOrigin.Checked :=V[0,i];
    5: LastHeight:=V[0,i];
    6: LastWidth :=V[0,i];
    7: if V[0,i]>0 then Panel6.Width:=V[0,i];
    8: viewSQL.Font.Name:=V[0,i];
    9: viewSQL.Font.Size:=V[0,i];
    10: viewSQL.Font.Color:=V[0,i];
    11: viewSQL.Font.Style:=StrToFontStyle(V[0,i]);
    12: viewSQL.Font.CharSet:=V[0,i];    
   end;
   if chParamDefSymb.Checked then vParamSymb:='?'
   else
   vParamSymb:=':'
{$ENDIF}
end;


function FontStyleToStr(Font:TFont):string;
begin
  Result:='[';
  if fsBold in Font.Style then Result:= Result+'fsBold,';
  if fsItalic in Font.Style then Result:= Result+'fsItalic,';
  if fsUnderline in Font.Style then Result:= Result+'fsUnderline,';
  if fsStrikeOut in Font.Style then Result:= Result+'fsStrikeOut';
  if Result[Length( Result )]=',' then
   Result[Length( Result )]:=']'
  else
   Result:= Result+']'
end;

procedure TfrmGenSQL.SaveOptions;
begin
{$IFNDEF NO_REGISTRY}
 DefWriteToRegistry(['Software',RegFIBRoot,RegFIBSQLEdOptions],
   ['WhereByPK',
    'NotUpdatePK',
    'Use?',
    'CheckSQL',
    'Origins',
    'Height',
    'Width',
    'GridWidth',
    'FontName',
    'FontSize',
    'FontColor',
    'FontStyle',
    'FontCharSet'
   ],
   [chByPrimary.Checked ,
    chNonUpdPrKey.Checked,
    chParamDefSymb.Checked,
    chCheck.Checked,
    chFieldOrigin.Checked,
    LastHeight,
    LastWidth,
    Panel6.Width,
    viewSQL.Font.Name,
    viewSQL.Font.Size,
    viewSQL.Font.Color,
    FontStyleToStr( viewSQL.Font),
    viewSQL.Font.CharSet
   ]
 );
{$ENDIF}
end;

procedure TfrmGenSQL.FormCreate(Sender: TObject);
begin
 InMenuCall:=false;
 {$IFDEF NO_REGISTRY}
  vParamSymb :='?' ;
 {$ENDIF}
  Caption := SGenSQLCaption;
  TabSheet1.Caption := SGenSQLOptions;
  btnGetFields.Caption := SGenSQLGetFieldsButton;
  btnGenSql.Caption := SGenSQLGenerateButton;
  btnCheckSQls.Caption := SGenSQLCheckButton;
  btnClearSQLs.Caption := SGenSQLClearButton;

  GroupBox1.Caption := SGenSQLOnSaveGroup;
  chCheck.Caption := SGenSQLCheckSQL;
  chCheck.Hint := SGenSQLCheckSQLHint;

  chFieldOrigin.Hint := SGenSQLFieldOriginHint;
  chFieldOrigin.Caption := SGenSQLFieldOrigin;
  GroupBox2.Caption := SGenSQLGeneratorOptions;
  chByPrimary.Hint := SGenSQLPrimaryHint;
  chByPrimary.Caption := SGenSQLPrimary;
  chNonUpdPrKey.Hint := SGenSQLNonUpdatePrimaryHint;
  chNonUpdPrKey.Caption := SGenSQLNonUpdatePrimary;
  chParamDefSymb.Caption := SGenSQLDefaultSymbol;

  Label1.Caption := SGenSQLKeyFields;
  Label2.Caption := SGenSQLUpdateFields;

  TabSheet2.Caption := SGenSQL_SQLsTabs;
  grSQLKind.Caption := SGenSQLStatement;

  Label4.Caption := SGenSQLFilterBy;
  LbTableSyn.Caption := SGenSQLAlias;
  DBGrid1.Columns[0].Title.Caption := SGenSQLTablesColumn;

  cmbTabsNameViews.Items.Add(SGenSQLView1);
  cmbTabsNameViews.Items.Add(SGenSQLView2);
  cmbTabsNameViews.Items.Add(SGenSQLView3);

  Label3.Caption := SGenSQLSelectMain;

  Button1.Caption := SGenSQLSaveAllButton;
  btnRWillCards.Caption := SGenSQLReplaceButton;
  btnPrepareSQL.Caption := SGenSQLCheckErrorButton;
  btnSave1SQL.Hint := SGenSQLSaveSQLButtonHint;
  btnSave1SQL.Caption := SGenSQLSaveSQLButton;

  Button2.Caption := SCancelButton;
  chReplaceSQL.Caption := SGenSQLReplaceSelect;
end;

procedure TfrmGenSQL.btnConnectClick(Sender: TObject);
begin
 if
  Assigned(dsShablon.Database) and   not dsShablon.Database.Connected
 then begin
  dsShablon.Database.Connected:=true;
  dsShablon.Transaction.StartTransaction;
  vIsTempStartTransaction :=true;
 end;
end;

procedure TfrmGenSQL.EditorDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
 Accept:=Source=DBGrid1
end;

procedure TfrmGenSQL.EditorDragDrop(Sender, Source: TObject; X,
  Y: Integer);
begin
 if  Source=DBGrid1 then
  GenTemplate(miSP.Checked)
end;

procedure TfrmGenSQL.DBGrid1MouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
 if ssLeft  in Shift then
  DBGrid1.BeginDrag(false)	
end;

procedure TfrmGenSQL.Panel6Resize(Sender: TObject);
begin
 DBGrid1.Columns[0].Width := DBGrid1.Width - 24;
 cmbTabsNameViews.Width := DBGrid1.Width;
 Edit1.Width := Panel7.ClientWidth - Edit1.Left;
 EdTabSyn.Width := Edit1.Width;
end;

procedure TfrmGenSQL.SpeedButton2Click(Sender: TObject);
begin
 FindDialog1.Execute
end;

procedure TfrmGenSQL.SpeedButton1Click(Sender: TObject);
begin
 with FontDialog1.Font do
 begin
   Name :=viewSQL.Font.Name;
   Size :=viewSQL.Font.Size;
   Color:=viewSQL.Font.Color;
   Style:=viewSQL.Font.Style;
   CharSet:=viewSQL.Font.CharSet;
 end;
 if FontDialog1.Execute then
  viewSQL.Font:=FontDialog1.Font
end;

initialization
 LastTop:=0;   LastLeft:=0;
 LastWidth:=0; LastHeight:=0
end.
