//<html><pre>
// KEHOME/java/mytap.java
// Sep/10/2003

// usage:
//	java mytap kbdata kbfile
//	subject predicate object
//	...
//	CONTROL-Z
//
// example:
//	java mytap http://tap.stanford.edu/data/ "$KEHOME/xml/tap.rdf"
//	Person type ?
//	? subClassOf Person
//	DickMcCullough type Person
//	CONTROL-Z

import java.io.*;
import java.util.*;
import java.util.regex.*;

import edu.stanford.TAP.Abbrev;
import edu.stanford.TAP.Client;
import edu.stanford.TAP.Resource;
import edu.stanford.TAP.XML;

/**
*	read TAP KB locations from command line
*	create TAP KB client
*	read sentence(s) from standard input
*	parse to RDF triple(s)
*	assert statement(s) to TAP KB
*   or
*	get answer(s) from TAP KB
*	sort answer(s)
*	print answer(s)
*/
public class mytap
{
    public static void main(String argv[])
    //----------------------------------//
    throws IOException
    {
	String info      = "# INFO: tap: ";
	String error     = "# ERROR: tap: ";
	String warning   = "# WARNING: tap: ";
	String debug     = "no";

	String Subflag   = "includeSubClasses=yes";
	String Superflag = "includeSuperClasses=yes";
	String flags     = "";

	//String kbdata = System.getProperty("KBDATA");
	String kbdata = argv[0];
	String kbfile = argv[1];
	Client tap = new Client(kbdata);
	//Client atap = new Client(kbfile);

	BufferedReader in = new BufferedReader(
		new InputStreamReader(System.in));
	String line = "";
for (
	int linenumber = 0;
	line != null;
	++linenumber
) {
	System.err.print("tap$ ");
	try {
		line = in.readLine();
	} catch(IOException e) {
		return;
	}
	if (line == null) return;
	if (line.length() == 0) continue;
	if (debug == "yes") {
	  System.err.println(info + "line = " + line);
	}
	/**
	* parse to triple: subject predicate object
	* any "left-over" words belong to object
	*/
	String[] sentence = Pattern.compile(" +").split(line);
	int ns = sentence.length;
	if (ns < 3) {
		System.err.println(error + "not a triple: " + line);
		continue;
	}
	String subject   = sentence[0];
	String predicate = sentence[1];
	String object    = sentence[2];
	for(int i = 3; i < ns; ++i)
		object += " " + sentence[i];

	if (debug == "yes") {
	  System.err.println(info + "kbdata = <"    + kbdata + ">");
	  System.err.println(info + "kbfile = <"    + kbfile + ">");
	  System.err.println(info + "subject = <"   + subject + ">");
	  System.err.println(info + "predicate = <" + predicate + ">");
	  System.err.println(info + "object = <"    + object + ">");
	}
	String[] answer;
	if (subject.equals("?resource")) {
		String stype = "qresource";
		if (debug == "yes") System.err.println("# stype = " + stype);
		flags = "";
		answer = getresource.get_resource(tap,predicate,object);
	} else if (predicate.equals("?")) {
		String stype = "qverb";
		if (debug == "yes") System.err.println("# stype = " + stype);
		predicate = "arcs";
		if (object.equals("?")) {
			flags = "inverse=no";
			answer = getdata.get_data(tap,subject,predicate,flags);
		} else if (subject.equals("?")) {
			flags = "inverse=yes";
			answer = getdata.get_data(tap,object,predicate,flags);
		} else {
			System.err.println(warning + "not implemented: " +
				"subject ? object");
			continue;
		}
	} else if (subject.equals("?")) {
		String stype = "qsubject";
		if (debug == "yes") System.err.println("# stype = " + stype);
		flags = "inverse=yes";
		answer = getdata.get_data(tap,object,predicate,flags);
	} else if (object.equals("?")) {
		String stype = "qobject";
		if (debug == "yes") System.err.println("# stype = " + stype);
		flags = "inverse=no";
		answer = getdata.get_data(tap,subject,predicate,flags);
	} else {
		String stype = "statement";
		if (debug == "yes") System.err.println("# stype = " + stype);
		flags = "";
		putdata.put_data(kbfile,subject,predicate,object);
		continue;
	}
	if (debug == "yes") {
	  System.err.println(info + "flags = <" + flags + ">");
	}

	int na = answer.length;
	if (na == 0) {
		System.err.println("  " + info + "count = " + na);
	} else if (predicate.equals("arcs")) {
		if (flags.equals("inverse=no")) {
			getdata.get_property_values(tap,subject,answer);
		} else {
			getdata.print_column(answer);
		}
	} else {
		getdata.print_column(answer);
	}
} // end for
	return;
    } // end main()

} // end class

//</pre></html>
