/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.TAP;

import edu.stanford.TAP.Cursor;
import edu.stanford.TAP.Error;
import edu.stanford.TAP.Import_DAML;
import edu.stanford.TAP.Import_MCF;
import edu.stanford.TAP.Import_RDF;
import edu.stanford.TAP.Import_TDF;
import edu.stanford.TAP.Import_XML;
import edu.stanford.TAP.KB;

public class Import_Guess {
    private static void _makeLabelsAndRoots(KB kB) {
        Cursor cursor = kB.GetAllNodes();
        String string = cursor.Next();
        while (string != null) {
            Cursor cursor2 = kB.GetLexicalArcTargets(string);
            if (cursor2.Next() == null) {
                String string2 = kB.MakeTitle(string);
                kB.Assert(string, "label", string2);
            }
            cursor2.Release();
            string = cursor.Next();
        }
        cursor.Release();
    }

    public static int Load(KB kB, String string, String string2, String string3) {
        int n = -1;
        if (string2 != null && string2.equalsIgnoreCase("text/rdf") || string != null && string.endsWith(".rdf")) {
            n = Import_RDF.Load(kB, string3);
        }
        if (string2 != null && string2.equalsIgnoreCase("text/daml") || string != null && string.endsWith(".daml")) {
            n = Import_DAML.Load(kB, string3);
        } else if (string2 != null && string2.equalsIgnoreCase("text/mcf") || string != null && string.endsWith(".mcf")) {
            n = Import_MCF.Load(kB, string);
        } else if (string2 != null && string2.equalsIgnoreCase("text/xml") || string != null && string.endsWith(".xml")) {
            n = Import_XML.Load(kB, string3);
        } else if (string2 != null && string2.equalsIgnoreCase("text/plain") || string != null && (string.endsWith(".txt") || string.endsWith(".tdf"))) {
            n = Import_TDF.Load(kB, string3);
        } else {
            Error.Report("Can't figure out what " + string + " is!");
            return -1;
        }
        if (n == 0) {
            Import_Guess._makeLabelsAndRoots(kB);
        }
        return n;
    }

    public static int LoadFile(KB kB, String string) {
        if (string.endsWith(".rdf")) {
            return Import_RDF.LoadFile(kB, string);
        }
        if (string.endsWith(".mcf")) {
            return Import_MCF.Load(kB, string);
        }
        if (string.endsWith(".xml")) {
            return Import_XML.LoadFile(kB, string);
        }
        if (string.endsWith(".txt") || string.endsWith(".tdf")) {
            return Import_TDF.LoadFile(kB, string);
        }
        Error.Report("Can't figure out what " + string + " is!");
        return -1;
    }
}

