/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.TAP;

import edu.stanford.TAP.Attribute;
import edu.stanford.TAP.ClientCallback;
import edu.stanford.TAP.Cursor;
import edu.stanford.TAP.Description;
import edu.stanford.TAP.Error;
import edu.stanford.TAP.Export_DAML;
import edu.stanford.TAP.Export_MCF;
import edu.stanford.TAP.Export_RDF;
import edu.stanford.TAP.Export_TDF;
import edu.stanford.TAP.Import_Guess;
import edu.stanford.TAP.Import_SOAP;
import edu.stanford.TAP.KB;
import edu.stanford.TAP.KB_MemHash;
import edu.stanford.TAP.Request;
import edu.stanford.TAP.Request_XML;
import edu.stanford.TAP.Resource;
import edu.stanford.TAP.Restriction;
import edu.stanford.TAP.SOAP;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class Client {
    static boolean trace = false;
    String url;
    KB skb;
    KB tkb;
    ClientCallback cb;

    private void __init(Object object, KB kB) {
        this.url = null;
        this.skb = null;
        this.tkb = null;
        this.cb = null;
        if (object instanceof String) {
            this.SetSource((String)object);
        } else if (object instanceof KB) {
            this.SetSource((KB)object);
        }
        if (kB != null) {
            this.SetTarget(kB);
        }
    }

    public Client() {
        this.__init(null, null);
    }

    public Client(String string) {
        this.__init(string, null);
    }

    public Client(Object object, KB kB) {
        this.__init(object, kB);
    }

    public void SetSource(String string) {
        this.skb = null;
        this.url = string;
    }

    public void SetSource(KB kB) {
        this.skb = kB;
        this.url = null;
    }

    public String GetSourceURL() {
        if (this.url != null) {
            return this.url;
        }
        return this.skb != null ? this.skb.GetURL() : null;
    }

    public KB GetSourceKB() {
        return this.skb;
    }

    public boolean IsLexiconArc(String string) {
        if (this.tkb == null) {
            this.tkb = new KB_MemHash();
        }
        return this.tkb.IsLexiconArc(string);
    }

    public void SetTarget(KB kB) {
        this.tkb = kB;
    }

    public KB GetTarget() {
        return this.tkb;
    }

    public void Import(String string) {
        if (this.skb != null) {
            this.skb.Shutdown();
            this.skb = null;
        }
        KB_MemHash kB_MemHash = new KB_MemHash();
        while (string != null) {
            int n = 0;
            while (n < string.length()) {
                if (Character.isWhitespace(string.charAt(n))) break;
                ++n;
            }
            String string2 = string.substring(0, n);
            String string3 = string = n < string.length() ? string.substring(n + 1) : null;
            if (string2.startsWith("http://")) {
                Attribute attribute = SOAP.GetWithType(string2);
                Import_Guess.Load(kB_MemHash, string2, attribute.name, attribute.value);
                continue;
            }
            Import_Guess.LoadFile(kB_MemHash, string2);
        }
        this.SetSource(kB_MemHash);
    }

    public void Use(String string) {
        if (this.skb != null) {
            this.skb.Shutdown();
            this.skb = null;
        }
        this.SetSource(string);
    }

    public void SetCallback(ClientCallback clientCallback) {
        this.cb = clientCallback;
    }

    public Vector GetDataCursor(Request request) {
        if (this.skb != null) {
            this.tkb = this.skb;
            return this.skb.GetData(request);
        }
        if (this.url != null) {
            Object object;
            Vector<Cursor> vector;
            Object object2;
            Description description = request.GetDescription();
            Description description2 = request.GetProperties();
            String string = (String)description.GetRestrictionValue("oid");
            if (this.tkb != null && string != null && this.tkb.HasNode(string)) {
                boolean bl = true;
                object2 = description2.GetRestrictionSet();
                vector = ((Vector)object2).elements();
                while (vector.hasMoreElements()) {
                    object = (Restriction)vector.nextElement();
                    boolean bl2 = ((Restriction)object).IsFlagSet("inverse");
                    if (bl2) {
                        if (this.tkb.GetSource(string, ((Restriction)object).GetArc()) != null) continue;
                        bl = false;
                        break;
                    }
                    if (this.tkb.GetTarget(string, ((Restriction)object).GetArc()) != null) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    return this.tkb.GetData(request);
                }
            }
            if (this.tkb == null) {
                this.tkb = new KB_MemHash();
                this.tkb.SetURL(this.url);
            }
            String string2 = Request_XML.SOAP_Serialize(this.url, request, "GetData");
            object2 = SOAP.Post(this.url, string2);
            if (trace) {
                System.err.println("got request:\n" + string2);
                System.err.println("got response:\n" + (String)object2);
            }
            if (object2 != null) {
                vector = Import_SOAP.Load(this.tkb, (String)object2);
                object = new Vector();
                if (vector.size() == 1) {
                    description = new Description(null);
                    description.AddArcTarget("oid", (String)vector.elementAt(0));
                    description2 = request.GetProperties();
                    Request request2 = new Request(description, description2);
                    return this.tkb.GetData(request2);
                }
                Cursor cursor = new Cursor(this.tkb);
                ((Vector)object).addElement(cursor);
                cursor.AddResults(vector);
                return object;
            }
            Error.Report("ERROR: Failed to contact remote server!");
            vector = new Vector<Cursor>();
            vector.addElement(new Cursor(null));
            return vector;
        }
        Error.Report("ERROR: Unknown source for GetData command!");
        Vector<Cursor> vector = new Vector<Cursor>();
        vector.addElement(new Cursor(null));
        return vector;
    }

    /*
     * Unable to fully structure code
     */
    private Resource makeResource(String var1_1) {
        var1_1 = var1_1.trim();
        var2_2 = new Resource();
        var3_3 = 0;
        var4_4 = 0;
        ** GOTO lbl15
        {
            ++var3_3;
            do {
                if (var3_3 < var1_1.length() && Character.isWhitespace(var1_1.charAt(var3_3))) continue block0;
                var4_4 = var3_3;
                while (var4_4 < var1_1.length() && !Character.isWhitespace(var1_1.charAt(var4_4))) {
                    ++var4_4;
                }
                var2_2.addProperty(var1_1.substring(var3_3, var4_4), null);
                var3_3 = var4_4;
lbl15:
                // 2 sources

            } while (var3_3 < var1_1.length());
        }
        return var2_2;
    }

    public Resource GetData(String string, String string2, String string3) {
        Resource resource = this.makeResource(string2);
        resource.setFlags(string3);
        return this.GetData(new Resource(string), resource);
    }

    public Resource GetData(String string, Resource resource, String string2) {
        resource.setFlags(string2);
        return this.GetData(new Resource(string), resource);
    }

    public Resource GetData(Resource resource, Resource resource2, String string) {
        resource2.setFlags(string);
        return this.GetData(resource, resource2);
    }

    public Resource GetData(Resource resource, String string, String string2) {
        Resource resource2 = this.makeResource(string);
        resource2.setFlags(string2);
        return this.GetData(resource, resource2);
    }

    public Resource GetData(String string, String string2) {
        return this.GetData(new Resource(string), this.makeResource(string2));
    }

    public Resource GetData(String string, Resource resource) {
        return this.GetData(new Resource(string), resource);
    }

    public Resource GetData(Resource resource, String string) {
        return this.GetData(resource, this.makeResource(string));
    }

    public Resource GetData(Resource resource, Resource resource2) {
        Object object;
        Object object2;
        Object object3;
        Description description = resource.asDescription();
        Description description2 = new Description(null);
        if (resource2.count() > 1) {
            int n = 0;
            while (n < resource2.count()) {
                object3 = resource2.item(n);
                object2 = ((Resource)object3).value;
                object = ((Resource)object3).getFlags();
                if (object != null) {
                    if (((String)object).indexOf("inverse=yes") != -1) {
                        object2 = "!" + (String)object2;
                    }
                    if (((String)object).indexOf("includeSuperClasses=yes") != -1) {
                        object2 = "<" + (String)object2;
                    }
                    if (((String)object).indexOf("includeSubClasses=yes") != -1) {
                        object2 = ">" + (String)object2;
                    }
                }
                description2.AddArcTarget((String)object2, null);
                ++n;
            }
        } else {
            String string = resource2.value;
            object3 = resource2.getFlags();
            if (object3 != null) {
                if (((String)object3).indexOf("inverse=yes") != -1) {
                    string = "!" + string;
                }
                if (((String)object3).indexOf("includeSuperClasses=yes") != -1) {
                    string = "<" + string;
                }
                if (((String)object3).indexOf("includeSubClasses=yes") != -1) {
                    string = ">" + string;
                }
            }
            description2.AddArcTarget(string, null);
        }
        Request request = new Request(description, description2);
        object3 = null;
        if (resource.startAt != -1) {
            request.SetParameter("startAt", Integer.toString(resource.startAt));
        }
        if (resource.stepSize != -1) {
            request.SetParameter("stepSize", Integer.toString(resource.stepSize));
        }
        while (true) {
            object3 = this.GetDataCursor(request);
            if (description2.HasRestriction("Identify") || ((Vector)object3).size() != 1 || this.cb == null) break;
            object2 = new Resource((Cursor)((Vector)object3).elementAt(0));
            if (((Resource)object2).value == null) break;
            if ((resource = this.cb.Disambiguate(resource, (Resource)object2)) == null) {
                return new Resource();
            }
            description = resource.asDescription();
            request.SetDescription(description);
        }
        object2 = new Resource();
        if (((Vector)object3).size() == 1) {
            object = (Cursor)((Vector)object3).elementAt(0);
            String string = ((Cursor)object).Next();
            while (string != null) {
                ((Resource)object2).addItem(new Resource(string));
                string = ((Cursor)object).Next();
            }
        } else {
            object = description2.GetRestrictionSet();
            ((Vector)object3).removeElementAt(0);
            if (((Vector)object).size() < 2) {
                Cursor cursor = (Cursor)((Vector)object3).elementAt(0);
                String string = cursor.Next();
                while (string != null) {
                    ((Resource)object2).addItem(new Resource(string));
                    string = cursor.Next();
                }
            } else {
                int n = 0;
                while (n < ((Vector)object).size() && n < ((Vector)object3).size()) {
                    Resource resource3 = new Resource();
                    Cursor cursor = (Cursor)((Vector)object3).elementAt(n);
                    String string = cursor.Next();
                    while (string != null) {
                        resource3.addItem(new Resource(string));
                        string = cursor.Next();
                    }
                    Restriction restriction = (Restriction)((Vector)object).elementAt(n);
                    ((Resource)object2).setPropertyResponse(restriction.GetArc(), resource3);
                    if (((Resource)object2).value == null) {
                        ((Resource)object2).setValue(resource3.value);
                    }
                    ++n;
                }
            }
        }
        return object2;
    }

    public String GetValue(Resource resource, String string, String string2) {
        Resource resource2 = this.GetData(resource, string, string2);
        return resource2.value;
    }

    public Vector GetValues(Resource resource, String string, String string2) {
        Resource resource2 = this.GetData(resource, string, string2);
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < resource2.count()) {
            vector.addElement(resource2.item((int)n).value);
            ++n;
        }
        return vector;
    }

    public int ExportData(String string, OutputStream outputStream, Resource resource, String string2, String string3) {
        Resource resource2 = this.GetData(resource, string2, string3);
        Cursor cursor = new Cursor(this.tkb);
        Vector vector = resource2.items();
        if (vector == null) {
            return 0;
        }
        Vector<String> vector2 = new Vector<String>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Resource resource3 = (Resource)enumeration.nextElement();
            vector2.addElement(resource3.value);
        }
        cursor.AddResults(vector2);
        if (string.equalsIgnoreCase("mcf")) {
            Export_MCF.DoSerializeCursor(outputStream, cursor);
        } else if (string.equalsIgnoreCase("daml")) {
            Export_DAML.DoSerializeCursor(outputStream, cursor);
        } else if (string.equalsIgnoreCase("rdf")) {
            Export_RDF.DoSerializeCursor(outputStream, cursor);
        } else if (string.equalsIgnoreCase("tdf")) {
            Export_TDF.DoSerializeCursor(outputStream, cursor);
        } else {
            return -1;
        }
        return 0;
    }

    public boolean IsInstanceOf(Resource resource, String string) {
        return this.IsInstanceOf(resource.value, string);
    }

    public boolean IsInstanceOf(String string, String string2) {
        Description description = new Description(null);
        Description description2 = new Description(null);
        description.AddArcTarget("oid", string);
        description.AddArcTarget("type", string2);
        description2.AddArcTarget("Identify", null);
        Request request = new Request(description, description2);
        Cursor cursor = this.tkb == null || !this.tkb.HasNode(string) ? (Cursor)this.GetDataCursor(request).elementAt(0) : (Cursor)this.tkb.GetData(request).elementAt(0);
        String string3 = cursor.Next();
        cursor.Release();
        return string3 != null;
    }

    public Resource GetResourcesNamed(String string, Resource resource) {
        return this.GetResourcesNamed(string, resource.value);
    }

    public Resource GetResourcesNamed(String string) {
        return this.GetResourcesNamed(string, (String)null);
    }

    public Resource GetResourcesNamed(String string, String string2) {
        Resource resource = new Resource(null);
        if (string2 != null) {
            resource.addArc("type", string2);
        }
        resource.addArc("term", string);
        return this.GetData(resource, "Identify", null);
    }
}

