// KEHOME/src/mkrGetResource.java
// Aug/18/2003
// usage: java -DKBDATA=kbdata mkrGetResource genus name

import edu.stanford.TAP.Abbrev;
import edu.stanford.TAP.Client;
import edu.stanford.TAP.Resource;
import edu.stanford.TAP.XML;

public class mkrGetResource
{
    public static void main(String argv[])
    {
	String info   = "INFO: GetResource: ";
	String tapuri = "http://tap.stanford.edu/data/";
	String debug  = "no";

	String kbdata = System.getProperty("KBDATA");
	String genus  = argv[0];
	String name   = argv[1];
	String flags  = "$flags";

	Abbrev.LoadNamespaces("namespaces.txt");
	if (!Abbrev.IsStandardTag(genus)) {
	    genus = tapuri + genus;
	}
	if (debug == "yes") {
	  System.out.println("# INFO: GetResource: tapuri = " + tapuri);
	  System.out.println("# INFO: GetResource: kbdata = " + kbdata);
	  System.out.println("# INFO: GetResource: genus = "  + genus);
	  System.out.println("# INFO: GetResource: name = "   + name);
	  System.out.println("# INFO: GetResource: flags = "  + flags);
	}

	Client tap = new Client(kbdata);
	//if () {
		//Resource answer = tap.GetResourcesNamed(name);
	//} else {
		Resource resource = new Resource(genus);
		Resource answer = tap.GetResourcesNamed(name,resource);
	//}

	if (answer.count() == 0) {
		System.out.println("  #" + info + "count = " + answer.count());
	}
	for(int n = 0; n < answer.count(); ++n) {
	    String tapAnswer = answer.item(n).value;
	    String mkrAnswer = XML.SplitNamespace(tapAnswer).tag;
	    //System.out.println("  " + tapAnswer);
	    System.out.println("  " + mkrAnswer);
	}
    }
}

