/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <errno.h>
#include <stat.h>
#include <time.h>
#include <libp.h>

static time_t to_timet(FILETIME *time)
{
   SYSTEMTIME stime ;
   struct tm tmx ;
   FileTimeToSystemTime(time,&stime) ;
   tmx.tm_hour = stime.wHour ;
   tmx.tm_min = stime.wMinute ;
   tmx.tm_sec = stime.wSecond ;
   tmx.tm_mon = stime.wMonth ;
   tmx.tm_mday = stime.wDay ;
   tmx.tm_year = stime.wYear - 1900 ;
   return mktime(&tmx) ;
}
int _ll_stat(int handle, void *__statbuf)
{
   struct _stat *sb = __statbuf ;
   BY_HANDLE_FILE_INFORMATION info ;
   FILETIME timex ;

   if (__statbuf & S_IFCHR)
      return 0 ;

   if (!GetFileInformationByHandle((HANDLE)handle,&info)) {
      errno = EBADF ;
      return -1 ;
   }
   if (sb->st_mode & S_IFREG) {
      sb->st_atime = to_timet(&info.ftLastAccessTime) ;
      sb->st_mtime = to_timet(&info.ftLastWriteTime) ;
      sb->st_ctime = to_timet(&info.ftCreationTime) ;
   } 
	return 0;
}
int _ll_writeable(const char *file)
{
   int attrib = GetFileAttributes(file) ;
   if (attrib == -1)
      return 1 ;
   return !(attrib & FILE_ATTRIBUTE_READONLY) ;

}