/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdio.h>
#include <time.h>

static char _monthdays[12] = { 31,28,31,30,31,30,31,31,30,31,30,31 };

#ifdef NONRECURSIVE
static time_t days;
#endif
time_t mktime(struct tm *timeptr)
{
#ifndef NONRECURSIVE
	char buf[STACKPAD];
	time_t days;
#endif
	int i = 0;
	struct tm t = *timeptr;
	t.tm_year += 1900;
	if (t.tm_year < 1970 || t.tm_year > 2038)
		return -1;
	if (!((t.tm_year - 1972)%4))
		_monthdays[1] = 29;
	else
		_monthdays[1] = 28;
	days = (t.tm_year - 1970)*365;
	days += (t.tm_year -1969)/4;
	for (i=0; i < t.tm_mon; i++)
		days += _monthdays[i];
	days += t.tm_mday-1;
	days *=24;
	days += t.tm_hour;
	days *=60;
	days += t.tm_min;
	days *=60;
	days += t.tm_sec;
	return days;
}