/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdlib.h>
#include <stdio.h>
#include <io.h>
#include <string.h>
#include <time.h>
#include <errno.h>
#include <stat.h>
#include <time.h>
#include <dpmi.h>
#include <libp.h>

int _ll_stat(int handle, void *__statbuf)
{
   struct _stat *sb = __statbuf ;
   if (sb->st_mode & S_IFREG) {
      struct ftime ft ;
      int timex ;
      struct tm tmx ;
      if (_ll_getftime(handle,&ft) == -1) {
         errno = EBADF ;
         return -1 ;
      }
      tmx.tm_year = ft.ft_year +1980 - 1900;
      tmx.tm_mon =ft.ft_month ;
      tmx.tm_mday = ft.ft_day ;
      tmx.tm_hour = ft.ft_hour ;
      tmx.tm_min = ft.ft_min ;
      tmx.tm_sec = 2 * ft.ft_tsec ;
      timex = mktime(&tmx) ;
      sb->st_atime = sb->st_mtime = sb->st_ctime = timex ;
   } 
	return 0;
}
int _ll_writeable(const char *file)
{
	DPMI_REGS regs;
   regs.b.al = 0 ;
   regs.h.dx = __nametodta(file,0) ;
   __doscall(0x43,&regs);
   if (regs.b.al != 0)
      return 1 ;
   return !(regs.h.cx & 1) ;
}