/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <dpmi.h>

/*
 * This file is included in this release as an alpha version.
 *
 * The only things that have been tested at this time are
 * the series 00xx,01xx,03xx functions
 *
 * Use the rest at your own risk!
 */

/* group 0 */
int	dpmi_alloc_descriptors(SELECTOR * basesel,UWORD num)
{
	asm mov cx,[num]
	asm mov ax,0
	asm int 0x31
	asm jc xerr
	asm mov ecx,[basesel]
	asm mov [ecx],ax
	return 0;

xerr:
	return(-1);
}
int	dpmi_free_selector(SELECTOR sel)
{
	asm push ebx
	asm mov	bx,[sel]
	asm mov	ax,1
	asm int 0x31
	asm pop ebx
	asm jc xerr
	return 0;

xerr:
	return(-1);
}
int	dpmi_get_sel_increment(ULONG * rv)
{
	asm mov ax,3
	asm int 0x31
	asm mov ecx,[rv]
	asm movzx eax,ax
	asm mov [ecx],eax
	return 0;
}
int dpmi_get_sel_base(ULONG * base, SELECTOR sel)
{
	asm push ebx
	asm mov bx,[sel]
	asm mov ax,6
	asm int 0x31
	asm pop ebx
	asm jc xerr
	asm	mov ax,cx
	asm shl eax,16
	asm mov ax,dx
	asm mov ecx,[base]
	asm mov [ecx],eax
	return 0;

xerr:
	return(-1);
}
int	dpmi_set_sel_base(SELECTOR sel, ULONG base)
{
	asm push ebx
	asm mov bx,[sel]
	asm mov ax,7
	asm mov ecx,[base]
	asm mov dx,cx
	asm shr ecx,16
	asm int 0x31
	asm pop ebx
	asm jc xerr
	return 0;

xerr:
	return(-1);
}
int	dpmi_get_sel_limit(ULONG *limit, SELECTOR sel)
{
	ULONG base;
	if (dpmi_get_sel_base(&base,sel))
		return -1;
	asm mov ax,[sel]
	asm lsl eax,eax
	asm mov ecx,[limit]
	asm mov [ecx],eax
	return 0;
}
int	dpmi_set_sel_limit(SELECTOR sel , ULONG limit)
{
	asm push ebx
	asm mov bx,[sel]
	asm mov ax,8
	asm mov ecx,[limit]
	asm mov dx,cx
	asm shr ecx,16
	asm int 0x31
	asm pop ebx
	asm jc xerr
	return 0;

xerr:
	return(-1);
}
int	dpmi_get_sel_access_rights(UWORD * rights, SELECTOR sel)
{
	ULONG base;
	if (dpmi_get_sel_base(&base,sel))
		return -1;
	asm mov ax,[sel]
	asm lar eax,eax
	asm mov ecx,[rights]
	asm mov [ecx],eax
	return 0;
}
int	dpmi_set_sel_access_rights(SELECTOR sel, UWORD rights)
{
	asm push ebx
	asm mov bx,[sel]
	asm mov ax,9
	asm mov cx,[rights]
	asm int 0x31
	asm pop ebx
	asm jc xerr
	return 0;

xerr:
	return(-1);
}
int	dpmi_get_alias_descriptor(SELECTOR *alias, SELECTOR sel)
{
	asm push ebx
	asm mov bx,[sel]
	asm mov ax,0xa
	asm int 0x31
	asm pop ebx
	asm jc xerr
	asm mov ecx,[alias]
	asm mov [ecx],ax
	return 0;

xerr:
	return(-1);
}
/* I haven't tested the next four */

int	dpmi_set_descriptor(SELECTOR sel, DESCRIPTOR *desc)
{
	asm push ebx
	asm push edi
	asm mov edi,[desc]
  asm mov bx,[sel]
	asm mov ax,0xc
	asm int 0x31
	asm pop edi
	asm pop ebx
	asm jc xerr
	return 0;

xerr:
	return(-1);
}
int	dpmi_get_descriptor(DESCRIPTOR *desc, SELECTOR sel)
{
	asm push ebx
	asm push edi
	asm mov edi,[desc]
  asm mov bx,[sel]
	asm mov ax,0xb
	asm int 0x31
	asm pop	edi
	asm pop	ebx
	asm jc xerr
	return 0;

xerr:
	return(-1);
}
int	dpmi_set_multiple_descriptors(MULTIPLE_DESCRIPTOR *desc , UWORD count)
{
	asm push edi
	asm mov edi,[desc]
  asm mov cx,[count]
	asm mov ax,0xf
	asm int 0x31
	asm pop edi
	asm jc xerr
	return 0;

xerr:
	return(-1);
}

int	dpmi_get_multiple_descriptors(MULTIPLE_DESCRIPTOR *desc , UWORD count)
{
	asm push edi
	asm mov edi,[desc]
  asm mov cx,[count]
	asm mov ax,0xE
	asm int 0x31
	asm pop edi
	asm jc xerr
	return 0;

xerr:
	return(-1);
}

/* group 1 */
int	dpmi_alloc_real_memory(SELECTOR *sel, UWORD *para, UWORD len)
{
	asm push ebx
	asm mov bx,[len]
	asm mov ax,0x100
	asm int 0x31
	asm pop ebx
	asm jc xerr
	asm mov ecx,[sel]
	asm mov [ecx],dx
	asm mov ecx,[para]
	asm mov [ecx],ax
	return 0;

xerr:
	return(-1);
}

int	dpmi_dealloc_real_memory(SELECTOR sel)
{
	asm mov dx,[sel]
	asm mov ax,0x101
	asm int 0x31
	asm jc xerr
	return 0;

xerr:
	return(-1);
}
int	dpmi_realloc_real_memory(SELECTOR sel, UWORD size)
{
	asm push ebx
	asm mov bx,[size]
	asm mov dx,[sel]
	asm mov ax,0x102
	asm int 0x31
	asm pop ebx
	asm jc xerr
	return 0;

xerr:
	return(-1);
}

int dpmi_arbitrary_copy( SELECTOR dstsel, ULONG dest, SELECTOR srcsel , ULONG source, ULONG len)
{
	asm push ds
	asm push es
	asm push esi
	asm push edi
	asm mov ecx,[len]
	asm mov edi,[dest]
  asm mov esi,[source]
  asm mov es,[dstsel]
  asm mov ds,[srcsel]
	asm cld
	asm rep movsb
	asm pop edi
	asm pop esi
	asm pop es
	asm pop ds
	return 0;
}
int	dpmi_copy_from_ds(SELECTOR sel,ULONG dest,void *source, ULONG len)
{
	asm push es
	asm push esi
	asm push edi
	asm mov ecx,[len]
	asm mov edi,[dest]
  asm mov esi,[source]
  asm mov es,[sel]
	asm cld
	asm rep movsb
	asm pop edi
	asm pop esi
	asm pop es
	return 0;
}
int 	dpmi_copy_to_ds(void *dest, SELECTOR sel, ULONG source, ULONG len)
{
	asm push ds
	asm push esi
	asm push edi
	asm mov ecx,[len]
	asm mov edi,[dest]
  asm mov esi,[source]
  asm mov ds,[sel]
	asm cld
	asm rep movsb
	asm pop edi
	asm pop esi
	asm pop ds
	return 0;
}

/* group 2 */
int	dpmi_get_real_interrupt(UWORD *xseg, UWORD *ofs, UWORD num)
{
	asm push ebx
	asm mov bx,[num]
	asm mov ax,0x200
	asm int 0x31
	asm pop ebx
	asm jc xerr
	asm mov eax,[xseg]
	asm mov [eax],cx
	asm mov eax,[ofs]
	asm mov [eax],dx
	return 0;

xerr:
	return(-1);
}
int	dpmi_set_real_interrupt(UWORD num ,UWORD xseg,UWORD ofs)
{
	asm push ebx
	asm mov bx,[num]
	asm mov cx,[xseg]
  asm mov dx,[ofs]
	asm mov ax,0x201
	asm int 0x31
	asm jc	xerr
	asm pop ebx
	return 0;

xerr:
	return(-1);
}

int	dpmi_get_protected_except(SELECTOR *sel, ULONG *ofs, UWORD num)
{
	asm push ebx
	asm mov bx,[num]
	asm mov ax,0x202
	asm int 0x31
	asm pop ebx
	asm jc xerr
	asm mov eax,[sel]
	asm mov [eax],cx
	asm mov eax,[ofs]
	asm mov [eax],edx
	return 0;

xerr:
	return(-1);
}

int	dpmi_set_protected_except(UWORD num,SELECTOR sel,ULONG ofs)
{
	asm push ebx
	asm mov bx,[num]
	asm mov cx,[sel]
  asm mov edx,[ofs]
	asm mov ax,0x203
	asm int 0x31
	asm pop ebx
	asm jc	xerr
	return 0;

xerr:
	return(-1);
}

int	dpmi_get_protected_interrupt(SELECTOR *sel, ULONG *ofs, UWORD num)
{
	asm push ebx
	asm mov bx,[num]
	asm mov ax,0x204
	asm int 0x31
	asm pop ebx
	asm jc xerr
	asm mov eax,[sel]
	asm mov [eax],cx
	asm mov eax,[ofs]
	asm mov [eax],edx
	return 0;

xerr:
	return(-1);
}

int	dpmi_set_protected_interrupt(UWORD num,SELECTOR sel,ULONG ofs)
{
	asm push ebx
	asm mov bx,[num]
	asm mov cx,[sel]
  asm mov edx,[ofs]
	asm mov ax,0x205
	asm int 0x31
	asm pop ebx
	asm jc	xerr
	return 0;

xerr:
	return(-1);
}

/* group 3 */
int	dpmi_simulate_real_interrupt(UWORD num, DPMI_REGS *val)
{
	asm push ebx
	asm push edi
	asm mov bx,[num]
	asm sub bh,bh
	asm mov edi,[val]
	asm sub ecx,ecx
	asm mov ax,0x300
	asm int 0x31
	asm pop edi
	asm pop ebx
	asm jc	xerr
	return 0;

xerr:
	return(-1);
}

int	dpmi_simulate_proc_far_ret_frame(DPMI_REGS *val)
{
	asm push ebx
	asm push edi
	asm sub bx,bx
	asm mov edi,[val]
	asm sub ecx,ecx
	asm mov ax,0x301
	asm int 0x31
	asm pop edi
	asm pop ebx
	asm jc	xerr
	return 0;

xerr:
	return(-1);
}

int	dpmi_simulate_proc_int_frame(DPMI_REGS *val)
{
	asm push ebx
	asm push edi
	asm sub bx,bx
	asm mov edi,[val]
	asm sub ecx,ecx
	asm mov ax,0x302
	asm int 0x31
	asm pop edi
	asm pop ebx
	asm jc	xerr
	return 0;

xerr:
	return(-1);
}
int	dpmi_get_real_callback(void *proc, void *buf, UWORD *xseg, UWORD *ofs)
{
	asm push esi
	asm push edi
	asm mov esi,[proc]
	asm mov edi,[buf]
	asm mov ax,0x303
	asm int 0x31
	asm pop edi
  asm pop esi
	asm jc xerr
	asm mov	eax,[xseg]
	asm mov	[eax],cx
	asm mov eax,[ofs]
	asm mov [eax],dx
	return 0;

xerr:
	return(-1);
}
int	dpmi_free_real_callback(UWORD xseg , UWORD ofs )
{
	asm mov cx,[xseg]
	asm mov dx,[ofs]
	asm mov ax,0x304
	asm int 0x31
	asm jc xerr
	return 0;

xerr:
	return(-1);
}
int	dpmi_get_state_save_restore(SELECTOR *csel, void *cofs, UWORD *xseg, UWORD *ofs, UWORD len)
{
	asm push esi
	asm push edi
	asm mov ax,0x305
	asm int 0x31
	asm push ebx
	asm mov bx,[len]
	asm movzx eax,ax
	asm mov [ebx],eax
	asm pop ebx
	asm mov eax,[csel]
	asm mov [eax],si
	asm mov eax,[cofs]
	asm mov [eax],edi
	asm mov eax,[xseg]
	asm mov [eax],cx
	asm mov eax,[ofs]
	asm mov [eax],dx
	asm pop edi
	asm pop esi
	return 0;
}
int	dpmi_call_state_save_restore(SELECTOR csel, void *proc, void *buf, UWORD flag)
{
	UBYTE fcall[6];
	asm push esi
	asm mov esi,[buf]
	asm mov ax,[csel]
	asm mov word ptr [fcall + 4],ax
	asm mov eax,[proc]
	asm mov dword ptr [fcall],eax
	asm mov ax,[flag]
	asm call fword ptr [fcall]
	asm pop esi
	return 0;
	
}
int	dpmi_get_version(DPMI_VER *ver)
{
	asm mov ax,0x400
	asm int 0x31
	asm push esi
	asm mov esi, [ver]
	asm mov [esi],ax
	asm mov [esi + 2],bx
	asm mov [esi + 4],cl
	asm mov [esi + 5],dx

	asm pop esi
	return 0;
}

/* group 5 */
int	dpmi_get_memory_info( DPMI_FREEMEM_INFO *info)
{
	asm push edi
	asm mov edi,[info]
	asm mov ax,0x500
	asm int 0x31
	asm jc xerr
	return 0;

xerr:
	return(-1);
}
int	dpmi_get_memory( ULONG *linear, DPMI_MEM_HANDLE *handle, ULONG size)		
{
	asm push esi
	asm push edi
	asm push ebx
	asm mov ax,0x501
	asm mov bx,word ptr [size + 2]
	asm mov cx,word ptr [size]
	asm int 0x31
	asm jc xerr
	asm mov eax,[linear]
	asm mov [eax],cx
	asm mov [eax+2],bx
	asm mov eax,[handle]
	asm mov [eax],di
	asm mov [eax+2],si
	asm pop ebx
	asm pop edi
	asm	pop esi
	return 0;

xerr:
	asm pop ebx
	asm pop edi
	asm pop esi
	return(-1);
}

int	dpmi_free_memory(DPMI_MEM_HANDLE handle)
{
	asm push esi
	asm push edi
	asm mov si,word ptr [handle+2]
	asm mov di,word ptr [handle]
	asm mov ax,0x502
	asm int 0x31
	asm pop edi
	asm pop esi
	asm jc xerr
	return 0;

xerr:
	return(-1);
}
int	dpmi_resize_memory( ULONG *linear, DPMI_MEM_HANDLE *handle, ULONG size)		
{
	asm push esi
	asm push edi
	asm push ebx
	asm mov ax,0x503
	asm mov bx,word ptr [size + 2]
	asm mov cx,word ptr [size]
	asm mov si,word ptr [handle+2]
	asm mov di,word ptr [handle]
	asm int 0x31
	asm jc xerr
	asm mov eax,[linear]
	asm mov [eax],cx
	asm mov [eax+2],bx
	asm mov eax,[handle]
	asm mov [eax],di
	asm mov [eax+2],si
	asm pop ebx
	asm pop edi
	asm pop esi
	return 0;

xerr:
	asm pop ebx
	asm pop edi
	asm pop esi
	return(-1);
}

int	dpmi_get_memory_params(ULONG *base, ULONG *size, DPMI_MEM_HANDLE handle)
{
	asm push esi
	asm push edi
	asm push ebx
	asm mov si,word ptr [handle+2]
	asm mov di,word ptr [handle]
	asm mov ax,0x504
	asm int 0x31
	asm jc xerr
	asm mov eax,[base]
	asm mov [eax],si
	asm mov [eax+2],di
	asm mov eax,[size]
	asm mov [eax],cx
	asm mov [eax+2],bx
	asm pop ebx
	asm pop edi
	asm pop esi
	return 0;

xerr:
	asm pop ebx
	asm pop edi
	asm pop esi
	return(-1);
}
	

/* group 9 */
int	dpmi_enable_virtual_flag(ULONG * rv)
{
  asm mov ax,0x901
	asm int 0x31
	asm movzx eax,al
  asm mov ecx,[rv]
	asm mov [ecx],eax
	return 0;
}
int	dpmi_disable_virtual_flag(ULONG * rv)
{
  asm mov ax,0x900
	asm int 0x31
	asm movzx eax,al
  asm mov ecx,[rv]
	asm mov [ecx],eax
	return 0;
}
int	dpmi_return_virtual_flag(ULONG * rv)
{
  asm mov ax,0x902
	asm int 0x31
	asm movzx eax,al
  asm mov ecx,[rv]
	asm mov [ecx],eax
	return 0;
}