#include <windows.h>
#include <signal.h>
#include <stdlib.h>

static int *_xceptblkptr;
static int ctrlchandlerInstalled ;

static int PASCAL _xceptionhandle(PEXCEPTION_RECORD er, void *frame,
			PCONTEXT context, void *dispatchercontext)
{

	int signum = -1,rv = 0;
	switch(er->ExceptionCode) {
		case EXCEPTION_ACCESS_VIOLATION:
		case EXCEPTION_DATATYPE_MISALIGNMENT:
		case EXCEPTION_ARRAY_BOUNDS_EXCEEDED:
			signum = SIGSEGV;
			break ;
		case EXCEPTION_PRIV_INSTRUCTION:
			signum = SIGILL;
			break ;
      case EXCEPTION_BREAKPOINT:
         // IF they really want to put a breakpoint in, let them but mmove on
         return EXCEPTION_CONTINUABLE ;
		case EXCEPTION_SINGLE_STEP:
			break ;
		case EXCEPTION_FLT_DENORMAL_OPERAND:
		case EXCEPTION_FLT_DIVIDE_BY_ZERO:
		case EXCEPTION_FLT_INEXACT_RESULT:
		case EXCEPTION_FLT_INVALID_OPERATION:
		case EXCEPTION_FLT_OVERFLOW:
		case EXCEPTION_FLT_STACK_CHECK:
		case EXCEPTION_FLT_UNDERFLOW:
			signum = SIGFPE ;
			break ;
		case EXCEPTION_INT_DIVIDE_BY_ZERO:
			break ;
		case EXCEPTION_INT_OVERFLOW:
			break ;
		case EXCEPTION_NONCONTINUABLE_EXCEPTION:
		case EXCEPTION_INVALID_DISPOSITION:
			break ;
		case EXCEPTION_STACK_OVERFLOW:
			break ;
	}
	if (signum != -1)
		rv = !raise(signum);

	if (!rv) {
		EXCEPTION_POINTERS xx;
		xx.ExceptionRecord = er ;
		xx.ContextRecord = context ;
		return UnhandledExceptionFilter(&xx) ;
	} else
		return EXCEPTION_CONTINUABLE ;
}
static BOOL PASCAL ControlCHandler(DWORD type)
{
   if (type == CTRL_C_EVENT || type == CTRL_BREAK_EVENT)
      raise(SIGINT) ;
   exit(0xff);
   return FALSE ;
}
void PASCAL __xceptinit(int *block)
{
	_xceptblkptr = block ;
	asm mov eax,[block]
   asm mov [eax+4],offset _xceptionhandle
	asm mov	ecx,fs:[0]
	asm mov [eax],ecx
	asm mov fs:[0],eax
}
void PASCAL __xceptrundown(void)
{
	asm mov eax,[_xceptblkptr]
   asm cmp eax,fs:[0]
  asm jnz nounset
	asm mov eax,[eax]
	asm mov fs:[0],eax
nounset:
   if (ctrlchandlerInstalled)
      SetConsoleCtrlHandler(ControlCHandler,0);
	return ;
}
void _ll_signal(int signum, void (*func)())
{
   if (signum == SIGINT && !ctrlchandlerInstalled) {
      SetConsoleCtrlHandler(ControlCHandler,1);
      ctrlchandlerInstalled = TRUE ;
   }
}