; 
;   Copyright 1994-2003 Free Software Foundation, Inc.
;
;   This library is free software; you can redistribute it and/or
;   modify it under the terms of the GNU Lesser General Public
;   License as published by the Free Software Foundation; either
;   version 2.1 of the License, or (at your option) any later version.
;
;   This library is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;   Lesser General Public License for more details.
;
;   You should have received a copy of the GNU Lesser General Public
;   License along with this library; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
;   USA
;
;   You may contact the author at:
;
;   mailto::camille@bluegrass.net
;
;   or by snail mail at:
;
;   David Lindauer
;   850 Washburn Ave Apt 99
;   Louisville, KY 40222
;
	;MASM MODE
	.386
	.model use32 small

	PUBLIC	PrintSpace,PrintDword,PrintWord,PrintByte
	PUBLIC	PureChar, PutChar, GetKey, Message, ScanKey
	PUBLIC  crlf, olMessage, dgroupMessage

	.data
col	db	0

	.code

;
; dump a message
;
Message	Proc
	xchg	ebx,[esp]
	call	olMessage
	xchg	ebx,[esp]
	ret
Message	Endp

dgroupMessage	PROC
olMessage Proc
	push	edx
mlp:
	mov	dl,[ebx]
	inc	ebx
	or	dl,dl
	jz	nomore
	call	PutChar
	jmp	mlp
nomore:
	pop	edx
	ret
olMessage ENDP
dgroupMessage	ENDP

;
; print a (pure) char
;
; chars are limited to ASCII unless the pure video option is set,
; in chich case we display everything but a few control chars the
; BIOS will try to interpret and wreck our display
;
PureChar	PROC
	cmp	dl,20h
	jnc	PutChar
	cmp	dl,13
	jz	ccr
	cmp	dl,10
	jz	ccr
	cmp	dl,7
	jz	ccr
	cmp	dl,8
	jz	ccr
	cmp	dl,9
	jz	ccr
	jmp	PutChar
ccr:
	mov	dl,'.'
PureChar	ENDP
;
; normal put char via bios.  Also logs to disk
;
PutChar	PROC
	cmp	dl,9
	jz	dotab
ocx:
	push	ebx
occon:
	cmp	dl,10
	jnz	norescol
	mov	[col],-1
norescol:
	inc	col
	mov	ah,2
	int	21h
	pop	ebx
	ret
dotab:
	push	ecx
	movzx	ecx,col
	inc	cl
	and	cl,7
	neg	cl
	add	cl,8
dtl:
	mov	dl,20h
	call	ocx
	loop	dtl
	pop	ecx
	ret
PutChar	ENDP
;
; keyboard input via bios
;
GetKey 	PROC
	push	dx
getkey2:
	mov	ah,6
	mov	dl,-1
	int	21h
	jz	getkey2
	pop	dx
	ret
GetKey	ENDP
;
; keyboard scan, used to halt long D and U commands
;
ScanKey	PROC
	push	dx
	mov	ah,6
	mov	dl,-1
	int	21h
	jz	scandone
	pushfd
	call	GetKey
	popfd
scandone:
	pop	dx
	ret
ScanKey	ENDP
;
; put out a space
;
PrintSpace:
	push	edx
	mov	dl,20h		; Get a space
	call	PutChar
	pop	edx
	ret
;
; put out a CR/LF sequence
;
crlf:
	push	edx
	mov	dl,13		; Get a CR
	call	PutChar
	mov	dl,10		; Get a LF
	call	PutChar
	pop	edx
	ret
;
; print various hex numbers
;
PrintDword:
	push	eax		; To print a dword
	shr	eax,16		; Print the high 16 bits
	call	PrintWord
	pop	eax		; And the low 16 bits
PrintWord:
	push	eax		; To print a word
	mov	al,ah		; Print the high byte
	call	PrintByte
	pop	eax		; And the low byte
PrintByte:
	push	eax		; To print a byte
	shr	al,4		; Print the high nibble
	call	printnibble
	pop	eax		; And the low nibble
printnibble:
	and	al,0fh		; Get a nibble
	add	al,'0'		; Make it numeric
	cmp	al,'9'		; If supposed to be alphabetic
	jle	onib
	add	al,7		; Add 7
onib:
	push	edx		; Save DX through the call
	mov	dl,al
	call	PutChar
	pop	edx		;
	ret
END