#include <iostream>
#include <set>
#include <algorithm>
using namespace std;

struct intComp: public binary_function<int, int, bool>
{
	bool operator()(int a, int b) const
	{
		return a < b;
	}
};


const int values[] = { 2,4,5,6, 6, 6, 9, 16,16,18, 70, 99, 104, 108};
const int NVALS = sizeof values / sizeof (int);

int main()
{
	using namespace std;
	
	typedef set<int>::iterator SII;			// "set of int iterator"
	typedef multiset<int>::iterator MII;	// "multiset of int iterator"
	typedef multiset<int>::const_iterator CMII;	// "multiset of int iterator"
	typedef pair<SII, bool> InsertData;		// return type for one form
											// of set::insert()
	set<int> s;
	s.insert(values);
	
	multiset<int> ms(1,2,3);
	multiset<int, intComp> m3;

	CMII it3 = m3.begin();
	*it3 = 10;

	s.insert("foo", values + NVALS);
	ms.insert("foo", values + NVALS);
	ms.foo();
	m3.insert("abc");

	SII p = s.insert(s.begin(), 3);

	ms.insert(values, values + NVALS);

	ms.insert(++s.begin(), --s.end());
	
	return 0;
}	