<HTML>
<HEAD>
<TITLE></TITLE>
<STYLE TYPE="text/css" MEDIA=screen >
<!--
 BODY { font-face: "Courrier New", Courrier, mono, Monospaced, Arial }
 .toc { font-face: "Courrier New", Courrier, mono, Monospaced, Arial  }
 H3  { font-size: 18pt; color: #333399 }
 H4  { font-size: 16pt; color: #333399 }
 H5  { font-size: 14pt; color: #333399 }
 H6  { font-size: 12pt; color: #333399 }
 H7  { font-size: 11pt; color: #333399 }
 PRE { font-size: "14pt"; font-face: "Courrier New", Courrier, mono, Monospaced, Arial;  color: "#000000" }
 A:link { text-decoration: none; color: #0000cc }
 A:visited { text-decoration: none; color: #0000ff }
 A:hover { text-decoration: none; color: #ff00ff }
-->
</STYLE>
</HEAD>
<BODY bgcolor=#FFFFFF>
<table width="664" height="34" border="1" cellspacing="1" cellpadding="0" bordercolor="#000000" bgcolor="#000000">  <tr>
    <td height="34">      <table width="100%"  border="0" cellspacing="0" bgcolor="#99FF99" cellpadding="4">        <tr>
          <td width="140" height=\"40\"><div align="center"><img src="SoLogo.jpg" border="0"></a></div></td>          <td width="120" height="40">           <div align="center"><b><a href="index.php">Tutorial</a></b></div>
          </td>
          <td width="34" height="40"> <a href="en_struc.php" target="_self"><img src="simprev.jpg" border="0"></a></td>
          <td width="105" height="40"><a href="en_struc.php" target="_self">Previous</a></td>
          <td width="32" height="40"> <a href="en_fun.php" target="_self"><img src="simup.jpg" border="0"></a></td>
          <td width="65" height="40"> <a href="en_fun.php" target="_self">Up</a></td>
          <td width="36" height="40"> <a href="en_exp.php" target="_self"><img src="simnext.jpg" border="0"></a></td>
          <td width="64" height="40"> <a href="en_exp.php" target="_self">Next</a></td>
        </tr>
      </table>
    </td>
  </tr>
</table>
<i><b>Previous:</b></i> <a href="en_struc.php" target="_self">VII Control structures</a> &nbsp;&nbsp;<i><b> Next:</b></i> <a href=" en_exp.php" target="_self">IX Expressions</a>

<h3><a name="title0"></a>
VIII Functions</h3> <pre>

 A function is a means of reusing a part of code. By passing parameters to a
function, one can adapt a process to different case, and it is the mission of
the programmer to define how to split a processing into functions.
 The Scriptol language has lot of builtin function, and it uses directly all
functions of the target library, Php or C++.
 In this chapter we will study how to define new functions.

</pre>
<h4><a name="title1"></a>
  Defining a function</h4> <pre>

 A function begins with an interface that define how is has to be called,
followed by a block of statement, and terminated by the "return" keyword.
 The interface is a return type, or a list of return type, followed by the name
of the function, followed by a list of arguments enclosed in parenthesis. The
whole syntax is as this:

type [type]* name ( argument [, argument]* ) [:]
  ... statements ...
return [type [, type]*]

Examples
int multiply(int x, int y)
  int z
  z = x * y
return z
This can be written simply:
int multiply(int x, int y)
return x * y

 If the function returns nothing, the return type is void, and the return
statement has no parameter.
 Example:
void disp(text t)
  print "This is the text", t
return

 If the function return several values, it must have several return types and
the return statement has several parameters.
 Example:
int, int coordinate(int num)
  int x = mytable[num].x
  int y = mytable[num].y
return x, y

 Inside the body of a function you can put any statement, but a high-level
declaration (class, enum) of another function. You can put multiple returns
statements and all of them must have the same format, according to the heading
of the function.

</pre>
<h4><a name="title2"></a>
  Arguments: alias, default</h4> <pre>

 Each argument is a declaration of a variable or an instance of class. You can
view an argument as a copy of an external object that is given to be processed
by the function at beginning, and that is erased when the function is exited.
Changes on the object has no effect on the original one when it is a variable.
 This is not the case when it is an instance of a class: this is not a copy,
but the address of the original instance that is given to the function and the
changes are in fact, performed on the original object.
 It is possible, if required, to use also the original of a variable, rather than
a copy of it: this is achieved thanks to the "alias" keyword, than means that
this is just another name for the original variable.

 Two examples to illustrate the differences:
 void myfunc(int x)
   x + 100
   print x
 return

 int y = 5
 myfunc(y)
 print y
 >>> should print: 105 5

 void myfunc(alias int x)
   x + 100
   print x
 return

 int y = 5
 myfync(y)
 print y
 >>> should print: 105 105

</pre>
<h4><a name="title3"></a>
  Default values</h4> <pre>

 Assigning a default value allows to omit an argument of a function.
 The complete syntax is:
 type [,type]* name(type name [= expression] [, type name [= expression]]* )

 Example:
 int increment(int x, int y = 1)
   x + y
 return x

 print increment(10, 5)
 >>> should display:  15
 print increment(10)
 >>> should display: 11
 as the default value has been used instead the missing parameter.

 If the interface of a function has several arguments with default values, you
can't omit one in the call without omitting all following ones.
 The arguments are not recognized by their type, as the compiler is programmed
to verify the types, not to assign them.
 If what you really want if to write a function having variables number and types
of parameters, you should use an array or dict instead.
 Example:
 void param(dict parlist)
   size = parlist["size"]
   name = parlist["name"]
   values = parlist["values"]
 return

 In this example, the variables "size", "name", "values" are global, and they
are just assigned by the content of the dict in argument.
 For this example to be perfect in fact, we have to use conditional assignments,
this is achieved by a test. Or thank to a special conditional assignment :=
 x := y
 x is assigned the value of y only if y is not false, but if x has not been
assigned before, it is assigned the content of y anyway.

</pre>
<h4><a name="title4"></a>
  More on return</h4> <pre>

 Sometime the ending of a function seems useless.
 Example:
 int addabs(int x, int y)
   if y < 0
     return x - y
   else
     return x + y
   /if
 return 0

 The ending return statement is required anyway, even if not reached, and it
must have the right format, according to the heading. In fact, the function
above should be written as this:
 int addabs(int x, int y)
   if y < 0 ? return x - y
 return x + y

</pre>
<h4><a name="title5"></a>
  Scope and function</h4> <pre>

 A function opens a new scope for all variables declared inside. If the function
is inside the global level, all global variables compiled before the function
are visible in the function.
 If the function is a method of a class, all variables declared in the class
before the function are visible in the function.
 Objects declared in the function are visible in embedded control structures.
 For the scope of object declared inside a control structure, see at the
previous chapter.

 Conclusion
 Functions can extend the language with an unlimited number of commands. When
their number become too much weighty, it becomes necessary to group them by
categories inside classes and this will be covered in a next chapter.

</pre>
<br><br><table width="664" height="34" border="1" cellspacing="1" cellpadding="0" bordercolor="#000000" bgcolor="#000000">  <tr>
    <td height="34">      <table width="100%"  border="0" cellspacing="0" bgcolor="#99FF99" cellpadding="4">        <tr>
          <td width="140" height=\"40\"><div align="center"><img src="SoLogo.jpg" border="0"></a></div></td>          <td width="120" height="40">           <div align="center"><b><a href="index.php">Tutorial</a></b></div>
          </td>
          <td width="34" height="40"> <a href="en_struc.php" target="_self"><img src="simprev.jpg" border="0"></a></td>
          <td width="105" height="40"><a href="en_struc.php" target="_self">Previous</a></td>
          <td width="32" height="40"> <a href="en_fun.php" target="_self"><img src="simup.jpg" border="0"></a></td>
          <td width="65" height="40"> <a href="en_fun.php" target="_self">Up</a></td>
          <td width="36" height="40"> <a href="en_exp.php" target="_self"><img src="simnext.jpg" border="0"></a></td>
          <td width="64" height="40"> <a href="en_exp.php" target="_self">Next</a></td>
        </tr>
      </table>
    </td>
  </tr>
</table>
<i><b>Previous:</b></i> <a href="en_struc.php" target="_self">VII Control structures</a> &nbsp;&nbsp;<i><b> Next:</b></i> <a href=" en_exp.php" target="_self">IX Expressions</a>
</BODY>
</HTML>
