<HTML>
<HEAD>
<TITLE></TITLE>
<STYLE TYPE="text/css" MEDIA=screen >
<!--
 BODY { font-family: "Courrier New", Courrier, mono, Monospaced, Arial }
 .toc { font-family: "Courrier New", Courrier, mono, Monospaced, Arial  }
 H3  { font-size: 18pt; color: #333399 }
 H4  { font-size: 16pt; color: #333399 }
 H5  { font-size: 14pt; color: #333399 }
 H6  { font-size: 12pt; color: #333399 }
 H7  { font-size: 11pt; color: #333399 }
 PRE { font-size: "14pt"; font-family: "Courrier New", Courrier, mono, Monospaced, Arial;  color: "#000000" }
 A:link { text-decoration: none; color: #0000cc }
 A:visited { text-decoration: none; color: #0000ff }
 A:hover { text-decoration: none; color: #ff00ff }
-->
</STYLE>
</HEAD>
<BODY bgcolor=#FFFFFF>
<table width="664" height="34" border="1" cellspacing="1" cellpadding="0" bordercolor="#000000" bgcolor="#000000">  <tr>
    <td height="34">      <table width="100%"  border="0" cellspacing="0" bgcolor="#99FF99" cellpadding="4">        <tr>
          <td width="140" height=\"40\"><div align="center"><img src="SoLogo.jpg" border="0"></a></div></td>          <td width="120" height="40">           <div align="center"><b><a href="index.php">Tutorial</a></b></div>
          </td>
          <td width="34" height="40"> <a href="en_nat.php" target="_self"><img src="simprev.gif" border="0"></a></td>
          <td width="105" height="40"><a href="en_nat.php" target="_self">Previous</a></td>
          <td width="32" height="40"> <a href="en_class.php" target="_self"><img src="simup.gif" border="0"></a></td>
          <td width="65" height="40"> <a href="en_class.php" target="_self">Up</a></td>
          <td width="36" height="40"> <a href="en_java.php" target="_self"><img src="simnext.gif" border="0"></a></td>
          <td width="64" height="40"> <a href="en_java.php" target="_self">Next</a></td>
        </tr>
      </table>
    </td>
  </tr>
</table>
<i><b>Previous:</b></i> <a href="en_nat.php" target="_self">XII Native Php</a> &nbsp;&nbsp;<i><b> Next:</b></i> <a href=" en_java.php" target="_self">XIV Java and GUI</a>

<h3><a name="title0"></a>
XIII Classes and objects</h3> <pre>

 In the goal to do programs approaching the reality, the concept of objects has
been added to programming languages, in the form of classes that describe objects
of the real world.
 A class is a structure which has variables (named in this case attributes) and
functions (named methods of the class).
 Once a class is defined, it becomes a kind of complex type and one can declare
instances of a class as one declares variables of a type. These instances are
named objects.
 Meanwhile Scriptol programmers are not encouraged to become object-maniacs,
and to describe anything as an object, it is a good practice to assemble all
variables and functions related to a process in a class, since they may be used
even without instance of class, as we will see further in the "Static" section.
 By convention, a class name is usually capitalized, but this is not mandatory.

</pre>
<h4><a name="title1"></a>
  Defining a class</h4> <pre>

 The description of a class starts with the "class" keyword and ends with
 "/class".
 The attributes (variables) should by stored before functions.
 A class opens a space of visibility. Global variables and functions are not
visible inside a class. The attributes and methods are visible directly inside
all methods of the class.
 Of course a mean exists to use them outside the class!

 Simple example:
 class Car
  int speed
  int power
  int getSpeed() return speed
  int getPower() return power
  void setSpeed(int s)
    speed = s
  return
 /class

</pre>
<h4><a name="title2"></a>
  Constructor</h4> <pre>

 A constructor is a special method that is automatically called at the creation
of an object. The identifier of this special method is the name of the class.
 A constructor is defined only if special processing, as attributes
initialization for example, is required for each instance of the class.
 A constructor has always a void return type.

 Example:
 class car
  int speed
  int power
  void Car(int p)             ` this method is the constructor
    speed = 0                 ` speed is initialized with a default value
    power = p                 ` power is initialized by an argument
  return
 /class

</pre>
<h4><a name="title3"></a>
  Declaring and using an instance</h4> <pre>

 An instance is an object whose description is given by the class. The objects
share same description and same methods, but not same data: each instance owns
a set of all the attributes. You can declare instances of a class in any scope,
including inside other classes.
 The syntax of an instance declaration is:
 classname instancename(arguments)   or
 classname instancename

 Example:
 Car myCar(850)
 Truck myTruck

 If the constructor has not arguments, the parenthesis must be omitted.
Empty parenthesis are not allowed in the declaration of an instance.

 Example:
 class Demo
  void demo()          ` constructor
    ...
  return
 /class
 Demo mydemo           ` instance

 Once an instance is declared, attributes and methods of the class become
visible outside the class providing they are associated with the name of the
instance by the dot symbol, in the form:
 instanceName.attribute
 instanceName.method()

 Example:
 Car myCar
 print myCar.speed
 print myCar.getSpeed()

</pre>
<h4><a name="title4"></a>
  Static methods and attributes</h4> <pre>

 A real, mathematical function doesn't use variables not declared inside its
body. Methods that are pure functions, and thus that don't use the attributes of
the class are considered as static, and may be called directly associated to
the class name rather than with an instance name.
 As said above, this is good practice to put functions inside classes, just to
make the programs clearer and make reusable components.
 Example of static call:
 node, extension = Dir.splitExt(path)

 An attribute declared as static may also be associated with the name of the
class, or with the name of an instance. A static attribute shares its content
with all instances of a class, including inherited ones.
 A static method can only use static attributes. It can't call other methods,
nor use other attribute.
 Example:
 class Car
   static constructor = "X"
   static void setName(text x)
     constructor = x
   return
 /class

 Car myCar
 Car.setName("name")
 myCar.setName("name")
 Car.constructor = "name"
 myCar.constructor = "name"
 ... all these statements have the same result but only static members may
be called along with the class' name, and if you change a static attribute
for an instance, the change applies to all other instances.


</pre>
<h4><a name="title5"></a>
  Inheritance</h4> <pre>

 A class is a kind of abstraction and we can define a class that describes a
specialized case of a more general class.
 For example, a car is a kind of vehicule and we can describe what is a
vehicule, then what is a car or a truck, by describing only the attributes and
methods that are proper to a car or a truck.
 Vehicle is named the "superclass" or "base class" and Car and Truck are named
subclasses, of vehicle. The attributes and methods of the superclass Vehicle,
are also attributes and methods of the subclasses.

 The syntax of inheritance is:
 class name is supername
 That means that the instances of the class "name" inherits of attributes and
methods of the superclass "supername".
 This works even for static methods.

 Example:
 class Vehicle
   int fuel
   void Vehicle()
    fuel = 100
   return
 /class

 class Car
   int passengers
   void Car()
    passengers = 4
    fuel = 50
   return
 /class

 class Truck
   int charge
   void Truck()
    fuel = 200
    charge = 1000
 /class

 Truck redbaby
 Car daisy
 print redbaby.charge        ` attribute of the class Truck
 print redbaby.fuel          ` attribute of the superclass Vehicle
 print redbaby.passengers    ` bad! passengers is not accessible to Truck!
 print daisy.passengers      ` good, passengers is attribute of Car

</pre>
<h4><a name="title6"></a>
  Virtual methods</h4> <pre>

 In Scriptol, all types have methods. Even literal texts or numbers have methods.
 The instance of basic types as text, numbers, arrays are considered as virtual
object. They are translated to Php as simple variables, and methods attached to
these objects are translated as simple function with the variable as arguments!
 All virtual methods are detailed in the reference manual.

 Conclusion
 Using classes allows both to describe objects of the real world and to build
reusable components. This makes also the code clearer. Thus, it is a good
practice to put all functions related to a same kind of processing inside a
class, either to make instances of this class or to call directly these functions
along with the class' name.
 The java language has no function but only classes with methods, and it offers
a very huge library of components. You can use all these components through a
Scriptol program. See at the next chapter.

</pre>
<br><br><table width="664" height="34" border="1" cellspacing="1" cellpadding="0" bordercolor="#000000" bgcolor="#000000">  <tr>
    <td height="34">      <table width="100%"  border="0" cellspacing="0" bgcolor="#99FF99" cellpadding="4">        <tr>
          <td width="140" height=\"40\"><div align="center"><img src="SoLogo.jpg" border="0"></a></div></td>          <td width="120" height="40">           <div align="center"><b><a href="index.php">Tutorial</a></b></div>
          </td>
          <td width="34" height="40"> <a href="en_nat.php" target="_self"><img src="simprev.gif" border="0"></a></td>
          <td width="105" height="40"><a href="en_nat.php" target="_self">Previous</a></td>
          <td width="32" height="40"> <a href="en_class.php" target="_self"><img src="simup.gif" border="0"></a></td>
          <td width="65" height="40"> <a href="en_class.php" target="_self">Up</a></td>
          <td width="36" height="40"> <a href="en_java.php" target="_self"><img src="simnext.gif" border="0"></a></td>
          <td width="64" height="40"> <a href="en_java.php" target="_self">Next</a></td>
        </tr>
      </table>
    </td>
  </tr>
</table>
<i><b>Previous:</b></i> <a href="en_nat.php" target="_self">XII Native Php</a> &nbsp;&nbsp;<i><b> Next:</b></i> <a href=" en_java.php" target="_self">XIV Java and GUI</a>
</BODY>
</HTML>
