
`  Path Class
`  Scriptol-Php - (c) 2001-2002  D.G Sureau
`  www.scriptol.com

`  This is a set of static functions related to files in directory
`  The path separator is "/" under Unix and Windows


include "libphp.sol"

class Path

 ` EXISTS - Test if a file exists
 static boolean exists(text dname): return file_exists(dname)


 ` SIZE - Return the size of a file
 static number size(text fname):   return filesize(fname)


 ` TYPE - Return the type of an entry: file, dir, etc...
 static text type(text fname):   return filetype(fname)


 ` ISFILE
 static boolean isFile(text fname) return filetype(fname) = "file"


 ` ISDIR
 static boolean isDir(text fname)
  text t = filetype(fname)
  if t = "link" ? return false
  if t != "dir" ? return false
 return true


 ` REN
 static boolean ren(text oldname, text newname)
   boolean b = true
   rename(oldname, newname)
 return b


 ` DELETE
 static boolean erase(text fname) return unlink(fname) = 0


 ` MERGE - Merge elements of path
 static text merge(text path, text filename)
   if path = "" ? return filename
   if filename = "" ? return path
   if (path[path.length()-1] <> "/") and (filename[0] <> "/") ? path + "/"
 return path + filename


 ` MAKE DIR - Create a sub-directory

 static boolean make(text name)
   if mkdir(name) = -1 ? return false
 return true

 ` SPLIT EXT - Split the node and the extension of a filename or path
 static text, text splitExt(text path)
   int l = path.length()
   if l = 0 ? return "", ""
   for int x in l - 1 .. 0 step -1
    if path[x] = "." ? return path[--x], path[x + 1..]
   /for
 return path, ""

 ` GET DIR Get current directory
 text getDir()  return getcwd()

/class

