@echo %__DEBUG% OFF
:: Copyright 1997 Malcom Dew-Jones.
:: Freely distributable under the terms of the GNU General Public License.
:: This program is distributed in the hope that it will be useful,
:: but WITHOUT ANY WARRANTY.

::The author can be reached (as of Dec 1997) at 73312.2317@compuserve.com
::and yf110@freenet.victoria.bc.ca

:: try to avoid any collision is running multiple copies at once
:: this assumes that this section never runs concurrently with itself
:: which is probably true on a single user PC
revlib&u -t %TEMP% r&u>%TEMP%\temp.bat
call %TEMP%\temp.bat
rem >%TEMPNAME%.$$$

set TZ=PST8PDT
set RCSINIT=-x.revisions
::win95 RCS automatically finds username
::echo set user=%%2>user.bat
::    net config | find "User name">__.bat
::    call __.bat
::    del __.bat
::    del user.bat

::---------------------------------------------------------------------
::CATEGORIZE_PARAMETRE
:: might be no param, or one file (or wild that resolves to one file)
:: or a directory name

    if %1.==. goto NODOCUMENT

    :: get filename components
    dir %1 | revlib&u -f > %TEMPNAME%.bat
    call %TEMPNAME%

    if not exist %1 goto MAYBE_DIR
    if not %FILECOUNT%.==1. goto ERRMANYFILES

    :: RCS allows psuedo symbolic links using a file called RCS
    if %SHORTNAME%.==RCS. goto ERRpsuedoRCS

    :: we found one file, so lets RCS it
    %DISK%
    CD "%DIRECTORY%"
    for %%n in (Title Copy Master) do if .%%n.==%EXT%. goto controlled_doc
    if %PARENT%.==RCS. goto RCSEDDOC 
    goto UNCONTROLLED

    :controlled_doc
    for %%n in (Title Copy Master) do if .%%n.==%EXT%. goto %%n


:MAYBE_DIR
    if %SHORTNAME%.==. goto NOSUCHFILE
    %DISK%
    CD "%DIRECTORY%"
    if %PARENT%.==RCS. cd ..
    goto SUPER


::---------------------------------------------------------------------
::ERROR_MESSAGES_AND_QUIT

:ERRMANYFILES
echo The filename %1 is ambiguous, it refers to more than one file.
pause
goto the_end

:NOSUCHFILE
echo The filename %1 could not be found.
pause
goto the_end


:ERRpsuedoRCS
echo This utility doesn't yet handle pseudo symbolic links using an RCS file.
echo.
pause
goto the_end


:not_a_defined_ext
echo The file extension %REAL_EXT% is not registered with windows
pause
goto the_end

:not_a_defined_type
echo The file extension %REAL_EXT% is registered with windows, but the
echo registry does not have an entry defining how to open these documents.
pause
goto the_end


:ERRNODOCTYPE
echo No original document type, can't open automatically.
echo This document must be opened from within an application.
pause
goto the_end


:DO_QUIT
goto the_end

:DO_ABORT
echo ** An error occurred, please read the above message **
pause
goto the_end

::---------------------------------------------------------------------
::MENUS

:NODOCUMENT
SET MENU=NODOCUMENT
echo Revision Librarian 0.5 - copyright (C) 1997 Malcom Dew-Jones.
echo Freely distributable under the terms of the GNU General Public License.
echo This program is distributed in the hope that it will be useful,
echo but WITHOUT ANY WARRANTY.
echo.
echo Files with extensions .Title, .Copy, .Master, and .Revisions are recognized
echo as controlled documents.  Double click these files to access the appropriate
echo revision librarian menu for the document.
echo.
echo Other files are assumed to be uncontrolled documents.  Uncontrolled documents
echo must be checked into the revision librarian by dragging them onto the
echo "do revision librarian .bat" icon, or by right clicking and selecting
echo "Send To:revision librarian".
echo.
echo "Drag and drop" and "Send To" can also be used with controlled documents.
echo.
pause
if not exist rcs\*.* goto the_end

:SUPER
SET MENU=SUPER
echo You are performing revision library tasks for the directory
CD
echo ----------------------
echo.
echo What do you wish to do.
echo.
echo    G - get all the titles of documents in the library
echo.
echo    P - put all the documents into the library
echo.
echo    Q - quit
echo.
choice /C:GPQ
if errorlevel 3 goto DO_QUIT
for %%n in (1 2) do if errorlevel %%n goto sup_%%n


:RCSEDDOC
SET MENU=RCSEDDOC
echo This document is the checked-in version in the revision control library.
echo It cannot be accessed directly.  You can extract its title into the
echo document directory and then access the document from its title.
echo.
echo What do you wish to do with this library document.
echo.
echo    T - place the title into the document directory
echo.
echo    L - view the change log for this document.
echo.
echo    A - abandon changes for this document (this invalidates .Master)
echo.
echo    O - take Ownership of the master document (lock .Master with your id)
echo.
echo    R - get a copy of a previous Release
echo.
echo    Q - quit
echo.
choice /C:TLAORQ
if errorlevel 6 goto DO_QUIT
for %%n in (1 2 3 4 5 ) do if errorlevel %%n goto RCS_%%n

:UNCONTROLLED
SET MENU=UNCONTROLLED
echo This document appears to be an original copy which not yet under
echo revision control.
echo.
echo What do you wish to do with this document.
echo.
echo    P - put this document into the revision control library
echo.
echo    Q - quit
echo.
choice /C:PQ
if errorlevel 2 goto DO_QUIT
for %%n in (1) do if errorlevel %%n goto unc_%%n


:TITLE
SET MENU=TITLE
echo This document is currently checked-in to the revision control library.
echo You can access the original document (called the master) which can be
echo edited and saved as a new version, or a copy.
echo.
echo What do you wish to do with this document.
echo.
echo    M - get master copy, but do not edit it
echo.
echo    E - get master copy and edit it
echo.
echo    C - get a copy of the document, but do not view it
echo.
echo    V - get a copy of the document and view (edit) it
echo.
echo    L - view the change log for this document.
echo.
echo    R - get a copy of a previous Release
echo.
echo    Q - quit
echo.
choice /C:MECVLRQ
if errorlevel 7 goto DO_QUIT
for %%n in (1 2 3 4 5 6 ) do if errorlevel %%n goto tit_%%n


:COPY
SET MENU=COPY
echo This document is a view only copy of the version which is stored
echo in the revision control library.  An application may allow you to
echo edit this file, but the revision control librarian will only save
echo changes made to the master copy.
echo.
echo What do you wish to do with this document.
echo.
echo    M - replace the copy with the master copy, but do not edit it
echo.
echo    E - replace copy with the master copy and edit it
echo.
echo    C - get a new copy of the document, but do not view it
echo.
echo    V - view this copy of the document
echo.
echo    T - remove the copy, leaving just the title
echo.
echo    Q - quit
echo.
choice /C:MECVTQ
if errorlevel 6 goto DO_QUIT
for %%n in (1 2 3 4 5) do if errorlevel %%n goto cop_%%n


:MASTER
if exist "RCS\%REAL_LONGNAME%.revisions" goto MASTERA

:: the document isn't in its original directory, so try to find another
:: directory which has the library.
:: the symbol REVLIB may have been set to point to the original parent
:: directory.  Normally this is set by DO REVISION LIBRARIAN .BAT
:: In this case setup the pseudo sym link to allow RCS functions to work.

 if exist RCS\*.* goto MASTERB
 if not exist "%REVLIB%\RCS\%REAL_LONGNAME%" goto MASTERB
 echo %REVLIB%\RCS>RCS
 goto MASTERA

:MASTERB

SET MENU=MASTERB
echo This document is the master copy which has been checked out of
echo the revision control library.  However, the document is not in its
echo original directory, and an alternate RCS directory could not be found.
echo The "do revision librarian .bat" icon can be used as a drag and drop
echo destination.  A copy of it should reside in the document's original
echo location.
echo.
echo What do you wish to do with this document.
echo.
echo    E - edit this master copy
echo.
echo    Q - quit
echo.
choice /C:EQ
if errorlevel 2 goto DO_QUIT
for %%n in (1) do if errorlevel %%n goto mas_%%n

:MASTERA
SET MENU=MASTERA
echo This document is the master copy which has been checked out of
echo the revision control library.  Once you have finished modifying the
echo document then it should be put back into the library.
echo.
echo What do you wish to do with this document.
echo.
echo    E - edit this master copy
echo.
echo    P - put this document back into the library
echo.
echo    D - display differences between this copy and the latest copy
echo        kept in the library.
echo.
echo    L - view the change log for this document.
echo.
echo    A - abandon changes for this document
echo.
echo    Q - quit
echo.
choice /C:EPDLAQ
if errorlevel 6 goto DO_QUIT
for %%n in (1 2 3 4 5) do if errorlevel %%n goto mas_%%n


::---------------------------------------------------------------------
::FUNCTIONS

:RCS_1
echo entering title into directory
    rem>"..\%REAL_LONGNAME% .Title"
    pause
    goto the_end

:RCS_2
echo Displaying revision log for %REAL_LONGNAME%
    rlog "..\%REAL_LONGNAME%"|more
    echo.
    pause
    goto %MENU%
    goto the_end

:RCS_3
echo Forcing any changes to the .Master to be abandonned
    rcs -u "..\%REAL_LONGNAME%"
    if errorlevel 1 goto do_abort
    pause
    rem>"..\%REAL_LONGNAME% .Title"
    if not exist "..\%REAL_LONGNAME% .Master" goto %MENU%

    attrib -r "..\%REAL_LONGNAME% .Master"
    rename "..\%REAL_LONGNAME% .Master" "modified %REAL_LONGNAME%"
    if not exist "..\%REAL_LONGNAME% .Master" goto %MENU%
    rename "..\%REAL_LONGNAME% .Master" "modified 2 %REAL_LONGNAME%"
    if not exist "..\%REAL_LONGNAME% .Master" goto %MENU%
    rename "..\%REAL_LONGNAME% .Master" "modified 3 %REAL_LONGNAME%"
    if not exist "..\%REAL_LONGNAME% .Master" goto %MENU%
    rename "..\%REAL_LONGNAME% .Master" "modified 4 %REAL_LONGNAME%"
    if not exist "..\%REAL_LONGNAME% .Master" goto %MENU%
    rename "..\%REAL_LONGNAME% .Master" "modified 5 %REAL_LONGNAME%"
    if not exist "..\%REAL_LONGNAME% .Master" goto %MENU%
    rename "..\%REAL_LONGNAME% .Master" "modified 6 %REAL_LONGNAME%"
    if not exist "..\%REAL_LONGNAME% .Master" goto %MENU%
    rename "..\%REAL_LONGNAME% .Master" "modified 7 %REAL_LONGNAME%"
    if not exist "..\%REAL_LONGNAME% .Master" goto %MENU%
    rename "..\%REAL_LONGNAME% .Master" "modified 8 %REAL_LONGNAME%"
    if not exist "..\%REAL_LONGNAME% .Master" goto %MENU%
    rename "..\%REAL_LONGNAME% .Master" "modified 9 %REAL_LONGNAME%"
    if not exist "..\%REAL_LONGNAME% .Master" goto %MENU%
    goto do_abort

:RCS_4
echo Taking ownership of an existing .Master document for
echo %REAL_LONGNAME%
    find "locks;" "%REAL_LONGNAME%.revisions"
    if errorlevel 1 goto rcs_4b
    echo.
    echo.
    echo There is no master copy checked out by anyone, therefore you cannot
    echo take ownership of it.
    echo.
    echo However you are free to check out the master copy yourself if you
    echo wish since no one else has done so.
    echo Get the .Title for the document from this menu, and then open the
    echo .Title icon to access the menu that can get the master document.
    echo.
    echo.
    pause
    goto %MENU%

:rcs_4b
    rcs -l -M "..\%REAL_LONGNAME%"
    if errorlevel 1 goto do_abort
    pause
    goto %MENU%


:RCS_5
echo Extracting a copy of a previous release of 
echo %REAL_LONGNAME%
    rlog "..\%REAL_LONGNAME%"|revlib&u -m|more
    revlib&u -a OPT Enter the desired revision number (eg. 1.4)>%TEMPNAME%.bat
    if errorlevel 1 pause
    if errorlevel 1 goto %MENU%
    call %tempname%
    if %OPT%.==. goto %MENU%
    if not exist "..\R-%OPT% %REAL_LONGNAME%" goto rcs_5b
    echo the file R-%OPT% %REAL_LONGNAME% exists.
    echo Shall we overwrite it?
    choice
    if errorlevel 2 goto %MENU%
:rcs_5b
    co -p -r%OPT% "..\%REAL_LONGNAME%" >"..\R-%OPT% %REAL_LONGNAME%"
    if errorlevel 1 del "..\R-%OPT% %REAL_LONGNAME%"
    if errorlevel 1 goto do_abort
    pause
    goto the_end


:sup_1
echo Getting titles of all documents.
    echo not implemented yet.
    pause
    goto the_end

:sup_2
echo Putting all documents into the revision control library
    echo not implemented yet.
    pause
    goto the_end


:unc_1
echo Placing file %LONGNAME% into revision library
    mkdir RCS
    revlib&u -b "%LONGNAME%"
    if errorlevel 1 RCS -i -kb "%LONGNAME%"
    if errorlevel 1 goto do_abort
    ci "%LONGNAME%"
    if errorlevel 1 goto do_abort
    rem>"%LONGNAME% .Title"
    goto the_end

:tit_6
echo Extracting a copy of a previous release of 
echo %REAL_LONGNAME%
    rlog "%REAL_LONGNAME%"|revlib&u -m|more
    revlib&u -a OPT Enter the desired revision number (eg. 1.4)>%tempname%.bat
    if errorlevel 1 pause
    if errorlevel 1 goto %MENU%
    call %tempname%
    if %OPT%.==. goto %MENU%
    if not exist "R-%OPT% %REAL_LONGNAME%" goto tit_6b
    echo the file R-%OPT% %REAL_LONGNAME% exists.
    echo Shall we overwrite it?
    choice
    if errorlevel 2 goto %MENU%
:tit_6b
    co -p -r%OPT% "%REAL_LONGNAME%" >"R-%OPT% %REAL_LONGNAME%"
    if errorlevel 1 del "R-%OPT% %REAL_LONGNAME%"
    if errorlevel 1 goto do_abort
    pause
    goto the_end



:tit_5
echo Displaying revision log for %REAL_LONGNAME%
    rlog "%REAL_LONGNAME%"|more
    echo.
    pause
    goto %MENU%
    goto the_end

:tit_4
echo Getting copy of %REAL_LONGNAME% from library to edit
    co "%REAL_LONGNAME%"
    if errorlevel 1 goto do_abort
    attrib -r "%REAL_LONGNAME%"
    rename "%REAL_LONGNAME%" "%REAL_LONGNAME% .Copy"
    del "%LONGNAME%"
    set EXT=.Copy
    goto open_it
    goto the_end

:tit_3
echo Getting copy of %REAL_LONGNAME% from library
    co "%REAL_LONGNAME%"
    if errorlevel 1 goto do_abort
    attrib -r "%REAL_LONGNAME%"
    rename "%REAL_LONGNAME%" "%REAL_LONGNAME% .Copy"
    del "%LONGNAME%"
    goto the_end


:tit_2
echo Getting master version of %REAL_LONGNAME% from library for editing
    co -l "%REAL_LONGNAME%"
    if errorlevel 1 goto do_abort
    attrib -r "%REAL_LONGNAME%"
    rename "%REAL_LONGNAME%" "%REAL_LONGNAME% .Master"
    del "%LONGNAME%"
    set EXT=.Master
    goto open_it
    goto the_end

:tit_1
echo Getting master version of %REAL_LONGNAME% from library
    co -l "%REAL_LONGNAME%"
    if errorlevel 1 goto do_abort
    attrib -r "%REAL_LONGNAME%"
    rename "%REAL_LONGNAME%" "%REAL_LONGNAME% .Master"
    del "%LONGNAME%"
    goto the_end

:cop_5
echo Removing the copy, extracting the title
    rem>"%REAL_LONGNAME% .Title"
    attrib -r "%LONGNAME%"
    del "%LONGNAME%"
    goto the_end

:cop_4
echo About to edit copy of document
    goto open_it
    goto the_end

:cop_3
echo Getting copy of %REAL_LONGNAME% from library
    co "%REAL_LONGNAME%"
    if errorlevel 1 goto do_abort
    attrib -r "%REAL_LONGNAME%"
    rename "%REAL_LONGNAME%" "%REAL_LONGNAME% .Copy"
    goto the_end


:cop_2
echo Getting master version of %REAL_LONGNAME% for editing
    co -l "%REAL_LONGNAME%"
    if errorlevel 1 goto do_abort
    attrib -r "%REAL_LONGNAME%"
    rename "%REAL_LONGNAME%" "%REAL_LONGNAME% .Master"
    attrib -r "%LONGNAME%"
    del "%LONGNAME%"
    set EXT=.Master
    goto open_it
    goto the_end

:cop_1
echo Getting master version of %REAL_LONGNAME% 
    co -l "%REAL_LONGNAME%"
    if errorlevel 1 goto do_abort
    attrib -r "%REAL_LONGNAME%"
    rename "%REAL_LONGNAME%" "%REAL_LONGNAME% .Master"
    attrib -r "%LONGNAME%"
    del "%LONGNAME%"
    goto the_end


:mas_5
echo Abandonning changes for %REAL_LONGNAME%
    rcs -u "%REAL_LONGNAME%"
    if errorlevel 1 goto do_abort
    pause
    attrib -r "%LONGNAME%"
    rem>"%REAL_LONGNAME% .Title"
    rename "%LONGNAME%" "modified %REAL_LONGNAME%"
    if exist "%LONGNAME%" rename "%LONGNAME%" "modified 2 %REAL_LONGNAME%"
    if exist "%LONGNAME%" rename "%LONGNAME%" "modified 3 %REAL_LONGNAME%"
    if exist "%LONGNAME%" rename "%LONGNAME%" "modified 4 %REAL_LONGNAME%"
    if exist "%LONGNAME%" rename "%LONGNAME%" "modified 5 %REAL_LONGNAME%"
    if exist "%LONGNAME%" rename "%LONGNAME%" "modified 6 %REAL_LONGNAME%"
    if exist "%LONGNAME%" rename "%LONGNAME%" "modified 7 %REAL_LONGNAME%"
    if exist "%LONGNAME%" rename "%LONGNAME%" "modified 8 %REAL_LONGNAME%"
    if exist "%LONGNAME%" rename "%LONGNAME%" "modified 9 %REAL_LONGNAME%"
    if exist "%LONGNAME%" goto do_abort
    goto the_end


:mas_4
echo displaying revision log of %REAL_LONGNAME%
    rlog "%REAL_LONGNAME%"
    pause
    goto %MENU%
    goto the_end

:mas_3
echo Displaying differences between current master document and library version.
    attrib -r "%LONGNAME%"
    rename "%LONGNAME%" "%REAL_LONGNAME%"
    rcsdiff "%REAL_LONGNAME%"|more
    echo.
    pause
    rename "%REAL_LONGNAME%" "%LONGNAME%"
    goto %MENU%
    goto the_end


:mas_2
echo Checking master copy back into library
    attrib -r "%LONGNAME%"
    rename "%LONGNAME%" "%REAL_LONGNAME%"
    ci "%REAL_LONGNAME%"
    if errorlevel 1 goto do_abort
::    if not exist "RCS\%REAL_LONGNAME%" goto mas_2b
    rem>"%REAL_LONGNAME% .Title"
:mas_2b
    goto the_end

:mas_1
echo About to edit master version of document
    goto open_it
    goto the_end


::---------------------------------------------------------------------
::EDIT_DOCUMENT


:open_it
if %REAL_EXT%.==. goto ERRNODOCTYPE


echo @echo ON>%TEMPNAME%.bat
revlib&u -c %REAL_EXT%>>%TEMPNAME%.bat
call %TEMPNAME% "%DIRECTORY%\%REAL_LONGNAME% %EXT%"
:the_end
if not %TEMPNAME%.==. if exist %TEMPNAME%.$$$ del %TEMPNAME%.$$$
set TEMPNAME=
