// gksLineCursor.cpp : implementation of the gksLineCursor class
//

#include "stdafx.h"

#include "OzAPIDoc.h"
#include "OzAPIView.h"
#include "gksObject.h"
#include "gksCursor.h"
#include "gksLineCursor.h"
#include "OzGKS.h"
#include "OzFTN.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CgksLineCursor::CgksLineCursor(long type, float* initialData, 
							   long handle, BOOL callback)
		: CgksCursor(type, initialData, handle, callback)
{
} 

void CgksLineCursor::ButtonDown(CClientDC* pDC, CPoint point)
{
	m_screenPoint.RemoveAll();
	m_screenPoint.Add(point);
	m_screenPoint.Add(point);
	m_drawing = TRUE;
	this->DrawCursor(pDC);
}

void CgksLineCursor::ButtonUp(CClientDC* pDC, CPoint point)
{
	if (!m_drawing)
		return;
	this->DrawCursor(pDC); // erase
	this->GKScallback();
	m_drawing = FALSE;
}

void CgksLineCursor::MouseMove(CClientDC* pDC, CPoint point)
{
	if (!m_drawing)
		return;
	this->DrawCursor(pDC); // erase
	m_screenPoint[1] = point;
	this->DrawCursor(pDC); // new 
}

void CgksLineCursor::DrawCursor(CClientDC* pDC)
{
	CPen* pOldPen = (CPen*)pDC->SelectStockObject(WHITE_PEN);
	int	oldROP = pDC->SetROP2(R2_NOT);          // Erases previous box 
	pDC->MoveTo(m_screenPoint[0]);
	pDC->LineTo(m_screenPoint[1]);
	pDC->SetROP2(oldROP);
	pDC->SelectObject(pOldPen);
}

