// DialogInteger.cpp : implementation file
//

#include "stdafx.h"
#include "OzAPI.h"
#include "DialogInteger.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDialogInteger dialog


CDialogInteger::CDialogInteger(CWnd* pParent /*=NULL*/)
	: CDialog(CDialogInteger::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDialogInteger)
	m_text = _T("");
	m_value = 0;
	m_min = -10000;
	m_max = 10000;
	//}}AFX_DATA_INIT

}


void CDialogInteger::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDialogInteger)
	DDX_Text(pDX, IDC_DLG_INT_TEXT, m_text);
	DDX_Text(pDX, IDC_DLG_INT_VALUE, m_value);
	DDV_MinMaxInt(pDX, m_value, m_min, m_max);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDialogInteger, CDialog)
	//{{AFX_MSG_MAP(CDialogInteger)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDialogInteger message handlers




///////////////////  FORTRAN /////////////////////////////////////

extern "C" long ozintdlg (char* prompt, long* min, long* max, long* initial)
{
	CDialogInteger  dlg;
	long result = -999;

	dlg.m_text = prompt;
	dlg.m_value = *initial;
	dlg.m_min = *min;
	dlg.m_max = *max;
	if (*min > *max)
		OzFatalError ("ozintdlg - illegal range");
	if (*initial < *min || *initial > *max)
		OzFatalError ("ozintdlg - illegal default");
	if (dlg.DoModal() == IDOK)
	{
		result = dlg.m_value;
	}


	return(result);
}

void CDialogInteger::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
		this->GetDlgItem(IDC_DLG_INT_VALUE)->SetFocus();
	
	// Do not call CDialog::OnPaint() for painting messages
}
