/** \file 2D_View.h
    A partial view of an infinite 2D World.

Copyright (c) 1998-1999 by Amir Geva.
This file is part of the Photon Game Development library,
beta release version 0.25.
Permission is granted to use and copy this file for non-commercial use only.  
Please contact the author concerning commercial usage. 
Amir Geva makes no representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

*/
#ifndef H_2D_VIEW
#define H_2D_VIEW

#include <WO_View.h>
#include <CON_Bitmap.h>
#include <2D_Types.h>

/** View2D is the visible rectangle in the infinite 2D world.
    A World2D has an active View2D for rendering its sprites.
*/
class View2D : public View
{
public:
  /** Creates a view with the specified rectangle on the Canvas (screen/bitmap) */
  View2D(Drawable* Canvas, const int x1, const int y1, const int x2, const int y2);
  View2D(Drawable* Canvas, const Rect2D& r);

  /** Changes the default parameters. */
  void setViewParams(Drawable* Canvas, const int x1, const int y1, const int x2, const int y2);
  void setViewParams(Drawable* Canvas, const Rect2D& r)
      { setViewParams(Canvas, r.tl.x, r.tl.y, r.br.x, r.br.y); }

  /** Sets the position of the view in the 2D World.
      This specifies the View's top left corner position.
  */
  void setWorldPosition(const int x, const int y);
  void setWorldPosition(const Vector2D& p) { setWorldPosition(p.x, p.y); }

  /** Retrieve the View's position. */
  const Vector2D& getWorldPosition() const;

  /** Retrieve the View's viewport */ 
  const Rect2D& getWindow() const   { return m_Window; }

  /** Retrieve the View's canvas */
  Drawable* getCanvas() const       { return m_Canvas; }

  /** Must be called before rendering, to ensure correct clipping. */
  virtual int beginRendering();

  /** Must be called after rendering, to ensure correct clipping. */
  virtual int endRendering();

protected:
  Drawable *m_Canvas;
  Vector2D  m_Position;
  Rect2D    m_Window;
};

#endif // H_2D_VIEW