#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <CON_All.h>

int initConsole(int& Width, int& Height, int& FullScreen, int& Flags, Screen* S)
{
  if (!S->isModeAvailable(640,480))
  {
    MessageBox(NULL,"Mode 640x480x16 not available","ERROR",MB_OK);
    return -1;
  }
  Width=640;
  Height=480;
  FullScreen=0;
  Flags=0;
  return 0;
}

VideoReader* VR=NULL;
Bitmap*      BM=NULL;

int action(Console* C)
{
	Screen* S=C->getScreen();
  if (VR==NULL) // First time initialization.
  {
    VR=newVideoReader("cup.avi");     // Create a video reader.
    Vector2D Size=VR->getFrameSize(); // Get the size of video frames.
    BM=newBitmap(Size.x,Size.y);      // Create the bitmap to hold frames
  }
  if (VR->getFrame(BM)==1) // Get a frame and check for end of video
  {
    VR->reset();           // Restart
    VR->getFrame(BM);      // Get the frame again, since last call failed.
  }
  S->scaleCopy(BM);        // Scale while copying to fit the screen.
  S->flip();
  Keyboard& K=*C->getKeyboard();
  K.update();
  if (K[DIK_ESCAPE])
  {
    BM->release();
    VR->release();
    return 1;
  }
  return 0;
}